/**
 * Purchase Types Module JavaScript
 * Auto-generated on 2025-08-05
 * Based on Sales Types module pattern
 */

$(document).ready(function() {
    // Initialize form validation
    init_validation();
    
    // Auto-focus first field
    $('#purchase_type_name').focus();
});

/**
 * Initialize form validation
 */
function init_validation() {
    // Remove validation messages on input
    $('input, textarea, select').on('input change', function() {
        $('#' + $(this).attr('id') + '_msg').fadeOut(200).hide();
        $(this).removeClass('required');
    });
}

/**
 * Validate required field
 */
function check_field(id) {
    if(!$("#" + id).val().trim()) {
        $('#' + id + '_msg').fadeIn(200).show().html('Required Field').addClass('required');
        $('#' + id).addClass('required');
        return false;
    } else {
        $('#' + id + '_msg').fadeOut(200).hide();
        $('#' + id).removeClass('required');
        return true;
    }
}

/**
 * Validate all form fields
 */
function validate_form() {
    var flag = true;
    
    // Required field validations
    if(!check_field('purchase_type_name')) flag = false;
    if(!check_field('purchase_type_initial')) flag = false;
    
    return flag;
}

/**
 * Save/Update button click handler
 */
$('#save, #update').on("click", function (e) {
    e.preventDefault();
    
    var base_url = $("#base_url").val();
    var this_id = this.id;
    
    // Validate form
    if(!validate_form()) {
        toastr["warning"]("Please fill all required fields!");
        return false;
    }
    
    // Prepare form data
    var form_data = new FormData($('#purchase-types-form')[0]);
    
    // XSS validation
    if(!xss_validation(form_data)) { 
        return false; 
    }
    
    // Show loading
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $("#" + this_id).attr('disabled', true);
    
    // Determine URL
    var url = (this_id == "save") ? 
        base_url + 'purchase_types/new_purchase_type' : 
        base_url + 'purchase_types/update_purchase_type';
    
    // AJAX request
    $.ajax({
        type: 'POST',
        url: url,
        data: form_data,
        cache: false,
        contentType: false,
        processData: false,
        success: function(result) {
            if(result == "success") {
                if(this_id == "save") {
                    toastr["success"]("Purchase Type added successfully!");
                } else {
                    toastr["success"]("Purchase Type updated successfully!");
                }
                setTimeout(function() {
                    window.location = base_url + "purchase_types";
                }, 1000);
            } else if(result == "failed") {
                toastr["error"]("Operation failed! Please try again.");
            } else {
                toastr["error"](result);
            }
        },
        error: function(xhr, status, error) {
            toastr["error"]("An error occurred: " + error);
        },
        complete: function() {
            $("#" + this_id).attr('disabled', false);
            $(".overlay").remove();
        }
    });
});

/**
 * Reset form
 */
function reset_form() {
    $('#purchase-types-form')[0].reset();
    $('.form-group').removeClass('has-error');
    $('.help-block').hide();
    $('#purchase_type_name').focus();
}

/**
 * Cancel button handler
 */
$('.btn-cancel').on('click', function() {
    if(confirm('Are you sure you want to cancel? Any unsaved changes will be lost.')) {
        window.location = $("#base_url").val() + "purchase_types";
    }
});
