<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php $this->load->view('comman/code_css.php');?>
<style>
  @media(max-width: 480px){
  .small-box h3 {
    font-size: 23px;
    font-weight: bold;
    margin: 0 0 10px 0;
    white-space: nowrap;
    padding: 0;
}
}
.sectionmenu {
    display: block;
    min-height: 110px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 5px;
    margin-bottom: 35px;
}
.sectionmenu .info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: right;
    height: 80px;
    margin-right: 20px;
    margin-top: 13px;
    margin-left: 10px;
    padding: 8px;
    border-radius: 60px;
    background-color: rgb(0 0 0 / 31%);
    color: white;
    width: 80px;
    text-align: center;
    font-size: 40px;
    line-height: 68px;
}
.sectionmenu .info-box-content {
    padding: 24px 10px;
    margin-left: 27px;
}
.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 14px;
}

/* Enhanced summary cards styling */
.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
    border-radius: 2px;
    margin-bottom: 15px;
}
.info-box .info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}
.info-box .info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}
.info-box .info-box-text {
    text-transform: uppercase;
    font-weight: bold;
    font-size: 13px;
}
.info-box .info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}
.info-box .info-box-more {
    display: block;
    font-size: 13px;
}

/* Inline editing styles */
.editable-amount, .editable-date {
    cursor: pointer;
    padding: 4px 6px;
    border-radius: 3px;
    transition: background-color 0.3s;
    display: inline-block;
    min-width: 80px;
}

.editable-amount:hover, .editable-date:hover {
    background-color: #f0f0f0;
    border: 1px dashed #337ab7;
}

.editable-amount.editing, .editable-date.editing {
    background-color: #fff;
    border: 2px solid #337ab7;
}

/* Credit/Debit column styling */
.credit-amount {
    color: #28a745 !important;
    font-weight: bold;
}

.debit-amount {
    color: #dc3545 !important;
    font-weight: bold;
}

.credit-column {
    background-color: #f8fff9;
    border-left: 3px solid #28a745;
}

.debit-column {
    background-color: #fff8f8;
    border-left: 3px solid #dc3545;
}

/* Credit/Debit summary styling */
.summary-credit {
    color: #28a745;
    font-weight: bold;
    font-size: 16px;
}

.summary-debit {
    color: #dc3545;
    font-weight: bold;
    font-size: 16px;
}

.balance-positive {
    color: #28a745;
    font-weight: bold;
}

.balance-negative {
    color: #dc3545;
    font-weight: bold;
}

.balance-zero {
    color: #6c757d;
    font-weight: normal;
}

.edit-input {
    border: none;
    background: transparent;
    width: 100%;
    text-align: center;
    font-size: inherit;
    padding: 2px;
}

.edit-input:focus {
    outline: none;
    background-color: #f9f9f9;
}

.edit-controls {
    margin-top: 2px;
    text-align: center;
}

.edit-controls button {
    font-size: 11px;
    padding: 2px 6px;
    margin: 0 2px;
}

.loading-spinner {
    display: inline-block;
    width: 12px;
    height: 12px;
    border: 2px solid #f3f3f3;
    border-top: 2px solid #3498db;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

</style>
<!-- bootstrap datepicker -->
<link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/datepicker/datepicker3.css">
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

  <!-- Left side column. contains the logo and sidebar -->

  <?php $this->load->view('sidebar.php');?>

  <?php $CI =& get_instance(); ?>
 
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?=$page_title;?>
       
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><?=$page_title;?></li>
      </ol>
    </section>

    <div class="pay_now_modal">
    </div>
   

    <!-- Main content -->
    <?=form_open('#', array('class' => '', 'id' => 'table_form'));?>
    <input type="hidden" id='base_url' value="<?=$base_url;?>">
    <section class="content">
      <!-- Small boxes (Stat box) -->


<div class="row">
  <!-- ********** ALERT MESSAGE START******* -->
        <?php $this->load->view('comman/code_flashdata.php');?>
        <!-- ********** ALERT MESSAGE END******* -->
        
        <!-- ********** INSTRUCTIONS START******* -->
        <div class="col-md-12">
          <div class="alert alert-info alert-dismissible">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            <h4><i class="icon fa fa-info-circle"></i> Quick Edit Instructions</h4>
            <ul class="mb-0">
              <li><strong>Payment Amount:</strong> Click on any payment amount to edit it inline</li>
              <li><strong>Payment Date:</strong> Click on any payment date to edit it (use DD-MM-YYYY format)</li>
              <li><strong>Filters:</strong> Use multiple filters to narrow down results and view balance summaries</li>
              <li><strong>Account Collections:</strong> Payments without sales ID are shown as "Account Payment Collection"</li>
            </ul>
          </div>
        </div>
        <!-- ********** INSTRUCTIONS END******* -->
</div>






      <div class="row">
        
        <div class="col-xs-12 ">
          <div class="box box-primary">
            <div class="box-header with-border">
              <!-- <h3 class="box-title"><?=$page_title;?></h3> -->

             
              <div class="row">

                <div class="col-md-12">

                <div class="col-md-2">
                    <div class="form-group">
                       <label for="customer_search"><?=$this->lang->line('customer_name');?></label>
                       <select class="form-control select2" id="customer_search" name="customer_search" style="width: 100%;">
                        <option value="">-All Customers-</option>
                        <?php
                          $q1=$this->db->query("select * from db_customers where status=1 and store_id=".get_current_store_id()." order by customer_name");
                           if($q1->num_rows()>0){
                               foreach($q1->result() as $res1){
                               echo "<option value='".$res1->id."'>".$res1->customer_name ."</option>";
                             }
                           }
                          ?>
                     </select>
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="payment_type_search"><?=$this->lang->line('payment_type');?></label>
                       <select class="form-control select2" id="payment_type_search" name="payment_type_search"  style="width: 100%;">
                        <option value="">-All Types-</option>
                        <?php
                          $q1=$this->db->query("select * from db_paymenttypes where status=1 and store_id=".get_current_store_id());
                           if($q1->num_rows()>0){
                               foreach($q1->result() as $res1){
                               echo "<option value='".$res1->payment_type."'>".$res1->payment_type ."</option>";
                             }
                           }
                          ?>
                     </select>
                    </div>
                  </div>

                   <div class="col-md-2">
                    <div class="form-group">
                       <label for="cheque_status_search"><?=$this->lang->line('payment_status');?></label>
                       <select class="form-control select2" id="cheque_status_search" name="cheque_status_search"  style="width: 100%;">
                        <option value="">-All Status-</option>
                        <?=get_cheque_status_select_list()?>
                     </select>
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="from_date">From Date</label>
                       <input type="text" class="form-control datepicker" id="from_date" name="from_date" placeholder="From Date" readonly>
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="to_date">To Date</label>
                       <input type="text" class="form-control datepicker" id="to_date" name="to_date" placeholder="To Date" readonly>
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="created_by_search">Created By</label>
                       <select class="form-control select2" id="created_by_search" name="created_by_search" style="width: 100%;">
                        <option value="">-All Users-</option>
                        <?php
                          $q1=$this->db->query("select distinct created_by from db_salespayments where store_id=".get_current_store_id()." order by created_by");
                           if($q1->num_rows()>0){
                               foreach($q1->result() as $res1){
                                 if(!empty($res1->created_by)){
                                   echo "<option value='".$res1->created_by."'>".$res1->created_by ."</option>";
                                 }
                               }
                           }
                          ?>
                     </select>
                    </div>
                  </div>

                </div>

                <div class="col-md-12">
                  
                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="payment_amount_from">Amount From</label>
                       <input type="number" step="0.01" class="form-control" id="payment_amount_from" name="payment_amount_from" placeholder="Min Amount">
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label for="payment_amount_to">Amount To</label>
                       <input type="number" step="0.01" class="form-control" id="payment_amount_to" name="payment_amount_to" placeholder="Max Amount">
                    </div>
                  </div>

                  <div class="col-md-2">
                    <div class="form-group">
                       <label>&nbsp;</label><br>
                       <button type="button" class="btn btn-primary" onclick="load_datatable()">
                         <i class="fa fa-search"></i> Search
                       </button>
                       <button type="button" class="btn btn-default" onclick="reset_filters()">
                         <i class="fa fa-refresh"></i> Reset
                       </button>
                       <div class="btn-group">
                         <button type="button" class="btn btn-warning dropdown-toggle" data-toggle="dropdown" title="Show outstanding balances and unpaid invoices">
                           <i class="fa fa-plus-circle"></i> Show Outstanding <span class="caret"></span>
                         </button>
                         <ul class="dropdown-menu">
                           <li><a href="#" onclick="create_outstanding_entries('outstanding')"><i class="fa fa-money"></i> Outstanding Balances</a></li>
                           <li><a href="#" onclick="create_outstanding_entries('unpaid_invoices')"><i class="fa fa-file-text-o"></i> Unpaid Invoices</a></li>
                         </ul>
                       </div>
                    </div>
                  </div>

                  <!-- Summary Cards -->
                  <div class="col-md-6">
                    <div id="payments_summary" style="display: none;">
                      <div class="row">
                        <div class="col-md-6">
                          <div class="info-box bg-green">
                            <span class="info-box-icon"><i class="fa fa-arrow-down"></i></span>
                            <div class="info-box-content">
                              <span class="info-box-text">Total Credit (Payments)</span>
                              <span class="info-box-number summary-credit" id="total_credit_amount">0.00</span>
                              <span class="info-box-more" id="total_payments_count">Count: 0</span>
                            </div>
                          </div>
                        </div>
                        <div class="col-md-6">
                          <div class="info-box bg-red">
                            <span class="info-box-icon"><i class="fa fa-arrow-up"></i></span>
                            <div class="info-box-content">
                              <span class="info-box-text">Total Debit (Sales)</span>
                              <span class="info-box-number summary-debit" id="total_debit_amount">0.00</span>
                              <span class="info-box-more" id="linked_sales_count">Linked Sales: 0</span>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="info-box bg-blue">
                            <span class="info-box-icon"><i class="fa fa-user"></i></span>
                            <div class="info-box-content">
                              <span class="info-box-text">Customer Balance</span>
                              <span class="info-box-number" id="opening_balance">Opening: 0.00</span>
                              <span class="info-box-more" id="closing_balance">Closing: 0.00</span>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>


                </div>
              </div>

            </div>
            <!-- /.box-header -->
            <div class="box-body ">
              <table id="example2" class="table custom_hover " width="100%">
                <thead class="bg-gray ">
                <tr>
                  <th width="4%">
                    <input type="checkbox" class="group_check checkbox" >
                  </th>
                  <th><?=$this->lang->line('payment_code');?></th>
                  <th title="Click to edit date"><?=$this->lang->line('payment_date');?> <i class="fa fa-edit text-muted"></i></th>
                  <th><?=$this->lang->line('sales_code');?></th>
                  <th><?=$this->lang->line('customer_name');?></th>
                  <th title="Click to edit amount" style="color: #28a745;">Credit (Payment) <i class="fa fa-edit text-muted"></i></th>
                  <th style="color: #dc3545;">Debit (Sales)</th>
                  <th>Bill Amount</th>
                  <th><?=$this->lang->line('payment_type');?></th>
                  <th><?=$this->lang->line('payment_note');?></th>
                  <th><?=$this->lang->line('created_by');?></th>
                  <th><?=$this->lang->line('action');?></th>
                </tr>
                </thead>
                <tbody>

                </tbody>
              

              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
    <?=form_close();?>
  </div>
  <!-- /.content-wrapper -->
  <?php $this->load->view('footer.php');?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
<?php $this->load->view('comman/code_js_sound.php');?>
<!-- TABLES CODE -->
<?php $this->load->view('comman/code_js.php');?>
<!-- bootstrap datepicker -->
<script src="<?php echo $theme_link; ?>plugins/datepicker/bootstrap-datepicker.js"></script>
<script src="<?php echo $theme_link; ?>js/sales_payments/create.js"></script>
<script type="text/javascript">
  //Date picker
    $('.datepicker').datepicker({
      autoclose: true,
      format: 'dd-mm-yyyy',
      todayHighlight: true
    });
    
    // Trigger search when date changes
    $('.datepicker').on('changeDate', function(){
      if ($.fn.DataTable.isDataTable('#example2')) {
        $('#example2').DataTable().destroy();
      }
      load_datatable();
    });
</script>
<script type="text/javascript">
      function load_datatable(){
        // Check if DataTable is already initialized and destroy it
        if ($.fn.DataTable.isDataTable('#example2')) {
          $('#example2').DataTable().destroy();
        }
        
        //datatables
         var table = $('#example2').DataTable({

            /* FOR EXPORT BUTTONS START*/
        dom:'<"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr><"pull-right margin-left-10 "B>>>tip',
       /* dom:'<"row"<"col-sm-12"<"pull-left"B><"pull-right">>> <"row margin-bottom-12"<"col-sm-12"<"pull-left"l><"pull-right"fr>>>tip',*/
            buttons: {
              buttons: [
                  {
                      className: 'btn bg-red color-palette btn-flat hidden delete_btn pull-left',
                      text: 'Delete',
                      action: function ( e, dt, node, config ) {
                          multi_delete();
                      }
                  },
                  { 
                    extend: 'copy', 
                    className: 'btn bg-teal color-palette btn-flat',
                    footer: true, 
                    exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11]},
                    title: function() {
                      return getExportTitle();
                    },
                    messageTop: function() {
                      return getExportHeader();
                    },
                    messageBottom: function() {
                      return getExportFooter();
                    }
                  },
                  { 
                    extend: 'excel', 
                    className: 'btn bg-teal color-palette btn-flat',
                    footer: true, 
                    exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11]},
                    title: function() {
                      return getExportTitle();
                    },
                    messageTop: function() {
                      return getExportHeader();
                    },
                    messageBottom: function() {
                      return getExportFooter();
                    }
                  },
                  { 
                    extend: 'pdf', 
                    className: 'btn bg-teal color-palette btn-flat',
                    footer: true, 
                    exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11]},
                    title: function() {
                      return getExportTitle();
                    },
                    messageTop: function() {
                      return getExportHeader();
                    },
                    messageBottom: function() {
                      return getExportFooter();
                    },
                    customize: function(doc) {
                      // Add custom styling for PDF with proper error checking
                      try {
                        if (doc && doc.content && doc.content[1] && doc.content[1].table) {
                          doc.content[1].table.widths = ['6%', '10%', '10%', '12%', '12%', '10%', '10%', '8%', '10%', '8%', '8%', '6%'];
                        }
                        if (doc && doc.styles) {
                          if (doc.styles.tableHeader) {
                            doc.styles.tableHeader.fontSize = 7;
                          }
                          if (doc.styles.tableBodyEven) {
                            doc.styles.tableBodyEven.fontSize = 6;
                          }
                          if (doc.styles.tableBodyOdd) {
                            doc.styles.tableBodyOdd.fontSize = 6;
                          }
                        }
                        if (doc && doc.defaultStyle) {
                          doc.defaultStyle.fontSize = 6;
                        }
                      } catch (e) {
                        console.log('PDF customization error:', e);
                      }
                    }
                  },
                  { 
                    extend: 'print', 
                    className: 'btn bg-teal color-palette btn-flat',
                    footer: true, 
                    exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11]},
                    title: function() {
                      return getExportTitle();
                    },
                    messageTop: function() {
                      return getExportHeader();
                    },
                    messageBottom: function() {
                      return getExportFooter();
                    }
                  },
                  { 
                    extend: 'csv', 
                    className: 'btn bg-teal color-palette btn-flat',
                    footer: true, 
                    exportOptions: { columns: [0,1,2,3,4,5,6,7,8,9,10,11]},
                    title: function() {
                      return getExportTitle();
                    }
                  },
                  { extend: 'colvis', className: 'btn bg-teal color-palette btn-flat',footer: true, text:'Columns' },
                  {
                      text: 'Detailed Report',
                      className: 'btn bg-purple color-palette btn-flat',
                      action: function ( e, dt, node, config ) {
                          exportDetailedReport();
                      }
                  }

                  ]
              },
              /* FOR EXPORT BUTTONS END */

              "processing": true, //Feature control the processing indicator.
              "serverSide": true, //Feature control DataTables' server-side processing mode.
              "order": [], //Initial no order.
              "responsive": true,
              language: {
                  processing: '<div class="text-primary bg-primary" style="position: relative;z-index:100;overflow: visible;">Processing...</div>'
              },
              // Load data for the table's content from an Ajax source
              "ajax": {
                  "url": "<?php echo site_url('sales_payments/ajax_list') ?>",
                  "type": "POST",
                  "data": function(d) {
                      d.cheque_status_search = $("#cheque_status_search").val();
                      d.payment_type_search = $("#payment_type_search").val();
                      d.customer_search = $("#customer_search").val();
                      d.from_date = $("#from_date").val();
                      d.to_date = $("#to_date").val();
                      d.payment_amount_from = $("#payment_amount_from").val();
                      d.payment_amount_to = $("#payment_amount_to").val();
                      d.created_by_search = $("#created_by_search").val();
                    },
                  complete: function (data) {
                   $('.column_checkbox').iCheck({
                      checkboxClass: 'icheckbox_square-orange',
                      /*uncheckedClass: 'bg-white',*/
                      radioClass: 'iradio_square-orange',
                      increaseArea: '10%' // optional
                    });
                   call_code();
                    //$(".delete_btn").hide();
                   
                   // Load summary data
                   load_payments_summary();
                   },

              },

              //Set column definition initialisation properties.
              "columnDefs": [
              {
                  "targets": [ 0,11 ], //first column (checkbox) and last column (actions)
                  "orderable": false, //set not orderable
              },
              {
                  "targets" :[0],
                  "className": "text-center",
              },
              {
                  "targets" :[5], //credit amount column  
                  "className": "text-right text-success",
              },
              {
                  "targets" :[6], //debit amount column
                  "className": "text-right text-danger",
              },
              {
                  "targets" :[7], //bill amount column
                  "className": "text-right",
              },

              ],
          
          });

          new $.fn.dataTable.FixedHeader( table );
      }
      $(document).ready(function() {
          // Check for preselected customer from URL parameter
          var preselectedCustomerId = '<?= isset($preselected_customer_id) ? $preselected_customer_id : "" ?>';
          if(preselectedCustomerId && preselectedCustomerId !== '') {
              // Set the customer dropdown value and trigger change
              $("#customer_search").val(preselectedCustomerId).trigger('change');
              
              // Show a notification that the customer is pre-selected
              setTimeout(function() {
                  var customerName = $("#customer_search option:selected").text();
                  toastr.info('Showing payments for customer: ' + customerName, 'Pre-filtered View');
              }, 500);
          }
          
          //datatables
         load_datatable();
      });
     
      $("#cheque_status_search,#payment_type_search,#customer_search,#from_date,#to_date,#payment_amount_from,#payment_amount_to,#created_by_search").on("change",function(){
        if ($.fn.DataTable.isDataTable('#example2')) {
          $('#example2').DataTable().destroy();
        }
        load_datatable();
      });

      // Reset filters
      function reset_filters() {
        $("#cheque_status_search").val('').trigger('change');
        $("#payment_type_search").val('').trigger('change');
        $("#customer_search").val('').trigger('change');
        $("#from_date").val('');
        $("#to_date").val('');
        $("#payment_amount_from").val('');
        $("#payment_amount_to").val('');
        $("#created_by_search").val('').trigger('change');
        
        if ($.fn.DataTable.isDataTable('#example2')) {
          $('#example2').DataTable().destroy();
        }
        load_datatable();
      }

      // Inline editing functionality
      $(document).on('click', '.editable-amount, .editable-date', function() {
        if($(this).hasClass('editing')) return;
        
        var $this = $(this);
        var id = $this.data('id');
        var field = $this.data('field');
        var currentValue = $this.data('value');
        var displayValue = $this.text();
        
        $this.addClass('editing');
        
        var inputType = field === 'payment_date' ? 'text' : 'number';
        var inputStep = field === 'payment' ? 'step="0.01"' : '';
        var placeholder = field === 'payment_date' ? 'DD-MM-YYYY' : 'Amount';
        
        var editHtml = '<input type="' + inputType + '" class="edit-input" value="' + 
                       (field === 'payment_date' ? formatDateForInput(currentValue) : currentValue) + 
                       '" ' + inputStep + ' placeholder="' + placeholder + '">' +
                       '<div class="edit-controls">' +
                       '<button class="btn btn-xs btn-success save-edit" data-id="' + id + '" data-field="' + field + '">✓</button>' +
                       '<button class="btn btn-xs btn-default cancel-edit">✗</button>' +
                       '</div>';
        
        $this.html(editHtml);
        $this.find('.edit-input').focus().select();
      });

      // Save edit
      $(document).on('click', '.save-edit', function() {
        var $button = $(this);
        var $container = $button.closest('.editable-amount, .editable-date');
        var id = $button.data('id');
        var field = $button.data('field');
        var newValue = $container.find('.edit-input').val();
        
        if(!newValue || newValue.trim() === '') {
          alert('Please enter a valid value');
          return;
        }
        
        $button.html('<span class="loading-spinner"></span>');
        $button.prop('disabled', true);
        
        var url = field === 'payment' ? 
                  '<?php echo site_url("sales_payments/update_payment_amount"); ?>' :
                  '<?php echo site_url("sales_payments/update_payment_date"); ?>';
        
        var data = {
          payment_id: id
        };
        data[field === 'payment' ? 'payment_amount' : 'payment_date'] = newValue;
        
        $.ajax({
          url: url,
          type: 'POST',
          data: data,
          dataType: 'json',
          success: function(response) {
            if(response.status === 'success') {
              // Update the display
              $container.removeClass('editing');
              if(field === 'payment') {
                $container.html(response.new_amount);
                $container.data('value', newValue);
              } else {
                $container.html(response.new_date);
                $container.data('value', newValue);
              }
              
              // Show success message
              toastr.success(response.message);
              
              // Reload summary
              load_payments_summary();
              
            } else {
              alert(response.message || 'Failed to update');
              cancelEdit($container);
            }
          },
          error: function() {
            alert('Network error occurred');
            cancelEdit($container);
          }
        });
      });

      // Cancel edit
      $(document).on('click', '.cancel-edit', function() {
        var $container = $(this).closest('.editable-amount, .editable-date');
        cancelEdit($container);
      });

      // Handle Enter key to save
      $(document).on('keypress', '.edit-input', function(e) {
        if(e.which === 13) { // Enter key
          $(this).closest('.editable-amount, .editable-date').find('.save-edit').click();
        } else if(e.which === 27) { // Escape key
          $(this).closest('.editable-amount, .editable-date').find('.cancel-edit').click();
        }
      });

      function cancelEdit($container) {
        var field = $container.data('field');
        var currentValue = $container.data('value');
        
        $container.removeClass('editing');
        
        if(field === 'payment') {
          // Format as currency
          var formatted = parseFloat(currentValue).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
          $container.html(formatted);
        } else {
          // Format as date
          $container.html(formatDateForDisplay(currentValue));
        }
      }

      function formatDateForInput(dateValue) {
        // Convert Y-m-d to d-m-Y for input
        if(dateValue && dateValue.length === 10) {
          var parts = dateValue.split('-');
          return parts[2] + '-' + parts[1] + '-' + parts[0];
        }
        return dateValue;
      }

      function formatDateForDisplay(dateValue) {
        // This should match your show_date() PHP function format
        if(dateValue && dateValue.length === 10) {
          var parts = dateValue.split('-');
          return parts[2] + '-' + parts[1] + '-' + parts[0];
        }
        return dateValue;
      }

      // Export helper functions
      function getExportTitle() {
        return 'Sales Payments Report - Generated on ' + new Date().toLocaleDateString();
      }

      function getExportHeader() {
        var header = 'SALES PAYMENTS REPORT\n';
        header += '========================\n\n';
        
        // Add filter information
        header += 'APPLIED FILTERS:\n';
        header += '----------------\n';
        
        var customerText = $("#customer_search option:selected").text();
        if($("#customer_search").val()) {
          header += 'Customer: ' + customerText + '\n';
        } else {
          header += 'Customer: All Customers\n';
        }
        
        var paymentTypeText = $("#payment_type_search option:selected").text();
        if($("#payment_type_search").val()) {
          header += 'Payment Type: ' + paymentTypeText + '\n';
        } else {
          header += 'Payment Type: All Types\n';
        }
        
        var statusText = $("#cheque_status_search option:selected").text();
        if($("#cheque_status_search").val()) {
          header += 'Payment Status: ' + statusText + '\n';
        } else {
          header += 'Payment Status: All Status\n';
        }
        
        if($("#from_date").val()) {
          header += 'From Date: ' + $("#from_date").val() + '\n';
        } else {
          header += 'From Date: All Dates\n';
        }
        
        if($("#to_date").val()) {
          header += 'To Date: ' + $("#to_date").val() + '\n';
        } else {
          header += 'To Date: All Dates\n';
        }
        
        var createdByText = $("#created_by_search option:selected").text();
        if($("#created_by_search").val()) {
          header += 'Created By: ' + createdByText + '\n';
        } else {
          header += 'Created By: All Users\n';
        }
        
        if($("#payment_amount_from").val()) {
          header += 'Amount From: ' + $("#payment_amount_from").val() + '\n';
        } else {
          header += 'Amount From: No Minimum\n';
        }
        
        if($("#payment_amount_to").val()) {
          header += 'Amount To: ' + $("#payment_amount_to").val() + '\n';
        } else {
          header += 'Amount To: No Maximum\n';
        }
        
        header += '\n';
        return header;
      }

      function getExportFooter() {
        var footer = '\n\nSUMMARY INFORMATION:\n';
        footer += '===================\n';
        
        // Get Total Credit (Payments) information
        var totalCreditAmount = $("#total_credit_amount").text() || '0.00';
        var totalPaymentsCount = $("#total_payments_count").text().replace('Count: ', '') || '0';
        footer += 'Total Credit (Payments): ' + totalCreditAmount + '\n';
        footer += 'Count: ' + totalPaymentsCount + '\n';
        
        // Get Total Debit (Sales) information  
        var totalDebitAmount = $("#total_debit_amount").text() || '0.00';
        var linkedSalesCount = $("#linked_sales_count").text().replace('Linked Sales: ', '') || '0';
        footer += 'Total Debit (Sales): ' + totalDebitAmount + '\n';
        footer += 'Linked Sales: ' + linkedSalesCount + '\n';
        
        // Add customer balance if available
        if($("#customer_search").val() && $("#opening_balance").is(':visible')) {
          var openingBalance = $("#opening_balance").text().replace('Opening: ', '') || '0.00';
          var closingBalance = $("#closing_balance").text().replace('Closing: ', '') || '0.00';
          footer += '\nCustomer Balance:\n';
          footer += 'Opening: ' + openingBalance + '\n';
          footer += 'Closing: ' + closingBalance + '\n';
        }
        
        // Add net balance calculation
        var creditAmount = parseFloat(totalCreditAmount.replace(/[^0-9.-]/g, '')) || 0;
        var debitAmount = parseFloat(totalDebitAmount.replace(/[^0-9.-]/g, '')) || 0;
        var netBalance = debitAmount - creditAmount;
        footer += '\nNet Balance (Outstanding): ' + netBalance.toFixed(2) + '\n';
        
        footer += '\n';
        footer += 'Generated on: ' + new Date().toLocaleString() + '\n';
        footer += 'System: Sales Payments Management\n';
        
        return footer;
      }

      // Store current summary data globally for export
      var currentSummaryData = {};
      
      // Update the load_payments_summary function to store data
      function load_payments_summary() {
        $.ajax({
          url: "<?php echo site_url('sales_payments/get_payments_summary') ?>",
          type: "POST",
          data: {
            cheque_status_search: $("#cheque_status_search").val(),
            payment_type_search: $("#payment_type_search").val(),
            customer_search: $("#customer_search").val(),
            from_date: $("#from_date").val(),
            to_date: $("#to_date").val(),
            payment_amount_from: $("#payment_amount_from").val(),
            payment_amount_to: $("#payment_amount_to").val(),
            created_by_search: $("#created_by_search").val(),
          },
          dataType: "json",
          success: function(response) {
            // Store for export
            currentSummaryData = response;
            
            $("#total_payments_count").text("Count: " + response.total_records);
            $("#total_credit_amount").text(parseFloat(response.total_amount).toFixed(2));
            $("#total_debit_amount").text(parseFloat(response.total_debit_amount).toFixed(2));
            $("#linked_sales_count").text("Linked Sales: " + response.linked_sales_count);
            
            if($("#customer_search").val() && (response.opening_balance !== undefined || response.closing_balance !== undefined)) {
              $("#opening_balance").text("Opening: " + parseFloat(response.opening_balance || 0).toFixed(2));
              $("#closing_balance").text("Closing: " + parseFloat(response.closing_balance || 0).toFixed(2));
              $(".info-box:has(#opening_balance)").show();
            } else {
              $(".info-box:has(#opening_balance)").hide();
            }
            
            $("#payments_summary").show();
          }
        });
      }

      // Export detailed report with filters and summary
      function exportDetailedReport() {
        // Show loading message
        toastr.info('Generating detailed report...');
        
        // Create form data with current filters
        var formData = {
          customer_search: $("#customer_search").val(),
          payment_type_search: $("#payment_type_search").val(),
          cheque_status_search: $("#cheque_status_search").val(),
          from_date: $("#from_date").val(),
          to_date: $("#to_date").val(),
          payment_amount_from: $("#payment_amount_from").val(),
          payment_amount_to: $("#payment_amount_to").val(),
          created_by_search: $("#created_by_search").val()
        };
        
        // Create a temporary form for submission
        var form = $('<form>', {
          'method': 'POST',
          'action': '<?php echo site_url("sales_payments/export_detailed_report"); ?>',
          'target': '_blank'
        });
        
        // Add form fields
        $.each(formData, function(key, value) {
          form.append($('<input>', {
            'type': 'hidden',
            'name': key,
            'value': value
          }));
        });
        
        // Submit form
        form.appendTo('body').submit().remove();
        
        // Show success message
        setTimeout(function() {
          toastr.success('Detailed report download initiated!');
        }, 1000);
      }

      // Create outstanding balance entries
      function create_outstanding_entries(entry_type) {
        var customer_id = $("#customer_search").val();
        var message_text = '';
        var confirm_text = '';
        
        if(entry_type == 'unpaid_invoices') {
          message_text = 'unpaid invoice entries';
          confirm_text = 'This will create payment entries for unpaid invoices to show them in the payments report. Continue?';
        } else {
          message_text = 'outstanding balance entries';
          confirm_text = 'This will create payment entries for customers with outstanding balances but no payment records. Continue?';
        }
        
        if(confirm(confirm_text)) {
          $.ajax({
            url: base_url + 'sales_payments/create_outstanding_entries',
            type: 'POST',
            data: {
              customer_id: customer_id,
              entry_type: entry_type,
              '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
            },
            dataType: 'json',
            beforeSend: function() {
              $('.btn-warning.dropdown-toggle').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
            },
            success: function(response) {
              if(response.success) {
                toastr.success(response.message);
                // Reload the table to show new entries
                if ($.fn.DataTable.isDataTable('#example2')) {
                  $('#example2').DataTable().destroy();
                }
                load_datatable();
              } else {
                toastr.info(response.message);
              }
            },
            error: function() {
              toastr.error('Error occurred while creating ' + message_text);
            },
            complete: function() {
              $('.btn-warning.dropdown-toggle').prop('disabled', false).html('<i class="fa fa-plus-circle"></i> Show Outstanding <span class="caret"></span>');
            }
          });
        }
      }


</script>

<!-- Make sidebar menu hughlighter/selector -->
<script>$(".sales-payments-list-active-li").addClass("active");</script>

</body>
</html>
