<!DOCTYPE html>
<html>
<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">

 
  <!-- Left side column. contains the logo and sidebar -->
  <?php include"sidebar.php"; ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <?=$page_title;?>
        <small>View/Search Sales Return Types</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active"><?=$page_title;?></li>
      </ol>
    </section>

     <!-- Main content -->
    <section class="content">
      <div class="row">
        <input type="hidden" id='base_url' value="<?=$base_url;?>">
        <div class="col-xs-12">
         <div class="box box-primary">
            <div class="box-header with-border">
              <h3 class="box-title">Sales Return Types List</h3>
              <?php if($CI->permissions('sales_return_types_add')) { ?>
              <div class="box-tools">
                <a class="btn btn-block btn-info" href="<?php echo $base_url; ?>sales_return_types/add">
                   <i class="fa fa-plus fa-lg"></i> New</a>
              </div>
              <?php } ?>
            </div>
            <!-- /.box-header -->
            <div class="box-body">
              <table id="example2" class="table table-bordered table-striped" width="100%">
                <thead class="bg-primary ">
                <tr>
                  <th style="width:20%">Sales Return Type Name</th>
                  <th style="width:15%">Initial</th>
                  <th style="width:35%">Description</th>
                  <th style="width:15%">Status</th>
                  <th style="width:15%">Action</th>
                </tr>
                </thead>
                <tbody>
               
                </tbody>
               
              </table>
            </div>
            <!-- /.box-body -->
          </div>
          <!-- /.box -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
      
      <!-- MAILBOX COMPOSE MESSAGE MODAL -->
      <div class="modal fade" id="compose-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
          <div class="modal-content">
            <div class="modal-header">
              <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
              <h4 class="modal-title"><i class="fa fa-info-circle text-blue"></i> Sales Return Type Information</h4>
            </div>
            <div class="modal-body">
              <div class="form-group">
                <div id="modal_body">
                  
                </div>
              </div>
            </div>
          </div>
          <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
      </div>
      <!-- /.modal -->
      
      <!-- Show the actual flash messages -->
      <div class="row">
        <div class="col-sm-12">
          <?php include"comman/code_flashdata.php"; ?>
        </div>
      </div>
      
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  
  <?php include"footer.php"; ?>
  <!-- Add the sidebar's background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->

<!-- TABLES CODE -->
<?php include"comman/code_js.php"; ?>

<script type="text/javascript">
var base_url = "<?php echo base_url(); ?>";

$(document).ready(function() {
    // Debug: Check if base_url is properly set
    console.log('Base URL:', base_url);
    
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false,
      "responsive": true,
      "processing": true,
      "serverSide": true,
      "order": [],
      "ajax": {
          "url": base_url + "sales_return_types/ajax_list",
          "type": "POST"
      },
      "columnDefs": [
      { 
          "targets": [ -1 ],
          "orderable": false,
      },
      ],
    });
});

function update_status(id,status){
  if(confirm("Do You Wants to Change Status ?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url + "sales_return_types/update_status",{id:id,status:status},function(result){
      if(result=="success") {
        toastr["success"]("Status Updated Successfully!");
        $('#example2').DataTable().ajax.reload();
      } else if(result=="failed"){
        toastr["error"]("Status Update Failed!");
      } else {
        toastr["error"](result);
      }
      $(".overlay").remove();
    });
  }
}

function delete_sales_return_type(q_id){
  if(confirm("Do You Wants to Delete Record ?")){
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.post(base_url + "sales_return_types/delete_sales_return_type",{q_id:q_id},function(result){
      if(result=="success") {
        toastr["success"]("Record Deleted Successfully!");
        $('#example2').DataTable().ajax.reload();
      } else if(result=="failed"){
        toastr["error"]("Failed to Delete Record!");
      } else {
        toastr["error"](result);
      }
      $(".overlay").remove();
    });
  }
}
</script>

<!-- Make sidebar less active -->
<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
