<!DOCTYPE html>
<html>
   <head>
      <!-- TABLES CSS CODE -->
      <?php include"comman/code_css.php"; ?>
      <!-- </copy> -->  
   </head>
   <body class="hold-transition skin-blue sidebar-mini">
      <div class="wrapper">
         <?php include"sidebar.php"; ?>
         <!-- Content Wrapper. Contains page content -->
         <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
               <h1>
                  <?=$page_title;?>
                  <small></small>
               </h1>
               <ol class="breadcrumb">
                  <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                  <li class="active"><?=$page_title;?></li>
               </ol>
            </section>
            <!-- Main content -->
            <section class="content">
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <!-- Horizontal Form -->
                     <div class="box box-primary ">
                        <div class="box-header with-border">
                           <h3 class="box-title">WooCommerce Orders Filter</h3>
                        </div>
                        <!-- /.box-header -->
                        <!-- form start -->
                        <form class="form-horizontal" id="report-form" onkeypress="return event.keyCode != 13;">
                           <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                           <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
                           <div class="box-body">
                              <div class="form-group">
                                 <label for="from_date" class="col-sm-2 control-label">From Date</label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control datepicker" id="from_date" name="from_date" value="<?php echo date("d-m-Y", strtotime('-30 days'));?>" readonly>
                                    </div>
                                 </div>
                                 <label for="to_date" class="col-sm-2 control-label">To Date</label>
                                 <div class="col-sm-3">
                                    <div class="input-group date">
                                       <div class="input-group-addon">
                                          <i class="fa fa-calendar"></i>
                                       </div>
                                       <input type="text" class="form-control datepicker" id="to_date" name="to_date" value="<?php echo date("d-m-Y");?>" readonly>
                                    </div>
                                 </div>
                                 <div class="col-sm-2">
                                    <button type="button" id="show_all" class="btn btn-info btn-sm" title="Show All Orders">Show All</button>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-body -->
                           <div class="box-footer">
                              <div class="col-sm-8 col-sm-offset-2 text-center">
                                 <div class="col-md-3 col-md-offset-3">
                                    <button type="button" id="view" class=" btn btn-block btn-success" title="Show Report">Show</button>
                                 </div>
                                 <div class="col-sm-3">
                                    <a href="<?= base_url('dashboard') ?>">
                                    <button type="button" class="col-sm-3 btn btn-block btn-gray">Cancel</button>
                                    </a>
                                 </div>
                              </div>
                           </div>
                           <!-- /.box-footer -->
                        </form>
                     </div>
                     <!-- /.box -->
                  </div>
                  <!--/.col (right) -->
               </div>
               <!-- /.row -->
               <div class="row">
                  <!-- right column -->
                  <div class="col-md-12">
                     <div class="box">
                        <div class="box-header">
                           <h3 class="box-title">WooCommerce Orders Report</h3>
                           <?php $this->load->view('components/export_btn',array('tableId' => 'report_table'));?>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body table-responsive no-padding">
                           <table class="table table-bordered table-hover " id="report_table">
                              <thead>
                                 <tr class="bg-gray ">
                                    <th style="">#</th>
                                    <th style="">Order ID</th>
                                    <th style="">Date</th>
                                    <th style="">Time</th>
                                    <th style="">Customer</th>
                                    <th style="">Email</th>
                                    <th style="">Phone</th>
                                    <th style="">Status</th>
                                    <th style="">Amount</th>
                                    <th style="">Payment Method</th>
                                 </tr>
                              </thead>
                              <tbody id="tbody">
                              </tbody>
                           </table>
                        </div>
                        <!-- /.box-body -->
                     </div>
                     <!-- /.box -->
                  </div>
               </div>
            </section>
            <!-- /.content -->
         </div>
         <!-- /.content-wrapper -->
         <?php include"footer.php"; ?>
         <!-- Add the sidebar's background. This div must be placed
            immediately after the control sidebar -->
         <div class="control-sidebar-bg"></div>
      </div>
      <!-- ./wrapper -->
      <!-- SOUND CODE -->
      <?php include"comman/code_js_sound.php"; ?>
      <!-- TABLES CODE -->
      <?php include"comman/code_js.php"; ?>

      <script type="text/javascript">
         $(document).ready(function() {
            //Date picker
            $('.datepicker').datepicker({
              autoclose: true,
              format: 'dd-mm-yyyy',
              todayHighlight: true
            });
         });
         
         $('#view').click(function(){
            view_report();
         });
         
         $('#show_all').click(function(){
            $("#from_date").val('');
            $("#to_date").val('');
            view_report();
         });
         
         function view_report(){
            var from_date = $("#from_date").val();
            var to_date = $("#to_date").val();
            
            // Allow empty dates for "show all" functionality
            if(from_date == "" && to_date == ""){
               // Show all orders
            } else if(from_date != "" && to_date == ""){
               toastr["warning"]("Please select To Date or click 'Show All' for all orders..!");
               return;
            } else if(from_date == "" && to_date != ""){
               toastr["warning"]("Please select From Date or click 'Show All' for all orders..!");
               return;
            }
            
            $("#view").attr('disabled',true);
            $("#view").html('<i class="fa fa-spinner fa-spin"></i> Loading...');
            $("#show_all").attr('disabled',true);
            
            var base_url = $("#base_url").val();
            $.ajax({
               url : base_url + "reports/show_woocommerce_orders",
               type: "POST",
               dataType: 'html',
               data: $('#report-form').serialize(),
               success: function(result){
                  $("#tbody").html(result);
                  $("#view").attr('disabled',false);
                  $("#view").html('Show');
                  $("#show_all").attr('disabled',false);
               },
               error: function(xhr, status, error) {
                  toastr["error"]("Error loading report: " + error);
                  $("#view").attr('disabled',false);
                  $("#view").html('Show');
                  $("#show_all").attr('disabled',false);
               }
            });
         }
         
         // Load report on page load
         $(document).ready(function(){
            view_report();
         });
      </script>
   </body>
</html>
