<!DOCTYPE html>
<html>
<head>
    <?php include"comman/code_css.php"; ?>
    <style>
        .required { border-color: #dd4b39 !important; }
    </style>
</head>
<body class="hold-transition skin-blue sidebar-mini">
<div class="wrapper">
    <?php include"sidebar.php"; ?>
    
    <?php
    // Initialize variables
    if(!isset($purchase_type_name)) $purchase_type_name = '';
    if(!isset($purchase_type_initial)) $purchase_type_initial = '';
    if(!isset($description)) $description = '';
    if(!isset($store_id)) $store_id = '';
    ?>
    
    <div class="content-wrapper">
        <section class="content-header">
            <h1>Purchase Types <small>Add/Update Purchase Types</small></h1>
            <ol class="breadcrumb">
                <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="<?php echo $base_url; ?>purchase_types">Purchase Types List</a></li>
                <li class="active">Purchase Type</li>
            </ol>
        </section>
        
        <section class="content">
            <div class="row">
                <?php include"comman/code_flashdata.php"; ?>
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title">Purchase Type Details</h3>
                        </div>
                        
                        <form class="form-horizontal" id="purchase-types-form" onkeypress="return event.keyCode != 13;">
                            <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
                            <input type="hidden" id="base_url" value="<?php echo $base_url; ?>">
                            <?php if(isset($q_id)){ ?>
                                <input type="hidden" id="q_id" name="q_id" value="<?php echo $q_id; ?>">
                            <?php } ?>
                            
                            <div class="box-body">
                                <?php echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>"; ?>
                                
                                <!-- Purchase Type Name -->
                                <div class="form-group">
                                    <label for="purchase_type_name" class="col-sm-2 control-label">Purchase Type Name <span class="text-red">*</span></label>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="purchase_type_name" name="purchase_type_name" placeholder="Enter Purchase Type Name" value="<?php echo $purchase_type_name; ?>" tabindex="1">
                                        <span id="purchase_type_name_msg" style="display:none" class="text-danger"></span>
                                    </div>
                                </div>
                                
                                <!-- Purchase Type Initial -->
                                <div class="form-group">
                                    <label for="purchase_type_initial" class="col-sm-2 control-label">Purchase Type Initial <span class="text-red">*</span></label>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control" id="purchase_type_initial" name="purchase_type_initial" placeholder="Enter Purchase Type Initial" value="<?php echo $purchase_type_initial; ?>" tabindex="2" maxlength="10">
                                        <span id="purchase_type_initial_msg" style="display:none" class="text-danger"></span>
                                    </div>
                                </div>
                                
                                <!-- Description -->
                                <div class="form-group">
                                    <label for="description" class="col-sm-2 control-label">Description</label>
                                    <div class="col-sm-6">
                                        <textarea class="form-control" rows="3" id="description" name="description" placeholder="Enter Description" tabindex="3"><?php echo $description; ?></textarea>
                                        <span id="description_msg" style="display:none" class="text-danger"></span>
                                    </div>
                                </div>
                                
                            </div>
                            
                            <div class="box-footer">
                                <div class="col-sm-8 col-sm-offset-2 text-center">
                                    <?php
                                    if(!empty($purchase_type_name)){
                                        $btn_name = "Update";
                                        $btn_id = "update";
                                    } else {
                                        $btn_name = "Save";
                                        $btn_id = "save";
                                    }
                                    ?>
                                    <div class="col-md-3 col-md-offset-3">
                                        <button type="button" id="<?php echo $btn_id; ?>" class="btn btn-block btn-success" title="Save Data"><?php echo $btn_name; ?></button>
                                    </div>
                                    <div class="col-sm-3">
                                        <a href="<?=base_url('purchase_types'); ?>" class="btn btn-block btn-warning">Cancel</a>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
    </div>
    
    <?php include"footer.php"; ?>
    <div class="control-sidebar-bg"></div>
</div>

<?php include"comman/code_js_sound.php"; ?>
<?php include"comman/code_js.php"; ?>
<script src="<?php echo $theme_link; ?>js/purchase_types.js"></script>

<script type="text/javascript">
    <?php if(isset($q_id)){ ?>
    $("#store_id").attr('readonly', true);
    <?php } ?>
</script>

<script>$(".<?php echo basename(__FILE__,'.php');?>-active-li").addClass("active");</script>
</body>
</html>
