<!DOCTYPE html>
<html>

<head>
<!-- TABLES CSS CODE -->
<?php include"comman/code_css.php"; ?>
<!-- iCheck -->
  <link rel="stylesheet" href="<?php echo $theme_link; ?>plugins/iCheck/square/blue.css">
  <link rel="stylesheet" href="<?= base_url('theme/css/pos.css') ?>">
  
  <!-- Modern POS Button Styles -->
  <style>
    /* Modern Action Buttons - Compact Design */
    .pos-action-btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 4px 8px;
      border: none;
      border-radius: 4px;
      font-size: 11px;
      font-weight: 500;
      text-decoration: none;
      transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
      cursor: pointer;
      min-width: 70px;
      height: 26px;
      gap: 4px;
      box-shadow: 0 1px 2px rgba(0,0,0,0.1);
      position: relative;
      overflow: hidden;
      letter-spacing: 0.3px;
    }
    
    .pos-action-btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
      transition: left 0.5s;
    }
    
    .pos-action-btn:hover::before {
      left: 100%;
    }
    
    .pos-action-btn:hover {
      transform: translateY(-1px);
      box-shadow: 0 2px 6px rgba(0,0,0,0.15);
      text-decoration: none;
    }
    
    .pos-action-btn:active {
      transform: translateY(0);
      box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    /* Customer Button */
    .pos-customer-btn {
      background: linear-gradient(135deg, #4c63d2 0%, #5a67d8 100%);
      color: white;
      border: 1px solid rgba(76, 99, 210, 0.3);
    }
    
    .pos-customer-btn:hover {
      background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
      color: white;
      border-color: rgba(66, 153, 225, 0.3);
    }
    
    .pos-customer-btn:focus {
      box-shadow: 0 0 0 2px rgba(76, 99, 210, 0.2);
      outline: none;
    }
    
    /* Item Button */
    .pos-item-btn {
      background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
      color: white;
      border: 1px solid rgba(72, 187, 120, 0.3);
    }
    
    .pos-item-btn:hover {
      background: linear-gradient(135deg, #68d391 0%, #48bb78 100%);
      color: white;
      border-color: rgba(104, 211, 145, 0.3);
    }
    
    .pos-item-btn:focus {
      box-shadow: 0 0 0 2px rgba(72, 187, 120, 0.2);
      outline: none;
    }
    
    /* Expense Button */
    .pos-expense-btn {
      background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
      color: white;
      border: 1px solid rgba(237, 137, 54, 0.3);
    }
    
    .pos-expense-btn:hover {
      background: linear-gradient(135deg, #f6ad55 0%, #ed8936 100%);
      color: white;
      border-color: rgba(246, 173, 85, 0.3);
    }
    
    .pos-expense-btn:focus {
      box-shadow: 0 0 0 2px rgba(237, 137, 54, 0.2);
      outline: none;
    }
    
    /* Icon styles */
    .pos-action-btn i {
      font-size: 12px;
      filter: drop-shadow(0 1px 1px rgba(0,0,0,0.1));
    }
    
    /* Text styling */
    .pos-action-btn span {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
      font-size: 10px;
    }
    
    /* Compact style for action buttons container */
    .pos-actions-container {
      display: inline-flex;
      gap: 4px;
      align-items: center;
      margin-left: 6px;
      margin-top: 2px;
      margin-bottom: 2px;
    }
    
    /* Enhanced input group styling for compact layout */
    .pos-enhanced-input {
      margin-bottom: 3px;
    }
    
    .pos-enhanced-input .input-group {
      border-radius: 4px;
      overflow: hidden;
      box-shadow: 0 1px 2px rgba(0,0,0,0.05);
    }
    
    .pos-enhanced-input .form-control {
      border: 1px solid #e2e8f0;
      font-size: 12px;
      height: 28px;
      padding: 3px 6px;
    }
    
    .pos-enhanced-input .form-control:focus {
      border-color: #4c63d2;
      box-shadow: 0 0 0 1px rgba(76, 99, 210, 0.1);
    }
    
    .pos-enhanced-input .input-group-addon {
      background: #f7fafc;
      border: 1px solid #e2e8f0;
      color: #4a5568;
      padding: 3px 6px;
      font-size: 11px;
    }
    
    /* Compact row styling */
    .pos-compact-row {
      margin-bottom: 6px;
    }
    
    .pos-compact-row .col-md-6 {
      padding-left: 6px;
      padding-right: 6px;
    }
    
    /* Enhanced table height for more items visibility */
    .pos-items-table-container {
      overflow-y: auto;
      height: 350px !important;
      border: 3px solid #337ab7;
      margin-bottom: 8px;
    }
    
    /* Input row with inline buttons */
    .pos-input-row {
      display: flex;
      align-items: flex-start;
      gap: 0;
    }
    
    .pos-input-row .pos-enhanced-input {
      flex: 1;
      margin-bottom: 0;
    }
    
    /* Ultra-compact layout */
    .pos-ultra-compact {
      padding: 2px 4px;
      margin: 2px 0;
    }
    
    /* Reduce form spacing */
    .form-group {
      margin-bottom: 6px;
    }
    
    .box-body {
      padding: 10px;
    }
    
    .box-header {
      padding: 8px 10px;
    }
    
    /* Table optimizations */
    .items_table th, .items_table td {
      padding: 4px 6px !important;
      font-size: 12px !important;
      line-height: 1.2;
    }
    
    .items_table th {
      font-size: 11px !important;
      font-weight: 600;
      background: #f8f9fa !important;
    }
    
    /* Compact select2 */
    .select2-container .select2-selection--single {
      height: 32px !important;
      line-height: 30px !important;
    }
    
    .select2-container .select2-selection--single .select2-selection__rendered {
      padding-left: 8px !important;
      padding-right: 8px !important;
      font-size: 13px !important;
    }
    
    .select2-container .select2-selection--single .select2-selection__arrow {
      height: 30px !important;
    }
    
    /* Responsive design */
    @media (max-width: 768px) {
      .pos-action-btn {
        min-width: 60px;
        font-size: 10px;
        padding: 3px 6px;
        height: 24px;
        gap: 3px;
      }
      
      .pos-action-btn span {
        font-size: 9px;
      }
      
      .pos-actions-container {
        gap: 3px;
      }
      
      .pos-items-table-container {
        height: 350px !important;
      }
    }
    
    /* Loading state for buttons */
    .pos-action-btn.loading {
      pointer-events: none;
      opacity: 0.7;
    }
    
    .pos-action-btn.loading i {
      animation: spin 1s linear infinite;
    }
    
    @keyframes spin {
      from { transform: rotate(0deg); }
      to { transform: rotate(360deg); }
    }
    
    /* Success feedback animation */
    .pos-action-btn.success {
      background: linear-gradient(135deg, #48bb78 0%, #38a169 100%) !important;
      transform: scale(1.05);
    }
    
    .pos-action-btn.success i::before {
      content: '\f00c';
      font-family: FontAwesome;
    }
    
    /* Rate Type Selector Styling */
    #rate_type_selector {
      border: 1px solid #4c63d2;
      background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
      color: #333;
      font-weight: 500;
      transition: all 0.2s ease;
    }
    
    #rate_type_selector:focus {
      border-color: #4c63d2;
      box-shadow: 0 0 0 2px rgba(76, 99, 210, 0.1);
      outline: none;
    }
    
    #rate_type_selector option {
      padding: 4px 8px;
      font-weight: 500;
    }
    
    /* Sales Type Selector Styling */
    #sales_type_selector {
      border: 1px solid #28a745;
      border-radius: 4px;
      padding: 3px 6px;
      font-size: 12px;
      color: #333;
      background: linear-gradient(145deg, #ffffff, #f8f9fa);
      font-weight: 500;
      transition: all 0.2s ease;
      height: 28px;
    }
    
    #sales_type_selector:focus {
      border-color: #28a745;
      box-shadow: 0 0 0 2px rgba(40, 167, 69, 0.15);
      outline: none;
      background: #fff;
    }
    
    #sales_type_selector option {
      padding: 3px 6px;
      font-weight: 500;
      color: #333;
    }
    
    /* Sales Type input group styling */
    .sales-type-group .input-group-addon {
      background: #e8f5e8;
      border-color: #28a745;
      color: #28a745;
    }
    
    .sales-type-group .btn-success {
      border-color: #28a745;
      background: #28a745;
    }
    
    .sales-type-group .btn-success:hover {
      background: #218838;
      border-color: #1e7e34;
    }
    
    /* Rate type indicator styling */
    .rate-type-indicator {
      position: absolute;
      top: -8px;
      right: -8px;
      background: #4c63d2;
      color: white;
      border-radius: 50%;
      width: 20px;
      height: 20px;
      font-size: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: bold;
    }
    
    /* Camera Button Styles */
    .camera-btn {
      background: #28a745 !important;
      color: white !important;
      cursor: pointer;
      transition: background-color 0.3s ease;
      border-left: none !important;
    }
    
    .camera-btn:hover {
      background: #218838 !important;
      color: white !important;
    }
    
    /* QR Scanner Modal Styles */
    .scanner-modal {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.8);
      z-index: 9999;
      display: flex;
      align-items: center;
      justify-content: center;
      flex-direction: column;
    }

    .scanner-content {
      background: white;
      border-radius: 8px;
      padding: 20px;
      text-align: center;
      max-width: 90vw;
      max-height: 90vh;
    }

    #qr-reader {
      width: 100% !important;
      max-width: 400px;
      margin: 0 auto;
    }

    .scanner-controls {
      margin-top: 15px;
    }

    .scanner-controls button {
      margin: 0 5px;
      padding: 8px 15px;
      border: none;
      border-radius: 4px;
      cursor: pointer;
      font-size: 14px;
    }

    .btn-flash {
      background: #ffc107;
      color: #212529;
    }

    .btn-flash:hover {
      background: #e0a800;
    }

    .btn-close-scanner {
      background: #dc3545;
      color: white;
    }

    .btn-close-scanner:hover {
      background: #c82333;
    }
  </style>
</head>

<!-- ADD THE CLASS layout-top-nav TO REMOVE THE SIDEBAR. -->
<body class="hold-transition skin-blue layout-top-nav">
  <?php $CI =& get_instance(); ?>
<div class="wrapper">
  
  
  <header class="main-header">
    <nav class="navbar navbar-static-top">
      <div class="container">
        <div class="navbar-header">
          <a href="<?php echo $base_url; ?>dashboard" class="navbar-brand" title="Go to Dashboard!"><b class="hidden-xs"><?= $this->session->userdata('store_name'); ?></b><b class="hidden-lg">POS</b></a>
          <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse">
            <i class="fa fa-bars"></i>
          </button>
        </div>

        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse pull-left" id="navbar-collapse">
          <ul class="nav navbar-nav">
            <?php if($CI->permissions('sales_view')) { ?>
            <li class=""><a href="<?php echo $base_url; ?>sales" title="View Sales List!"><i class="fa fa-list text-yellow" ></i> <span><?= $this->lang->line('sales_list'); ?></span></a></li>
            <?php } ?>
            
            <?php if($CI->permissions('customers_view')) { ?>
            <li class=""><a href="<?php echo $base_url; ?>customers/" title="View Customers List"><i class="fa  fa-group  text-yellow " ></i> <span><?= $this->lang->line('customers_list'); ?></span></a></li>
            <?php } ?>
            <?php if($CI->permissions('items_view')) { ?>
            <li class=""><a href="<?php echo $base_url; ?>items/" title="View Items List"><i class="fa  fa-cubes text-yellow " ></i> <span><?= $this->lang->line('items_list'); ?></span></a></li>
            <?php } ?>
            <?php if($CI->permissions('sales_add')) { ?>
            <li class=""><a href="<?php echo $base_url; ?>pos" title="Create New POS Invoice"><i class="fa fa-calculator text-yellow " ></i> <span><?= $this->lang->line('new_invoice'); ?></span></a></li>
            <?php } ?>
          </ul>
        </div>
        <!-- /.navbar-collapse -->
        <!-- Navbar Right Menu -->
        <div class="navbar-custom-menu">
          <ul class="nav navbar-nav">
            
            <!-- User Account Menu -->
            <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown" title="Click To View Hold Invoices">
             
              <span class=""><?= $this->lang->line('hold_list'); ?></span>
              <span class="label label-danger hold_invoice_list_count"><?=$tot_count?></span>
            </a>

            <ul class="dropdown-menu dropdown-width-lg">
              
              <!-- Menu Body -->
              <li class="user-body">
                <div class="row">
                  <div class="col-xs-12 text-center " style="max-height:300px;overflow-y: scroll;">
                    <table class="table table-bordered" width="100%">
                      <thead>
                      <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>Ref.ID</th>
                        <th>Action</th>
                      </tr>
                      </thead>
                      <tbody id="hold_invoice_list" >
                       <?=$result?>
                      </tbody>
                    </table>
                  </div>
                </div>
                <!-- /.row -->
              <!--</li>-->
            </ul>
          </li>

            <!-- Messages: style can be found in dropdown.less-->
            <li class="hidden-xs" id="fullscreen"><a title="Fullscreen On/Off"><i class="fa fa-tv text-white" ></i> </a></li>
            <li class="text-center" id="">
            <a title="Dashboard" href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard text-yellow" ></i><b class="hidden-xs"><?= $this->lang->line('dashboard'); ?></b></a>
          </li>

            <!-- User Account Menu -->
            <li class="dropdown user user-menu">
            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
              <img src="<?php echo get_profile_picture(); ?>" class="user-image" alt="User Image">
              <span class="hidden-xs"><?php print ucfirst($this->session->userdata('inv_username')); ?></span>
            </a>

            <ul class="dropdown-menu">
              <!-- User image -->
              <li class="user-header">
                <img src="<?php echo get_profile_picture(); ?>" class="img-circle" alt="User Image">

                <p>
                 <?php print ($this->session->userdata('inv_username')); ?>
                  <small>Year <?=date("Y");?></small>
                  <small class='text-uppercase text-bold'>Role: <?=$this->session->userdata('role_name');?></small>
                </p>
              </li>
              <!-- Menu Body -->
              <!-- Menu Footer-->
              <li class="user-footer">
                <div class="pull-left">
                  <a href="<?php echo $base_url; ?>users/edit/<?= $this->session->userdata('inv_userid'); ?>" class="btn btn-default btn-flat">Profile</a>
                </div>
                <div class="pull-right">
                  <a href="<?php echo $base_url; ?>logout" class="btn btn-default btn-flat">Sign out</a>
                </div>
              </li>
            </ul>
          </li>
          </ul>
        </div>
        <!-- /.navbar-custom-menu -->
      </div>
      <!-- /.container-fluid -->
    </nav>
  </header>

  <?php $css = ($this->session->userdata('language')=='Arabic' || $this->session->userdata('language')=='Urdu') ? 'margin-right: 0 !important;': '';?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper" style="<?=$css;?>">
    <!-- Content Header (Page header) -->
   <!--  <section class="content-header">
      <h1>
        General Form Elements
        <small>Preview</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li><a href="#">Forms</a></li>
        <li class="active">General Elements</li>
      </ol>
    </section> -->

    <!-- **********************MODALS***************** -->
    <?php include"modals/modal_customer.php"; ?>
    <?php include"modals/modal_sales_item.php"; ?>
    <?php include"modals/modal_item.php"; ?>
    <?php include"modals/modal_item_or_service.php"; ?>
    
    <?php /*include"modals/modal_service.php";*/ ?>

    
    <!-- **********************MODALS END***************** -->
    
    <!-- **********************EXPENSE MODAL START***************** -->
    <div class="modal fade" id="expense-modal" tabindex='-1'>
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title"><i class="fa fa-money"></i> Add New Expense</h4>
          </div>
          <div class="modal-body">
            <form id="expense-form-modal" class="form-horizontal">
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
              <input type="hidden" name="store_id" value="<?php echo get_current_store_id(); ?>">
              
              <div class="row">
                <div class="col-md-6">
                  <!-- Expense Date -->
                  <div class="form-group">
                    <label for="expense_date_modal" class="col-sm-4 control-label">Expense Date <span class="text-danger">*</span></label>
                    <div class="col-sm-8">
                      <div class="input-group date">
                        <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                        <input type="text" class="form-control datepicker" id="expense_date_modal" name="expense_date" value="<?php echo date('d-m-Y'); ?>" readonly>
                      </div>
                      <span id="expense_date_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                  
                  <!-- Category -->
                  <div class="form-group">
                    <label for="category_id_modal" class="col-sm-4 control-label">Category <span class="text-danger">*</span></label>
                    <div class="col-sm-8">
                      <select class="form-control select2" id="category_id_modal" name="category_id" style="width: 100%;">
                        <option value="">-Select-</option>
                        <?php
                        $query1="select * from db_expense_category where status=1 and store_id=".get_current_store_id();
                        $q1=$this->db->query($query1);
                        if($q1->num_rows()>0) {
                          foreach($q1->result() as $res1) {
                            echo "<option value='".$res1->id."'>".$res1->category_name."</option>";
                          }
                        } else {
                          echo "<option value=''>No categories found. Please create expense categories first.</option>";
                        }
                        ?>
                      </select>
                      <span id="category_id_modal_msg" style="display:none" class="text-danger"></span>
                      <?php if($q1->num_rows() == 0): ?>
                      <small class="text-muted">
                        <i class="fa fa-info-circle"></i> 
                        Go to <a href="<?php echo $base_url; ?>expense/category" target="_blank">Expense Categories</a> to create categories first.
                      </small>
                      <?php endif; ?>
                    </div>
                  </div>
                  
                  <!-- Expense For -->
                  <div class="form-group">
                    <label for="expense_for_modal" class="col-sm-4 control-label">Expense For <span class="text-danger">*</span></label>
                    <div class="col-sm-8">
                      <input type="text" class="form-control" id="expense_for_modal" name="expense_for" placeholder="Description">
                      <span id="expense_for_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                </div>
                
                <div class="col-md-6">
                  <!-- Payment Type -->
                  <div class="form-group">
                    <label for="payment_type_modal" class="col-sm-4 control-label">Payment Type <span class="text-danger">*</span></label>
                    <div class="col-sm-8">
                      <select class="form-control select2" id="payment_type_modal" name="payment_type">
                        <option value="">-Select-</option>
                        <?php
                        $q1=$this->db->query("select * from db_paymenttypes where status=1 and store_id=".get_current_store_id());
                        if($q1->num_rows()>0){
                          foreach($q1->result() as $res1){
                            echo "<option value='".$res1->payment_type."'>".$res1->payment_type ."</option>";
                          }
                        }
                        ?>
                      </select>
                      <span id="payment_type_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                  
                  <!-- Account -->
                  <div class="form-group">
                    <label for="account_id_modal" class="col-sm-4 control-label">Account</label>
                    <div class="col-sm-8">
                      <select class="form-control select2" id="account_id_modal" name="account_id">
                        <option value="">-None-</option>
                        <?php echo get_accounts_select_list(''); ?>
                      </select>
                      <span id="account_id_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                  
                  <!-- Amount -->
                  <div class="form-group">
                    <label for="expense_amt_modal" class="col-sm-4 control-label">Amount <span class="text-danger">*</span></label>
                    <div class="col-sm-8">
                      <input type="text" class="form-control only_currency" id="expense_amt_modal" name="expense_amt" placeholder="0.00">
                      <span id="expense_amt_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="row">
                <div class="col-md-12">
                  <!-- Reference No -->
                  <div class="form-group">
                    <label for="reference_no_modal" class="col-sm-2 control-label">Reference No</label>
                    <div class="col-sm-4">
                      <input type="text" class="form-control" id="reference_no_modal" name="reference_no" placeholder="">
                      <span id="reference_no_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                    
                    <label for="note_modal" class="col-sm-2 control-label">Note</label>
                    <div class="col-sm-4">
                      <textarea class="form-control" id="note_modal" name="note" placeholder="" rows="3"></textarea>
                      <span id="note_modal_msg" style="display:none" class="text-danger"></span>
                    </div>
                  </div>
                </div>
              </div>
            </form>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            <button type="button" class="btn btn-primary" onclick="saveExpense()"><i class="fa fa-save"></i> Save Expense</button>
          </div>
        </div>
      </div>
    </div>
    <!-- **********************EXPENSE MODAL END***************** -->
    <!-- Main content -->
    <section class="content">
      <div class="row">
        <!-- left column -->
        <div class="col-md-7">
         
          <!-- general form elements -->
          <div class="box box-primary">
            <!-- form start -->
            <form class="form-horizontal" id="pos-form" >
            <div class="box-header with-border" style="padding-bottom: 0px;">
              <div class="row" >
                <div class="col-md-12" >
               
                  
                <?php if(isset($sales_id)): ?>
                  <?php if($CI->permissions('sales_add')) { ?>
                  <div class="col-md-4 pull-right">
                    <a href='<?= $base_url;?>pos' class="btn btn-primary pull-right">New Invoice</a>
                  </div>
                  <?php } ?>
                <?php endif; ?>
                
              </div>
              </div>
               
            
            
            
          </div>
            <!-- /.box-header -->
            
              <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">
              <input type="hidden" value='0' id="hidden_rowcount" name="hidden_rowcount">
              <input type="hidden" value='' id="hidden_invoice_id" name="hidden_invoice_id">
              <input type="hidden" value='' id="sales_type_id" name="sales_type_id">
              <input type="hidden" id="base_url" value="<?php echo $base_url;; ?>">
              <input type="hidden" class="scroll_or_not" value="true">

              
              <input type="hidden" value='' id="walk_in_customer_name" value="<?=get_walk_in_customer_name();?>">
              
              <!-- **********************MODALS***************** -->
             <?php include"modals_pos_payment/modal_payments_multi.php"; ?>

             <?php include"modals/modal_terms.php"; ?>

              <!-- **********************MODALS END***************** -->
              <!-- **********************MODALS***************** -->
              <div class="modal fade" id="discount-modal" tabindex='-1'>
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                      <h4 class="modal-title">Set Discount</h4>
                    </div>
                    <div class="modal-body">
                      
                        <div class="row">
                          <div class="col-md-6">
                            <div class="box-body">
                              <div class="form-group">
                                <label for="discount_input">Discount</label>
                                <input type="text" class="form-control" id="discount_input" name="discount_input" placeholder="" value="0">
                              </div>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="box-body">
                              <div class="form-group">
                                <label for="discount_type">Discount Type</label>
                                <select class="form-control" id='discount_type' name="discount_type">
                                  <option value='in_percentage'>Per%</option>
                                  <option value='in_fixed'>Fixed</option>
                                </select>
                              </div>
                            </div>
                          </div>
                        </div>
                     
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-warning" data-dismiss="modal">Close</button>
                      <button type="button" class="btn btn-primary discount_update">Update</button>
                    </div>
                  </div>
                  <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
              </div>
              <!-- /.modal -->
              
              <!-- Payment Collection Modal -->
              <div class="modal fade" id="payment-collection-modal" tabindex='-1'>
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                      <h4 class="modal-title">Collect Payment from Customer</h4>
                    </div>
                    <div class="modal-body">
                      <div class="row">
                        <div class="col-md-12">
                          <div class="form-group">
                            <label>Customer:</label>
                            <span id="payment_customer_name" class="form-control-static" style="font-weight: bold;"></span>
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Previous Due Amount:</label>
                            <span id="payment_previous_due" class="form-control-static text-red" style="font-weight: bold; font-size: 16px;"></span>
                          </div>
                        </div>
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Payment Amount:</label>
                            <input type="number" class="form-control" id="collection_amount" placeholder="Enter amount to collect" step="0.01" min="0.01">
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Payment Type:</label>
                            <select class="form-control" id="collection_payment_type">
                              <option value="Cash">Cash</option>
                              <option value="Card">Card</option>
                              <option value="Bank Transfer">Bank Transfer</option>
                              <option value="Cheque">Cheque</option>
                              <option value="Other">Other</option>
                            </select>
                          </div>
                        </div>
                        <div class="col-md-6">
                          <div class="form-group">
                            <label>Payment Note:</label>
                            <input type="text" class="form-control" id="collection_payment_note" placeholder="Optional note">
                          </div>
                        </div>
                      </div>
                      <div class="row">
                        <div class="col-md-12">
                          <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> This payment will be applied to reduce the customer's previous due balance.
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                      <button type="button" class="btn btn-success" onclick="processPaymentCollection()">
                        <i class="fa fa-money"></i> Collect Payment
                      </button>
                    </div>
                  </div>
                  <!-- /.modal-content -->
                </div>
                <!-- /.modal-dialog -->
              </div>
              <!-- /.modal -->
              
              <!-- **********************MODALS END***************** -->
              <div class="box-body">                
              <!-- Store Code -->
              <?php $store_id=''; ?>
            <?php 
             /*if(store_module() && is_admin()) {$this->load->view('store/store_code',array('show_store_select_box_2'=>true,'store_id'=>$store_id)); }else{*/
                echo "<input type='hidden' name='store_id' id='store_id' value='".get_current_store_id()."'>";
              /*}*/
              ?>
            <!-- Store Code end -->


              <div class="row pos-compact-row">
                <div class="col-md-4">
                  <div class="input-group" data-toggle="tooltip" title="Warehouse" style="margin-bottom: 4px;">
                    <span class="input-group-addon" style="padding: 3px 6px;"><i class="fa fa-building text-red"></i></span>
                     <select class="form-control select2" id="warehouse_id" name="warehouse_id" style="width: 100%; height: 28px; padding: 3px 6px;">
                          <?= get_warehouse_select_list($warehouse_id,get_current_store_id()); ?>
                      </select>
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="input-group" data-toggle="tooltip" title="Invoice Initial Code" style="margin-bottom: 4px;">
                    <span class="input-group-addon" style="padding: 3px 6px;"><i class="fa fa-th-list"></i></span>
                     <input type="text" class="form-control" placeholder="Invoice Code" id="init_code" name="init_code" value="<?= $init_code ?>" style="height: 28px; padding: 3px 6px;">
                  </div>
                </div> 
                <div class="col-md-2">
                     <input type="text" class="form-control" data-toggle="tooltip" title="Invoice Count ID" placeholder="Invoice #" id="count_id" name="count_id" value="<?= $count_id ?>" style="height: 28px; padding: 3px 6px; margin-bottom: 4px;">
                </div>
                <div class="col-md-3">
                  <div style="display: flex; gap: 3px; align-items: flex-start;">
                    <div class="input-group" data-toggle="tooltip" title="Reference Number" style="margin-bottom: 4px; flex: 1;">
                      <span class="input-group-addon" style="padding: 3px 6px;"><i class="fa fa-bookmark"></i></span>
                      <input type="text" class="form-control" placeholder="Ref #" id="reference_no" name="reference_no" style="height: 28px; padding: 3px 6px;">
                    </div>
                    <button type="button" class="pos-action-btn pos-expense-btn" data-toggle="modal" data-target="#expense-modal" title="Add New Expense" style="padding: 5px 8px; font-size: 10px; min-width: 70px; height: 28px; margin-bottom: 4px;">
                      <i class="fa fa-money"></i>
                      <span>Expense</span>
                    </button>
                  </div>
                </div>
              </div><!-- row end -->

              <div class="row pos-compact-row">
                <div class="col-md-6">
                  <div class="pos-input-row">
                    <div class="pos-enhanced-input">
                      <div class="input-group" data-toggle="tooltip" title="Customer">
                        <span class="input-group-addon" ><i class="fa fa-user"></i></span>
                         <select class="form-control select2" id="customer_id" name="customer_id"  style="width: 100%;"  >
                          </select>
                      </div>
                    </div>
                    
                    <!-- Modern Customer Actions - Inline -->
                    <div class="pos-actions-container">
                      <button type="button" class="pos-action-btn pos-customer-btn" data-toggle="modal" data-target="#customer-modal" title="Add New Customer">
                        <i class="fa fa-user-plus"></i>
                        <span>Add</span>
                      </button>
                    </div>
                  </div>
                  
                    <span class="customer_points text-success" style="display: none;"></span>
                    <div style="display: flex; align-items: center; gap: 8px; margin-top: 4px; font-size: 12px;">
                        <label><?= $this->lang->line('previous_due'); ?> :<span class="customer_previous_due text-red" style="font-size: 14px; font-weight: bold;"><?=store_number_format(0)?></span></label>
                        <button type="button" class="btn btn-success btn-xs" id="collect_payment_btn" style="display: none; padding: 2px 6px; font-size: 10px;" onclick="showPaymentCollectionModal()" title="Collect Payment from Customer">
                            <i class="fa fa-money"></i> Collect
                        </button>
                        <button type="button" class="btn btn-warning btn-xs" id="customer_ledger_btn" style="display: none; padding: 2px 6px; font-size: 10px;" onclick="openTransactionLedger()" title="View Customer Transaction Ledger">
                            <i class="fa fa-list-alt"></i> Ledger
                        </button>
                        <button type="button" class="btn btn-info btn-xs" style="padding: 2px 6px; font-size: 10px;" onclick="openStockAdjustment()" title="Stock Adjustment">
                            <i class="fa fa-balance-scale"></i> Stock Adj
                        </button>
                    </div>
                  
                </div>
                <div class="col-md-6">
                  <!-- Rate Type and Sales Type Selectors Row - Moved Above -->
                  <div style="display: flex; gap: 4px; margin-bottom: 6px;">
                    <!-- Rate Type Selector - Reduced Size -->
                    <div class="pos-enhanced-input" style="flex: 0.8;">
                      <div class="input-group" data-toggle="tooltip" title="Rate Type" style="margin-bottom: 2px;">
                        <span class="input-group-addon" style="padding: 2px 4px; font-size: 10px;"><i class="fa fa-tags text-primary" style="font-size: 10px;"></i></span>
                        <select class="form-control" id="rate_type_selector" onchange="updateCartRates()" style="height: 26px; border-color: #4c63d2; font-size: 11px; padding: 2px 4px;" title="Select Rate Type">
                          <option value="sales">Sales</option>
                          <option value="shop">Shop</option>
                          <option value="wholesale">Wholesale</option>
                        </select>
                      </div>
                    </div>
                    
                    <!-- Sales Type Selector - Reduced Size -->
                    <div class="pos-enhanced-input" style="flex: 1.2;">
                      <div class="input-group" data-toggle="tooltip" title="Sales Type" style="margin-bottom: 2px;">
                        <span class="input-group-addon" style="background: #e8f5e8; border-color: #28a745; color: #28a745; padding: 2px 4px; font-size: 10px;">
                          <i class="fa fa-file-text" style="font-size: 10px;"></i>
                        </span>
                        <select class="form-control" id="sales_type_selector" onchange="updateInvoiceNumber()" style="height: 26px; border-color: #28a745; font-size: 11px; padding: 2px 4px;" title="Select Sales Type">
                          <?php if(!empty($sales_types)): ?>
                            <?php foreach($sales_types as $type): ?>
                              <option value="<?= $type->id ?>" data-initial="<?= $type->sales_type_initial ?>"><?= $type->sales_type_name ?></option>
                            <?php endforeach; ?>
                          <?php else: ?>
                            <option value="">No Sales Types Available</option>
                          <?php endif; ?>
                        </select>
                        <script>
                          // Debug: Log available sales types
                          console.log("Sales Types loaded:", 
                            <?php if(!empty($sales_types)): ?>
                              <?= json_encode($sales_types) ?>
                            <?php else: ?>
                              "No sales types found"
                            <?php endif; ?>
                          );
                        </script>
                      </div>
                    </div>
                  </div>
                  
                  <div class="pos-input-row">
                    <div class="pos-enhanced-input">
                      <div class="input-group" data-toggle="tooltip" title="Select Items">
                        <span class="input-group-addon" style="padding: 4px 8px;"><i class="fa fa-barcode" style="font-size: 14px;"></i></span>
                         <input type="text" class="form-control" placeholder="Item name/Barcode/Itemcode" id="item_search" style="height: 32px; font-size: 13px; padding: 6px 12px;">
                        <span class="input-group-addon camera-btn" onclick="startItemBarcodeScanner()" title="Scan QR/Barcode" style="padding: 4px 8px;">
                          <i class="fa fa-camera" style="font-size: 14px;"></i>
                        </span>
                      </div>
                    </div>
                    
                    <!-- Modern Item Actions - Inline -->
                    <div class="pos-actions-container">
                      <button type="button" class="pos-action-btn pos-item-btn show_item_service" title="Add New Item">
                        <i class="fa fa-plus"></i>
                        <span>Add</span>
                      </button>
                    </div>
                  </div>
                </div>                
              </div><!-- row end -->

              <div class="row pos-compact-row">
                <div class="col-md-12">
                  <div class="form-group" style="margin-bottom: 8px;">
                    <div class="col-sm-12 pos-items-table-container">
                      <table class="table table-condensed table-bordered table-responsive items_table" style="margin-bottom: 0;">
                        <thead class="bg-gray">
                          <th width="30%"><?= $this->lang->line('item_name'); ?></th>
                          <th width="10%"><?= $this->lang->line('stock'); ?></th>
                          <th width="25%"><?= $this->lang->line('quantity'); ?></th>
                          <th width="15%"><?= $this->lang->line('price'); ?></th>
                          <th width="10%"><?= $this->lang->line('discount'); ?>(<?=$CI->currency()?>)</th>
                          <th width="10%"><?= $this->lang->line('tax'); ?></th>
                          <th width="15%"><?= $this->lang->line('subtotal'); ?></th>
                          <th width="5%"><i class="fa fa-close"></i></th>
                        </thead>
                        <tbody id="pos-form-tbody" style="font-size: 14px; font-weight: 500;">
                          <!-- body code -->
                        </tbody>        
                        <tfoot>
                          <!-- footer code -->
                        </tfoot>              
                      </table>
                    </div>
                  </div>
                </div>
              </div>
           
              </div>
              <!-- /.box-body -->

              <!-- Compact Footer with Modern Buttons -->
              <div class="box-footer" style="padding: 6px 10px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%); border-top: 1px solid #dee2e6;">
                
                <?php 
                   //SMS Configuration
                    $send_sms_checkbox='disabled';
                    if($CI->is_sms_enabled()){
                      if(!isset($sales_id)){
                        $send_sms_checkbox='checked';  
                      }else{
                        $send_sms_checkbox='';
                      }
                    }
                ?>
                
                <!-- Compact Summary Row with SMS -->
                <div class="row pos-compact-row" style="margin-bottom: 6px; background: #f8f9fa; padding: 4px; border-radius: 4px;">
                  <!-- SMS and T&C Column -->
                  <div class="col-md-3">
                    <div style="display: flex; align-items: center; gap: 8px;">
                      <div class="checkbox icheck" style="margin: 0;">
                        <label style="font-size: 9px; margin: 0; display: flex; align-items: center;">
                          <input type="checkbox" <?=$send_sms_checkbox;?> id="send_sms" name="send_sms" style="margin-right: 3px;"> SMS
                        </label>
                      </div>
                      <label class="text-blue pointer" style="font-size: 9px; margin: 0;" toggle="tooltip" title="<?= $this->lang->line('edit_invoice_tc')?>" data-toggle="modal" data-target="#terms-modal">
                        <span class="glyphicon glyphicon-list-alt"></span> T&C
                      </label>
                      <label class="hide div2 text-blue" style="font-size: 9px; margin: 0;">
                        Coupon: <span class="coupon_value">0.00</span><span class="coupon_type"></span>
                      </label>
                    </div>
                  </div>
                  
                  <!-- Summary Stats -->
                  <div class="col-md-9">
                    <div style="display: flex; justify-content: space-around; text-align: center;">
                      <div>
                        <label style="font-size: 9px; margin: 0; color: #6c757d;"> <?= $this->lang->line('quantity'); ?></label><br>
                        <span class="text-bold tot_qty" style="font-size: 12px; color: #495057;"></span>
                      </div>
                      <div>
                        <label style="font-size: 9px; margin: 0; color: #6c757d;"><?= $this->lang->line('total_amount'); ?></label><br>
                        <?= $CI->currency('<span style="font-size: 12px; color: #495057;" class="tot_amt text-bold"></span>');?>
                      </div>
                      <div>
                        <label style="font-size: 9px; margin: 0; color: #6c757d;"><?= $this->lang->line('total_discount'); ?>:<a class="fa fa-pencil-square-o cursor-pointer" data-toggle="modal" data-target="#discount-modal" style="font-size: 8px; margin-left: 2px;"></a></label><br>
                        <?= $CI->currency('<span style="font-size: 12px; color: #495057;" class="tot_disc text-bold"></span>');?>
                      </div>
                      <div>
                        <label style="font-size: 9px; margin: 0; color: #6c757d;"><?= $this->lang->line('grand_total'); ?></label><br>
                        <?= $CI->currency('<span style="font-size: 20px; color: #28a745; font-weight: bold;" class="tot_grand text-bold"></span>');?>
                      </div>
                    </div>
                  </div>
                </div>
               
               <!-- Modern Compact Action Buttons -->
               <div class="row">
                
                  <?php if(isset($sales_id)){ $btn_id='update';$btn_name="Cash"; ?>
                    <input type="hidden" name="sales_id" id="sales_id" value="<?php echo $sales_id;?>"/>
                  <?php } else{ $btn_id='save';$btn_name="Cash";} ?>

                  <div class="col-md-12">
                    <div style="display: flex; gap: 4px; justify-content: space-between;">
                      <button type="button" id="hold_invoice" name="" class="btn bg-maroon btn-flat btnhold modern-pos-btn" title="Hold Invoice [Alt+H]" style="flex: 1; padding: 8px 4px; font-size: 10px; border-radius: 4px; font-weight: 500; min-height: 50px; display: flex; flex-direction: column; align-items: center; justify-content: center;">
                        <i class="fa fa-hand-paper-o" aria-hidden="true" style="font-size: 14px; margin-bottom: 2px;"></i>
                        <span style="font-size: 9px;">Hold</span>
                      </button>
                      
                      <button type="button" id="" name="" class="btn btn-primary btnhold btn-flat show_payments_modal modern-pos-btn" title="Multiple Payments [Alt+M]" style="flex: 1; padding: 8px 4px; font-size: 10px; border-radius: 4px; font-weight: 500; min-height: 50px; display: flex; flex-direction: column; align-items: center; justify-content: center;">
                        <i class="fa fa-credit-card" aria-hidden="true" style="font-size: 14px; margin-bottom: 2px;"></i>
                        <span style="font-size: 9px;">Multi Pay</span>
                      </button>
                      
                      <button type="button" id="<?php echo "show_cash_modal";?>" name="" class="btn btnhold btn-success btn-flat Alt_c modern-pos-btn" title="By Cash & Save [Alt+C]" style="flex: 1; padding: 8px 4px; font-size: 10px; border-radius: 4px; font-weight: 500; min-height: 50px; display: flex; flex-direction: column; align-items: center; justify-content: center;">
                        <i class="fa fa-money" aria-hidden="true" style="font-size: 14px; margin-bottom: 2px;"></i>
                        <span style="font-size: 9px;"><?php echo $btn_name;?></span>
                      </button>

                      <button type="button" id="pay_all" name="" class="btn bg-purple btnhold btn-flat Alt_a modern-pos-btn" title="Pay All [Alt+A]" style="flex: 1; padding: 8px 4px; font-size: 10px; border-radius: 4px; font-weight: 500; min-height: 50px; display: flex; flex-direction: column; align-items: center; justify-content: center;">
                        <i class="fa fa-money" aria-hidden="true" style="font-size: 14px; margin-bottom: 2px;"></i>
                        <span style="font-size: 9px;">Pay All</span>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
            </form>
          </div>
          <!-- /.box -->
        </div>
        <!--/.col (left) -->
        <!-- right column -->
        <div class="col-md-5">
          <!-- Horizontal Form -->
          <div class="box box-info">
            <!-- form start -->
            
              <div class="box-body">
                
              <div class="row">

                <div class="col-md-6">
                  <div class="input-group input-group-md">
                      <select class="form-control select2" id="category_id" name="category_id"  style="width: 100%;"  >
                        <option value="">-All Categories-</option>
                        <?= get_categories_select_list();  ?>
                      </select>
                          <span class="input-group-btn">
                            <button type="button" class="btn text-blue btn-flat reset_categories" title="Reset Categories" data-toggle="tooltip" data-placement="top">
                              <i class="fa fa-undo"></i>
                            </button>
                          </span>
                    </div>
                </div>


                <div class="col-md-6">
                  <div class="input-group input-group-md">
                      <select class="form-control select2" id="brand_id" name="brand_id"  style="width: 100%;"  >
                        <option value="">-All Brands-</option>
                        <?= get_brands_select_list();  ?>
                      </select>
                          <span class="input-group-btn">
                            <button type="button" class="btn text-blue btn-flat reset_brands" title="Reset Brand" data-toggle="tooltip" data-placement="top">
                              <i class="fa fa-undo"></i>
                            </button>
                          </span>
                    </div>
                </div>                

              </div><!-- row end -->

              <br>
              <div class="row">

                <div class="col-md-12">
                  <div class="input-group input-group-md">
                   
                      <input type="text" class="form-control" data-toggle="tooltip" title="Enter Item Name" placeholder="Item Name" id="item_name" name="item_name">

                          <span class="input-group-btn">
                            <button type="button" class="btn text-blue btn-flat reset_item_name" title="Reset Item Name" data-toggle="tooltip" data-placement="top">
                              <i class="fa fa-undo"></i>
                            </button>
                          </span>
                    </div>
                </div>               

              </div><!-- row end -->


             
              <div class="row">
                <div class="col-md-12">
                  <!-- <div class="form-group"> -->
                   <!--  <div class="col-sm-12"> -->
                      <!-- <style type="text/css">
                        
                      /* Modern action buttons for footer */
    .modern-pos-btn {
        transition: all 0.3s ease;
        border: none !important;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .modern-pos-btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }
    
    .modern-pos-btn:active {
        transform: translateY(0);
        box-shadow: 0 1px 2px rgba(0,0,0,0.1);
    }

    .bg-maroon.modern-pos-btn:hover {
        background-color: #d81b60 !important;
    }
    
    .btn-primary.modern-pos-btn:hover {
        background-color: #0056b3 !important;
    }
    
    .btn-success.modern-pos-btn:hover {
        background-color: #218838 !important;
    }
    
    .bg-purple.modern-pos-btn:hover {
        background-color: #6f42c1 !important;
    }

    </style> -->
                     

                            <section class="content .sec_div" >
                              <div class="row search_div" style="overflow-y: scroll;min-height: 100px;height: 550px">
                              </div>
                              <h4 class='text-danger text-center error_div' style="display: none;">No More Records Found</h4>
                            </section>
                            <div class="ajax-load text-center" style="display:none;">
                                <button type="button" class="btn btn-default btn-lrg ajax" title="Ajax Request">
                                <i class="fa fa-spin fa-refresh"></i>&nbsp; Loading More Data
                              </button>
                              </div>
                      
                         
                    <!-- </div> -->
                  <!-- </div> -->
                </div>
              </div>
           
              </div>
              <!-- /.box-body -->

              
           
          </div>
          <!-- /.box -->
          
          <!-- /.box -->
        </div>
        <!--/.col (right) -->
      </div>
      <!-- /.row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

  <?php include"footer.php";?>
</div>
<!-- ./wrapper -->

<!-- SOUND CODE -->
<?php include"comman/code_js_sound.php"; ?>
<!-- GENERAL CODE -->
<?php include"comman/code_js.php"; ?>

<!-- iCheck -->
<script src="<?php echo $theme_link; ?>plugins/iCheck/icheck.min.js"></script>

<script src="<?php echo $theme_link; ?>js/fullscreen.js"></script>
<script src="<?php echo $theme_link; ?>js/modals.js"></script>
<script src="<?php echo $theme_link; ?>js/modals/modal_item.js"></script>
<script src="<?php echo $theme_link; ?>js/ajaxselect/customer_select_ajax.js"></script>  

<!-- DROP DOWN -->
<script src="<?php echo $theme_link; ?>dist/js/bootstrap3-typeahead.min.js"></script>  
<!-- DROP DOWN END-->

<!-- QR Code Scanner Library -->
<script src="https://unpkg.com/html5-qrcode"></script>

<script type="text/javascript">
  
  var warehouse_module=false;
  <?php if(warehouse_module() && warehouse_count()>1){ ?> 
    warehouse_module=true;
  <?php } ?>

  var store_module=false;
  <?php if(store_module()){ ?> 
    store_module=true;
  <?php } ?>
</script>
<script src="<?php echo $theme_link; ?>js/pos.js"></script>
<script src="<?php echo $theme_link; ?>js/pos_rate_management.js"></script>
<script>

        //Customer Selection Box Search
         function getCustomerSelectionId() {
           return '#customer_id';
         }

         $(document).ready(function () {

            // var customer_id = "<?= (!empty($customer_id)) ? $customer_id : '';  ?>";

            // autoLoadFirstCustomer(customer_id);

         });
         //Customer Selection Box Search - END


    var base_url=$("#base_url").val();
    /*$("#store_id").on("change",function(){
      var store_id=$(this).val();
      $.post(base_url+"sales/get_customers_select_list",{store_id:store_id},function(result){
          $("#customer_id").html('').append(result).select2();
          <?php if(isset($sales_id) && empty($sales_id)){ ?>
            $(".items_table > tbody").empty();
          <?php } ?>
          final_total();
      });
    });*/

     $(".close_btn").on("click",function(){
       if(confirm('Are you sure you want to navigate away from this page?')){
           window.location='<?php echo $base_url; ?>dashboard';
         }
     });


  /*Warehouse*/
    $("#warehouse_id").on("change",function(){
      var warehouse_id=$(this).val();
      $(".items_table > tbody").empty();
      get_details(null,true);
      final_total();
    });
    /*Warehouse end*/

  //RIGHT SIT DIV:-> FILTER ITEM INTO THE ITEMS LIST
  function search_it(){
  
  /*var input = $("#search_it").val();
  var item_count=$(".search_div .search_item").length;
  var error_count=item_count;
  for(i=0; i<item_count; i++){
    console.log("item_count ->"+i+" =>"+$("#item_"+i).html());
    console.log($("#item_"+i).html().toUpperCase().indexOf(input.toUpperCase()));
    if($("#item_"+i).html().toUpperCase().indexOf(input.toUpperCase())>-1){
      console.log("found");
      $("#item_"+i).show();
      $("#item_parent_"+i).show();
    }
    else{
     console.log("not-found"); 
     $("#item_"+i).hide();
     $("#item_parent_"+i).hide();
     error_count--;
    }
    if(error_count==0){
      $(".error_div").show();
    }
    else{
      $(".error_div").hide();
    }
    
  }*/
  }




//LEFT SIDE: ON CLICK ITEM ADD TO INVOICE LIST
function addrow(id='',item_obj=''){


    var item_id = (item_obj=='') ? $('#div_'+id).attr('data-item-id') : item_obj.item_id; 

    //CHECK SAME ITEM ALREADY EXIST IN ITEMS TABLE 
    var item_check=check_same_item(item_id);
    if(!item_check){return false;}
    var rowcount        =$("#hidden_rowcount").val();//0,1,2...
    var item_name = (item_obj=='') ? $('#div_'+id).attr('data-item-name') : item_obj.item_name; 

    var stock   =(item_obj=='') ? $('#div_'+id).attr('data-item-available-qty') : item_obj.stock;
        stock     =(parseFloat(stock)).toFixed(2);

    var tax_type   =(item_obj=='') ? $('#div_'+id).attr('data-item-tax-type') : item_obj.tax_type;  
    var tax_id   =(item_obj=='') ? $('#div_'+id).attr('data-item-tax-id') : item_obj.tax_id;  
    var tax_value   =(item_obj=='') ? $('#div_'+id).attr('data-item-tax-value') : item_obj.tax;
    
    var tax_name   =(item_obj=='') ? $('#div_'+id).attr('data-item-tax-name'):item_obj.tax_name;  
    var tax_amt   =(item_obj=='') ? $('#div_'+id).attr('data-item-tax-amt') : item_obj.item_tax_amt; 
    //var purchase_price   =(item_obj=='') ? $('#div_'+id).attr('data-purchase_price') : item_obj.purchase_price; 
    var discount_type   =(item_obj=='') ? $('#div_'+id).attr('data-discount_type') :item_obj.discount_type; 
    var discount   =(item_obj=='') ? $('#div_'+id).attr('data-discount') : item_obj.discount; 
 
    
    var service_bit   =(item_obj=='') ? $('#div_'+id).attr('data-service_bit') : item_obj.service_bit; 
    //var gst_per         =$('#div_'+id).attr('data-item-tax-per');
    //var gst_amt         =$('#div_'+id).attr('data-item-gst-amt');

    var item_cost     =(item_obj=='') ? $('#div_'+id).attr('data-item-cost') : item_obj.purchase_price;  
    
    // Get the selected rate type and corresponding price
    var rate_type = $("#rate_type_selector").val();
    var sales_price, shop_rate, wholesale_rate;
    
    if(item_obj==''){
        sales_price = $('#div_'+id).attr('data-item-sales-price');
        shop_rate = $('#div_'+id).attr('data-item-shop-rate');
        wholesale_rate = $('#div_'+id).attr('data-item-wholesale-rate');
    } else {
        sales_price = item_obj.sales_price;
        shop_rate = item_obj.shop_rate;
        wholesale_rate = item_obj.wholesale_rate;
    }
    
    // Select the appropriate rate based on rate type
    var selected_price;
    switch(rate_type) {
        case 'shop':
            selected_price = shop_rate && shop_rate != '0' ? shop_rate : sales_price;
            break;
        case 'wholesale':
            selected_price = wholesale_rate && wholesale_rate != '0' ? wholesale_rate : sales_price;
            break;
        default:
            selected_price = sales_price;
    }
    
    var sales_price_temp = selected_price;
    selected_price = to_Fixed(selected_price);

    var quantity        ='<div class="input-group input-group-sm"><span class="input-group-btn"><button onclick="decrement_qty('+item_id+','+rowcount+')" type="button" class="btn btn-default btn-flat"><i class="fa fa-minus text-danger"></i></button></span>';
        quantity       +='<input typ="text" value="'+format_qty(1)+'" class="form-control no-padding text-center min_width" onchange="item_qty_input('+item_id+','+rowcount+')" id="item_qty_'+item_id+'" name="item_qty_'+item_id+'">';
        quantity       +='<span class="input-group-btn"><button onclick="increment_qty('+item_id+','+rowcount+')" type="button" class="btn btn-default btn-flat"><i class="fa fa-plus text-success"></i></button></span></div>';
    var sub_total       =(to_Fixed(1)*to_Fixed(selected_price));//Initial
    var remove_btn      ='<a class="fa fa-fw fa-trash-o text-red" style="cursor: pointer;font-size: 20px;" onclick="removerow('+rowcount+')" title="Delete Item?"></a>';

    var str=' <tr id="row_'+rowcount+'" data-row="0" data-item-id='+item_id+'>';/*item id*/
        str+='<td id="td_'+rowcount+'_0"><a data-toggle="tooltip" title="Click to Change Tax" class="pointer" id="td_data_'+rowcount+'_0" onclick="show_sales_item_modal('+rowcount+')">'+ item_name     +'</a> <i onclick="show_sales_item_modal('+rowcount+')" class="fa fa-edit pointer"></i></td>';/* td_0_0 item name*/ 
        str+='<td id="td_'+rowcount+'_1">'+ stock +'</td>';/* td_0_1 item available qty*/
        str+='<td id="td_'+rowcount+'_2">'+ quantity      +'</td>';/* td_0_2 item available qty*/
            info='<input id="sales_price_'+rowcount+'" onblur="set_to_original('+rowcount+','+item_cost+')" onkeyup="update_price('+rowcount+','+item_cost+')" name="sales_price_'+rowcount+'" type="text" class="form-control no-padding min_width" value="'+selected_price+'">';
        str+='<td id="td_'+rowcount+'_3" class="text-right">'+ info   +'</td>';/* td_0_3 item sales price*/

        /*Discount*/
         info='<input data-toggle="tooltip" title="Click to Change" onclick="show_sales_item_modal('+rowcount+')" id="item_discount_'+rowcount+'" readonly name="item_discount_'+rowcount+'" type="text" class="form-control no-padding min_width pointer" value="0">';
         
        str+='<td id="td_'+rowcount+'_6" class="text-right">'+ info   +'</td>';

        /*Tax amt*/
        str+='<td id="td_'+rowcount+'_11"><input data-toggle="tooltip" title="Click to Change" id="td_data_'+rowcount+'_11" onclick="show_sales_item_modal('+rowcount+')" name="td_data_'+rowcount+'_11" type="text" class="form-control no-padding pointer min_width" readonly value="'+tax_amt+'"></td>';

        str+='<td id="td_'+rowcount+'_4" class="text-right"><input data-toggle="tooltip" title="Total" id="td_data_'+rowcount+'_4" name="td_data_'+rowcount+'_4" type="text" class="form-control no-padding pointer" readonly value="'+sub_total+'"></td>';/* td_0_4 item sub_total */
        str+='<td id="td_'+rowcount+'_5">'+ remove_btn    +'</td>';/* td_0_5 item gst_amt */

        str+='<input type="hidden" name="tr_item_id_'+rowcount+'" id="tr_item_id_'+rowcount+'" value="'+item_id+'">';
       // str+='<input type="hidden" id="tr_item_per_'+rowcount+'" name="tr_item_per_'+rowcount+'" value="'+gst_per+'">';
        str+='<input type="hidden" id="tr_sales_price_temp_'+rowcount+'" name="tr_sales_price_temp_'+rowcount+'" value="'+sales_price_temp+'">';
        str+='<input type="hidden" id="tr_rate_type_'+rowcount+'" name="tr_rate_type_'+rowcount+'" value="'+rate_type+'">';
        str+='<input type="hidden" id="tr_all_rates_'+rowcount+'" name="tr_all_rates_'+rowcount+'" value="'+JSON.stringify({sales:sales_price, shop:shop_rate, wholesale:wholesale_rate})+'">';
        str+='<input type="hidden" id="tr_tax_type_'+rowcount+'" name="tr_tax_type_'+rowcount+'" value="'+tax_type+'">';
        str+='<input type="hidden" id="tr_tax_id_'+rowcount+'" name="tr_tax_id_'+rowcount+'" value="'+tax_id+'">';
        str+='<input type="hidden" id="tr_tax_value_'+rowcount+'" name="tr_tax_value_'+rowcount+'" value="'+tax_value+'">';
        str+='<input type="hidden" id="description_'+rowcount+'" name="description_'+rowcount+'" value="">';
        str+='<input type="hidden" id="service_bit_'+rowcount+'" name="service_bit_'+rowcount+'" value="'+service_bit+'">';
        str+='<input id="item_discount_type_'+rowcount+'" name="item_discount_type_'+rowcount+'" type="hidden" value="'+discount_type+'">';
         str+='<input id="item_discount_input_'+rowcount+'" name="item_discount_input_'+rowcount+'" type="hidden" value="'+discount+'">';
        str+='</tr>';   

    //LEFT SIDE: ADD OR APPEND TO SALES INVOICE TERMINAL
    $('#pos-form-tbody').append(str);

    //LEFT SIDE: INCREMANT ROW COUNT
    $("#hidden_rowcount").val(parseFloat($("#hidden_rowcount").val())+1);
    failed.currentTime = 0;
    failed.play();
    //CALCULATE FINAL TOTAL AND OTHER OPERATIONS
    make_subtotal(item_id,rowcount);
  }

function update_price(row_id,item_cost){
  /*Input*/
  /*var sales_price=$("#sales_price_"+row_id).val();
  if(sales_price!='' || sales_price==0) {sales_price = parseFloat(sales_price); }

  Default set from item master
  var item_price=parseFloat($("#tr_sales_price_temp_"+row_id).val());

  if(sales_price<item_cost){
    //toastr["warning"]("Minimum Sales Price is "+item_cost);
    $("#sales_price_"+row_id).parent().addClass('has-error');
  }else{
    $("#sales_price_"+row_id).parent().removeClass('has-error');
  }*/

  make_subtotal($("#tr_item_id_"+row_id).val(),row_id);
}

function set_to_original(row_id,item_cost) {
  return true;
  /*Input*/
  var sales_price=$("#sales_price_"+row_id).val();
  if(sales_price!='' || sales_price==0) {sales_price = parseFloat(sales_price); }

  /*Default set from item master*/
  var item_price=parseFloat($("#tr_sales_price_temp_"+row_id).val());

  if(sales_price<item_cost){
    toastr["success"]("Default Price Set "+item_price);
    $("#sales_price_"+row_id).parent().removeClass('has-error');
    $("#sales_price_"+row_id).val(item_price);
  }
  make_subtotal($("#tr_item_id_"+row_id).val(),row_id);
}


//INCREMENT ITEM
function increment_qty(item_id,rowcount){
  var service_bit=$("#service_bit_"+rowcount).val();
  var item_qty=$("#item_qty_"+item_id).val();
  var stock=$("#td_"+rowcount+"_1").html();
  if(service_bit==1 || parseFloat(item_qty)<parseFloat(stock)){
    item_qty=parseFloat(item_qty)+1;
    $("#item_qty_"+item_id).val(format_qty(item_qty));
  }
  make_subtotal(item_id,rowcount);
}
//DECREMENT ITEM
function decrement_qty(item_id,rowcount){
  var item_qty=$("#item_qty_"+item_id).val();
  if(item_qty<=1){
    $("#item_qty_"+item_id).val(format_qty(1));
    return;
  }
  $("#item_qty_"+item_id).val(format_qty(parseFloat(item_qty)-1));
  make_subtotal(item_id,rowcount);
}
//LEFT SIDE: IF ITEM QTY CHANGED MANUALLY
function item_qty_input(item_id,rowcount){
  var item_qty=$("#item_qty_"+item_id).val();
  var service_bit=$("#service_bit_"+rowcount).val();
  var stock=$("#td_"+rowcount+"_1").html();

  if(service_bit!=1){
    if(stock==0){
      toastr["warning"]("item Not Available in stock!");
      //return;  
    }
    if(parseFloat(item_qty)>parseFloat(stock)){
      $("#item_qty_"+item_id).val(format_qty(stock));
      toastr["warning"]("Oops! You have only "+stock+" items in Stock");
     // return;
    }
    if(item_qty==0){
      $("#item_qty_"+item_id).val(format_qty(1));
      toastr["warning"]("You must have atlease one Quantity");
      //return; 
    }
    /*else{
      $("#item_qty_"+item_id).val(1);
      toastr["warning"]("You must have atlease one Quantity");
      return; 
    }*/
  }

  make_subtotal(item_id,rowcount);
}

function zero_stock(){
  toastr["error"]("Out of Stock!");
  return;
}
//LEFT SIDE: REMOVE ROW 
function removerow(id){//id=Rowid  
    $("#row_"+id).remove();
    failed.currentTime = 0;
    failed.play();
    final_total();
}

//MAKE SUBTOTAL


function make_subtotal(item_id,rowcount){
  set_tax_value(rowcount);

   //Find the Tax type and Tax amount
   var tax_type = $("#tr_tax_type_"+rowcount).val();
   var tax_amount = $("#td_data_"+rowcount+"_11").val();

  var sales_price     =$("#sales_price_"+rowcount).val();
  //var gst_per         =$("#tr_item_per_"+rowcount).val();
  var item_qty        =$("#item_qty_"+item_id).val();

  var tot_sales_price =parseFloat(item_qty)*parseFloat(sales_price);
  //var gst_amt=(tot_sales_price * gst_per)/100;

  var subtotal        =parseFloat(tot_sales_price);
  /*Discounr*/
  var discount_amt    =$("#item_discount_"+rowcount).val();

  subtotal = (tax_type=='Inclusive') ? subtotal : parseFloat(subtotal) + parseFloat(tax_amount);

  subtotal -= parseFloat(discount_amt);
  
  $("#td_data_"+rowcount+"_4").val(to_Fixed(subtotal));
  final_total();
}


function calulate_discount(discount_input,discount_type,total){
  if(discount_type=='in_percentage'){
    return parseFloat((total*discount_input)/100);
  }
  else{//in_fixed
    return parseFloat(discount_input);
  }
}
//LEFT SIDE: FINAL TOTAL


function final_total(){
  var total=0;
  var item_qty=0;
  var rowcount=$("#hidden_rowcount").val();
  var discount_input=$("#discount_input").val();
  var discount_type=$("#discount_type").val();
  /*var other_charges=parseFloat($("#other_charges").val());
      other_charges = (isNaN(other_charges)) ? parseFloat(0) :other_charges;*/

  if($(".items_table tr").length>1){
    for(i=0;i<rowcount;i++){
      if(document.getElementById('tr_item_id_'+i)){
       // set_tax_value(i);
      //var tax_amt = parseFloat($("#td_data_"+i+"_11").val());
      item_id=$("#tr_item_id_"+i).val();
      
      total=parseFloat(total)+parseFloat($("#td_data_"+i+"_4").val());
      //console.log("==>total="+total);
      //console.log("==>tax_amt="+tax_amt);
     // total+=tax_amt;
      //console.log("==>total="+total);
      item_qty=parseFloat(item_qty)+parseFloat($("#item_qty_"+item_id).val());
      item_qty = format_qty(item_qty);
      }
    }//for end
  }//items_table
  
  //total+=other_charges;
  //total =round_off(total);
  
  var discount_amt=0;
  if(total>0){
    var discount_amt=calulate_discount(discount_input,discount_type,total);//return value 
  }

  var subtotal = total-discount_amt;

  var coupon_amt = discount_coupon_tot(subtotal);
      subtotal -=coupon_amt;
    
  set_total(item_qty,total,discount_amt,subtotal);
}
function set_total(tot_qty=0, tot_amt=0, tot_disc=0, tot_grand=0){
  $(".tot_qty   ").html(tot_qty);
  $(".tot_amt   ").html(to_Fixed(tot_amt));
  $(".tot_disc  ").html(to_Fixed(tot_disc));
  $(".tot_grand ").html(to_Fixed(round_off(tot_grand)));
}

//LEFT SIDE: FINAL TOTAL
function adjust_payments(){
  var total=0;
  var item_qty=parseFloat(0);
  var rowcount=$("#hidden_rowcount").val();
  var discount_input=$("#discount_input").val();
  var discount_type=$("#discount_type").val();
  
  if($(".items_table tr").length>1){
    for(i=0;i<rowcount;i++){
      if(document.getElementById('tr_item_id_'+i)){
      total=parseFloat(total)+parseFloat($("#td_data_"+i+"_4").val());
      item_id=$("#tr_item_id_"+i).val();
      row_wise_item_qty = get_float_type_data("#item_qty_"+item_id);
      item_qty+=row_wise_item_qty;
      }
    }//for end
  }//items_table

  var payments_row =get_id_value("payment_row_count");
  var paid_amount =parseFloat(0);
  for (var i = 1; i <=payments_row; i++) {
    if(document.getElementById("amount_"+i)){
      var amount = parseFloat(get_id_value("amount_"+i));
          amount = isNaN(amount) ? 0 : amount;
      paid_amount += amount;
    }
  }
  
  var discount_amt=calulate_discount(discount_input,discount_type,total);

  var subtotal = total-discount_amt;
  var coupon_amt = discount_coupon_tot(subtotal);
      subtotal -=coupon_amt;
    
  var previous_due = parseFloat($(".customer_previous_due").text()) || 0;
  var total_payable = subtotal + previous_due;

  var balance = total_payable - paid_amount;
  var change_return = 0;

  if(balance < 0){
    change_return = Math.abs(parseFloat(balance));
    balance = 0;
  }
  
  balance =round_off(balance);
  $(".sales_div_tot_qty").html(format_qty(item_qty));
  $(".sales_div_tot_amt").html((to_Fixed(total)));
  $(".sales_div_tot_discount").html((to_Fixed(discount_amt))); 
  $(".coupon_discount_div_amt").html((to_Fixed(coupon_amt))); 
  $("#coupon_discount_amt").val(coupon_amt); 
  $(".sales_div_tot_payble").html(to_Fixed(round_off(total_payable))); 
  $(".sales_div_tot_paid").html(to_Fixed(round_off(paid_amount)));
  $(".sales_div_tot_balance ").html(to_Fixed(round_off(balance))); 
  $(".sales_div_change_return").html(to_Fixed(change_return)); 
}

$(document).ready(function(){
  get_coupon_details();
});
function check_same_item(item_id){

  if($(".items_table tr").length>1){
    var rowcount=$("#hidden_rowcount").val();
    for(i=0;i<=rowcount;i++){
            if($("#tr_item_id_"+i).val()==item_id){
              increment_qty(item_id,i);
              failed.currentTime = 0;
              failed.play();
              return false;
            }
      }//end for
  }
  return true;
}

// Function to update all cart items when rate type changes
function updateCartRates() {
    var new_rate_type = $("#rate_type_selector").val();
    var rowcount = $("#hidden_rowcount").val();
    
    for(var i = 0; i < rowcount; i++) {
        if(document.getElementById('tr_item_id_'+i)) {
            // Get stored rates for this item
            var all_rates_str = $("#tr_all_rates_"+i).val();
            if(all_rates_str) {
                try {
                    var all_rates = JSON.parse(all_rates_str);
                    var new_price;
                    
                    // Select appropriate rate
                    switch(new_rate_type) {
                        case 'shop':
                            new_price = (all_rates.shop && all_rates.shop != '0') ? all_rates.shop : all_rates.sales;
                            break;
                        case 'wholesale':
                            new_price = (all_rates.wholesale && all_rates.wholesale != '0') ? all_rates.wholesale : all_rates.sales;
                            break;
                        default:
                            new_price = all_rates.sales;
                    }
                    
                    // Update the price input field
                    $("#sales_price_"+i).val(to_Fixed(new_price));
                    
                    // Update the rate type for this row
                    $("#tr_rate_type_"+i).val(new_rate_type);
                    
                    // Recalculate subtotal for this item
                    var item_id = $("#tr_item_id_"+i).val();
                    make_subtotal(item_id, i);
                    
                } catch(e) {
                    console.log("Error parsing rates for row " + i);
                }
            }
        }
    }
    
    // Show notification
    toastr.success("Prices updated to " + new_rate_type.charAt(0).toUpperCase() + new_rate_type.slice(1) + " Rate");
}

// Function to update invoice number when sales type changes
function updateInvoiceNumber() {
    var sales_type_id = $("#sales_type_selector").val();
    var sales_type_name = $("#sales_type_selector option:selected").text();
    
    if(!sales_type_id) {
        toastr.error("Please select a valid sales type");
        return;
    }
    
    // Show loading state
    $("#init_code").val("Loading...");
    $("#count_id").val("Loading...");
    
    // Make AJAX call to get new invoice details
    $.post(base_url + "pos/get_sales_type_invoice_details", {
        sales_type_id: sales_type_id
    }, function(response) {
        try {
            var data = JSON.parse(response);
            if(data.error) {
                toastr.error(data.error);
                return;
            }
            
            // Update invoice fields
            $("#init_code").val(data.init_code);
            $("#count_id").val(data.count_id);
            
            // Store sales type ID for saving
            $("#sales_type_id").val(sales_type_id);
            
            // Show notification
            toastr.success("Invoice number updated for " + sales_type_name);
            
        } catch(e) {
            toastr.error("Error updating invoice number");
            console.log("Error:", e);
        }
    }).fail(function() {
        toastr.error("Server error occurred while updating invoice number");
        // Reset to original values if needed
        $("#init_code").val("<?= $init_code ?>");
        $("#count_id").val("<?= $count_id ?>");
    });
}




$(document).ready(function(){
  
  $("#store_id").trigger('change');

  var customer_id = "<?= (!empty($customer_id)) ? $customer_id : '';  ?>";

  autoLoadFirstCustomer(customer_id);

  //FIRST TIME: LOAD
  //get_details();

  var first_div= parseFloat($(".content-wrapper").height());
  var second_div= parseFloat($("section").height());
  var items_table= parseFloat($(".items_table").height());
  $(".items_table").parent().css("height",(first_div-second_div)+items_table+230);/**/
  $(".search_div").height(((parseFloat(second_div)-parseFloat(items_table))>500) ? 500 : (second_div-items_table) );/**/
  $(".sec_div").height(((parseFloat(second_div)-parseFloat(items_table))>500) ? (parseFloat(second_div)-parseFloat(items_table)) : (second_div-items_table) );/**/

  



  //FIRST TIME: SET TOTAL ZERO
  set_total();
  
  //Debug sales type selector
  console.log("Sales type selector found:", $("#sales_type_selector").length > 0);
  console.log("Sales type options count:", $("#sales_type_selector option").length);
  console.log("Sales type options:", $("#sales_type_selector option").map(function() { 
    return { value: this.value, text: this.text }; 
  }).get());
  
  //Initialize Sales Type with default option and update invoice number based on store settings
  setTimeout(function() {
      var salesTypeOptions = $("#sales_type_selector option");
      var hasValidOptions = salesTypeOptions.length > 1 || (salesTypeOptions.length == 1 && salesTypeOptions.first().val() != '');
      
      if(hasValidOptions) {
          // Only auto-initialize if we're not editing an existing invoice
          <?php if(!isset($sales_id) || empty($sales_id)): ?>
          // Check if there's a default sales type in store settings, otherwise use first option
          var defaultSalesType = "<?= isset($default_sales_type_id) ? $default_sales_type_id : '' ?>";
          if(defaultSalesType && $("#sales_type_selector option[value='" + defaultSalesType + "']").length > 0) {
              $("#sales_type_selector").val(defaultSalesType);
              $("#sales_type_id").val(defaultSalesType);
              console.log("Setting default sales type: " + defaultSalesType);
          } else {
              // Select first valid option by default (skip empty options)
              var firstValidOption = $("#sales_type_selector option[value!='']").first();
              if(firstValidOption.length > 0) {
                  $("#sales_type_selector").val(firstValidOption.val());
                  $("#sales_type_id").val(firstValidOption.val());
                  console.log("Setting first valid sales type: " + firstValidOption.val());
              }
          }
          
          // Update the invoice number based on selected sales type
          setTimeout(function() {
              if($("#sales_type_selector").val()) {
                  updateInvoiceNumber();
              }
          }, 200);
          <?php endif; ?>
      } else {
          console.log("No valid sales types available");
      }
  }, 300);

  //RIGHT DIV: FILTER INPUT BOX
 /* $("#search_it").on("keyup",function(){
    search_it();
  });*/

  //CATEGORY WISE ITEM FETCH FROM SERVER
  var show_only_searched=true;
  $("#category_id,#brand_id").on("change",function () {
      get_details(null,show_only_searched);
  });

  //DISCOUNT UPDATE
  $(".discount_update").on("click",function () {
      final_total();
      $('#discount-modal').modal('toggle');    
  });

  $("#item_name").on("keyup",function () {
      get_details(null,show_only_searched);
  });

  //RIGHT SIDE: CLEAR SEARCH BOX
 /* $(".show_all").on("click",function(){
    $("#search_it").val('').trigger("keyup");
    $("#category_id").val('').trigger("change");
  });*/

  //Reset Category & brand
  $(".reset_categories").on("click",function(){
      $("#category_id").val('').trigger("change");
  });
  $(".reset_brands").on("click",function(){
      $("#brand_id").val('').trigger("change");
  });
  $(".reset_item_name").on("click",function(){
      $("#item_name").val('');
      $("#brand_id").val('').trigger("change");
  });
  
  // Rate Type Selector Change Event
  $("#rate_type_selector").on("change", function(){
      updateCartRates();
  });
  
  // Sales Type Selector Change Event
  $("#sales_type_selector").on("change", function(){
      updateInvoiceNumber();
  });
  
  //UPDATE PROCESS START
 <?php if(isset($sales_id) && !empty($sales_id)){ ?>
    $("#store_id").attr('readonly',true);
    $(".box").append('<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>');
    $.get("<?php echo $base_url ?>pos/fetch_sales/<?php echo $sales_id ?>",{},function(result){
      console.log(result);

      result=result.split("<<<###>>>");
      $('#pos-form-tbody').append(result[0]);
      $('#discount_input').val(result[1]);
      $('#discount_type').val(result[2]);
      $('#reference_no').val(result[7]);
      $('#invoice_terms').text(result[8]);
      
      // Set sales type ID if available
      if(result[9] && result[9] != '' && result[9] != 'undefined' && result[9] != '0') {
        console.log("Setting sales type ID to: " + result[9]);
        
        // Function to wait for sales type options to be loaded
        function setSalesTypeWithRetry(targetId, retryCount = 0) {
          if(retryCount > 10) {
            console.log("Max retries reached for setting sales type");
            return;
          }
          
          var salesTypeOptions = $("#sales_type_selector option");
          var hasValidOptions = salesTypeOptions.length > 1 || (salesTypeOptions.length == 1 && salesTypeOptions.first().val() != '');
          
          if(hasValidOptions && $("#sales_type_selector option[value='" + targetId + "']").length > 0) {
            $('#sales_type_selector').val(targetId);
            $('#sales_type_id').val(targetId);
            console.log("Sales type successfully set for edit invoice: " + targetId);
          } else if(hasValidOptions) {
            console.log("Sales type option not found, available options:", $("#sales_type_selector option").map(function() { return this.value; }).get());
            // Fallback to first valid option
            var firstValidOption = $("#sales_type_selector option[value!='']").first();
            if(firstValidOption.length > 0) {
              $('#sales_type_selector').val(firstValidOption.val());
              $('#sales_type_id').val(firstValidOption.val());
              console.log("Fallback to first valid sales type: " + firstValidOption.val());
            }
          } else {
            // Options not loaded yet, retry
            console.log("Sales type options not ready, retrying... (" + retryCount + ")");
            setTimeout(function() {
              setSalesTypeWithRetry(targetId, retryCount + 1);
            }, 100);
          }
        }
        
        // Start the retry process
        setSalesTypeWithRetry(result[9]);
      } else {
        console.log("No sales type ID found in result[9]: " + result[9]);
        // If no sales type, select first valid available option using the same retry mechanism
        function setFirstValidSalesType(retryCount = 0) {
          if(retryCount > 10) {
            console.log("Max retries reached for setting fallback sales type");
            return;
          }
          
          var salesTypeOptions = $("#sales_type_selector option");
          var hasValidOptions = salesTypeOptions.length > 1 || (salesTypeOptions.length == 1 && salesTypeOptions.first().val() != '');
          
          if(hasValidOptions) {
            var firstValidOption = $("#sales_type_selector option[value!='']").first();
            if(firstValidOption.length > 0) {
              $('#sales_type_selector').val(firstValidOption.val());
              $('#sales_type_id').val(firstValidOption.val());
              console.log("Set first valid sales type as fallback: " + firstValidOption.val());
            }
          } else {
            // Options not loaded yet, retry
            console.log("Sales type options not ready for fallback, retrying... (" + retryCount + ")");
            setTimeout(function() {
              setFirstValidSalesType(retryCount + 1);
            }, 100);
          }
        }
        
        setFirstValidSalesType();
      }
      /*if(store_module){
        $('#store_id').val(result[4]).select2();
      }
      else{*/
        $('#store_id').val(result[4]);
      /*}*/
      console.log("warehouse = "+result[5]);
      if(warehouse_module){
        $('#warehouse_id').val(result[5]).select2();
      }
      else{
        $('#warehouse_id').val(result[5]);
      }

      //$('#customer_id').val(result[3]).select2();
      //$("#customer_id").trigger("change");
      
      
      $("#hidden_rowcount").val(parseInt($(".items_table tr").length)-1);
      final_total();
      get_details();
      $(".overlay").remove();
      
      if(result[5]==1){
        $( "#binvoice" ).prop( "checked", true );
        $('#binvoice').parent('div').addClass('checked');
      }
    });
      //DISABLE THE HOLD BUTTON
      $("#hold_invoice,#show_cash_modal,#pay_all").attr('disabled',true).removeAttr('id');

 <?php } else{?>
  get_details();
 <?php } ?>
  //UPDATE PROCESS END


});//ready() end



//DATEPICKER INITIALIZATION
$('#order_date,#delivery_date,#cheque_date,#expense_date_modal').datepicker({
      autoclose: true,
      format: 'dd-mm-yyyy',
      todayHighlight: true
    });
    $('#customer_dob,#birthday_person_dob').datepicker({
      calendarWeeks: true,
      todayHighlight: true,
      autoclose: true,
      format: 'dd-mm-yyyy',
      startView: 2
    });
    
    //Datemask dd-mm-yyyy
    //$("#customer_dob,#birthday_person_dob").inputmask("dd-mm-yyyy", {"placeholder": "dd-mm-yyyy"});

    //Timepicker
    /*$('.timepicker').timepicker({
      showInputs: false,
    });*/

    //Sale Items Modal Operations Start
    function show_sales_item_modal(row_id){
      $('#sales_item').modal('toggle');
      //$("#popup_tax_id").select2();

      //Find the item details
      var item_name = $("#td_data_"+row_id+"_0").html();
      var tax_type = $("#tr_tax_type_"+row_id).val();
      var tax_id = $("#tr_tax_id_"+row_id).val();
      var description = $("#description_"+row_id).val();

      /*Discount*/
      var item_discount_input = $("#item_discount_input_"+row_id).val();
      var item_discount_type = $("#item_discount_type_"+row_id).val();

      //Set to Popup
      $("#item_discount_input").val(item_discount_input);
      $("#item_discount_type").val(item_discount_type).select2();

      $("#popup_item_name").html(item_name);
      $("#popup_tax_type").val(tax_type).select2();
      $("#popup_tax_id").val(tax_id).select2();
      $("#popup_row_id").val(row_id);
      $("#popup_description").val(description);
    }

    function set_info(){
      var row_id = $("#popup_row_id").val();
      var tax_type = $("#popup_tax_type").val();
      var tax_id = $("#popup_tax_id").val();
      var description = $("#popup_description").val();
      var tax_name = ($('option:selected', "#popup_tax_id").attr('data-tax-value'));
      var tax = parseFloat($('option:selected', "#popup_tax_id").attr('data-tax'));

      /*Discounr*/
      var item_discount_input = $("#item_discount_input").val();
      var item_discount_type = $("#item_discount_type").val();

      //Set it into row 
      $("#item_discount_input_"+row_id).val(item_discount_input);
      $("#item_discount_type_"+row_id).val(item_discount_type);

      $("#tr_tax_type_"+row_id).val(tax_type);
      $("#tr_tax_id_"+row_id).val(tax_id);
      $("#description_"+row_id).val(description);
      $("#tr_tax_value_"+row_id).val(tax);//%
      //$("#td_data_"+row_id+"_12").html(tax_type+" "+tax_name);
      
      var item_id=$("#tr_item_id_"+row_id).val();
      make_subtotal(item_id,row_id);
      //calculate_tax(row_id);
      $('#sales_item').modal('toggle');
    }
    function set_tax_value(row_id){
      //get the sales price of the item
      var tax_type = $("#tr_tax_type_"+row_id).val();
      var tax = $("#tr_tax_value_"+row_id).val(); //%
      var item_id=$("#tr_item_id_"+row_id).val();
      var qty=($("#item_qty_"+item_id).val());
          qty = (isNaN(qty)) ? 0 :qty;

      var sales_price = parseFloat($("#sales_price_"+row_id).val());
          sales_price = (isNaN(sales_price)) ? 0 :sales_price;
          sales_price = sales_price * qty;

      /*Discount*/
      var item_discount_type = $("#item_discount_type_"+row_id).val();
      var item_discount_input = parseFloat($("#item_discount_input_"+row_id).val());
          item_discount_input = (isNaN(item_discount_input)) ? 0 :item_discount_input;
      
      //Calculate discount      
      var discount_amt=(item_discount_type=='Percentage') ? ((sales_price) * item_discount_input)/100 : (item_discount_input*qty);
     
      sales_price-=parseFloat(discount_amt);

      var tax_amount = (tax_type=='Inclusive') ? calculate_inclusive(sales_price,tax) : calculate_exclusive(sales_price,tax);
      
      $("#item_discount_"+row_id).val(to_Fixed(discount_amt));
      $("#td_data_"+row_id+"_11").val(to_Fixed(tax_amount));
    }
    //Sale Items Modal Operations End

</script>
<script>
  $(function () {
    $('input').iCheck({
      checkboxClass: 'icheckbox_square-blue',
      radioClass: 'iradio_square-blue',
      increaseArea: '20%' // optional
    });
  });
</script>
<script type="text/javascript">
  shortcut.add("Alt+m",function(e) {
        e.preventDefault();
        $(".show_payments_modal").trigger('click');
    },{
        'type':'keydown',
        'propagate':true,
        'target':document
      });

  shortcut.add("Alt+h",function(e) {
        e.preventDefault();
        $("#hold_invoice").trigger('click');
    },{
        'type':'keydown',
        'propagate':true,
        'target':document
      });
  shortcut.add("Alt+c",function(e) {
        e.preventDefault();
        $(".Alt_c").trigger('click');
    },{
        'type':'keydown',
        'propagate':true,
        'target':document
      });
  shortcut.add("Alt+a",function(e) {
        e.preventDefault();
        $(".Alt_a").trigger('click');
    },{
        'type':'keydown',
        'propagate':true,
        'target':document
      });
</script>

<script>

//Reset Tooltip
function reset_tooltip() {
  $('[data-toggle="tooltip"]').tooltip("destroy");
  $('[data-toggle="tooltip"]').tooltip(); // re-enabling 
}
$('.search_div').on('scroll', function() {
    if ($(this).scrollTop() + $(this).innerHeight() >= $(this)[0].scrollHeight) {

      if($(".scroll_or_not").val()=="true"){

        //Scroll Restriction Enabled
        $(".scroll_or_not").val("false");
        //Ajax Loader
        $('.ajax-load').show();

        setTimeout(function() {
          //Ajax Request
          load_next_details();  
          //Scroll Restriction Disabled
          $(".scroll_or_not").val("true");
          //Ajax Loader End
          $('.ajax-load').hide();    
        }, 1000);
        
        
      }
      
    }
});

function load_next_details(){
  var last_id = $(".item_box:last").attr("data-item-id");
  get_details(last_id);
}



function get_details(last_id='',show_only_searched=false){

  warehouse_id = $("#warehouse_id").val();

  $.ajax({
      url: '<?php echo $base_url; ?>pos/get_details',
      type: "post",
      data:{
        last_id       : (!show_only_searched) ? last_id : '',
        customer_id   : $("#customer_id").val(),
        id            : $("#category_id").val(),
        store_id      : $("#store_id").val(),
        warehouse_id  : $("#warehouse_id").val(),
        item_name     : $("#item_name").val(),
        //search_it  : $("#search_it").val(),
        brand_id  : $("#brand_id").val(),

      },
      beforeSend: function(){
          $('.ajax-load').show();
      }
  }).done(function(data){
      $('.ajax-load').hide();
      
      if(data=='') {
        $(".error_div").show();
      }
      else{
        $(".error_div").hide();
      }


      if(show_only_searched){
        $(".search_div").html('');
      }
      $(".search_div").append(data);
      reset_tooltip();
  }).fail(function(jqXHR, ajaxOptions, thrownError){
      alert('server not responding...');
  });
}

// Payment Collection Functions
function showPaymentCollectionModal() {
    var customer_id = $("#customer_id").val();
    var customer_name = $("#customer_id option:selected").text();
    var previous_due = parseFloat($(".customer_previous_due").text().replace(/[^0-9.-]/g, '')) || 0;
    
    if (customer_id == 1 || customer_id == '') {
        toastr["error"]("Please select a customer first!");
        return;
    }
    
    if (previous_due <= 0) {
        toastr["info"]("Customer has no previous due amount to collect.");
        return;
    }
    
    // Populate modal
    $("#payment_customer_name").text(customer_name);
    $("#payment_previous_due").text(to_Fixed(previous_due));
    $("#collection_amount").val('').attr('max', previous_due);
    $("#collection_payment_type").val('Cash');
    $("#collection_payment_note").val('');
    
    // Show modal
    $('#payment-collection-modal').modal('show');
}

function processPaymentCollection() {
    var customer_id = $("#customer_id").val();
    var amount = parseFloat($("#collection_amount").val());
    var payment_type = $("#collection_payment_type").val();
    var payment_note = $("#collection_payment_note").val();
    var previous_due = parseFloat($(".customer_previous_due").text().replace(/[^0-9.-]/g, '')) || 0;
    
    // Validation
    if (!amount || amount <= 0) {
        toastr["error"]("Please enter a valid payment amount!");
        $("#collection_amount").focus();
        return;
    }
    
    if (amount > previous_due) {
        toastr["error"]("Payment amount cannot exceed previous due amount!");
        $("#collection_amount").focus();
        return;
    }
    
    // Disable button to prevent double submission
    $("#payment-collection-modal .btn-success").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
    
    // Send AJAX request
    $.post($("#base_url").val() + "pos/collect_customer_payment", {
        customer_id: customer_id,
        amount: amount,
        payment_type: payment_type,
        payment_note: payment_note || 'Previous due payment collection'
    }, function(result) {
        if (result.includes('success') || result.includes('Success')) {
            toastr["success"]("Payment collected successfully!");
            
            // Update previous due display
            var new_due = previous_due - amount;
            $(".customer_previous_due").text(to_Fixed(new_due));
            
            // Hide collect button if no more due
            if (new_due <= 0) {
                $("#collect_payment_btn").hide();
            }
            
            // Close modal
            $('#payment-collection-modal').modal('hide');
            
            // Recalculate totals
            adjust_payments();
        } else {
            toastr["error"]("Error: " + result);
        }
    }).fail(function() {
        toastr["error"]("Server error occurred!");
    }).always(function() {
        // Re-enable button
        $("#payment-collection-modal .btn-success").prop('disabled', false).html('<i class="fa fa-money"></i> Collect Payment');
    });
}

// Show/hide collect payment button when customer changes
$(document).on('change', '#customer_id', function() {
    var customer_id = $(this).val();
    setTimeout(function() {
        var previous_due = parseFloat($(".customer_previous_due").text().replace(/[^0-9.-]/g, '')) || 0;
        if (customer_id != 1 && customer_id != '' && previous_due > 0) {
            $("#collect_payment_btn").show();
        } else {
            $("#collect_payment_btn").hide();
        }
        
        // Show/hide ledger button for any valid customer (except walk-in customer)
        if (customer_id != 1 && customer_id != '') {
            $("#customer_ledger_btn").show();
        } else {
            $("#customer_ledger_btn").hide();
        }
    }, 500); // Small delay to ensure previous due is updated
});

// Transaction Ledger Function
function openTransactionLedger() {
    var customer_id = $("#customer_id").val();
    if (customer_id && customer_id != 1) {
        // Open Sales Payments page with pre-selected customer in new window
        var url = $("#base_url").val() + "sales_payments?customer_id=" + customer_id;
        window.open(url, '_blank', 'width=1400,height=900,scrollbars=yes,resizable=yes');
    } else {
        alert('Please select a customer first.');
    }
}

// Stock Adjustment Function
function openStockAdjustment() {
    // Redirect to stock adjustment add page
    var url = $("#base_url").val() + "stock_adjustment/add";
    window.location.href = url;
}

// Save Expense Function
function saveExpense() {
    // Clear previous error messages
    $('span[id$="_modal_msg"]').hide();
    
    // Get form data
    var expense_date = $("#expense_date_modal").val();
    var category_id = $("#category_id_modal").val();
    var expense_for = $("#expense_for_modal").val();
    var payment_type = $("#payment_type_modal").val();
    var account_id = $("#account_id_modal").val();
    var expense_amt = $("#expense_amt_modal").val();
    var reference_no = $("#reference_no_modal").val();
    var note = $("#note_modal").val();
    
    // Validation
    var hasError = false;
    
    if (!expense_date.trim()) {
        $("#expense_date_modal_msg").text("Expense date is required").show();
        hasError = true;
    }
    
    if (!category_id) {
        $("#category_id_modal_msg").text("Category is required").show();
        hasError = true;
    }
    
    if (!expense_for.trim()) {
        $("#expense_for_modal_msg").text("Expense description is required").show();
        hasError = true;
    }
    
    if (!payment_type) {
        $("#payment_type_modal_msg").text("Payment type is required").show();
        hasError = true;
    }
    
    if (!expense_amt.trim() || parseFloat(expense_amt) <= 0) {
        $("#expense_amt_modal_msg").text("Valid expense amount is required").show();
        hasError = true;
    }
    
    if (hasError) {
        return false;
    }
    
    // Disable button to prevent double submission
    $(".modal-footer .btn-primary").prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving...');
    
    // Prepare form data
    var formData = $("#expense-form-modal").serialize();
    
    // Send AJAX request
    $.post($("#base_url").val() + "expense/newexpense", formData, function(result) {
        if (result.includes('success') || result.includes('Success')) {
            toastr["success"]("Expense saved successfully!");
            
            // Reset form
            $("#expense-form-modal")[0].reset();
            $('.select2').val(null).trigger('change');
            
            // Close modal
            $('#expense-modal').modal('hide');
        } else {
            toastr["error"]("Error: " + result);
        }
    }).fail(function() {
        toastr["error"]("Server error occurred!");
    }).always(function() {
        // Re-enable button
        $(".modal-footer .btn-primary").prop('disabled', false).html('<i class="fa fa-save"></i> Save Expense');
    });
}

// Reset expense modal when opened
$('#expense-modal').on('show.bs.modal', function() {
    // Reset form
    $("#expense-form-modal")[0].reset();
    
    // Clear error messages
    $('span[id$="_modal_msg"]').hide();
    
    // Initialize select2 dropdowns for modal
    $("#category_id_modal").select2();
    $("#payment_type_modal").select2();
    $("#account_id_modal").select2();
    
    // Reset select2 dropdowns
    $("#category_id_modal").val(null).trigger('change');
    $("#payment_type_modal").val(null).trigger('change');
    $("#account_id_modal").val(null).trigger('change');
    
    // Set current date
    $("#expense_date_modal").val('<?php echo date("d-m-Y"); ?>');
});

// QR Code Scanner Function
function startItemBarcodeScanner() {
    // Create scanner modal
    const modal = document.createElement('div');
    modal.className = 'scanner-modal';
    modal.innerHTML = `
        <div class="scanner-content">
            <h4>Scan QR Code or Barcode</h4>
            <div id="qr-reader" style="width: 100%; max-width: 400px; margin: 0 auto;"></div>
            <div class="scanner-controls">
                <button id="flashToggle" class="btn-flash">
                    <i class="fa fa-lightbulb"></i> Flash: OFF
                </button>
                <button id="closeScanner" class="btn-close-scanner">
                    <i class="fa fa-times"></i> Close Scanner
                </button>
            </div>
        </div>
    `;
    
    document.body.appendChild(modal);
    
    const html5QrCode = new Html5Qrcode("qr-reader");
    let isScanning = true;
    let isFlashOn = false;
    
    // Flash toggle function
    async function toggleFlash() {
        try {
            const flashBtn = document.getElementById('flashToggle');
            isFlashOn = !isFlashOn;
            
            await html5QrCode.applyVideoConstraints({
                advanced: [{ torch: isFlashOn }]
            });
            
            flashBtn.innerHTML = `<i class="fa fa-lightbulb"></i> Flash: ${isFlashOn ? 'ON' : 'OFF'}`;
        } catch (err) {
            console.log('Flash not supported:', err);
        }
    }
    
    // Stop scanner function
    function stopScanner() {
        if (isScanning) {
            html5QrCode.stop().then(() => {
                document.body.removeChild(modal);
                isScanning = false;
            }).catch((err) => {
                console.log('Error stopping scanner:', err);
                document.body.removeChild(modal);
                isScanning = false;
            });
        }
    }
    
    // Event listeners
    document.getElementById('flashToggle').onclick = toggleFlash;
    document.getElementById('closeScanner').onclick = stopScanner;
    modal.onclick = (e) => {
        if (e.target === modal) stopScanner();
    };
    
    // Scan success callback
    const onScanSuccess = (decodedText, decodedResult) => {
        console.log('Scanned:', decodedText);
        
        // Set the scanned text to the item search input
        document.getElementById('item_search').value = decodedText;
        
        // Trigger the autocomplete search
        $("#item_search").autocomplete('search');
        
        // Stop scanner and close modal
        stopScanner();
        
        // Show success message
        toastr["success"]("Barcode scanned successfully!");
    };
    
    // Scan error callback (optional)
    const onScanFailure = (error) => {
        // Handle scan failure silently
    };
    
    // Start scanning
    Html5Qrcode.getCameras().then(cameras => {
        if (cameras && cameras.length) {
            const cameraId = cameras[0].id;
            
            html5QrCode.start(
                cameraId,
                {
                    fps: 10,
                    qrbox: { width: 250, height: 150 }
                },
                onScanSuccess,
                onScanFailure
            ).then(() => {
                console.log('QR Code scanner started.');
                // Wait a moment for camera to initialize before enabling flash
                setTimeout(() => {
                    document.getElementById('flashToggle').style.display = 'inline-block';
                }, 1000);
            }).catch(err => {
                console.log('Unable to start scanning:', err);
                stopScanner();
                alert('Unable to access camera. Please check camera permissions.');
            });
        } else {
            alert('No cameras found.');
            stopScanner();
        }
    }).catch(err => {
        console.log('Error getting cameras:', err);
        stopScanner();
        alert('Error accessing camera.');
    });
}

</script> 
</body>
</html>
