<!DOCTYPE html>
<html>
<head>
    <!-- TABLES CSS CODE -->
    <?php include"comman/code_css.php"; ?>
    <!-- </copy> -->  
</head>
<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <?php include"sidebar.php"; ?>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    <?=$page_title;?>
                    <small></small>
                </h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo $base_url; ?>dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo $base_url; ?>pos"><i class="fa fa-calculator"></i> POS</a></li>
                    <li class="active"><?=$page_title;?></li>
                </ol>
            </section>
            
            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <!-- Customer Information -->
                    <div class="col-md-12">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">Customer Information</h3>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <strong>Customer Name:</strong><br>
                                        <?= $customer->customer_name ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Mobile:</strong><br>
                                        <?= isset($customer->mobile) ? $customer->mobile : (isset($customer->mobile_number) ? $customer->mobile_number : 'N/A') ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Email:</strong><br>
                                        <?= isset($customer->email) ? $customer->email : (isset($customer->email_id) ? $customer->email_id : 'N/A') ?>
                                    </div>
                                    <div class="col-md-3">
                                        <strong>Address:</strong><br>
                                        <?= $customer->address ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Date Filter -->
                    <div class="col-md-12">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">Filter Options</h3>
                            </div>
                            <div class="box-body">
                                <form class="form-horizontal" id="filter-form">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label for="from_date" class="control-label">From Date</label>
                                            <div class="input-group date">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right datepicker" id="from_date" name="from_date" value="<?php echo show_date($from_date);?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="to_date" class="control-label">To Date</label>
                                            <div class="input-group date">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input type="text" class="form-control pull-right datepicker" id="to_date" name="to_date" value="<?php echo show_date($to_date);?>">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="control-label">&nbsp;</label><br>
                                            <button type="button" class="btn btn-primary" onclick="get_customer_history_report()">
                                                <i class="fa fa-search"></i> Show Report
                                            </button>
                                            <button type="button" class="btn btn-default" onclick="print_report()">
                                                <i class="fa fa-print"></i> Print
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Balance Summary -->
                    <div class="col-md-12">
                        <div class="box box-info">
                            <div class="box-header with-border">
                                <h3 class="box-title">Balance Summary</h3>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-4 text-center">
                                        <h4>Opening Balance</h4>
                                        <h3 class="text-blue" id="opening_balance"><?= store_number_format($opening_balance) ?></h3>
                                        <small>As of <?= show_date($from_date) ?></small>
                                    </div>
                                    <div class="col-md-4 text-center">
                                        <h4>Closing Balance</h4>
                                        <h3 class="text-green" id="closing_balance"><?= store_number_format($closing_balance) ?></h3>
                                        <small>As of <?= show_date(date('Y-m-d')) ?></small>
                                    </div>
                                    <div class="col-md-4 text-center">
                                        <h4>Outstanding</h4>
                                        <h3 class="text-red" id="outstanding_balance"><?= store_number_format($closing_balance) ?></h3>
                                        <small>Current Outstanding</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Transaction History Table -->
                    <div class="col-md-12">
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title">Transaction History</h3>
                            </div>
                            <div class="box-body">
                                <table id="history_table" class="table table-bordered table-striped" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Description</th>
                                            <th>Reference</th>
                                            <th>Debit</th>
                                            <th>Credit</th>
                                            <th>Balance</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Opening Balance Row -->
                                        <tr class="bg-light-blue">
                                            <td><?= show_date($from_date) ?></td>
                                            <td><strong>Opening Balance</strong></td>
                                            <td>-</td>
                                            <td>-</td>
                                            <td>-</td>
                                            <td><strong><?= store_number_format($opening_balance) ?></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        
        <?php include"footer.php"; ?>
        <!-- Add the sidebar's background. This div must be placed
             immediately after the control sidebar -->
        <div class="control-sidebar-bg"></div>
    </div>
    <!-- ./wrapper -->
    
    <!-- SCRIPTS -->
    <?php include"comman/code_js.php"; ?>
    <!-- </copy> -->
    
    <script>
        var customer_id = <?= $customer_id ?>;
        var base_url = "<?= base_url() ?>";
        
        $(document).ready(function() {
            // Initialize DataTable
            $('#history_table').DataTable({
                "processing": true,
                "ordering": false,
                "searching": false,
                "paging": true,
                "pageLength": 25,
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "dom": 'Bfrtip',
                "buttons": [
                    {
                        extend: 'copy',
                        title: 'Customer Transaction History'
                    },
                    {
                        extend: 'csv',
                        title: 'Customer Transaction History'
                    },
                    {
                        extend: 'excel',
                        title: 'Customer Transaction History'
                    },
                    {
                        extend: 'pdf',
                        title: 'Customer Transaction History',
                        orientation: 'landscape'
                    },
                    {
                        extend: 'print',
                        title: 'Customer Transaction History'
                    }
                ]
            });
            
            // Load initial data
            get_customer_history_report();
        });
        
        function get_customer_history_report() {
            var from_date = $("#from_date").val();
            var to_date = $("#to_date").val();
            
            if (from_date == '' || to_date == '') {
                alert('Please select both From Date and To Date');
                return;
            }
            
            // Show loading
            $('#history_table').DataTable().clear().draw();
            
            $.ajax({
                url: base_url + 'account_transactions/get_customer_history_data',
                type: 'POST',
                data: {
                    customer_id: customer_id,
                    from_date: db_date(from_date),
                    to_date: db_date(to_date),
                    '<?php echo $this->security->get_csrf_token_name();?>': '<?php echo $this->security->get_csrf_hash();?>'
                },
                dataType: 'json',
                success: function(response) {
                    // Clear existing data
                    $('#history_table').DataTable().clear();
                    
                    // Add opening balance row
                    var opening_balance = <?= $opening_balance ?>;
                    $('#history_table').DataTable().row.add([
                        show_date(db_date(from_date)),
                        '<strong>Opening Balance</strong>',
                        '-',
                        '-',
                        '-',
                        '<strong>' + number_format(opening_balance) + '</strong>'
                    ]);
                    
                    // Add transaction data
                    if (response.data && response.data.length > 0) {
                        for (var i = 0; i < response.data.length; i++) {
                            $('#history_table').DataTable().row.add(response.data[i]);
                        }
                    }
                    
                    // Add closing balance row
                    var closing_balance = <?= $closing_balance ?>;
                    $('#history_table').DataTable().row.add([
                        show_date(db_date(to_date)),
                        '<strong>Closing Balance</strong>',
                        '-',
                        '-',
                        '-',
                        '<strong>' + number_format(closing_balance) + '</strong>'
                    ]);
                    
                    $('#history_table').DataTable().draw();
                },
                error: function() {
                    alert('Error occurred while loading data');
                }
            });
        }
        
        function print_report() {
            window.print();
        }
    </script>
</body>
</html>
