<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sales_types_model extends CI_Model {

	var $table = 'db_sales_types';
	var $column_order = array('sales_type_name','sales_type_initial','description','status','store_id'); //set column field database for datatable orderable
	var $column_search = array('sales_type_name','sales_type_initial','description','status','store_id'); //set column field database for datatable searchable 
	var $order = array('id' => 'desc'); // default order 

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);
		//if not admin
		//if(!is_admin()){
			$this->db->where("store_id",get_current_store_id());
		//}

		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{
				
				if($i===0) // first loop
				{
					$this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
					$this->db->like($item, $_POST['search']['value']);
				}
				else
				{
					$this->db->or_like($item, $_POST['search']['value']);
				}

				if(count($this->column_search) - 1 == $i) //last loop
					$this->db->group_end(); //close bracket
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->where("store_id",get_current_store_id());
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}


	public function verify_and_save(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
		$store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();  	
		//Validate This sales type already exist or not
		$query=$this->db->query("select * from db_sales_types where (upper(sales_type_name)=upper('$sales_type_name') OR upper(sales_type_initial)=upper('$sales_type_initial')) and store_id=$store_id");
		if($query->num_rows()>0){
			return "This Sales Type Name or Initial Already Exist.";
			
		}
		else{
			$info = array(
		    				'store_id' 				=> $store_id, 
		    				'sales_type_name' 		=> $sales_type_name, 
		    				'sales_type_initial' 	=> strtoupper($sales_type_initial),
		    				'description' 			=> $description,
		    				'status' 				=> 1,
		    			);
			
			$q1 = $this->db->insert('db_sales_types', $info);
			if ($q1){
					$this->session->set_flashdata('success', 'Success!! Sales Type Added Successfully!');
			        return "success";
			}
			else{
			        return "failed";
			}
		}
	}

	//Get sales_types_details
	public function get_details($id,$data){
		//Validate This sales type already exist or not
		$query=$this->db->query("select * from db_sales_types where upper(id)=upper('$id')");
		if($query->num_rows()==0){
			show_404();exit;
		}
		else{
			$query=$query->row();
			$data['q_id']=$query->id;
			$data['sales_type_name']=$query->sales_type_name;
			$data['sales_type_initial']=$query->sales_type_initial;
			$data['description']=$query->description;
			$data['store_id']=$query->store_id;
			return $data;
		}
	}
	public function update_sales_type(){
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST))));
		$store_id=(store_module() && is_admin()) ? $store_id : get_current_store_id();  	
		//Validate This sales type already exist or not
		$query=$this->db->query("select * from db_sales_types where (upper(sales_type_name)=upper('$sales_type_name') OR upper(sales_type_initial)=upper('$sales_type_initial')) and id<>$q_id and store_id=$store_id");
		if($query->num_rows()>0){
			return "This Sales Type Name or Initial already Exist.";
			
		}
		else{
			$info = array(
		    				'sales_type_name' 		=> $sales_type_name, 
		    				'sales_type_initial' 	=> strtoupper($sales_type_initial),
		    				'description' 			=> $description,
		    			);
			
			$info['store_id']=(store_module() && is_admin()) ? $store_id : get_current_store_id();

			$q1 = $this->db->where('id',$q_id)->where('store_id',$store_id)->update('db_sales_types', $info);
		
			if ($q1){
					$this->session->set_flashdata('success', 'Success!! Sales Type Updated Successfully!');
			        return "success";
			}
			else{
			        return "failed";
			}
		}
	}
	public function update_status($id,$status){
       if (set_status_of_table($id,$status,'db_sales_types')){
            echo "success";
        }
        else{
            echo "failed";
        }
	}
	public function delete_sales_type($id){
		// Check if sales type is used in any sales transactions
		$tot_rec = $this->db->select("count(*) as tot")->where("store_id",get_current_store_id())->where("sales_type_id in($id)")->get("db_sales")->row()->tot;
		if($tot_rec>0){
			echo "Can't Delete! Already used in Sales transactions.";exit;
		}
		
		$this->db->where("id",$id);
		//if not admin
		if(!is_admin()){
			$this->db->where("store_id",get_current_store_id());
		}

		$query1=$this->db->delete("db_sales_types");
        if ($query1){
            echo "success";
        }
        else{
            echo "failed";
        }
	}

	//Get all active sales types for dropdown
	public function get_all_active_sales_types($store_id = null){
		$store_id = ($store_id) ? $store_id : get_current_store_id();
		
		$this->db->select('id, sales_type_name, sales_type_initial');
		$this->db->where('status', 1);
		$this->db->where('store_id', $store_id);
		$this->db->order_by('sales_type_name', 'ASC');
		$query = $this->db->get('db_sales_types');
		return $query->result();
	}


}
