<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Purchase_return_types_model
 * Auto-generated on August 5, 2025
 * Handles database operations for Purchase Return Types
 */
class Purchase_return_types_model extends CI_Model {

	var $table = 'db_purchase_return_types';
	var $column_order = array('purchase_return_type_name','purchase_return_type_initial','description','status','store_id');
	var $column_search = array('purchase_return_type_name','purchase_return_type_initial','description','status','store_id');
	var $order = array('id' => 'desc');

	public function __construct(){
		parent::__construct();
	}

	/**
	 * DataTables query builder
	 */
	private function _get_datatables_query(){
		$this->db->from($this->table);
		$this->db->where("store_id", get_current_store_id());
		
		$i = 0;
		foreach ($this->column_search as $item) {
			if($_POST['search']['value']) {
				if($i === 0) {
					$this->db->group_start();
					$this->db->like($item, $_POST['search']['value']);
				} else {
					$this->db->or_like($item, $_POST['search']['value']);
				}
				if(count($this->column_search) - 1 == $i)
					$this->db->group_end();
			}
			$i++;
		}
		
		if(isset($_POST['order'])) {
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} else if(isset($this->order)) {
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	/**
	 * Get DataTables data
	 */
	function get_datatables(){
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
			$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	/**
	 * Count filtered records
	 */
	function count_filtered(){
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	/**
	 * Count all records
	 */
	public function count_all(){
		$this->db->where("store_id", get_current_store_id());
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	/**
	 * Save new record
	 */
	public function verify_and_save(){
		// Initialize data array
		if (!isset($this->data)) {
			$this->data = array();
		}
		
		// Clean input data
		extract($this->security->xss_clean(html_escape(array_merge($this->data, $_POST))));
		$store_id = (store_module() && is_admin()) ? $store_id : get_current_store_id();
		
		// Check for duplicates
		$query = $this->db->query("SELECT * FROM db_purchase_return_types WHERE (UPPER(purchase_return_type_name) = UPPER('$purchase_return_type_name') OR UPPER(purchase_return_type_initial) = UPPER('$purchase_return_type_initial')) AND store_id = $store_id");
		if($query->num_rows() > 0){
			return "This Purchase Return Type Name or Initial Already Exist.";
		} else {
			$info = array(
				'store_id' => $store_id,
				'purchase_return_type_name' => $purchase_return_type_name,
				'purchase_return_type_initial' => strtoupper($purchase_return_type_initial),
				'description' => $description,
				'status' => 1,
			);
			
			$q1 = $this->db->insert('db_purchase_return_types', $info);
			if ($q1){
				$this->session->set_flashdata('success', 'Success!! Purchase Return Type Added Successfully!');
				return "success";
			} else {
				return "failed";
			}
		}
	}

	/**
	 * Get record details
	 */
	public function get_details($id, $data){
		$query = $this->db->query("SELECT * FROM db_purchase_return_types WHERE UPPER(id) = UPPER('$id')");
		if($query->num_rows() == 0){
			show_404();
			exit;
		} else {
			$query = $query->row();
			$data['q_id'] = $query->id;
			$data['purchase_return_type_name'] = $query->purchase_return_type_name;
			$data['purchase_return_type_initial'] = $query->purchase_return_type_initial;
			$data['description'] = $query->description;
			$data['store_id'] = $query->store_id;
			return $data;
		}
	}

	/**
	 * Update record
	 */
	public function update_purchase_return_type(){
		// Initialize data array
		if (!isset($this->data)) {
			$this->data = array();
		}
		
		// Clean input data
		extract($this->security->xss_clean(html_escape(array_merge($this->data, $_POST))));
		$store_id = (store_module() && is_admin()) ? $store_id : get_current_store_id();
		
		// Check for duplicates excluding current record
		$query = $this->db->query("SELECT * FROM db_purchase_return_types WHERE (UPPER(purchase_return_type_name) = UPPER('$purchase_return_type_name') OR UPPER(purchase_return_type_initial) = UPPER('$purchase_return_type_initial')) AND id <> $q_id AND store_id = $store_id");
		if($query->num_rows() > 0){
			return "This Purchase Return Type Name or Initial already Exist.";
		} else {
			$info = array(
				'purchase_return_type_name' => $purchase_return_type_name,
				'purchase_return_type_initial' => strtoupper($purchase_return_type_initial),
				'description' => $description,
			);
			
			$info['store_id'] = (store_module() && is_admin()) ? $store_id : get_current_store_id();
			$q1 = $this->db->where('id', $q_id)->where('store_id', $store_id)->update('db_purchase_return_types', $info);
		
			if ($q1){
				$this->session->set_flashdata('success', 'Success!! Purchase Return Type Updated Successfully!');
				return "success";
			} else {
				return "failed";
			}
		}
	}

	/**
	 * Update status
	 */
	public function update_status($id, $status){
		if (set_status_of_table($id, $status, 'db_purchase_return_types')){
			echo "success";
		} else {
			echo "failed";
		}
	}

	/**
	 * Delete record
	 */
	public function delete_purchase_return_type($id){
		// Check if purchase return type is used in any purchase return transactions
		$tot_rec = $this->db->select("count(*) as tot")->where("store_id", get_current_store_id())->where("purchase_return_type_id in($id)")->get("db_purchase_return")->row()->tot;
		if($tot_rec > 0){
			echo "Can't Delete! Already used in Purchase Return transactions.";
			exit;
		}
		
		$this->db->where("id", $id);
		if(!is_admin()){
			$this->db->where("store_id", get_current_store_id());
		}

		$query1 = $this->db->delete("db_purchase_return_types");
		if ($query1){
			echo "success";
		} else {
			echo "failed";
		}
	}
}
