<?php

include('MyPDF.php');

class GstInvoice extends MyPDF{
	//public $CI=null;

	protected $sales_id =null;

	//public $store =array();

	protected $customer =array();

	protected $sales =array();

	public $customer_state_name = null;


	public function __construct(array $param=array())
	{
		parent::__construct();

		$this->sales_id = $param['sales_id'];

		//$this->CI =& get_instance();

		//$this->store = get_store_details();//Declared in MyPDF Pa

		$this->sales = get_sales_details($this->sales_id);

		$this->customer = get_customer_details($this->sales->customer_id);

	}
	public function _get_customer_details()
    {   

    	$customer = $this->customer;//array()

    	$store = $this->store;//array()

    	//Customer Records
	    $state = (!empty($customer->state_id)) ? get_state_details($customer->state_id) : '';
	    $this->customer_state_name = (!empty($state)) ? $state->state : $store->state;

        $w = 100;
        $h = 40;

        $custmer_details = '<span style="color:#2c3e50;font-weight:bold;font-size:12px;font-family:Times New Roman,serif;">'.$this->CI->lang->line('bill_to').':</span>';
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('name')." :</b> ".$customer->customer_name."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('address')." :</b> ".$customer->address."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('postcode')." :</b> ".$customer->postcode."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('mobile')." :</b> ".$customer->mobile."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('email')." :</b> ".$customer->email."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('gst_number')." :</b> ".$customer->gstin."</span>";

        //$this->setCellMargins(1,1,1,1);
        $this->setCellPaddings(3,2,2,2);
        $this->setFont('times', '', 10);
        $this->setFillColor(248, 249, 250);

        $this->writeHTMLCell($w, $h, $x ='6', $y='52', $custmer_details, 1, 0, 1, true, 'J', true);
        return $this;
    } 

    public function _get_invoice_details()
    {
    	$sales = $this->sales;//array()

        $w = 100;
        $h = 40;
        $invoice_details = "";
        $invoice_details = '<span style="color:#2c3e50;font-weight:bold;font-size:12px;font-family:Times New Roman,serif;">'.$this->CI->lang->line('invoice_details').'</span>';
        $invoice_details .= '<br><span style="font-family:Times New Roman,serif;"><b>'.$this->CI->lang->line('invoice_no').' :</b> <span style="font-size:16px;color:#e74c3c;font-weight:bold;">'.$sales->sales_code.'</span></span>';
        $invoice_details .= '<br><span style="font-family:Times New Roman,serif;"><b>'.$this->CI->lang->line('date').' :</b> <span style="">'.show_date($sales->sales_date).'</span></span>';
        $invoice_details .= '<br><span style="font-family:Times New Roman,serif;"><b>'.$this->CI->lang->line('due_date').' :</b> <span style="">'.((!empty($sales->due_date)) ? show_date($sales->due_date):'').'</span></span>';
        $invoice_details .= '<br><span style="font-family:Times New Roman,serif;"><b>'.$this->CI->lang->line('reference_no').' :</b> <span style="">'.$sales->reference_no.'</span></span>';
        $invoice_details .= '<br><span style="font-family:Times New Roman,serif;"><b>'.$this->CI->lang->line('payment_status').' :</b> <span style="">'.$sales->payment_status.'</span></span>';

        $this->writeHTMLCell($w, $h, $x ='104', $y='', $invoice_details, 1, 1, 1, true, 'J', true);
        return $this;
    }

    public function _get_shipping_address()
    {
        $w = 100;
        $h = 40;

        $customer = $this->customer;//array()
        //Customer Shipping Address Records
	    $country='';
	    $state='';
	    $city='';
	    $address='';
	    $postcode='';
	    if(!empty($customer->shippingaddress_id)){
	        $Q2 = $this->CI->db->select("c.country,s.state,a.city,a.postcode,a.address")
	                        ->where("a.id",$customer->shippingaddress_id)
	                        ->from("db_shippingaddress a")
	                        ->join("db_country c","c.id = a.country_id",'left')
	                        ->join("db_states s","s.id = a.state_id",'left')
	                        ->get();                    
	        if($Q2->num_rows()>0){
	          $country=$Q2->row()->country;
	          $address=$Q2->row()->address;
	          $state=$Q2->row()->state;
	          $city=$Q2->row()->city;
	          $postcode=$Q2->row()->postcode;
	        }
	      }

        $custmer_details = '<span style="color:#2c3e50;font-weight:bold;font-size:12px;font-family:Times New Roman,serif;">'.$this->CI->lang->line('shipping_address').'</span>';

        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('mobile')." :</b> ".$customer->mobile."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('name')." :</b> ".$customer->customer_name."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('address')." :</b> ".$address."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('postcode')." :</b> ".$postcode."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('city')." :</b> ".$city."</span>";
        $custmer_details .= "<br><span style='font-family:Times New Roman,serif;'><b>".$this->CI->lang->line('state')." :</b> ".$state."</span>";

        $this->writeHTMLCell($w, $h, $x ='6', $y='90', $custmer_details, 1, 0, 1, true, 'J', true);
        return $this;
    }

    public function _get_bank_details()
    {
    	$store = $this->store;
        $w = 100;
        $h = 40;
        $invoice_details = "";
        $invoice_details = '<span style="color:#2c3e50;font-weight:bold;font-size:12px;font-family:Times New Roman,serif;">'.$this->CI->lang->line("bank_details").'</span><br>';
        $invoice_details .= '<span style="font-family:Times New Roman,serif;">'.nl2br($store->bank_details).'</span>';

        $this->writeHTMLCell($w, $h, $x ='104', $y='', $invoice_details, 1, 1, 1, true, 'J', true);
        return $this;
    }

   
	public function show_pdf()
	{
		$this->_main_body();
	}

	

	public function _main_body()
	{	
		$sales 		= $this->sales;//array()
		$store 		= $this->store;//array()
		$customer 	= $this->customer;//array()
			
	

		$this->_invoice_name = "Tax Invoice";

		$this->page_title = "GST Invoice";

		//Don't change this
		$this->_invoice_format = 'GST';

		//$this->_QRCODE = $sales->sales_code;

		// set font
		$this->setFont('times', 'B', 22);

		// add a page
		$this->AddPage();

		// Cusomer Details
		$this->_get_customer_details(); 

		// Cusomer Details
		$this->_get_invoice_details();

		// Shipping Details
		$this->_get_shipping_address(); 

		// Bank Details
		$this->_get_bank_details();

		//Set document name (footer -R)
		$this->_set_document_name($this->CI->lang->line("invoice_number"));
		
		//Sey document number (footer -R)
		$this->_set_document_number($sales->sales_code);

		//Search Coupon Details
		$coupon_code = $coupon_type = '';
	    $coupon_value=0;
	    if(!empty($sales->coupon_id)){
	      $coupon_details =get_customer_coupon_details($sales->coupon_id);
	      $coupon_code =$coupon_details->code;
	      $coupon_value =$coupon_details->value;
	      $coupon_type =$coupon_details->type;
	    } 
		$this->setFont('times', '', 9);

		// set cell padding
		$this->setCellPaddings(2, 2, 2, 2);

		// set cell margins
		//$this->setCellMargins(1, 1, 1, 1);

		// set color for background
		$this->setFillColor(255, 255, 255);

		$this->Ln(0);

		

		$this->setFont('times', '', 9);
		
		
		$tbl = '
		<style type="text/css">
			* {
				font-family: "Times New Roman", serif;
			}
			table, td, th {
			    border-collapse: collapse;
			    border: 1px solid #34495e;
			    font-family: "Times New Roman", serif;
			}
			
			table + table, table + table tr:first-child th, table + table tr:first-child td {
			    border-top: 0;
			}
			.text-right{
				text-align: right;
			}
			.text-center{
				text-align: center;
			}
			.text-bold{
				font-weight: bold;
			}
			.bg-light-blue{
				background-color: #3498db;
				color: white;
				font-weight: bold;
			}
			.bg-modern-header{
				background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
				color: white;
				font-weight: bold;
			}
			.modern-row:nth-child(even) {
				background-color: #f8f9fa;
			}
			.modern-row:hover {
				background-color: #e8f4f8;
			}
			
		</style>
		<table >';

			$widthArray = array(
				'sl_no' 		=> '5',
				'description' 	=> '29',
				'hsn' 			=> '10',
				'gst_rate' 		=> '10',
				'qty' 			=> '8',
				'unit' 			=> '6',
				'before_tax' 	=> '10',
				'discount' 		=> '10',
				'amount' 		=> '12',

			);

			//Sum the value
			$sumOfWidth = 0;

			$colW =array();
			foreach($widthArray as $key => $val){
				

				//Update value
				$colWidthSize[$key] = $val;

				//New Array => Reasssign % symbol
				$colW[$key] = $val.'%';

				//Sum of value
				$sumOfWidth+=$val;
			}

			
			
		    $tbl .='<thead>
		        <tr class="bg-modern-header text-bold">
			        <th colspan="1" style="width: '.$colW['sl_no'].'; padding: 8px;">'.$this->CI->lang->line("sl_no").'</th>
			        <th colspan="1" style="width: '.$colW['description'].'; padding: 8px;" >'.$this->CI->lang->line("description").'</th>
			        <th colspan="1" style="width: '.$colW['hsn'].'; padding: 8px;">'.$this->CI->lang->line("hsn").'</th>
			        <th colspan="1" style="width: '.$colW['gst_rate'].'; padding: 8px;">'.$this->CI->lang->line("gst_rate").'</th>
			        <th colspan="1" style="width: '.$colW['qty'].'; padding: 8px;">'.$this->CI->lang->line("qty").'</th>
			        <th colspan="1" style="width: '.$colW['unit'].'; padding: 8px;">'.$this->CI->lang->line("unit").'</th>
			        <th colspan="1" style="width: '.$colW['before_tax'].'; padding: 8px;">'.$this->CI->lang->line("unit_price").'</th>
			        <th colspan="1" style="width: '.$colW['discount'].'; padding: 8px;">'.$this->CI->lang->line("discount_per").'</th>
			        <th colspan="1" style="width: '.$colW['amount'].'; padding: 8px;">'.$this->CI->lang->line("amount").'</th>
		        </tr>
		    </thead>
		    <tbody>';
		        
		      $i=1;
              $tot_qty=0;
              $tot_sales_price=0;
              $tot_tax_amt=0;
              $tot_discount_amt=0;
              $tot_unit_total_cost=0;
              $tot_total_cost=0;
              $tot_before_tax=0;
              $total_cost=0;
              
              $tot_price_per_unit=0;
              $sum_of_tot_price=0;

          

              $this->CI->db->select(" a.description,c.item_name, a.sales_qty,a.tax_type,
                                  a.price_per_unit, b.tax,b.tax_name,a.tax_amt,
                                  a.discount_input,a.discount_amt, a.unit_total_cost,
                                  a.total_cost , d.unit_name,c.sku,c.hsn
                              ");
              $this->CI->db->where("a.sales_id",$this->sales_id);
              $this->CI->db->from("db_salesitems a");
              $this->CI->db->join("db_tax b","b.id=a.tax_id","left");
              $this->CI->db->join("db_items c","c.id=a.item_id","left");
              $this->CI->db->join("db_units d","d.id = c.unit_id","left");

              $q2=$this->CI->db->get();

		        foreach ($q2->result() as $res2) {
                  $discount = (empty($res2->discount_input)||$res2->discount_input==0)? store_number_format(0):store_number_format($res2->discount_input)."%";
                  $discount_amt = (empty($res2->discount_amt)||$res2->discount_input==0)? '0':$res2->discount_amt."";
                  $before_tax=$res2->price_per_unit;// * $res2->sales_qty;
                  $total_cost=$res2->total_cost;//$before_tax * $res2->sales_qty;

                  $unit_total_cost = $res2->unit_total_cost - ($res2->tax_amt/$res2->sales_qty);

                  $tax_type = ($res2->tax_type=='Exclusive') ? 'Exc.' : 'Inc.';

                 $tbl .='<tr class="modern-row" style="" nobr="true">';
				      $tbl .='<td colspan="1" style="width: '.$colW['sl_no'].'; padding: 6px; text-align: center;">'.$i++.'</td>';
				      $tbl .='<td colspan="1" style="width: '.$colW['description'].'; padding: 6px;" >';
				      $tbl .= '<strong>'.$res2->item_name.'</strong>';
				      $tbl .= (!empty($res2->description)) ? "<br><em style='color:#7f8c8d; font-size:9px;'>[".nl2br($res2->description)."]</em>" : '';
				      $tbl .= '</td>';
				      $tbl .='<td colspan="1" style="width: '.$colW['hsn'].'; padding: 6px; text-align: center;">'.$res2->hsn.'</td>';
				      $tbl .='<td colspan="1" style="width: '.$colW['gst_rate'].'; padding: 6px; text-align: center;">'.store_number_format($res2->tax)." ".$tax_type.'</td>';

				      $tbl .='<td colspan="1" style="width: '.$colW['qty'].'; padding: 6px; text-align: center;">'.format_qty($res2->sales_qty).'</td>';
				      $tbl .='<td colspan="1" style="width: '.$colW['unit'].'; padding: 6px; text-align: center;">'.$res2->unit_name.'</td>';

				      $tbl .='<td colspan="1" class="text-right" style="width: '.$colW['before_tax'].'; padding: 6px;">'.store_number_format($unit_total_cost).'</td>';
				          
					
					  
				      $tbl .='<td colspan="1" class="text-right" style="width: '.$colW['discount'].'; padding: 6px;">'.($discount).'</td>';
				      $tbl .='<td colspan="1" class="text-right" style="width: '.$colW['amount'].'; padding: 6px; font-weight: bold;">'.store_number_format($total_cost).'</td>';
		          $tbl .='</tr>';

                  $tot_qty +=$res2->sales_qty;
                  $tot_sales_price +=$res2->price_per_unit;
                  $tot_tax_amt +=$res2->tax_amt;
                  $tot_discount_amt +=$res2->discount_amt;
                  $tot_unit_total_cost +=$unit_total_cost;
                  $tot_before_tax +=$before_tax;
                  $tot_total_cost +=$total_cost;
              }

		    $tbl .='</tbody>
		    
		</table>
		';

		$tbl .='<table>
		            <tbody>';

		            	$tbl .='<tr nobr="true" class="text-bold" style="background-color:#ecf0f1;">';
		                	$tbl .='<td colspan="4" style="width:'.($colWidthSize['sl_no']+$colWidthSize['description']+$colWidthSize['hsn']+$colWidthSize['gst_rate']).'%; padding: 8px; font-weight: bold;">';
		                	$tbl .=$this->CI->lang->line("total");
		                	$tbl .='</td>';

		                	$tbl .='<td colspan="1" style="width:'.($colWidthSize['qty']).'%; padding: 8px; text-align: center; font-weight: bold;">';
		                	$tbl .=format_qty($tot_qty);
		                	$tbl .='</td>';

		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['unit']).'%; padding: 8px;">';
		                	$tbl .='';
		                	$tbl .='</td>';

		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['before_tax']).'%; padding: 8px;">';
			                $tbl .='';
			                $tbl .='</td>';


			                $tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['discount']).'%; padding: 8px;">';
		                	$tbl .='';
		                	$tbl .='</td>';

		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%; padding: 8px; font-weight: bold; color: #2c3e50;">';
		                	$tbl .=store_number_format($tot_total_cost);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Total Before Tax
		                $tbl .='<tr nobr="true" style="background-color:#f8f9fa;">
		                	<td colspan="7" class="text-right" style="width:'.($sumOfWidth-$colWidthSize['amount']).'%; padding: 6px; font-weight: bold;">';
		                	$tbl .=$this->CI->lang->line("before_tax");
		                	$tbl .='</td>';
		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%; padding: 6px; font-weight: bold;">';
		                	$tbl .=store_number_format($tot_total_cost-$tot_tax_amt);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Tax Total
		                $tbl .='<tr nobr="true" style="background-color:#e8f4f8;">
		                	<td colspan="7" class="text-right" style="width:'.($sumOfWidth-$colWidthSize['amount']).'%; padding: 6px; font-weight: bold; color: #2980b9;">';
		                	$tbl .=$this->CI->lang->line("gst");
		                	$tbl .='</td>';
		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%; padding: 6px; font-weight: bold; color: #2980b9;">';
		                	$tbl .=store_number_format($tot_tax_amt);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Tax Total
		                $tbl .='<tr nobr="true">
		                	<td colspan="7" class="text-right" style="width:'.($sumOfWidth-$colWidthSize['amount']).'%">';
		                	$tbl .=$this->CI->lang->line("other_charges");
		                	$tbl .='</td>';
		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%">';
		                	$tbl .=store_number_format($sales->other_charges_amt);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Coupon
		                if(!empty($coupon_code)){
			                $tbl .='<tr nobr="true">
			                	<td colspan="4" style="width:'.($colWidthSize['sl_no']+$colWidthSize['description']+$colWidthSize['hsn']+$colWidthSize['gst_rate']+$colWidthSize['qty']).'%">';
			                	$tbl .="<b>".$this->CI->lang->line("couponCode")."</b>: ".getTruncatedCCNumber($coupon_code);
			                	$tbl .='</td>


			                	<td colspan="3" class="text-right" style="width:'.($colWidthSize['before_tax']+$colWidthSize['discount']).'%">';
			                	$tbl .=$this->CI->lang->line("couponDiscount").":";
			                	$tbl .=($coupon_type=='Percentage') ? $coupon_value .'%' : '[Fixed]' ;
			                	$tbl .='</td>

			                	<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%">';
			                	$tbl .=store_number_format($sales->coupon_amt);
			                	$tbl .='</td>';
			                $tbl .='</tr>';
		            	}

		            	////Discount on All
		                $tbl .='<tr nobr="true">
		                	<td colspan="7" class="text-right" style="width:'.($sumOfWidth-$colWidthSize['amount']).'%">';
		                	$tbl .=$this->CI->lang->line("discount_on_all");
		                	$tbl .="[";
		                	$tbl .=store_number_format($sales->discount_to_all_input)." ".(($sales->discount_to_all_type=='percentage') ? '%' : 'Fixed');
		                	$tbl .="]";
		                	$tbl .='</td>';
		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%">';
		                	$tbl .=store_number_format($sales->tot_discount_to_all_amt);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		            	//Round Off
		                $tbl .='<tr nobr="true">
		                	<td colspan="7" class="text-right" style="width:'.($sumOfWidth-$colWidthSize['amount']).'%">';
		                	$tbl .=$this->CI->lang->line("round_off");
		                	$tbl .='</td>';
		                	$tbl .='<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%">';
		                	$tbl .=store_number_format($sales->round_off);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Grand Total
		                $tbl .='<tr nobr="true" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">';
		                	$tbl .='<td colspan="4" style="width:'.($colWidthSize['sl_no']+$colWidthSize['description']+$colWidthSize['hsn']+$colWidthSize['gst_rate']+$colWidthSize['qty']+$colWidthSize['unit']).'%; padding: 10px; font-family: Times New Roman, serif;">';
		                	$tbl .="<b style='font-size: 12px;'>".$this->CI->lang->line("amount_in_words")."</b>: <span style='font-style: italic;'>".no_to_words($sales->grand_total)."</span>";
		                	$tbl .='</td>


		                	<td colspan="3" class="text-right" style="width:'.($colWidthSize['before_tax']+$colWidthSize['discount']).'%; padding: 10px; font-weight: bold; font-size: 14px;">';
		                	$tbl .=$this->CI->lang->line("grand_total");
		                	$tbl .='</td>

		                	<td colspan="1" class="text-right" style="width:'.($colWidthSize['amount']).'%; padding: 10px; font-weight: bold; font-size: 16px;">';
		                	$tbl .=store_number_format($sales->grand_total);
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		                //Note
		                $tbl .='<tr nobr="true">
		                	<td colspan="8" style="width:'.($sumOfWidth).'%; height:40px; padding: 10px; background-color: #f8f9fa; border-left: 4px solid #3498db; font-family: Times New Roman, serif;">';
		                	$tbl .="<b style='color: #2c3e50;'>".$this->CI->lang->line("note")."</b>: <span style='font-style: italic; color: #7f8c8d;'>".nl2br($sales->sales_note)."</span>";
		                	$tbl .='</td>';
		                $tbl .='</tr>';

		            $tbl .='</tbody>
		        </table>
		       
		        ';
		 //Tax Details

		$tbl .='<table>
		            <tbody>';
		            	$tbl .='<tr nobr="true">';
		            		$tbl .='<td colspan="9" class="text-bold" style="padding: 12px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; font-size: 14px; font-family: Times New Roman, serif; text-align: center;">';
		            			$tbl .=$this->CI->lang->line("tax_details");
		            		$tbl .='</td>';
		            	$tbl .='</tr>';





		            	$tbl .='<tr nobr="true" class="bg-modern-header text-bold text-center">';
                          $tbl .='<td colspan="1" class="" rowspan="2" style="width:5%; padding: 8px;">'.$this->CI->lang->line('sl_no').'</td>';
                          $tbl .='<td colspan="1" class="" rowspan="2" style="width:10%; padding: 8px;">'.$this->CI->lang->line('hsn/sac').'</td>';
                          $tbl .='<td colspan="1" class="" rowspan="2" style="width:15%; padding: 8px;">'.$this->CI->lang->line('taxable_amount').'</td>';
                          $tbl .='<td class="" colspan="2" style="width:20%; padding: 8px;">';
                          	$tbl .=$this->CI->lang->line('cgst');
                          $tbl .='</td>';
                          $tbl .='<td class="" colspan="2" style="width:20%; padding: 8px;">';
                            $tbl .=$this->CI->lang->line('sgst');
                          $tbl .='</td>';
                          $tbl .='<td class="" colspan="2" style="width:20%; padding: 8px;">';
                            $tbl .=$this->CI->lang->line('igst');
                          $tbl .='</td>';
                          $tbl .='<td colspan="2" class="" style="width:10%; padding: 8px;" rowspan="2">';
                            $tbl .=$this->CI->lang->line('total');
                          $tbl .='</td>';
                        $tbl .='</tr>';

                        $tbl .='<tr nobr="true" class="text-center bg-modern-header text-bold">';
                          $tbl .='<td style="padding: 6px;">Rate(%)</td><td style="padding: 6px;">Amt</td>';
                          $tbl .='<td style="padding: 6px;">Rate(%)</td><td style="padding: 6px;">Amt</td>';
                          $tbl .='<td style="padding: 6px;">Rate(%)</td><td style="padding: 6px;">Amt</td>';
                          
                        $tbl .='</tr>';


                        //HSN wise tax group
                        $tot_price_before_tax = $tot_price_after_tax = $tot_cgst_amt =$tot_sgst_amt=$tot_sgst_amt=$tot_igst_amt = 0;
                        $this->CI->db->select("c.item_name,
                        				   COALESCE(SUM(a.price_per_unit),0) AS price_before_tax, 
                                           b.tax,b.tax_name,c.hsn,
                                           COALESCE(SUM(a.tax_amt),0) AS sum_of_tax_amt,
                                           COALESCE(SUM(a.total_cost),0) AS price_after_tax,c.tax_type,
                                           c.sku 
                                         ");

                        $this->CI->db->where("a.sales_id",$this->sales_id);
                        $this->CI->db->from("db_salesitems a");
                        $this->CI->db->join("db_tax b","b.id=a.tax_id","left");
                        $this->CI->db->join("db_items c","c.id=a.item_id","left");
                        $this->CI->db->join("db_units d","d.id = c.unit_id","left");
                        $this->CI->db->group_by("c.hsn,a.tax_id");
                        $this->CI->db->order_by("a.id");
                        //echo $this->CI->db->get_compiled_select();exit();
                        $q2=$this->CI->db->get();

                        $i = 1;
                        foreach ($q2->result() as $res2) {
                          $hsn = $res2->hsn;
                          //$price_before_tax = $res2->price_before_tax;
                          $price_before_tax = $res2->price_before_tax;
                          $price_after_tax = $res2->price_after_tax;

                          $tax_per = $res2->tax;
                          $sum_of_tax_amt = $res2->sum_of_tax_amt;

                          $price_before_tax = $price_after_tax - $sum_of_tax_amt;

                          $tax_type='';
                          //$tax_type = ($res2->tax_type=='Exclusive') ? 'Exc.' : 'Inc.';
                          if( $customer->id==1 || (strtoupper($this->customer_state_name) == strtoupper($store->state))){
                            $sgst_per = $cgst_per = $tax_per;
                            $sgst_amt = $cgst_amt = $sum_of_tax_amt / 2;
                            $igst_per = $igst_amt = 0;
                          }else{
                            $sgst_per = $cgst_per = 0;
                            $sgst_amt = $cgst_amt = 0;
                            $igst_per = $tax_per;
                            $igst_amt = $sum_of_tax_amt;
                          }
                          

             

                        $tbl .='<tr nobr="true" class="modern-row">';
                        			$tbl .='<td style="padding: 6px; text-align: center;">'.$i++.'</td>';
                        			$tbl .='<td style="padding: 6px; text-align: center;">'.$hsn.'</td>';
                        			$tbl .='<td class="text-right" style="padding: 6px;">'.store_number_format($price_before_tax)." ".$tax_type.'</td>';
                        			//$tbl .='<td>00</td>';

                        			$tbl .='<td style="padding: 6px; text-align: center;">'.((!empty($cgst_per))? store_number_format($cgst_per/2):'').'</td>';

                        			$tbl .='<td class="text-right" style="padding: 6px;">'.store_number_format($cgst_amt).'</td>';

                        			$tbl .='<td style="padding: 6px; text-align: center;">'.((!empty($sgst_per))? store_number_format($sgst_per/2):'').'</td>';
                        			$tbl .='<td class="text-right" style="padding: 6px;">'.store_number_format($sgst_amt).'</td>';

                        			$tbl .='<td style="padding: 6px; text-align: center;">'.((!empty($igst_per))? store_number_format($igst_per):'').'</td>';
                        			$tbl .='<td class="text-right" style="padding: 6px;">'.store_number_format($igst_amt).'</td>';
                        			
                        			$tbl .='<td colspan="2" class="text-right" style="padding: 6px; font-weight: bold;">'.store_number_format($price_after_tax).'</td>';
                        		$tbl .='</tr>';


                   

                       $tot_price_before_tax +=$price_before_tax;
                       $tot_price_after_tax +=(!empty($price_after_tax)) ? $price_after_tax : 0;
                       $tot_cgst_amt +=(!empty($cgst_amt)) ? $cgst_amt : 0;
                       $tot_sgst_amt +=(!empty($sgst_amt)) ? $sgst_amt : 0;
                       $tot_igst_amt +=(!empty($igst_amt)) ? $igst_amt : 0;
                       
                     } 


                     $tbl .='<tr nobr="true" class="text-bold" style="background-color:#2c3e50; color: white;">';
                        			$tbl .='<td colspan="4" class="text-right" style="padding: 8px;">'.$this->CI->lang->line('total').'</td>';
                        			
                        			$tbl .='<td class="text-right" style="padding: 8px;">'.store_number_format($tot_cgst_amt).'</td>';

                        			$tbl .='<td style="padding: 8px;"></td>';
                        			$tbl .='<td class="text-right" style="padding: 8px;">'.store_number_format($tot_sgst_amt).'</td>';

                        			$tbl .='<td style="padding: 8px;"></td>';
                        			$tbl .='<td class="text-right" style="padding: 8px;">'.store_number_format($tot_igst_amt).'</td>';
                        			
                        			$tbl .='<td colspan="2" class="text-right" style="padding: 8px;">'.store_number_format($tot_price_after_tax).'</td>';
                      $tbl .='</tr>';


		            $tbl .='</tbody>
		        </table>
		       
		        ';

		$tbl .='<table nobr="true">
		            <tbody>
		                <tr nobr="true">

		                    <td colspan="12" style="padding: 12px;"><div style="font-size:11px; font-family: Times New Roman, serif;"><span style="color:#2c3e50;font-weight:bold;font-size:12px;">'.$this->CI->lang->line("termsAndConditions").':</span><br>';
		                        	$tbl .='<span style="font-family: Times New Roman, serif;">'.nl2br(html_entity_decode($sales->invoice_terms)).'</span>';
		                    		$tbl .='</div>
		                    </td>


		                    <td colspan="6" style="vertical-align:bottom;text-align:center;min-height:80px;height:80px;padding: 12px;">
		                    	<div style="font-size:11px; font-family: Times New Roman, serif;">
			                    	<span style="color:#2c3e50;font-weight:bold;vertical-align:bottom;">
			                    	'.$this->CI->lang->line("authorised_signatory").'
			                    	:</span>
		                    	</div>';
		                    	if(!empty($this->get_signature_image_path())){
			                    	$tbl .='<div style="margin-top: 10px;">
			                    		<img style="height:70px; border: 1px solid #bdc3c7; padding: 5px;" src="'.$this->get_signature_image_path().'"/>
			                    	</div>';
		                    	}

		                    $tbl .='</td>


		                </tr>
		                <tr nobr="true">
		                    <td colspan="18" class="text-center" style="padding: 10px; background-color: #34495e; color: white; font-family: Times New Roman, serif; font-size: 11px;">';
		                        	$tbl .=nl2br($store->sales_invoice_footer_text);
		                    		$tbl .='
		                    </td>
		                </tr>
		            </tbody>
		        </table>
		       
		        ';

		      //  echo $tbl;exit;
		$this->writeHTMLCell('', '', $x ='', $y='', $tbl, 0, 1, 1, true, 'J', true);

		$this->Output('invoice_100.pdf', 'I');
	}

}
