<?php
/**
 * Enhanced Error Handler for Cloud Deployment
 */
class CloudErrorHandler {
    
    public static function register() {
        // Set custom error handler
        set_error_handler([self::class, "handleError"]);
        set_exception_handler([self::class, "handleException"]);
        register_shutdown_function([self::class, "handleFatalError"]);
    }
    
    public static function handleError($severity, $message, $file, $line) {
        if (ENVIRONMENT === "production") {
            error_log("PHP Error: [$severity] $message in $file on line $line");
            return true;
        }
        return false;
    }
    
    public static function handleException($exception) {
        if (ENVIRONMENT === "production") {
            error_log("PHP Exception: " . $exception->getMessage() . " in " . $exception->getFile() . " on line " . $exception->getLine());
            header("HTTP/1.1 500 Internal Server Error");
            if (file_exists("application/views/errors/html/error_general.php")) {
                include_once "application/views/errors/html/error_general.php";
            } else {
                echo "<!DOCTYPE html><html><head><title>Service Error</title></head><body><h1>Service Temporarily Unavailable</h1><p>Please try again later.</p></body></html>";
            }
        } else {
            echo $exception;
        }
    }
    
    public static function handleFatalError() {
        $error = error_get_last();
        if ($error !== null && in_array($error["type"], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
            if (ENVIRONMENT === "production") {
                error_log("PHP Fatal Error: " . $error["message"] . " in " . $error["file"] . " on line " . $error["line"]);
                header("HTTP/1.1 500 Internal Server Error");
                echo "<!DOCTYPE html><html><head><title>Service Unavailable</title></head><body><h1>Service Temporarily Unavailable</h1><p>Please try again later.</p></body></html>";
            }
        }
    }
}
?>
