<?php
/**
 * PHP 8+ Compatible MY_Controller
 * Extends the base MY_Controller with PHP 8+ compatibility fixes
 */

// Only load if CodeIgniter is available
if (defined('BASEPATH') || defined('CI_VERSION')) {
    
    if (!class_exists('MY_Controller_PHP8_Fixed')) {
        class MY_Controller_PHP8_Fixed extends CI_Controller {
            
            public function __construct() {
                parent::__construct();
                
                // Set error handling for PHP 8+
                if (PHP_MAJOR_VERSION >= 8) {
                    error_reporting(E_ALL & ~E_DEPRECATED & ~E_STRICT & ~E_NOTICE);
                }
            }
            
            /**
             * PHP 8+ safe property access
             */
            public function __get($property) {
                if (isset($this->{$property})) {
                    return $this->{$property};
                }
                return null;
            }
            
            /**
             * PHP 8+ safe property setting
             */
            public function __set($property, $value) {
                $this->{$property} = $value;
            }
            
            /**
             * PHP 8+ safe isset check
             */
            public function __isset($property) {
                return isset($this->{$property});
            }
        }
    }
}
?>