<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Woo_debug extends CI_Controller {
    
    public function index() {
        echo "<h2>WooCommerce Debug Information</h2>";
        
        $hosts = [
            '46.4.10.227',
            'srv1048.hstgr.io',
            'lightning.megpanel.com',
            'srv1048.hstgr.io:3306',
            'smacamel.com',
            'www.smacamel.com'
        ];
        
        $working_host = null;
        
        foreach($hosts as $host) {
            echo "<h3>Testing Host: $host</h3>";
            
            try {
                // Test direct connection
                $connection = new mysqli($host, 'porpatas_smacam_usr25', 'C%Scl%RQvFxVFR2{', 'porpatas_smacam_db25');
                
                if ($connection->connect_error) {
                    echo '<p style="color:red;">❌ Connection failed: ' . $connection->connect_error . '</p>';
                    continue;
                }
                
                echo '<p style="color:green;">✅ Database connection successful!</p>';
                
                // Test wp_posts table
                $result = $connection->query("SHOW TABLES LIKE 'wp_posts'");
                if($result && $result->num_rows > 0) {
                    echo '<p style="color:green;">✅ wp_posts table found</p>';
                    
                    // Count orders
                    $orders = $connection->query("SELECT COUNT(*) as count FROM wp_posts WHERE post_type = 'shop_order'");
                    if($orders) {
                        $count = $orders->fetch_assoc()['count'];
                        echo '<p style="color:blue;">📊 Total WooCommerce orders: ' . $count . '</p>';
                        
                        if($count > 0) {
                            $working_host = $host;
                            
                            // Show recent orders
                            echo '<h4>Recent Orders (Last 5)</h4>';
                            $recent_orders = $connection->query("
                                SELECT 
                                    o.ID, 
                                    o.post_date, 
                                    o.post_status,
                                    MAX(CASE WHEN pm.meta_key = '_billing_first_name' THEN pm.meta_value END) as first_name,
                                    MAX(CASE WHEN pm.meta_key = '_billing_last_name' THEN pm.meta_value END) as last_name,
                                    MAX(CASE WHEN pm.meta_key = '_order_total' THEN pm.meta_value END) as total
                                FROM wp_posts o
                                LEFT JOIN wp_postmeta pm ON o.ID = pm.post_id
                                WHERE o.post_type = 'shop_order'
                                GROUP BY o.ID
                                ORDER BY o.post_date DESC 
                                LIMIT 5
                            ");
                            
                            if($recent_orders && $recent_orders->num_rows > 0) {
                                echo '<table border="1" style="border-collapse:collapse; padding:5px;">';
                                echo '<tr><th>Order ID</th><th>Date</th><th>Status</th><th>Customer</th><th>Total</th></tr>';
                                while($order = $recent_orders->fetch_assoc()) {
                                    $customer_name = trim($order['first_name'] . ' ' . $order['last_name']) ?: 'Guest';
                                    $status = str_replace('wc-', '', $order['post_status']);
                                    echo '<tr>';
                                    echo '<td>#' . $order['ID'] . '</td>';
                                    echo '<td>' . date('d-m-Y H:i', strtotime($order['post_date'])) . '</td>';
                                    echo '<td>' . ucfirst($status) . '</td>';
                                    echo '<td>' . htmlspecialchars($customer_name) . '</td>';
                                    echo '<td>₹' . number_format($order['total'], 2) . '</td>';
                                    echo '</tr>';
                                }
                                echo '</table>';
                                
                                echo '<p style="color:green; font-weight:bold;">🎯 This host works! Update database config to use: ' . $host . '</p>';
                                break; // Found working host, stop testing
                            }
                        }
                    }
                } else {
                    echo '<p style="color:red;">❌ wp_posts table not found</p>';
                }
                
                $connection->close();
                
            } catch(Exception $e) {
                echo '<p style="color:red;">❌ Error: ' . $e->getMessage() . '</p>';
            }
            
            echo "<hr>";
        }
        
        if($working_host) {
            echo "<div style='background:#d4edda; padding:15px; border:1px solid #c3e6cb; margin:10px 0;'>";
            echo "<h3 style='color:#155724;'>✅ Working Configuration Found!</h3>";
            echo "<p><strong>Host to use:</strong> $working_host</p>";
            echo "<p>Update your database configuration to use this host.</p>";
            echo "</div>";
        } else {
            echo "<div style='background:#f8d7da; padding:15px; border:1px solid #f5c6cb; margin:10px 0;'>";
            echo "<h3 style='color:#721c24;'>❌ No Working Host Found</h3>";
            echo "<p>Please check your database credentials and host information.</p>";
            echo "</div>";
        }
        
        echo "<hr>";
        echo "<p><a href='" . base_url('reports/woocommerce_orders') . "'>🔗 Go to WooCommerce Orders Report</a></p>";
    }
}
