<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Woo_api extends CI_Controller {
    
    public function orders() {
        // Try to get orders via WordPress REST API instead of direct database connection
        
        $api_urls = [
            'https://www.smacamel.com/wp-json/wc/v3/orders',
            'https://smacamel.com/wp-json/wc/v3/orders'
        ];
        
        echo "<h2>WooCommerce API Test</h2>";
        
        foreach($api_urls as $url) {
            echo "<h3>Testing: $url</h3>";
            
            try {
                $context = stream_context_create([
                    'http' => [
                        'timeout' => 10,
                        'method' => 'GET',
                        'header' => [
                            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
                        ]
                    ]
                ]);
                
                $response = file_get_contents($url, false, $context);
                
                if($response !== false) {
                    echo "<p style='color:green;'>✅ API accessible!</p>";
                    
                    $data = json_decode($response, true);
                    if($data) {
                        echo "<p>Response type: " . gettype($data) . "</p>";
                        echo "<p>Data structure: " . (is_array($data) ? count($data) . " items" : "Object") . "</p>";
                        echo "<pre>" . htmlspecialchars(substr($response, 0, 500)) . "...</pre>";
                    }
                } else {
                    echo "<p style='color:red;'>❌ API not accessible</p>";
                }
                
            } catch(Exception $e) {
                echo "<p style='color:red;'>❌ Error: " . $e->getMessage() . "</p>";
            }
            
            echo "<hr>";
        }
        
        echo "<h3>Manual Database Setup Instructions:</h3>";
        echo "<ol>";
        echo "<li><strong>Login to cPanel:</strong> https://lightning.megpanel.com:2083/</li>";
        echo "<li><strong>Go to:</strong> Remote MySQL® (in Databases section)</li>";
        echo "<li><strong>Add Access Host:</strong> Enter your IP or use '%' for all IPs</li>";
        echo "<li><strong>Your Current IP:</strong> " . $this->get_client_ip() . "</li>";
        echo "<li><strong>Alternative:</strong> Use 'localhost' and create a proxy script on the server</li>";
        echo "</ol>";
        
        echo "<p><a href='" . base_url('reports/woocommerce_orders') . "'>Try WooCommerce Report Again</a></p>";
    }
    
    private function get_client_ip() {
        $ipkeys = array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR');
        foreach ($ipkeys as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    $ip = trim($ip);
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                        return $ip;
                    }
                }
            }
        }
        return $_SERVER['REMOTE_ADDR'] ?? 'Unknown';
    }
}
