<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transaction_ledger extends MY_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('transaction_ledger_model','ledger');
	}

	public function index(){
		// $this->permission_check('sales_view'); // Temporarily disabled for debugging
		$data=$this->data;//$this->data is loaded from MY_controller
		$data['page_title']=$this->lang->line('transaction_ledger_report');
		
		// Get customer_id from URL parameter if provided
		$customer_id = $this->input->get('customer_id');
		$data['pre_selected_customer_id'] = (!empty($customer_id)) ? $customer_id : '';
		
		$this->load->view('transaction-ledger-report', $data);
	}

	public function show_transaction_ledger(){
		// $this->permission_check('sales_view'); // Temporarily disabled for debugging
		
		try {
			extract($_POST);
			
			// Set default dates if not provided
			if(empty($from_date)) {
				$from_date = date('Y-m-01'); // First day of current month
			}
			if(empty($to_date)) {
				$to_date = date('Y-m-d'); // Today
			}
			
			$from_date = system_fromatted_date($from_date);
			$to_date = system_fromatted_date($to_date);
			
			$customer_id = (!empty($customer_id)) ? $customer_id : '';
			$store_id = (!empty($store_id)) ? $store_id : get_current_store_id();
			
			$data = $this->ledger->get_transaction_ledger_data($customer_id, $from_date, $to_date, $store_id);
			
			echo json_encode($data);
		} catch (Exception $e) {
			echo json_encode(array('error' => 'Error: ' . $e->getMessage()));
		}
	}

	public function export_transaction_ledger(){
		$this->permission_check('sales_view'); // Changed from 'reports_view' to 'sales_view'
		
		extract($_GET);
		
		// Set default dates if not provided
		if(empty($from_date)) {
			$from_date = date('Y-m-01'); // First day of current month
		}
		if(empty($to_date)) {
			$to_date = date('Y-m-d'); // Today
		}
		
		$from_date = system_fromatted_date($from_date);
		$to_date = system_fromatted_date($to_date);
		
		$customer_id = (!empty($customer_id)) ? $customer_id : '';
		$store_id = (!empty($store_id)) ? $store_id : get_current_store_id();
		
		$data = $this->ledger->get_transaction_ledger_data($customer_id, $from_date, $to_date, $store_id);
		
		// Set headers for CSV download
		header('Content-Type: text/csv');
		header('Content-Disposition: attachment; filename="transaction_ledger_' . date('Y-m-d') . '.csv"');
		
		$output = fopen('php://output', 'w');
		
		// CSV Headers
		fputcsv($output, array(
			'Date',
			'Customer',
			'Transaction Type',
			'Reference',
			'Description',
			'Debit',
			'Credit',
			'Balance'
		));
		
		// CSV Data
		foreach($data['transactions'] as $row) {
			fputcsv($output, array(
				$row['date'],
				$row['customer_name'],
				$row['transaction_type'],
				$row['reference'],
				$row['description'],
				$row['debit'],
				$row['credit'],
				$row['running_balance']
			));
		}
		
		fclose($output);
	}

	public function customer_transaction_summary(){
		$this->permission_check('sales_view'); // Changed from 'reports_view' to 'sales_view'
		
		extract($_POST);
		
		$customer_id = (!empty($customer_id)) ? $customer_id : '';
		$store_id = (!empty($store_id)) ? $store_id : get_current_store_id();
		
		if(empty($customer_id)) {
			echo json_encode(array('error' => 'Please select a customer'));
			return;
		}
		
		$summary = $this->ledger->get_customer_summary($customer_id, $store_id);
		
		echo json_encode($summary);
	}
}
