<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Test_labels extends CI_Controller {
    
    public function __construct(){
        parent::__construct();
        $this->load->model('items_model', 'items');
        $this->load->helper('url');
    }
    
    public function index(){
        // Generate test labels for verification
        $this->test_tvs_labels();
    }
    
    public function test_tvs_labels(){
        echo '<!DOCTYPE html>
<html>
<head>
    <title>TVS LP 46 Neo Label Test</title>
    <link rel="stylesheet" href="'.base_url().'theme/css/tvs-labels.css">
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .test-info { background: #f0f8ff; padding: 15px; border: 1px solid #ccc; margin-bottom: 20px; }
        .print-btn { background: #007cba; color: white; padding: 10px 20px; border: none; cursor: pointer; margin: 10px 0; }
        .print-btn:hover { background: #005a87; }
    </style>
</head>
<body>
    <h1>TVS LP 46 Neo Label Test Page</h1>
    
    <div class="test-info">
        <h3>Test Information:</h3>
        <ul>
            <li>Label Size: <strong>35mm (W) x 22mm (H)</strong></li>
            <li>Labels per Row: 3</li>
            <li>This test shows 6 sample labels (2 rows)</li>
            <li>Features: QR codes, MRP strikethrough, enhanced pricing</li>
            <li>Use Chrome browser for printing</li>
            <li>Set printer to "Actual Size" when printing</li>
        </ul>
        <button class="print-btn" onclick="printTestLabels()">Print Test Labels</button>
    </div>
    
    <div id="test-labels">
        <div class="tvs-label-container">
            <!-- Row 1 -->
            <div class="tvs-label-row">
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">SAMPLE ITEM 1</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price-row">
                            <span class="tvs-mrp">MRP <span class="strikethrough">₹120</span></span>
                            <span class="tvs-price">₹99</span>
                        </div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST001</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST001%7CSAMPLE%20ITEM%201%7C99" alt="QR">
                    </div>
                </div>
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">SAMPLE ITEM 2</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price">₹149</div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST002</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST002%7CSAMPLE%20ITEM%202%7C149" alt="QR">
                    </div>
                </div>
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">LONG ITEM NAME TEST</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price-row">
                            <span class="tvs-mrp">MRP <span class="strikethrough">₹30</span></span>
                            <span class="tvs-price">₹25</span>
                        </div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST003</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST003%7CLONG%20ITEM%20NAME%20TEST%7C25" alt="QR">
                    </div>
                </div>
            </div>
            
            <!-- Row 2 -->
            <div class="tvs-label-row">
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">TEST PRODUCT 4</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price-row">
                            <span class="tvs-mrp">MRP <span class="strikethrough">₹600</span></span>
                            <span class="tvs-price">₹500</span>
                        </div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST004</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST004%7CTEST%20PRODUCT%204%7C500" alt="QR">
                    </div>
                </div>
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">ITEM FIVE</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price">₹75</div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST005</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST005%7CITEM%20FIVE%7C75" alt="QR">
                    </div>
                </div>
                <div class="tvs-label">
                    <div class="tvs-store-name">TEST STORE</div>
                    <div class="tvs-item-name">SAMPLE SIX</div>
                    <div class="tvs-price-section">
                        <div class="tvs-price-row">
                            <span class="tvs-mrp">MRP <span class="strikethrough">₹350</span></span>
                            <span class="tvs-price">₹299</span>
                        </div>
                    </div>
                    <div class="tvs-bottom-row">
                        <div class="tvs-code">TEST006</div>
                        <img class="tvs-qrcode" src="'.base_url().'qrcoder/generate/TEST006%7CSAMPLE%20SIX%7C299" alt="QR">
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="test-info">
        <h3>Print Instructions:</h3>
        <ol>
            <li>Click the "Print Test Labels" button above</li>
            <li>In the print dialog, select your TVS LP 46 Neo printer</li>
            <li>Ensure "Actual Size" is selected (not "Fit to Page")</li>
            <li>Set margins to "None" or "Minimum"</li>
            <li>Print and verify alignment with your label roll</li>
        </ol>
        <p><strong>Note:</strong> If labels appear too large or small, check your browser zoom level (should be 100%)</p>
    </div>
    
    <script>
    function printTestLabels() {
        var content = document.getElementById("test-labels").innerHTML;
        var printWindow = window.open("", "", "width=500,height=400");
        
        printWindow.document.write(`<!DOCTYPE html>
<html>
<head>
    <title>TVS LP 46 Neo Test Labels</title>
    <style>
        @page { margin: 0; size: 4.5in auto; }
        body { margin: 0; padding: 2px; font-family: Arial, sans-serif; font-weight: bold; }
        .tvs-label-container { width: 100%; }
        .tvs-label-row { display: flex !important; width: 100% !important; margin: 0 !important; page-break-inside: avoid; }
        .tvs-label { height: 22mm !important; width: 35mm !important; margin: 0 1mm 1mm 0 !important; padding: 1mm !important; border: none !important; box-sizing: border-box !important; display: flex !important; flex-direction: column !important; justify-content: center !important; align-items: center !important; text-align: center !important; }
        .tvs-store-name { font-size: 6px !important; font-weight: bold !important; line-height: 1 !important; margin-bottom: 1mm !important; text-transform: uppercase !important; color: #000 !important; letter-spacing: 0.2px !important; width: 100% !important; }
        .tvs-item-name { font-size: 8px !important; font-weight: bold !important; line-height: 1.1 !important; margin-bottom: 1.5mm !important; color: #000 !important; text-transform: uppercase !important; width: 100% !important; }
        .tvs-price-section { display: flex !important; flex-direction: column !important; align-items: center !important; margin-bottom: 1.5mm !important; width: 100% !important; justify-content: center !important; }
        .tvs-price-row { display: flex !important; justify-content: center !important; align-items: center !important; gap: 2mm !important; width: 100% !important; }
        .tvs-mrp { font-size: 5px !important; color: #000 !important; line-height: 1 !important; font-weight: bold !important; white-space: nowrap !important; }
        .tvs-price { font-size: 8px !important; font-weight: bold !important; color: #000 !important; line-height: 1 !important; white-space: nowrap !important; }
        .tvs-bottom-row { display: flex !important; justify-content: space-between !important; align-items: center !important; width: 100% !important; }
        .tvs-code { font-size: 5px !important; font-weight: bold !important; color: #000 !important; letter-spacing: 0.3px !important; font-family: monospace !important; }
        .tvs-qrcode { width: 8mm !important; height: 8mm !important; border: none !important; display: block !important; }
        .strikethrough { text-decoration: line-through !important; text-decoration-thickness: 1px !important; }
    </style>
</head>
<body onLoad="self.print(); self.close();">
${content}
</body>
</html>`);
        
        printWindow.document.close();
        printWindow.focus();
    }
    </script>
</body>
</html>';
    }
}
?>
