<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Store_profile extends MY_Controller {
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('store_profile_model','store');
	}

	public function update($id){
		//if not admin
		if(!is_admin()){
			if($id!=get_current_store_id()){
				show_error("Access Denied", 403, $heading = "You Don't Have Enough Permission!!");exit();
			}
		}

		$this->permission_check('store_edit');
		$data=$this->store->get_details($id);
		$data['page_title']=$this->lang->line('store');
		$this->load->view('store', $data);
	}
	public function update_store(){
		$result=$this->store->update_store();
		echo $result;	
	}
	
	public function delete_data(){
		$this->permission_check('store_edit');
		
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST,$_GET))));
		
		//if not admin
		if(!is_admin()){
			if($store_id!=get_current_store_id()){
				echo "Access Denied";exit();
			}
		}
		
		$result = $this->store->delete_data($data_type, $store_id);
		echo $result;
	}
	
	public function get_data_count(){
		$this->permission_check('store_edit');
		
		//Filtering XSS and html escape from user inputs 
		extract($this->security->xss_clean(html_escape(array_merge($this->data,$_POST,$_GET))));
		
		//if not admin
		if(!is_admin()){
			if($store_id!=get_current_store_id()){
				echo "Access Denied";exit();
			}
		}
		
		$count = $this->store->get_data_count($data_type, $store_id);
		echo $count;
	}

}