<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Purchase_types Controller
 * Auto-generated on 2025-08-05
 * Manages CRUD operations for Purchase Types
 * Based on Sales Types module pattern
 */
class Purchase_types extends MY_Controller {
	
	public function __construct(){
		parent::__construct();
		$this->load_global();
		$this->load->model('purchase_types_model','purchase_types');
	}

	/**
	 * Display add form
	 */
	public function add(){
		$this->permission_check('purchase_types_add');
		$data = $this->data;
		$data['page_title'] = 'Purchase Types';
		$this->load->view('purchase_type', $data);
	}

	/**
	 * Process new record creation
	 */
	public function new_purchase_type(){
		$this->form_validation->set_rules('purchase_type_name', 'Purchase Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_type_initial', 'Purchase Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_types->verify_and_save();
			echo $result;
		} else {
			echo "Please Enter Purchase Type Name and Initial.";
		}
	}

	/**
	 * Display edit form
	 */
	public function update($id){
		$this->belong_to('db_purchase_types', $id);
		$this->permission_check('purchase_types_edit');
		$data = $this->data;
		$result = $this->purchase_types->get_details($id, $data);
		$data = array_merge($data, $result);
		$data['page_title'] = 'Purchase Types';
		$this->load->view('purchase_type', $data);
	}

	/**
	 * Process record update
	 */
	public function update_purchase_type(){
		$this->form_validation->set_rules('purchase_type_name', 'Purchase Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_type_initial', 'Purchase Type Initial', 'trim|required');
		$this->form_validation->set_rules('q_id', '', 'trim|required');

		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_types->update_purchase_type();
			echo $result;
		} else {
			echo "Please Enter Purchase Type name and Initial.";
		}
	}

	/**
	 * Display list view
	 */
	public function index(){
		$this->permission_check('purchase_types_view');
		$data = $this->data;
		$data['page_title'] = 'Purchase Types List';
		$this->load->view('purchase-types-list', $data);
	}

	/**
	 * AJAX DataTables data source
	 */
	public function ajax_list(){
		$list = $this->purchase_types->get_datatables();
		
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $purchase_type) {
			$no++;
			$row = array();
			
			// Main fields
			$row[] = $purchase_type->purchase_type_name;
			$row[] = $purchase_type->purchase_type_initial;
			$row[] = $purchase_type->description;

			// Status
			if($purchase_type->status == 1){ 
				$str = "<span onclick='update_status(".$purchase_type->id.",0)' id='span_".$purchase_type->id."' class='label label-success' style='cursor:pointer'>Active</span>";
			} else{ 
				$str = "<span onclick='update_status(".$purchase_type->id.",1)' id='span_".$purchase_type->id."' class='label label-danger' style='cursor:pointer'>Inactive</span>";
			}
			$row[] = $str;

			// Actions
			$actions = '<div class="btn-group">
							<a class="btn btn-primary btn-o dropdown-toggle" data-toggle="dropdown" href="#">
								Action <span class="caret"></span>
							</a>
							<ul role="menu" class="dropdown-menu dropdown-light pull-right">';

			if($this->permissions('purchase_types_edit'))
				$actions .= '<li><a href="'.base_url('purchase_types/update/'.$purchase_type->id).'">
								<i class="fa fa-fw fa-edit text-blue"></i>Edit
							</a></li>';

			if($this->permissions('purchase_types_delete'))
				$actions .= '<li><a onclick="delete_purchase_type('.$purchase_type->id.')" style="cursor:pointer">
								<i class="fa fa-fw fa-trash text-red"></i>Delete
							</a></li>';
							
			$actions .= '</ul></div>';
			$row[] = $actions;

			$data[] = $row;
		}

		$output = array(
			"draw" => $_POST['draw'],
			"recordsTotal" => $this->purchase_types->count_all(),
			"recordsFiltered" => $this->purchase_types->count_filtered(),
			"data" => $data,
		);
		echo json_encode($output);
	}

	/**
	 * Update record status
	 */
	public function update_status(){
		$this->permission_check_with_msg('purchase_types_edit');
		$id = $this->input->post('id');
		$status = $this->input->post('status');
		$result = $this->purchase_types->update_status($id, $status);
		return $result;
	}

	/**
	 * Delete record
	 */
	public function delete_purchase_type(){
		$this->permission_check_with_msg('purchase_types_delete');
		$id = $this->input->post('q_id');
		$result = $this->purchase_types->delete_purchase_type($id);
		return $result;
	}

	/**
	 * Modal support for quick add
	 */
	public function add_purchase_type_modal(){
		$this->permission_check('purchase_types_add');
		$this->form_validation->set_rules('purchase_type_name', 'Purchase Type Name', 'trim|required');
		$this->form_validation->set_rules('purchase_type_initial', 'Purchase Type Initial', 'trim|required');
		
		if ($this->form_validation->run() == TRUE) {
			$result = $this->purchase_types->verify_and_save();
			
			// Return new record for dropdown population
			$query = $this->db->select("id, purchase_type_name, purchase_type_initial")
							->where('store_id', get_current_store_id())
							->from('db_purchase_types')
							->order_by('id', 'desc')
							->limit(1)->get();
			
			$res = array();
			$res['id'] = $query->row()->id;
			$res['purchase_type'] = $query->row()->purchase_type_name;
			$res['purchase_type_initial'] = $query->row()->purchase_type_initial;
			$res['result'] = $result;
			
			echo json_encode($res);
		} else {
			echo "Please Fill Compulsory(* marked) Fields.";
		}
	}
}
