<?php
// Get statistics
$stats = [
    'total_credit' => fetchOne("SELECT COUNT(*) as count FROM credit_notes")['count'],
    'total_debit' => fetchOne("SELECT COUNT(*) as count FROM debit_notes")['count'],
    'credit_sales' => fetchOne("SELECT COUNT(*) as count FROM credit_notes WHERE note_type = 'sales'")['count'],
    'credit_purchase' => fetchOne("SELECT COUNT(*) as count FROM credit_notes WHERE note_type = 'purchase'")['count'],
    'debit_sales' => fetchOne("SELECT COUNT(*) as count FROM debit_notes WHERE note_type = 'sales'")['count'],
    'debit_purchase' => fetchOne("SELECT COUNT(*) as count FROM debit_notes WHERE note_type = 'purchase'")['count'],
    'credit_amount' => fetchOne("SELECT COALESCE(SUM(total_amount), 0) as amount FROM credit_notes")['amount'],
    'debit_amount' => fetchOne("SELECT COALESCE(SUM(total_amount), 0) as amount FROM debit_notes")['amount']
];

// Get recent notes
$recent_credit = fetchAll("SELECT * FROM credit_notes ORDER BY created_at DESC LIMIT 5");
$recent_debit = fetchAll("SELECT * FROM debit_notes ORDER BY created_at DESC LIMIT 5");
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-1 mb-2 border-bottom">
    <h1 class="h2"><i class="fas fa-tachometer-alt me-1"></i>Dashboard</h1>
    <div class="btn-toolbar mb-1 mb-md-0">
        <div class="btn-group me-1">
            <a href="?page=reports" class="btn btn-sm btn-outline-primary">
                <i class="fas fa-chart-bar me-1"></i>View Reports
            </a>
            <a href="?page=gst_returns" class="btn btn-sm btn-outline-info">
                <i class="fas fa-file-alt me-1"></i>GST Returns
            </a>
        </div>
        <div class="btn-group me-1">
            <button type="button" class="btn btn-sm btn-outline-secondary">
                <i class="fas fa-calendar"></i> <?= date('d M Y') ?>
            </button>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-2">
    <div class="col-md-3 mb-2">
        <div class="card stats-card credit">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle text-muted">Credit Notes</h6>
                        <h3 class="card-title mb-0"><?= $stats['total_credit'] ?></h3>
                        <small class="text-success">₹<?= number_format($stats['credit_amount'], 2) ?></small>
                    </div>
                    <div class="text-success">
                        <i class="fas fa-file-invoice fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-2">
        <div class="card stats-card debit">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle text-muted">Debit Notes</h6>
                        <h3 class="card-title mb-0"><?= $stats['total_debit'] ?></h3>
                        <small class="text-danger">₹<?= number_format($stats['debit_amount'], 2) ?></small>
                    </div>
                    <div class="text-danger">
                        <i class="fas fa-file-invoice fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-2">
        <div class="card stats-card sales">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle text-muted">Sales Notes</h6>
                        <h3 class="card-title mb-0"><?= $stats['credit_sales'] + $stats['debit_sales'] ?></h3>
                        <small class="text-muted">
                            C: <?= $stats['credit_sales'] ?> | D: <?= $stats['debit_sales'] ?>
                        </small>
                    </div>
                    <div class="text-primary">
                        <i class="fas fa-shopping-cart fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-2">
        <div class="card stats-card purchase">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="card-subtitle text-muted">Purchase Notes</h6>
                        <h3 class="card-title mb-0"><?= $stats['credit_purchase'] + $stats['debit_purchase'] ?></h3>
                        <small class="text-muted">
                            C: <?= $stats['credit_purchase'] ?> | D: <?= $stats['debit_purchase'] ?>
                        </small>
                    </div>
                    <div class="text-warning">
                        <i class="fas fa-shopping-bag fa-lg"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Notes -->
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-credit-card me-2"></i>Recent Credit Notes</h5>
            </div>
            <div class="card-body p-0">
                <?php if(empty($recent_credit)): ?>
                    <div class="text-center p-3">
                        <i class="fas fa-inbox fa-2x text-muted mb-2"></i>
                        <p class="text-muted mb-2">No credit notes found</p>
                        <a href="?page=credit&action=add" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus me-1"></i>Add First Credit Note
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0 table-sm">
                            <thead>
                                <tr>
                                    <th>Note #</th>
                                    <th>Party</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($recent_credit as $note): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($note['note_number']) ?></strong></td>
                                    <td><?= htmlspecialchars(substr($note['party_name'], 0, 15) . (strlen($note['party_name']) > 15 ? '...' : '')) ?></td>
                                    <td>
                                        <span class="badge bg-<?= $note['note_type'] === 'sales' ? 'primary' : 'warning' ?>">
                                            <?= ucfirst($note['note_type']) ?>
                                        </span>
                                    </td>
                                    <td>₹<?= number_format($note['total_amount'], 0) ?></td>
                                    <td><?= date('d/m', strtotime($note['note_date'])) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer text-center py-2">
                        <a href="?page=credit&action=list" class="btn btn-outline-primary btn-sm">
                            View All <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-money-bill-wave me-2"></i>Recent Debit Notes</h5>
            </div>
            <div class="card-body p-0">
                <?php if(empty($recent_debit)): ?>
                    <div class="text-center p-3">
                        <i class="fas fa-inbox fa-2x text-muted mb-2"></i>
                        <p class="text-muted mb-2">No debit notes found</p>
                        <a href="?page=debit&action=add" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus me-1"></i>Add First Debit Note
                        </a>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0 table-sm">
                            <thead>
                                <tr>
                                    <th>Note #</th>
                                    <th>Party</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($recent_debit as $note): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($note['note_number']) ?></strong></td>
                                    <td><?= htmlspecialchars(substr($note['party_name'], 0, 15) . (strlen($note['party_name']) > 15 ? '...' : '')) ?></td>
                                    <td>
                                        <span class="badge bg-<?= $note['note_type'] === 'sales' ? 'primary' : 'warning' ?>">
                                            <?= ucfirst($note['note_type']) ?>
                                        </span>
                                    </td>
                                    <td>₹<?= number_format($note['total_amount'], 0) ?></td>
                                    <td><?= date('d/m', strtotime($note['note_date'])) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer text-center py-2">
                        <a href="?page=debit&action=list" class="btn btn-outline-primary btn-sm">
                            View All <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
