# TVS LP 46 Neo Barcode Printer Setup Guide

## Printer Specifications
- **Model**: TVS LP 46 Neo
- **Label Size**: 35mm (Width) x 22mm (Height)
- **Labels per Row**: 3
- **Label Type**: Sticker roll
- **Features**: QR codes, MRP strikethrough, enhanced pricing display

## System Integration

### 2. Label Format Configuration
The system now supports TVS LP 46 Neo format with the following features:
- Optimized dimensions for 35mm x 22mm labels (width x height)
- 3 labels per row layout with enhanced design
- QR codes positioned on the right side of each label
- MRP strikethrough pricing with enhanced price display
- Proper spacing and margins for thermal printing
- Left-aligned text for better readability on small labels

### 2. Print Settings
When printing labels:
1. Select "TVS LP 46 Neo (35mm x 22mm - 3 per row)" from the Label Format dropdown
2. Use Chrome browser for best compatibility
3. Set printer to "Actual Size" (not "Fit to Page")
4. Ensure no scaling is applied

### 4. Label Content
Each label includes:
- **Store Name** (top left, bold, uppercase, max 10 characters)
- **Item Name** (main content, max 18 characters, left-aligned)
- **MRP Price** (if different from sales price, shown with strikethrough)
- **Sales Price** (bold, prominent display)
- **QR Code** (right side, contains item code, name, and price)
- **Item Code** (below QR code, small font, max 8 characters)

### 4. CSS Classes for Customization
The following CSS classes are available for customization:
- `.tvs-label-container`: Main container
- `.tvs-label-row`: Row containing 3 labels
- `.tvs-label`: Individual label
- `.tvs-store-name`: Store name styling
- `.tvs-item-name`: Item name styling  
- `.tvs-price`: Price styling
- `.tvs-barcode`: Barcode image styling
- `.tvs-barcode-text`: Barcode text styling

### 5. Browser Print Settings
For optimal printing results:

**Chrome Browser:**
1. Right-click → Print
2. Destination: Select your TVS LP 46 Neo printer
3. Pages: All
4. Layout: Portrait
5. Color: Black and white
6. Margins: None
7. Scale: Default (100%)
8. Options: Uncheck "Headers and footers"

**Print Media Settings:**
- Paper Size: Custom (67mm width to accommodate 3 labels + margins)
- Paper Type: Label/Thermal paper
- Print Quality: Normal
- Print Speed: Medium

### 6. Troubleshooting

**Labels too large/small:**
- Check browser zoom level (should be 100%)
- Verify printer driver settings
- Ensure "Actual Size" is selected in print dialog

**Misaligned labels:**
- Check label roll alignment in printer
- Verify label size settings match 35mm x 22mm
- Calibrate printer if necessary

**Blurry barcodes:**
- Increase barcode height in CSS if needed
- Check thermal printer head cleanliness
- Adjust print darkness/contrast settings

**Labels not printing in rows of 3:**
- Verify CSS media queries are loading
- Check browser compatibility (use Chrome recommended)
- Clear browser cache and try again

### 7. File Locations
- **Main Label View**: `application/views/labels.php`
- **Label Model**: `application/models/Items_model.php` (preview_labels method)
- **CSS Styles**: `theme/css/tvs-labels.css`
- **JavaScript**: `theme/js/labels.js`

### 8. API Endpoints
- **Label Preview**: `items/preview_labels` (POST)
- **Get Items**: `items/get_json_items_details` (GET)
- **Show Purchase Labels**: `items/show_labels/{purchase_id}` (GET)

### 9. Database Tables
- **Items**: `db_items` (contains item details, barcodes, prices)
- **Purchase Items**: `db_purchaseitems` (for bulk label printing from purchase)
- **Store**: `db_store` (store name for label header)

### 10. Customization Options
To modify label content or layout:
1. Edit `preview_labels()` method in `Items_model.php`
2. Update CSS in `tvs-labels.css`
3. Modify form in `labels.php` view
4. Update JavaScript handlers in `labels.js`

## Usage Instructions

### Standard Label Printing:
1. Go to Items → Print Labels
2. Select "TVS LP 46 Neo" format
3. Search and add items to print
4. Set quantities for each item
5. Click "Preview" to see label layout
6. Click "Print" to send to printer

### Bulk Printing from Purchase:
1. Go to Purchase → View Purchase
2. Click on purchase record
3. Click "Print Labels" button
4. System automatically loads all purchased items
5. Preview and print as above

### Quick Access URLs:
- Regular Labels: `{base_url}/items/labels`
- TVS Specific: `{base_url}/items/tvs_labels`
- From Purchase: `{base_url}/items/labels/{purchase_id}`

---
*Last Updated: August 18, 2025*
*Compatible with: TVS LP 46 Neo Thermal Barcode Printer*
