<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
include('includes/config.php');

// Check if database connection exists
if (!$con) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action'])) {
        echo json_encode(['success' => false, 'error' => 'Database connection failed']);
        exit;
    }
}

// Handle AJAX updates
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['action']) && $_POST['action'] == 'update_rate') {
    header('Content-Type: application/json');
    
    $id = mysqli_real_escape_string($con, $_POST['id']);
    $field = mysqli_real_escape_string($con, $_POST['field']);
    $value = mysqli_real_escape_string($con, $_POST['value']);
    
    // Validate field names to prevent SQL injection
    $allowed_fields = ['PurchasedRate', 'ShopRate', 'CustomerRate', 'WholesaleRate'];
    if (in_array($field, $allowed_fields)) {
        $query = "UPDATE tblvegetables SET $field = '$value', UpdatedDate = NOW() WHERE ID = '$id'";
        $result = mysqli_query($con, $query);
        
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'Rate updated successfully']);
        } else {
            echo json_encode(['success' => false, 'error' => mysqli_error($con)]);
        }
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid field']);
    }
    exit;
}

// Fetch all vegetables
$query = "SELECT * FROM tblvegetables WHERE Status = 'Active' ORDER BY CAST(VegetableCode AS UNSIGNED) ASC";
$result = mysqli_query($con, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Vegetable Rates Editor - Vegetable Shop</title>

    <!-- Custom fonts for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    
    <!-- DataTables -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css" rel="stylesheet">

    <style>
        body {
            background-color: #f8f9fc;
            font-family: 'Nunito', -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
        }
        
        .rates-editor-container {
            padding: 20px;
            max-width: 100%;
            margin: 0 auto;
        }
        
        .page-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        .editable-table {
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 35px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .editable-cell {
            cursor: pointer;
            transition: all 0.3s ease;
            padding: 12px 15px;
            position: relative;
        }
        
        .editable-cell:hover {
            background-color: #e3f2fd !important;
            transform: scale(1.02);
        }
        
        .editable-cell.editing {
            background-color: #fff3cd !important;
            padding: 0;
        }
        
        .edit-input {
            width: 100%;
            border: none;
            padding: 12px 15px;
            font-size: 14px;
            background: transparent;
            outline: none;
        }
        
        .edit-input::-webkit-outer-spin-button,
        .edit-input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        
        .edit-input[type=number] {
            -moz-appearance: textfield;
        }
        
        .rate-input {
            text-align: right;
            font-weight: 600;
            color: #2e7d32;
        }
        
        .vegetable-name {
            font-weight: 600;
            color: #1a202c;
        }
        
        .vegetable-code {
            font-size: 12px;
            color: #718096;
            background: #f7fafc;
            padding: 2px 8px;
            border-radius: 12px;
            display: inline-block;
        }
        
        .category-badge {
            font-size: 11px;
            padding: 4px 8px;
            border-radius: 12px;
            font-weight: 500;
        }
        
        .loading-indicator {
            position: absolute;
            top: 50%;
            right: 10px;
            transform: translateY(-50%);
            display: none;
        }
        
        .success-indicator {
            position: absolute;
            top: 50%;
            right: 10px;
            transform: translateY(-50%);
            color: #28a745;
            display: none;
        }
        
        .error-indicator {
            position: absolute;
            top: 50%;
            right: 10px;
            transform: translateY(-50%);
            color: #dc3545;
            display: none;
        }
        
        #dataTable th {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            font-weight: 600;
            text-align: center;
            padding: 15px 10px;
        }
        
        #dataTable td {
            border: 1px solid #e3e6f0;
            vertical-align: middle;
            text-align: center;
        }
        
        .back-button {
            position: fixed;
            top: 20px;
            left: 20px;
            z-index: 1000;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 20px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
            transition: all 0.3s ease;
        }
        
        .back-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.3);
            color: white;
            text-decoration: none;
        }
        
        .debug-panel {
            position: fixed;
            bottom: 50px;
            right: 10px;
            background: rgba(0,0,0,0.9);
            color: white;
            padding: 10px;
            border-radius: 5px;
            font-size: 11px;
            max-width: 300px;
            max-height: 200px;
            overflow-y: auto;
            z-index: 1000;
            display: none;
            font-family: monospace;
        }
        
        .debug-toggle {
            position: fixed;
            bottom: 10px;
            right: 10px;
            background: #007bff;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
            font-size: 12px;
            cursor: pointer;
            z-index: 1001;
        }
        
        .stats-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .stat-number {
            font-size: 2em;
            font-weight: bold;
            color: #667eea;
        }
        
        .stat-label {
            color: #718096;
            font-size: 14px;
            margin-top: 5px;
        }
        
        .footer-stats {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 10px;
            margin-top: 30px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .footer-stats .stats-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            text-align: center;
        }
        
        .footer-stat-item h4 {
            font-size: 1.5em;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .footer-stat-item p {
            margin: 0;
            opacity: 0.9;
            font-size: 14px;
        }
        
        .tamil-name {
            font-family: 'Latha', 'TAMu_Kadambri', 'TAMu_Kalyani', 'Noto Sans Tamil', sans-serif;
            font-weight: 500;
            text-shadow: 0 1px 2px rgba(0,0,0,0.1);
        }
        
        .vegetable-name {
            font-weight: 600;
            color: #2d3748;
        }
    </style>
</head>

<body>
    <a href="dashboard.php" class="back-button">
        <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
    </a>
    
    <div class="rates-editor-container">
      

        <!-- DataTable -->
        <div class="card shadow mb-4 editable-table">
            <div class="card-header py-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <h6 class="m-0 font-weight-bold text-white">
                    <i class="fas fa-table mr-2"></i>Editable Vegetable Rates
                </h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th width="15%">Vegetable / தமிழ் பெயர்</th>
                                <th width="10%">Code</th>
                                <th width="12%">Category</th>
                                <th width="8%">Unit</th>
                                <th width="13%">Purchase Rate (₹)</th>
                                <th width="13%">Shop Rate (₹)</th>
                                <th width="13%">Customer Rate (₹)</th>
                                <th width="13%">Wholesale Rate (₹)</th>
                                <th width="3%">Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalVegetables = 0;
                            $totalPurchaseRate = 0;
                            $totalCustomerRate = 0;
                            
                            while ($row = mysqli_fetch_assoc($result)) {
                                $totalVegetables++;
                                $totalPurchaseRate += $row['PurchasedRate'];
                                $totalCustomerRate += $row['CustomerRate'];
                                
                                // Category color mapping
                                $categoryColors = [
                                    'Fruit Vegetables' => 'badge-primary',
                                    'Root Vegetables' => 'badge-warning',
                                    'Leafy Vegetables' => 'badge-success',
                                    'Cruciferous Vegetables' => 'badge-info',
                                    'Allium Vegetables' => 'badge-secondary',
                                    'Legumes' => 'badge-danger'
                                ];
                                $categoryClass = $categoryColors[$row['Category']] ?? 'badge-dark';
                                ?>
                                <tr data-id="<?php echo $row['ID']; ?>">
                                    <td>
                                        <div class="vegetable-name"><?php echo htmlspecialchars($row['VegetableName']); ?></div>
                                        <div class="tamil-name" style="font-size: 12px; color: #6c757d; margin-top: 2px;"><?php echo htmlspecialchars($row['TamilName']); ?></div>
                                    </td>
                                    <td>
                                        <span class="vegetable-code"><?php echo htmlspecialchars($row['VegetableCode']); ?></span>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo $categoryClass; ?> category-badge">
                                            <?php echo htmlspecialchars($row['Category']); ?>
                                        </span>
                                    </td>
                                    <td><?php echo htmlspecialchars($row['Unit']); ?></td>
                                    <td class="editable-cell rate-input" data-field="PurchasedRate">
                                        <?php echo number_format($row['PurchasedRate'], 2); ?>
                                        <span class="loading-indicator"><i class="fas fa-spinner fa-spin"></i></span>
                                        <span class="success-indicator"><i class="fas fa-check"></i></span>
                                        <span class="error-indicator"><i class="fas fa-times"></i></span>
                                    </td>
                                    <td class="editable-cell rate-input" data-field="ShopRate">
                                        <?php echo number_format($row['ShopRate'], 2); ?>
                                        <span class="loading-indicator"><i class="fas fa-spinner fa-spin"></i></span>
                                        <span class="success-indicator"><i class="fas fa-check"></i></span>
                                        <span class="error-indicator"><i class="fas fa-times"></i></span>
                                    </td>
                                    <td class="editable-cell rate-input" data-field="CustomerRate">
                                        <?php echo number_format($row['CustomerRate'], 2); ?>
                                        <span class="loading-indicator"><i class="fas fa-spinner fa-spin"></i></span>
                                        <span class="success-indicator"><i class="fas fa-check"></i></span>
                                        <span class="error-indicator"><i class="fas fa-times"></i></span>
                                    </td>
                                    <td class="editable-cell rate-input" data-field="WholesaleRate">
                                        <?php echo number_format($row['WholesaleRate'], 2); ?>
                                        <span class="loading-indicator"><i class="fas fa-spinner fa-spin"></i></span>
                                        <span class="success-indicator"><i class="fas fa-check"></i></span>
                                        <span class="error-indicator"><i class="fas fa-times"></i></span>
                                    </td>
                                    <td>
                                        <span class="badge badge-success">Active</span>
                                    </td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- Footer Statistics -->
        <div class="footer-stats">
            <div class="text-center mb-3">
                <h5 class="mb-0 text-white font-weight-bold">
                    <i class="fas fa-table mr-2"></i>Editable Vegetable Rates Summary
                </h5>
            </div>
            <div class="stats-row">
                <div class="footer-stat-item">
                    <h4 id="footerTotalVegetables">0</h4>
                    <p>Total Vegetables</p>
                </div>
                <div class="footer-stat-item">
                    <h4 id="footerAvgPurchaseRate">₹0</h4>
                    <p>Avg Purchase Rate</p>
                </div>
                <div class="footer-stat-item">
                    <h4 id="footerAvgCustomerRate">₹0</h4>
                    <p>Avg Customer Rate</p>
                </div>
                <div class="footer-stat-item">
                    <h4 id="footerLastUpdated">-</h4>
                    <p>Last Updated</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Page level plugins -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>

    <script>
        // Debug functionality
        function addDebugMessage(message) {
            var timestamp = new Date().toLocaleTimeString();
            $('#debug-messages').prepend('<div>' + timestamp + ': ' + message + '</div>');
            var messages = $('#debug-messages div');
            if (messages.length > 20) {
                messages.last().remove();
            }
        }
        
        $(document).ready(function() {
            console.log('Document ready - initializing vegetable rates editor');
            
            // Check if DataTables is loaded
            if (typeof $.fn.DataTable === 'undefined') {
                console.error('DataTables library not loaded');
                addDebugMessage('ERROR: DataTables library not loaded');
                
                // Try to load DataTables from CDN as fallback
                var script = document.createElement('script');
                script.src = 'https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js';
                script.onload = function() {
                    var script2 = document.createElement('script');
                    script2.src = 'https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js';
                    script2.onload = function() {
                        initializeDataTable();
                    };
                    document.head.appendChild(script2);
                };
                document.head.appendChild(script);
                return;
            }
            
            initializeDataTable();
        });
        
        function initializeDataTable() {
            console.log('Initializing DataTable');
            addDebugMessage('Initializing DataTable');
            
            // Initialize debug panel toggle
            $('#debug-toggle').click(function() {
                $('#debug-panel').toggle();
            });
            
            addDebugMessage('Page loaded and debug system ready');
            
            try {
                // Initialize DataTable
                $('#dataTable').DataTable({
                    "pageLength": 25,
                    "order": [[0, "asc"]],
                    "columnDefs": [
                        { "orderable": false, "targets": [8] }
                    ]
                });
                
                console.log('DataTable initialized successfully');
                addDebugMessage('DataTable initialized successfully');
                
            } catch (error) {
                console.error('Error initializing DataTable:', error);
                addDebugMessage('ERROR initializing DataTable: ' + error.message);
                
                // If DataTable fails, at least show the table
                $('#dataTable').show();
            }
            
            // Update statistics
            updateStatistics();
            
            // Make cells editable - use event delegation for better reliability
            $(document).on('click', '.editable-cell', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                if ($(this).hasClass('editing')) {
                    console.log('Cell already being edited');
                    addDebugMessage('Cell already being edited');
                    return;
                }
                
                console.log('Making cell editable:', $(this).data('field'));
                addDebugMessage('Making cell editable: ' + $(this).data('field'));
                makeEditable($(this));
            });
            
            // Add keyboard navigation
            $(document).on('keydown', '.edit-input', function(e) {
                var $input = $(this);
                var $cell = $input.closest('.editable-cell');
                var $row = $cell.closest('tr');
                var currentField = $cell.data('field');
                var fields = ['PurchasedRate', 'ShopRate', 'CustomerRate', 'WholesaleRate'];
                var currentFieldIndex = fields.indexOf(currentField);
                
                switch(e.which) {
                    case 37: // Left arrow
                        e.preventDefault();
                        if (currentFieldIndex > 0) {
                            saveAndMoveToCell($input, $row.find('[data-field="' + fields[currentFieldIndex - 1] + '"]'));
                        }
                        break;
                    case 39: // Right arrow
                        e.preventDefault();
                        if (currentFieldIndex < fields.length - 1) {
                            saveAndMoveToCell($input, $row.find('[data-field="' + fields[currentFieldIndex + 1] + '"]'));
                        }
                        break;
                    case 38: // Up arrow
                        e.preventDefault();
                        var $prevRow = $row.prev();
                        if ($prevRow.length && !$prevRow.find('th').length) {
                            saveAndMoveToCell($input, $prevRow.find('[data-field="' + currentField + '"]'));
                        }
                        break;
                    case 40: // Down arrow
                        e.preventDefault();
                        var $nextRow = $row.next();
                        if ($nextRow.length) {
                            saveAndMoveToCell($input, $nextRow.find('[data-field="' + currentField + '"]'));
                        }
                        break;
                    case 13: // Enter
                        e.preventDefault();
                        var $nextRow = $row.next();
                        if ($nextRow.length) {
                            saveAndMoveToCell($input, $nextRow.find('[data-field="' + currentField + '"]'));
                        } else {
                            saveCurrentCell($input);
                        }
                        break;
                    case 27: // Escape
                        e.preventDefault();
                        cancelEdit($input);
                        break;
                }
            });
        }
        
        function makeEditable($cell) {
            var currentValue = $cell.text().trim();
            var field = $cell.data('field');
            var id = $cell.closest('tr').data('id');
            
            // Create input
            var $input = $('<input>', {
                type: 'number',
                step: '0.01',
                min: '0',
                class: 'edit-input rate-input',
                value: parseFloat(currentValue)
            });
            
            $cell.addClass('editing').html($input);
            $input.focus().select();
            
            // Handle blur event
            $input.on('blur', function() {
                if (!$(this).data('navigating')) {
                    saveCurrentCell($(this));
                }
            });
        }
        
        function saveAndMoveToCell($input, $targetCell) {
            $input.data('navigating', true);
            saveCurrentCell($input, function() {
                if ($targetCell.length) {
                    makeEditable($targetCell);
                }
            });
        }
        
        function saveCurrentCell($input, callback) {
            var $cell = $input.closest('.editable-cell');
            var newValue = parseFloat($input.val()) || 0;
            var field = $cell.data('field');
            var id = $cell.closest('tr').data('id');
            
            updateRate(id, field, newValue, $cell, callback);
        }
        
        function cancelEdit($input) {
            var $cell = $input.closest('.editable-cell');
            var originalValue = $cell.data('original-value') || '0.00';
            $cell.removeClass('editing').text(originalValue);
        }
        
        function updateRate(id, field, value, $cell, callback) {
            // Store original value for cancel functionality
            if (!$cell.data('original-value')) {
                $cell.data('original-value', $cell.text().trim());
            }
            
            // Show loading indicator
            $cell.find('.loading-indicator').show();
            $cell.find('.success-indicator, .error-indicator').hide();
            
            console.log('Updating rate:', {id: id, field: field, value: value});
            
            $.ajax({
                url: 'vegetable-rates-editor.php',
                type: 'POST',
                data: {
                    action: 'update_rate',
                    id: id,
                    field: field,
                    value: value
                },
                dataType: 'json',
                timeout: 10000, // 10 second timeout
                success: function(response) {
                    console.log('Update response:', response);
                    $cell.find('.loading-indicator').hide();
                    
                    if (response && response.success) {
                        $cell.removeClass('editing').text(value.toFixed(2));
                        $cell.data('original-value', value.toFixed(2));
                        $cell.find('.success-indicator').show().delay(2000).fadeOut();
                        updateStatistics();
                        if (callback) callback();
                    } else {
                        $cell.find('.error-indicator').show().delay(3000).fadeOut();
                        console.error('Update failed:', response);
                        alert('Error updating rate: ' + (response ? response.error : 'Unknown error'));
                        $cell.removeClass('editing').text($cell.data('original-value') || '0.00');
                        if (callback) callback();
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', {xhr: xhr, status: status, error: error});
                    $cell.find('.loading-indicator').hide();
                    $cell.find('.error-indicator').show().delay(3000).fadeOut();
                    
                    let errorMessage = 'Error updating rate. ';
                    if (status === 'timeout') {
                        errorMessage += 'Request timed out.';
                    } else if (xhr.status === 0) {
                        errorMessage += 'Network error - check your connection.';
                    } else {
                        errorMessage += 'Server error (' + xhr.status + ').';
                    }
                    
                    alert(errorMessage + ' Please try again.');
                    $cell.removeClass('editing').text($cell.data('original-value') || '0.00');
                    if (callback) callback();
                }
            });
        }
        
        function updateStatistics() {
            var totalVegetables = <?php echo $totalVegetables; ?>;
            var avgPurchaseRate = <?php echo $totalVegetables > 0 ? number_format($totalPurchaseRate / $totalVegetables, 2) : 0; ?>;
            var avgCustomerRate = <?php echo $totalVegetables > 0 ? number_format($totalCustomerRate / $totalVegetables, 2) : 0; ?>;
            var currentTime = new Date().toLocaleTimeString();
            
            // Update header stats
            $('#totalVegetables').text(totalVegetables);
            $('#avgPurchaseRate').text('₹' + avgPurchaseRate);
            $('#avgCustomerRate').text('₹' + avgCustomerRate);
            $('#lastUpdated').text(currentTime);
            
            // Update footer stats
            $('#footerTotalVegetables').text(totalVegetables);
            $('#footerAvgPurchaseRate').text('₹' + avgPurchaseRate);
            $('#footerAvgCustomerRate').text('₹' + avgCustomerRate);
            $('#footerLastUpdated').text(currentTime);
        }
        
        // Auto-refresh statistics every 30 seconds
        setInterval(function() {
            location.reload();
        }, 30000);
    </script>
    
    <!-- Debug Panel -->
    <button id="debug-toggle" class="debug-toggle">Debug</button>
    <div id="debug-panel" class="debug-panel">
        <div><strong>Debug Console:</strong></div>
        <div id="debug-messages"></div>
    </div>
</body>
</html>
