<?php
session_start();
include_once('includes/config.php');
if (!isset($_SESSION['uid']) || $_SESSION['usertype'] != 'admin') {
    header('location:logout.php');
    exit();
}

$msg = "";

// CREATE
if(isset($_POST['create'])) {
    $vegetableName = mysqli_real_escape_string($con, $_POST['vegetableName']);
    $tamilName = mysqli_real_escape_string($con, $_POST['tamilName']);
    $vegetableCode = mysqli_real_escape_string($con, $_POST['vegetableCode']);
    $category = mysqli_real_escape_string($con, $_POST['category']);
    $unit = mysqli_real_escape_string($con, $_POST['unit']);
    $purchasedRate = floatval($_POST['purchasedRate']);
    $shopRate = floatval($_POST['shopRate']);
    $customerRate = floatval($_POST['customerRate']);
    $wholesaleRate = floatval($_POST['wholesaleRate']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    $status = mysqli_real_escape_string($con, $_POST['status']);

    $check = mysqli_query($con, "SELECT ID FROM tblvegetables WHERE VegetableCode='$vegetableCode'");
    if(mysqli_num_rows($check) > 0) {
        $msg = "Vegetable code already exists!";
    } else {
        $result = mysqli_query($con, "INSERT INTO tblvegetables (VegetableName, TamilName, VegetableCode, Category, Unit, PurchasedRate, ShopRate, CustomerRate, WholesaleRate, Description, Status) VALUES ('$vegetableName', '$tamilName', '$vegetableCode', '$category', '$unit', '$purchasedRate', '$shopRate', '$customerRate', '$wholesaleRate', '$description', '$status')");
        $msg = $result ? "Vegetable created successfully!" : "Error creating vegetable!";
    }
}

// UPDATE
if(isset($_POST['update'])) {
    $vegetableId = intval($_POST['vegetableId']);
    $vegetableName = mysqli_real_escape_string($con, $_POST['vegetableName']);
    $tamilName = mysqli_real_escape_string($con, $_POST['tamilName']);
    $category = mysqli_real_escape_string($con, $_POST['category']);
    $unit = mysqli_real_escape_string($con, $_POST['unit']);
    $purchasedRate = floatval($_POST['purchasedRate']);
    $shopRate = floatval($_POST['shopRate']);
    $customerRate = floatval($_POST['customerRate']);
    $wholesaleRate = floatval($_POST['wholesaleRate']);
    $description = mysqli_real_escape_string($con, $_POST['description']);
    $status = mysqli_real_escape_string($con, $_POST['status']);
    
    $updateQuery = "UPDATE tblvegetables SET VegetableName='$vegetableName', TamilName='$tamilName', Category='$category', Unit='$unit', PurchasedRate='$purchasedRate', ShopRate='$shopRate', CustomerRate='$customerRate', WholesaleRate='$wholesaleRate', Description='$description', Status='$status' WHERE ID='$vegetableId'";
    $result = mysqli_query($con, $updateQuery);
    $msg = $result ? "Vegetable updated successfully!" : "Error updating vegetable!";
}

// DELETE
if(isset($_GET['del'])) {
    $vegetableId = intval($_GET['del']);
    mysqli_query($con, "DELETE FROM tblvegetables WHERE ID='$vegetableId'");
    $msg = "Vegetable deleted successfully!";
}

// READ (fetch all vegetables)
$vegetables = mysqli_query($con, "SELECT * FROM tblvegetables ORDER BY ID DESC");

// For edit form
$editVegetable = null;
if(isset($_GET['edit'])) {
    $editid = intval($_GET['edit']);
    $editRes = mysqli_query($con, "SELECT * FROM tblvegetables WHERE ID='$editid'");
    $editVegetable = mysqli_fetch_assoc($editRes);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Vegetable Shop | Vegetable Master</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="css/sb-admin-2.min.css" rel="stylesheet">
    <link href="css/enhanced-admin.css" rel="stylesheet">
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('includes/topbar.php');?>
                <div class="container-fluid">
                  
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-seedling mr-2"></i>Vegetable Master
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item active">Vegetable Master</li>
                            </ol>
                        </nav>
                    </div>

                    <?php if($msg): ?>
                    <div class="alert alert-<?php echo strpos($msg, 'Error') !== false || strpos($msg, 'exists') !== false ? 'danger' : 'success'; ?> alert-dismissible fade show" role="alert">
                        <i class="fas fa-<?php echo strpos($msg, 'Error') !== false || strpos($msg, 'exists') !== false ? 'exclamation-triangle' : 'check-circle'; ?> mr-2"></i>
                        <?php echo $msg; ?>
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-lg-5 col-md-6 col-12">
                            <div class="card shadow mb-4">
                                <div class="card-header bg-success text-white text-center">
                                    <h4 class="mb-0"><?php echo $editVegetable ? "Edit Vegetable" : "Add New Vegetable"; ?></h4>
                                </div>
                                <div class="card-body">
                                    <form method="post" autocomplete="off">
                                        <?php if($editVegetable) { ?>
                                            <input type="hidden" name="vegetableId" value="<?php echo $editVegetable['ID']; ?>">
                                        <?php } ?>
                                        
                                        <div class="form-group">
                                            <label>Vegetable Name <span class="text-danger">*</span></label>
                                            <input type="text" id="vegetableNameInput" name="vegetableName" class="form-control" required value="<?php echo $editVegetable ? htmlspecialchars($editVegetable['VegetableName']) : ''; ?>" placeholder="Type in English (e.g., thakkali, koththavarangaai)">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Tamil Name</label>
                                            <input type="text" name="tamilName" class="form-control" placeholder="தமிழ் பெயர்" value="<?php echo $editVegetable ? htmlspecialchars($editVegetable['TamilName']) : ''; ?>">
                                        </div>
                                        
                                        <?php if(!$editVegetable) { ?>
                                        <div class="form-group">
                                            <label>Vegetable Code <span class="text-danger">*</span></label>
                                            <input type="text" name="vegetableCode" class="form-control" required placeholder="e.g., VEG001">
                                        </div>
                                        <?php } else { ?>
                                        <div class="form-group">
                                            <label>Vegetable Code</label>
                                            <input type="text" class="form-control" value="<?php echo htmlspecialchars($editVegetable['VegetableCode']); ?>" readonly>
                                        </div>
                                        <?php } ?>
                                        
                                        <div class="form-group">
                                            <label>Category</label>
                                            <select name="category" class="form-control">
                                                <option value="">Select Category</option>
                                                <option value="Leafy Vegetables" <?php if($editVegetable && $editVegetable['Category']=='Leafy Vegetables') echo 'selected'; ?>>Leafy Vegetables</option>
                                                <option value="Root Vegetables" <?php if($editVegetable && $editVegetable['Category']=='Root Vegetables') echo 'selected'; ?>>Root Vegetables</option>
                                                <option value="Fruit Vegetables" <?php if($editVegetable && $editVegetable['Category']=='Fruit Vegetables') echo 'selected'; ?>>Fruit Vegetables</option>
                                                <option value="Cruciferous Vegetables" <?php if($editVegetable && $editVegetable['Category']=='Cruciferous Vegetables') echo 'selected'; ?>>Cruciferous Vegetables</option>
                                                <option value="Allium Vegetables" <?php if($editVegetable && $editVegetable['Category']=='Allium Vegetables') echo 'selected'; ?>>Allium Vegetables</option>
                                                <option value="Legumes" <?php if($editVegetable && $editVegetable['Category']=='Legumes') echo 'selected'; ?>>Legumes</option>
                                            </select>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Unit <span class="text-danger">*</span></label>
                                            <select name="unit" class="form-control" required>
                                                <option value="kg" <?php if($editVegetable && $editVegetable['Unit']=='kg') echo 'selected'; ?>>Kilogram (kg)</option>
                                                <option value="gram" <?php if($editVegetable && $editVegetable['Unit']=='gram') echo 'selected'; ?>>Gram</option>
                                                <option value="bunch" <?php if($editVegetable && $editVegetable['Unit']=='bunch') echo 'selected'; ?>>Bunch</option>
                                                <option value="piece" <?php if($editVegetable && $editVegetable['Unit']=='piece') echo 'selected'; ?>>Piece</option>
                                            </select>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Purchased Rate (₹) <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" name="purchasedRate" class="form-control" required value="<?php echo $editVegetable ? $editVegetable['PurchasedRate'] : ''; ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Shop Rate (₹) <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" name="shopRate" class="form-control" required value="<?php echo $editVegetable ? $editVegetable['ShopRate'] : ''; ?>">
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Customer Rate (₹) <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" name="customerRate" class="form-control" required value="<?php echo $editVegetable ? $editVegetable['CustomerRate'] : ''; ?>">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Wholesale Rate (₹) <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" name="wholesaleRate" class="form-control" required value="<?php echo $editVegetable ? $editVegetable['WholesaleRate'] : ''; ?>">
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Description</label>
                                            <textarea name="description" class="form-control" rows="3"><?php echo $editVegetable ? htmlspecialchars($editVegetable['Description']) : ''; ?></textarea>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label>Status <span class="text-danger">*</span></label>
                                            <select name="status" class="form-control" required>
                                                <option value="Active" <?php if($editVegetable && $editVegetable['Status']=='Active') echo 'selected'; ?>>Active</option>
                                                <option value="Inactive" <?php if($editVegetable && $editVegetable['Status']=='Inactive') echo 'selected'; ?>>Inactive</option>
                                            </select>
                                        </div>
                                        
                                        <input type="submit" name="<?php echo $editVegetable ? "update" : "create"; ?>" class="btn btn-success btn-user btn-block" value="<?php echo $editVegetable ? "Update Vegetable" : "Add Vegetable"; ?>">
                                        <?php if($editVegetable) { ?>
                                            <a href="vegetable-master.php" class="btn btn-secondary btn-block mt-2">Cancel Edit</a>
                                        <?php } ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-lg-7 col-md-6 col-12">
                            <div class="card shadow">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0"><i class="fas fa-list mr-2"></i>All Vegetables</h5>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm mb-0">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>Code</th>
                                                    <th>Name</th>
                                                    <th>Tamil Name</th>
                                                    <th>Category</th>
                                                    <th>Unit</th>
                                                    <th>Purchase Rate</th>
                                                    <th>Shop Rate</th>
                                                    <th>Customer Rate</th>
                                                    <th>Wholesale Rate</th>
                                                    <th>Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                            <?php $i=1; while($row = mysqli_fetch_assoc($vegetables)) { ?>
                                                <tr>
                                                    <td><?php echo $i++; ?></td>
                                                    <td><span class="badge badge-secondary"><?php echo htmlspecialchars($row['VegetableCode']); ?></span></td>
                                                    <td><?php echo htmlspecialchars($row['VegetableName']); ?></td>
                                                    <td><?php echo !empty($row['TamilName']) ? htmlspecialchars($row['TamilName']) : '<small class="text-muted">Not set</small>'; ?></td>
                                                    <td><?php echo htmlspecialchars($row['Category']); ?></td>
                                                    <td><?php echo htmlspecialchars($row['Unit']); ?></td>
                                                    <td>₹<?php echo number_format($row['PurchasedRate'], 2); ?></td>
                                                    <td>₹<?php echo number_format($row['ShopRate'], 2); ?></td>
                                                    <td>₹<?php echo number_format($row['CustomerRate'], 2); ?></td>
                                                    <td>₹<?php echo number_format($row['WholesaleRate'], 2); ?></td>
                                                    <td>
                                                        <span class="badge badge-<?php echo $row['Status'] == 'Active' ? 'success' : 'danger'; ?>">
                                                            <?php echo $row['Status']; ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <a href="vegetable-master.php?edit=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning" title="Edit">
                                                                <i class="fas fa-edit"></i>
                                                            </a>
                                                            <a href="vegetable-master.php?del=<?php echo $row['ID']; ?>" class="btn btn-sm btn-danger" title="Delete" onclick="return confirm('Delete this vegetable?');">
                                                                <i class="fas fa-trash"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <a href="dashboard.php" class="btn btn-link btn-block mt-3">
                                <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                            </a>
                        </div>
                    </div>
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->
    <?php include_once('includes/footer2.php');?>
    
    <!-- Bootstrap core JavaScript-->
    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Aksharamukha Library for Better Tamil Transliteration -->
    <script src="https://unpkg.com/@virtualvinodh/aksharamukha"></script>
    <!-- Custom scripts for all pages-->
    <script src="js/sb-admin-2.min.js"></script>
    
    <!-- Tamil Input with Aksharamukha Transliteration Script -->
    <script>
    $(document).ready(function() {
        let transliterationTimeout;

        // Show loading indicator
        function showLoadingIndicator(input) {
            input.addClass('transliterating');
            const loadingIcon = '<i class="fas fa-language fa-spin ml-2" id="transliteration-loader"></i>';
            input.parent().find('#transliteration-loader').remove();
            input.after(loadingIcon);
        }

        // Hide loading indicator
        function hideLoadingIndicator(input) {
            input.removeClass('transliterating');
            input.parent().find('#transliteration-loader').remove();
        }

        // Enhanced conversion function using Google Input Tools API with fallbacks
        async function convertThanglishToTamilAsync(thanglishText) {
            if (!thanglishText || thanglishText.length < 1) return '';

            // 1. Try Google Input Tools API first
            try {
                const response = await fetch(`https://inputtools.google.com/request?text=${encodeURIComponent(thanglishText)}&itc=ta-t-i0-und&num=1`);
                const data = await response.json();
                if (data[0] === "SUCCESS" && data[1] && data[1][0] && data[1][0][1] && data[1][0][1][0]) {
                    return data[1][0][1][0];
                }
            } catch (error) {
                console.log('Google Input Tools API failed, trying fallback methods');
            }

            // 2. Try Aksharamukha as fallback
            if (typeof Aksharamukha !== 'undefined') {
                try {
                    const result = Aksharamukha.convert('ITRANS', 'Tamil', thanglishText);
                    if (result && result !== thanglishText) return result;
                } catch (error) {
                    console.log('Aksharamukha transliteration failed, using basic mappings');
                }
            }

            // 3. Fallback to simple mapping for common vegetables
            const basicMappings = {
                'thakkali': 'தக்காளி',
                'vengayam': 'வெங்காயம்',
                'koththavarangaai': 'கொத்தவரங்காய்',
                'kotthavarangai': 'கொத்தவரங்காய்',
                'sakkarai poosani': 'சக்கரை பூசணி',
                'poosani': 'பூசணி',
                'sakkarai': 'சக்கரை',
                'kathirikai': 'கத்தரிக்காய்',
                'vendai': 'வெண்டைக்காய்',
                'milagai': 'மிளகாய்',
                'keerai': 'கீரை',
                'pudina': 'புதினா',
                'kothamalli': 'கொத்தமல்லி',
                'karuveppilai': 'கறிவேப்பிலை',
                'murungai': 'முருங்கைக்காய்',
                'surai': 'சுரைக்காய்',
                'peerkangai': 'பீர்க்கங்காய்',
                'pagal': 'பாகற்காய்',
                'pudalangai': 'புடலங்காய்',
                'inji': 'இஞ்சி',
                'poondu': 'பூண்டு',
                'elumichai': 'எலுமிச்சை',
                'vazhaikai': 'வாழைக்காய்',
                'malli ilai': 'மல்லி இலை'
            };
            const lowerText = thanglishText.toLowerCase();
            return basicMappings[lowerText] || thanglishText;
        }

        // Auto-transliterate when typing in English name field
        $('input[name="vegetableName"]').on('input', function() {
            const thanglishText = $(this).val().trim();
            const tamilInput = $('input[name="tamilName"]');
            
            // Clear previous timeout
            if (transliterationTimeout) {
                clearTimeout(transliterationTimeout);
            }

            // Only auto-transliterate if Tamil field is empty or was auto-generated
            if (thanglishText.length >= 1 && (tamilInput.val() === '' || tamilInput.data('auto-generated'))) {
                
                showLoadingIndicator(tamilInput);
                
                // Debounce the transliteration request
                transliterationTimeout = setTimeout(async () => {
                    try {
                        const tamilText = await convertThanglishToTamilAsync(thanglishText);
                        
                        if (tamilText && tamilText !== thanglishText) {
                            tamilInput.val(tamilText);
                            tamilInput.data('auto-generated', true);
                            
                            // Add success animation
                            tamilInput.addClass('auto-filled');
                            setTimeout(() => {
                                tamilInput.removeClass('auto-filled');
                            }, 1500);
                        }
                    } catch (error) {
                        console.error('Transliteration failed:', error);
                    } finally {
                        hideLoadingIndicator(tamilInput);
                    }
                }, 300); // Wait 300ms after user stops typing
                
            } else if (thanglishText.length < 1) {
                // Clear Tamil field if English name is empty
                if (tamilInput.data('auto-generated')) {
                    tamilInput.val('');
                }
                hideLoadingIndicator(tamilInput);
            }
        });

        // Enable direct Tamil typing in Tamil field
        $('input[name="tamilName"]').on('input', function() {
            const input = $(this);
            const currentValue = input.val();
            
            // Mark as manually edited
            input.data('auto-generated', false);
            hideLoadingIndicator(input);

            // If user types in English in Tamil field, auto-convert
            if (currentValue && /^[a-zA-Z\s]+$/.test(currentValue) && currentValue.length >= 2) {
                setTimeout(async () => {
                    const convertedText = await convertThanglishToTamilAsync(currentValue);
                    if (convertedText && convertedText !== currentValue) {
                        input.val(convertedText);
                    }
                }, 300);
            }
        });

        // Add visual feedback styles
        $('<style>')
            .text(`
                .auto-filled {
                    background-color: #e8f5e8 !important;
                    border-color: #28a745 !important;
                    transition: all 0.3s ease;
                    box-shadow: 0 0 5px rgba(40, 167, 69, 0.3) !important;
                }
                .transliterating {
                    background-color: #e3f2fd !important;
                    border-color: #2196f3 !important;
                    background-image: linear-gradient(45deg, transparent 65%, rgba(33, 150, 243, 0.1) 65%, rgba(33, 150, 243, 0.1) 75%, transparent 75%);
                    background-size: 20px 20px;
                    animation: move 1s linear infinite;
                }
                @keyframes move {
                    0% { background-position: 0 0; }
                    100% { background-position: 20px 20px; }
                }
                #transliteration-loader {
                    color: #2196f3;
                    position: absolute;
                    right: 10px;
                    top: 50%;
                    transform: translateY(-50%);
                    z-index: 10;
                }
                .transliteration-hint {
                    position: absolute;
                    background: #2196f3;
                    color: white;
                    padding: 3px 8px;
                    border-radius: 3px;
                    font-size: 10px;
                    z-index: 1000;
                    white-space: nowrap;
                    opacity: 0.9;
                }
            `)
            .appendTo('head');

        // Show transliteration hint on focus
        $('input[name="vegetableName"]').on('focus', function() {
            const hint = $('<div class="transliteration-hint">Try: sakkarai poosani, thakkali, koththavarangaai...</div>');
            $(this).parent().css('position', 'relative').append(hint);
            
            hint.css({
                'top': -25,
                'left': 0
            });
            
            setTimeout(() => {
                hint.fadeOut(300, function() {
                    $(this).remove();
                });
            }, 4000);
        });

        // Remove hint on blur
        $('input[name="vegetableName"]').on('blur', function() {
            $('.transliteration-hint').fadeOut(300, function() {
                $(this).remove();
            });
        });

        // Add keyboard shortcut info (Ctrl+Space for manual conversion)
        $(document).on('keydown', 'input[name="vegetableName"], input[name="tamilName"]', function(e) {
            if (e.ctrlKey && e.key === ' ') {
                e.preventDefault();
                const input = $(this);
                const text = input.val();
                if (text) {
                    showLoadingIndicator(input);
                    convertThanglishToTamilAsync(text).then(result => {
                        if (result) {
                            input.val(result);
                        }
                        hideLoadingIndicator(input);
                    });
                }
            }
        });

        console.log('🌐 Google Input Tools + Aksharamukha Tamil transliteration initialized');
    });
    </script>
    </script>
</body>
</html>
