-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Jul 26, 2025 at 06:44 AM
-- Server version: 9.1.0
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `veg-shop`
--

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `customer_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `gst_number` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `credit_limit` decimal(10,2) DEFAULT '0.00',
  `outstanding_balance` decimal(10,2) DEFAULT '0.00',
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `customer_code` (`customer_code`),
  KEY `idx_customers_code` (`customer_code`),
  KEY `idx_customers_created_by` (`created_by`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `customer_code`, `customer_name`, `phone`, `email`, `gst_number`, `credit_limit`, `outstanding_balance`, `address`, `city`, `created_date`, `updated_date`, `status`, `created_by`) VALUES
(1, 'CUST0001', 'jeganathan', '8754975422', NULL, '', 0.00, 380.00, '', NULL, '2025-07-26 06:19:50', '2025-07-26 06:32:42', 'active', 1);

-- --------------------------------------------------------

--
-- Table structure for table `customer_ledger`
--

DROP TABLE IF EXISTS `customer_ledger`;
CREATE TABLE IF NOT EXISTS `customer_ledger` (
  `id` int NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_type` enum('invoice','payment','credit_note','debit_note','opening_balance') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `reference_id` int DEFAULT NULL,
  `debit_amount` decimal(10,2) DEFAULT '0.00',
  `credit_amount` decimal(10,2) DEFAULT '0.00',
  `balance` decimal(10,2) DEFAULT '0.00',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_customer_ledger_customer` (`customer_id`),
  KEY `idx_customer_ledger_date` (`transaction_date`),
  KEY `idx_customer_ledger_type` (`transaction_type`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `customer_ledger`
--

INSERT INTO `customer_ledger` (`id`, `customer_id`, `transaction_date`, `transaction_type`, `reference_no`, `reference_id`, `debit_amount`, `credit_amount`, `balance`, `description`, `created_by`, `created_date`) VALUES
(1, 1, '2025-07-26', 'invoice', 'INV-202507-0003', 3, 380.00, 0.00, 2520.00, 'Credit Invoice: Updated INV-3', 1, '2025-07-26 06:20:39');

-- --------------------------------------------------------

--
-- Table structure for table `income_expense`
--

DROP TABLE IF EXISTS `income_expense`;
CREATE TABLE IF NOT EXISTS `income_expense` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` enum('income','expense') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Type of transaction',
  `category` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Category of income/expense',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'Description of transaction',
  `amount` decimal(10,2) NOT NULL COMMENT 'Amount of transaction',
  `transaction_date` date NOT NULL COMMENT 'Date of transaction',
  `payment_method` enum('cash','bank','upi','card') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'cash' COMMENT 'Payment method',
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'Reference number if any',
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci COMMENT 'Additional notes',
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'admin' COMMENT 'User who created the record',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_transaction_date` (`transaction_date`),
  KEY `idx_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `income_expense`
--

INSERT INTO `income_expense` (`id`, `type`, `category`, `description`, `amount`, `transaction_date`, `payment_method`, `reference_no`, `notes`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'income', 'Sales Revenue', 'Daily vegetable sales', 5000.00, '2025-07-21', 'cash', NULL, 'Regular daily sales', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(2, 'income', 'Other Income', 'Miscellaneous income', 500.00, '2025-07-21', 'bank', NULL, 'Other sources', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(3, 'expense', 'Purchase', 'Vegetable purchase from market', 3000.00, '2025-07-21', 'cash', NULL, 'Daily vegetable purchase', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(4, 'expense', 'Rent', 'Shop rent for the month', 8000.00, '2025-07-21', 'bank', NULL, 'Monthly shop rent', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(5, 'expense', 'Electricity', 'Electricity bill', 1200.00, '2025-07-21', 'upi', NULL, 'Monthly electricity bill', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(6, 'expense', 'Transportation', 'Vehicle fuel and maintenance', 800.00, '2025-07-21', 'cash', NULL, 'Transportation costs', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(7, 'expense', 'Staff Salary', 'Employee salaries', 15000.00, '2025-07-21', 'bank', NULL, 'Monthly staff salaries', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(8, 'expense', 'Other Expenses', 'Miscellaneous expenses', 300.00, '2025-07-21', 'cash', NULL, 'Other operational expenses', 'admin', '2025-07-21 12:34:21', '2025-07-21 12:34:21'),
(9, 'expense', 'Staff Salary', 'xbcvb', 200.00, '2025-07-25', 'cash', 'j', 'cbv', 'admin', '2025-07-25 08:29:38', '2025-07-25 08:29:38');

-- --------------------------------------------------------

--
-- Table structure for table `payment_allocations`
--

DROP TABLE IF EXISTS `payment_allocations`;
CREATE TABLE IF NOT EXISTS `payment_allocations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment_receipt_id` int NOT NULL,
  `invoice_id` int NOT NULL,
  `allocated_amount` decimal(10,2) NOT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_payment_allocations_receipt` (`payment_receipt_id`),
  KEY `idx_payment_allocations_invoice` (`invoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payment_allocations`
--

INSERT INTO `payment_allocations` (`id`, `payment_receipt_id`, `invoice_id`, `allocated_amount`, `created_date`) VALUES
(6, 8, 7, 50.00, '2025-07-25 17:21:27');

-- --------------------------------------------------------

--
-- Table structure for table `payment_history`
--

DROP TABLE IF EXISTS `payment_history`;
CREATE TABLE IF NOT EXISTS `payment_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `payment_date` date NOT NULL,
  `cash_amount` decimal(10,2) DEFAULT '0.00',
  `upi_amount` decimal(10,2) DEFAULT '0.00',
  `total_payment` decimal(10,2) NOT NULL,
  `cash_tender_received` decimal(10,2) DEFAULT '0.00' COMMENT 'Cash amount tendered by customer',
  `cash_change` decimal(10,2) DEFAULT '0.00' COMMENT 'Change amount returned to customer',
  `payment_method` enum('cash','upi','mixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `idx_payment_history_invoice` (`invoice_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payment_history`
--

INSERT INTO `payment_history` (`id`, `invoice_id`, `payment_date`, `cash_amount`, `upi_amount`, `total_payment`, `cash_tender_received`, `cash_change`, `payment_method`, `reference_no`, `notes`, `created_by`, `created_date`) VALUES
(1, 1, '2025-07-26', 1360.00, 0.00, 1360.00, 1360.00, 0.00, 'cash', NULL, NULL, 1, '2025-07-26 06:18:24'),
(2, 2, '2025-07-26', 110.00, 0.00, 110.00, 110.00, 0.00, 'cash', NULL, NULL, 1, '2025-07-26 06:19:50'),
(3, 3, '2025-07-26', 380.00, 0.00, 380.00, 0.00, 0.00, 'cash', '', '', 1, '2025-07-26 06:32:18');

-- --------------------------------------------------------

--
-- Table structure for table `payment_receipts`
--

DROP TABLE IF EXISTS `payment_receipts`;
CREATE TABLE IF NOT EXISTS `payment_receipts` (
  `id` int NOT NULL AUTO_INCREMENT,
  `receipt_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `receipt_date` date NOT NULL,
  `customer_id` int DEFAULT NULL,
  `customer_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_mode` enum('cash','upi','cheque','bank_transfer','mixed') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'cash',
  `cash_amount` decimal(10,2) DEFAULT '0.00',
  `upi_amount` decimal(10,2) DEFAULT '0.00',
  `cheque_amount` decimal(10,2) DEFAULT '0.00',
  `bank_amount` decimal(10,2) DEFAULT '0.00',
  `cheque_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `bank_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `total_amount` decimal(10,2) DEFAULT '0.00',
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('active','cancelled') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'active',
  PRIMARY KEY (`id`),
  UNIQUE KEY `receipt_no` (`receipt_no`),
  KEY `idx_payment_receipts_date` (`receipt_date`),
  KEY `idx_payment_receipts_customer` (`customer_id`),
  KEY `created_by` (`created_by`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `payment_receipts`
--

INSERT INTO `payment_receipts` (`id`, `receipt_no`, `receipt_date`, `customer_id`, `customer_name`, `payment_mode`, `cash_amount`, `upi_amount`, `cheque_amount`, `bank_amount`, `cheque_no`, `cheque_date`, `bank_details`, `total_amount`, `notes`, `created_by`, `created_date`, `updated_date`, `status`) VALUES
(4, 'RCP-202507-0004', '2025-07-21', 0, 'kannan', 'cash', 2000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 2000.00, '', 1, '2025-07-21 10:39:19', '2025-07-21 10:39:19', 'active'),
(8, 'RCP-202507-0005', '2025-07-25', 1, 'kannan', 'cash', 2000.00, 0.00, 0.00, 0.00, NULL, NULL, NULL, 50.00, '', 1, '2025-07-25 17:21:27', '2025-07-25 17:21:41', 'active');

-- --------------------------------------------------------

--
-- Table structure for table `sales_invoices`
--

DROP TABLE IF EXISTS `sales_invoices`;
CREATE TABLE IF NOT EXISTS `sales_invoices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `invoice_date` date NOT NULL,
  `invoice_type` enum('cash','credit') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'cash',
  `sale_counter` enum('customer','shop','wholesale') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'customer' COMMENT 'Sale counter type: customer, shop, or wholesale rates',
  `due_date` date DEFAULT NULL,
  `credit_days` int DEFAULT '0',
  `customer_id` int DEFAULT NULL,
  `customer_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `customer_phone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `customer_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `customer_gst` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subtotal` decimal(10,2) DEFAULT '0.00',
  `discount_percent` decimal(5,2) DEFAULT '0.00',
  `discount_amount` decimal(10,2) DEFAULT '0.00',
  `discount_percentage` decimal(5,2) DEFAULT '0.00' COMMENT 'Discount percentage applied',
  `tax_percent` decimal(5,2) DEFAULT '0.00',
  `tax_amount` decimal(10,2) DEFAULT '0.00',
  `total_amount` decimal(10,2) DEFAULT '0.00',
  `payment_status` enum('unpaid','partial','paid') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'unpaid',
  `cash_received` decimal(10,2) DEFAULT '0.00',
  `upi_received` decimal(10,2) DEFAULT '0.00',
  `balance_amount` decimal(10,2) DEFAULT '0.00',
  `cash_tender_received` decimal(10,2) DEFAULT '0.00' COMMENT 'Cash amount tendered by customer',
  `cash_change` decimal(10,2) DEFAULT '0.00' COMMENT 'Change amount to be returned to customer',
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('active','cancelled') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'active',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoice_no` (`invoice_no`),
  KEY `created_by` (`created_by`),
  KEY `idx_sales_invoices_date` (`invoice_date`),
  KEY `idx_sales_invoices_customer` (`customer_id`),
  KEY `idx_sales_invoices_status` (`payment_status`),
  KEY `idx_invoice_type` (`invoice_type`),
  KEY `idx_due_date` (`due_date`),
  KEY `idx_sale_counter` (`sale_counter`),
  KEY `idx_cash_tender` (`cash_tender_received`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Sales invoices table with sale counter type for different rate categories';

--
-- Dumping data for table `sales_invoices`
--

INSERT INTO `sales_invoices` (`id`, `invoice_no`, `invoice_date`, `invoice_type`, `sale_counter`, `due_date`, `credit_days`, `customer_id`, `customer_name`, `customer_phone`, `customer_address`, `customer_gst`, `subtotal`, `discount_percent`, `discount_amount`, `discount_percentage`, `tax_percent`, `tax_amount`, `total_amount`, `payment_status`, `cash_received`, `upi_received`, `balance_amount`, `cash_tender_received`, `cash_change`, `notes`, `created_by`, `created_date`, `updated_date`, `status`, `updated_at`) VALUES
(1, 'INV-202507-0001', '2025-07-26', 'cash', 'customer', NULL, NULL, NULL, 'jeganathan', '888388801', '', NULL, 1360.00, 0.00, 0.00, 0.00, 0.00, 0.00, 1360.00, 'paid', 1360.00, 0.00, 0.00, 1360.00, 0.00, '', 1, '2025-07-26 06:18:24', '2025-07-26 06:18:24', 'active', '2025-07-26 06:18:24'),
(2, 'INV-202507-0002', '2025-07-26', 'cash', 'customer', NULL, NULL, NULL, 'jeganathan', '8754975422', '', NULL, 110.00, 0.00, 0.00, 0.00, 0.00, 0.00, 110.00, 'paid', 110.00, 0.00, 0.00, 110.00, 0.00, '', 1, '2025-07-26 06:19:50', '2025-07-26 06:19:50', 'active', '2025-07-26 06:19:50'),
(3, 'INV-202507-0003', '2025-07-26', 'credit', 'customer', '2025-08-25', 30, 1, 'jeganathan', '8754975422', '', NULL, 380.00, 0.00, 0.00, 0.00, 0.00, 0.00, 380.00, 'paid', 380.00, 0.00, 0.00, 0.00, 0.00, '', 1, '2025-07-26 06:20:39', '2025-07-26 06:32:18', 'active', '2025-07-26 06:32:18');

-- --------------------------------------------------------

--
-- Table structure for table `sales_invoice_details`
--

DROP TABLE IF EXISTS `sales_invoice_details`;
CREATE TABLE IF NOT EXISTS `sales_invoice_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `invoice_id` int NOT NULL,
  `product_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `product_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `quantity` decimal(10,3) NOT NULL,
  `rate` decimal(10,2) NOT NULL,
  `purchase_rate` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Purchase rate at the time of sale',
  `profit_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT 'Profit amount (rate - purchase_rate) * quantity',
  `profit_margin_percent` decimal(5,2) NOT NULL DEFAULT '0.00' COMMENT 'Profit margin percentage',
  `amount` decimal(10,2) NOT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `idx_purchase_rate` (`purchase_rate`),
  KEY `idx_profit_amount` (`profit_amount`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Sales invoice line items with purchase rate tracking for profit analysis';

--
-- Dumping data for table `sales_invoice_details`
--

INSERT INTO `sales_invoice_details` (`id`, `invoice_id`, `product_code`, `product_name`, `unit`, `quantity`, `rate`, `purchase_rate`, `profit_amount`, `profit_margin_percent`, `amount`, `created_date`) VALUES
(1, 1, '1', 'Tomato', 'kg', 10.000, 40.00, 25.00, 150.00, 37.50, 400.00, '2025-07-26 06:18:24'),
(2, 1, '2', 'Onion', 'kg', 30.000, 32.00, 20.00, 360.00, 37.50, 960.00, '2025-07-26 06:18:24'),
(3, 2, '1', 'Tomato', 'kg', 1.000, 40.00, 25.00, 15.00, 37.50, 40.00, '2025-07-26 06:19:50'),
(4, 2, '3', 'Potato', 'kg', 1.000, 25.00, 15.00, 10.00, 40.00, 25.00, '2025-07-26 06:19:50'),
(5, 2, '4', 'Carrot', 'kg', 1.000, 45.00, 30.00, 15.00, 33.33, 45.00, '2025-07-26 06:19:50'),
(10, 3, '1', 'Tomato', 'kg', 10.000, 38.00, 25.00, 130.00, 34.21, 380.00, '2025-07-26 06:26:17');

-- --------------------------------------------------------

--
-- Table structure for table `suppliers`
--

DROP TABLE IF EXISTS `suppliers`;
CREATE TABLE IF NOT EXISTS `suppliers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `supplier_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `supplier_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `contact_person` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `phone` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `outstanding_balance` decimal(10,2) DEFAULT '0.00',
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'active',
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `supplier_code` (`supplier_code`),
  KEY `idx_suppliers_code` (`supplier_code`),
  KEY `idx_suppliers_name` (`supplier_name`),
  KEY `idx_suppliers_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `suppliers`
--

INSERT INTO `suppliers` (`id`, `supplier_code`, `supplier_name`, `contact_person`, `phone`, `address`, `city`, `outstanding_balance`, `notes`, `created_date`, `updated_date`, `status`, `created_by`) VALUES
(1, 'SUP001', 'Fresh Farms Suppliers', 'Ramesh Kumar', '9876543210', '123 Agriculture Market, Sector 5', 'Mumbai', 0.00, NULL, '2025-07-21 11:18:54', '2025-07-25 08:29:06', 'active', 1),
(2, 'SUP002', 'Green Valley Traders', 'Suresh Patel', '9876543211', '456 Wholesale Market, Block A', 'Pune', 0.00, NULL, '2025-07-21 11:18:54', '2025-07-21 11:18:54', 'active', 1),
(3, 'SUP003', 'Organic Produce Co.', 'Priya Sharma', '9876543212', '789 Organic Farm Road', 'Nashik', 0.00, NULL, '2025-07-21 11:18:54', '2025-07-21 11:18:54', 'active', 1),
(4, 'SUP004', 'Local Vegetable Vendor', 'Amit Singh', '9876543213', '321 Local Market', 'Mumbai', 0.00, NULL, '2025-07-21 11:18:54', '2025-07-21 11:18:54', 'active', 1);

-- --------------------------------------------------------

--
-- Table structure for table `supplier_ledger`
--

DROP TABLE IF EXISTS `supplier_ledger`;
CREATE TABLE IF NOT EXISTS `supplier_ledger` (
  `id` int NOT NULL AUTO_INCREMENT,
  `supplier_id` int NOT NULL,
  `transaction_date` date NOT NULL,
  `transaction_type` enum('purchase','payment','adjustment') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `reference_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `debit_amount` decimal(10,2) DEFAULT '0.00',
  `credit_amount` decimal(10,2) DEFAULT '0.00',
  `balance` decimal(10,2) DEFAULT '0.00',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_supplier_ledger_supplier` (`supplier_id`),
  KEY `idx_supplier_ledger_date` (`transaction_date`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `supplier_ledger`
--

INSERT INTO `supplier_ledger` (`id`, `supplier_id`, `transaction_date`, `transaction_type`, `reference_no`, `debit_amount`, `credit_amount`, `balance`, `description`, `created_by`, `created_date`) VALUES
(1, 1, '2025-07-21', 'purchase', 's', 10000.00, 0.00, 10000.00, 'Ghee Mysore Pak', 1, '2025-07-21 11:34:30'),
(2, 1, '2025-07-21', 'payment', 'PAY-202507-0001', 0.00, 2000.00, 0.00, 'Payment via cash', 1, '2025-07-21 11:34:54'),
(3, 1, '2025-07-25', 'purchase', '000001', 1000.00, 0.00, 1000.00, '234567', 1, '2025-07-25 08:28:38'),
(4, 1, '2025-07-25', 'payment', 'PAY-20250725135858', 0.00, 1000.00, 0.00, 'Payment via cash', 1, '2025-07-25 08:29:06');

-- --------------------------------------------------------

--
-- Table structure for table `supplier_payments`
--

DROP TABLE IF EXISTS `supplier_payments`;
CREATE TABLE IF NOT EXISTS `supplier_payments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `payment_no` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `payment_date` date NOT NULL,
  `supplier_id` int NOT NULL,
  `supplier_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `payment_mode` enum('cash','upi','bank_transfer','cheque') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'cash',
  `amount` decimal(10,2) NOT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `created_by` int DEFAULT NULL,
  `created_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `payment_no` (`payment_no`),
  KEY `idx_supplier_payments_supplier` (`supplier_id`),
  KEY `idx_supplier_payments_date` (`payment_date`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `supplier_payments`
--

INSERT INTO `supplier_payments` (`id`, `payment_no`, `payment_date`, `supplier_id`, `supplier_name`, `payment_mode`, `amount`, `reference_no`, `notes`, `created_by`, `created_date`) VALUES
(1, 'PAY-202507-0001', '2025-07-21', 1, '', 'cash', 2000.00, 's', '', 1, '2025-07-21 11:34:54'),
(2, 'PAY-20250725135858', '2025-07-25', 1, 'Fresh Farms Suppliers', 'cash', 1000.00, NULL, NULL, 1, '2025-07-25 08:29:06');

-- --------------------------------------------------------

--
-- Table structure for table `tblusers`
--

DROP TABLE IF EXISTS `tblusers`;
CREATE TABLE IF NOT EXISTS `tblusers` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `UserName` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `FullName` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `UserType` enum('admin','staff') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'staff',
  `MobileNumber` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Email` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Password` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `RegDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblusers`
--

INSERT INTO `tblusers` (`ID`, `UserName`, `FullName`, `UserType`, `MobileNumber`, `Email`, `Password`, `RegDate`) VALUES
(1, 'admin', 'Admin User', 'admin', '1234567890', 'admin@ihita.com', '0192023a7bbd73250516f069df18b500', '2025-06-09 13:56:57'),
(2, 'staff1', 'Staff User', 'staff', '9876543210', 'staff1@ihita.com', '4297f44b13955235245b2497399d7a93', '2025-06-09 13:56:57'),
(3, 'jegan', 'Jegan', 'staff', '1234567890', '', '39f7fd5224e736d8f8dada96c85f17f0', '2025-06-09 16:13:05'),
(4, 'MUTHUKUMAR', 'MUTHUKUMAR', 'staff', '8248862021', '', '3512326b4973b0f7235ef1cfea69902c', '2025-06-30 08:39:10'),
(5, 'SURESH', 'SURESH', 'staff', '9159060793', '', '4cad7af0b660623419c64898a8277fd6', '2025-06-30 08:40:18');

-- --------------------------------------------------------

--
-- Table structure for table `tblvegetables`
--

DROP TABLE IF EXISTS `tblvegetables`;
CREATE TABLE IF NOT EXISTS `tblvegetables` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `VegetableName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `TamilName` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `VegetableCode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `Category` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `Unit` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'kg',
  `PurchasedRate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `ShopRate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `CustomerRate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `WholesaleRate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `Description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `Status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Active',
  `CreatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `UpdatedDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `VegetableCode` (`VegetableCode`),
  KEY `idx_vegetable_code` (`VegetableCode`),
  KEY `idx_status` (`Status`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `tblvegetables`
--

INSERT INTO `tblvegetables` (`ID`, `VegetableName`, `TamilName`, `VegetableCode`, `Category`, `Unit`, `PurchasedRate`, `ShopRate`, `CustomerRate`, `WholesaleRate`, `Description`, `Status`, `CreatedDate`, `UpdatedDate`) VALUES
(1, 'Tomato', 'தக்காளி', '1', 'Fruit Vegetables', 'kg', 25.00, 35.00, 40.00, 30.00, 'Fresh red tomatoes', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:32'),
(2, 'Onion', 'வெங்காயம்', '2', 'Allium Vegetables', 'kg', 20.00, 28.00, 32.00, 25.00, 'Fresh white onions', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:28'),
(3, 'Potato', 'உருளைக்கிழங்கு', '3', 'Root Vegetables', 'kg', 15.00, 22.00, 25.00, 20.00, 'Fresh potatoes', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:29'),
(4, 'Carrot', 'கேரட்', '4', 'Root Vegetables', 'kg', 30.00, 40.00, 45.00, 35.00, 'Fresh orange carrots', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:25'),
(5, 'Spinach', 'பசலைக்கீரை', '5', 'Leafy Vegetables', 'bunch', 5.00, 8.00, 10.00, 7.00, 'Fresh green spinach leaves', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:29'),
(6, 'Cabbage', 'முட்டைகோஸ்', '6', 'Cruciferous Vegetables', 'kg', 18.00, 25.00, 30.00, 22.00, 'Fresh green cabbage', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:25'),
(7, 'Cauliflower', 'காலிஃப்ளவர்', '7', 'Cruciferous Vegetables', 'kg', 35.00, 45.00, 50.00, 40.00, 'Fresh white cauliflower', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:26'),
(8, 'Broccoli', 'ப்ரோக்கோலி', '8', 'Cruciferous Vegetables', 'kg', 80.00, 100.00, 120.00, 90.00, 'Fresh green broccoli', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:25'),
(9, 'Bell Pepper', 'குடைமிளகாய்', '9', 'Fruit Vegetables', 'kg', 60.00, 63.00, 90.00, 70.00, 'Colorful bell peppers', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:24'),
(10, 'Cucumber', 'வெள்ளரி', '10', 'Fruit Vegetables', 'kg', 25.00, 35.00, 40.00, 30.00, 'Fresh green cucumber', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:26'),
(11, 'Eggplant', 'கத்தரிக்காய்', '11', 'Fruit Vegetables', 'kg', 35.00, 45.00, 50.00, 40.00, 'Fresh purple eggplant', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:27'),
(12, 'Okra', 'வெண்டைக்காய்', '12', 'Fruit Vegetables', 'kg', 40.00, 55.00, 60.00, 50.00, 'Fresh green okra (ladyfinger)', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:28'),
(13, 'Green Beans', 'பீன்ஸ்', '13', 'Legumes', 'kg', 45.00, 60.00, 70.00, 55.00, 'Fresh green beans', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:27'),
(14, 'Peas', 'பட்டாணி', '14', 'Legumes', 'kg', 50.00, 70.00, 80.00, 65.00, 'Fresh green peas', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:29'),
(15, 'Radish', 'முள்ளங்கி', '15', 'Root Vegetables', 'kg', 20.00, 30.00, 35.00, 25.00, 'Fresh white radish', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:29'),
(16, 'Beetroot', 'பீட்ரூட்', '16', 'Root Vegetables', 'kg', 40.00, 48.00, 45.00, 42.00, 'Fresh red beetroot', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:24'),
(17, 'Sweet Potato', 'சர்க்கரைவள்ளிக்கிழங்கு', '17', 'Root Vegetables', 'kg', 25.00, 35.00, 40.00, 30.00, 'Fresh sweet potatoes', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:30'),
(18, 'Ginger', 'இஞ்சி', '18', 'Root Vegetables', 'kg', 150.00, 200.00, 220.00, 180.00, 'Fresh ginger root', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:27'),
(19, 'Garlic', 'பூண்டு', '19', 'Allium Vegetables', 'kg', 120.00, 160.00, 180.00, 140.00, 'Fresh garlic bulbs', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:27'),
(20, 'Green Chili', 'பச்சைமிளகாய்', '20', 'Fruit Vegetables', 'kg', 80.00, 100.00, 120.00, 90.00, 'Fresh green chilies', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:27'),
(21, 'Coriander', 'கொத்தமல்லி', '21', 'Leafy Vegetables', 'bunch', 3.00, 5.00, 6.00, 4.00, 'Fresh coriander leaves', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:26'),
(22, 'Mint', 'புதினா', '22', 'Leafy Vegetables', 'bunch', 4.00, 6.00, 8.00, 5.00, 'Fresh mint leaves', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:28'),
(23, 'Lettuce', 'லெட்டூஸ்', '23', 'Leafy Vegetables', 'kg', 40.00, 55.00, 65.00, 50.00, 'Fresh lettuce leaves', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:28'),
(24, 'Bottle Gourd', 'சுரைக்காய்', '24', 'Fruit Vegetables', 'kg', 30.00, 30.00, 35.00, 25.00, 'Fresh bottle gourd', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:24'),
(25, 'Ridge Gourd', 'பீர்க்கங்காய்', '25', 'Fruit Vegetables', 'kg', 25.00, 35.00, 40.00, 30.00, 'Fresh ridge gourd', 'Active', '2025-07-20 02:35:10', '2025-07-25 08:26:29');

-- --------------------------------------------------------

--
-- Stand-in structure for view `v_sales_profit_analysis`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `v_sales_profit_analysis`;
CREATE TABLE IF NOT EXISTS `v_sales_profit_analysis` (
`invoice_id` int
,`invoice_no` varchar(20)
,`invoice_date` date
,`sale_counter` enum('customer','shop','wholesale')
,`customer_name` varchar(100)
,`detail_id` int
,`product_code` varchar(20)
,`product_name` varchar(100)
,`unit` varchar(20)
,`quantity` decimal(10,3)
,`purchase_rate` decimal(10,2)
,`selling_rate` decimal(10,2)
,`total_amount` decimal(10,2)
,`profit_amount` decimal(10,2)
,`profit_margin_percent` decimal(5,2)
,`profit_per_unit` decimal(11,2)
);

-- --------------------------------------------------------

--
-- Structure for view `v_sales_profit_analysis`
--
DROP TABLE IF EXISTS `v_sales_profit_analysis`;

DROP VIEW IF EXISTS `v_sales_profit_analysis`;
CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `v_sales_profit_analysis`  AS SELECT `si`.`id` AS `invoice_id`, `si`.`invoice_no` AS `invoice_no`, `si`.`invoice_date` AS `invoice_date`, `si`.`sale_counter` AS `sale_counter`, `si`.`customer_name` AS `customer_name`, `sid`.`id` AS `detail_id`, `sid`.`product_code` AS `product_code`, `sid`.`product_name` AS `product_name`, `sid`.`unit` AS `unit`, `sid`.`quantity` AS `quantity`, `sid`.`purchase_rate` AS `purchase_rate`, `sid`.`rate` AS `selling_rate`, `sid`.`amount` AS `total_amount`, `sid`.`profit_amount` AS `profit_amount`, `sid`.`profit_margin_percent` AS `profit_margin_percent`, (`sid`.`rate` - `sid`.`purchase_rate`) AS `profit_per_unit` FROM (`vegetable-shop`.`sales_invoices` `si` join `vegetable-shop`.`sales_invoice_details` `sid` on((`si`.`id` = `sid`.`invoice_id`))) WHERE (`si`.`status` = 'active') ORDER BY `si`.`invoice_date` DESC, `si`.`id` DESC ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
