<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    header('location:../index.php');
    exit;
}

include('../includes/config.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Outstanding Balance - Vegetable Shop</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include('../includes/sidebar.php'); ?>
        
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include('../includes/topbar.php'); ?>
                
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Supplier Outstanding Balance</h1>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <?php
                        $totalOutstanding = 0;
                        $countSql = "SELECT COUNT(*) as total_suppliers, SUM(outstanding_balance) as total_outstanding 
                                     FROM suppliers WHERE status='active'";
                        $countResult = mysqli_query($con, $countSql);
                        $countRow = mysqli_fetch_assoc($countResult);
                        $totalOutstanding = $countRow['total_outstanding'] ?: 0;
                        ?>
                        <div class="col-xl-6 col-md-6 mb-4">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Total Outstanding
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                ₹<?php echo number_format($totalOutstanding, 2); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Active Suppliers
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo $countRow['total_suppliers']; ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-truck fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Outstanding Balance Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Supplier Outstanding Summary</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Supplier Code</th>
                                            <th>Supplier Name</th>
                                            <th>Contact Person</th>
                                            <th>Phone</th>
                                            <th>Outstanding Balance</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM suppliers WHERE status='active' ORDER BY outstanding_balance DESC";
                                        $result = mysqli_query($con, $sql);
                                        while ($row = mysqli_fetch_assoc($result)) {
                                        ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['supplier_code']); ?></td>
                                            <td><?php echo htmlspecialchars($row['supplier_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['contact_person']); ?></td>
                                            <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                            <td class="<?php echo $row['outstanding_balance'] > 0 ? 'text-danger' : 'text-success'; ?>">
                                                <strong>₹<?php echo number_format($row['outstanding_balance'], 2); ?></strong>
                                            </td>
                                            <td>
                                                <a href="ledger.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-book"></i> View Ledger
                                                </a>
                                                <?php if ($row['outstanding_balance'] > 0) { ?>
                                                <button class="btn btn-success btn-sm" 
                                                        onclick="makePayment(<?php echo $row['id']; ?>, '<?php echo addslashes($row['supplier_name']); ?>', <?php echo $row['outstanding_balance']; ?>)"
                                                        data-toggle="modal" data-target="#quickPaymentModal">
                                                    <i class="fas fa-money-bill-wave"></i> Pay
                                                </button>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Quick Payment Modal -->
    <div class="modal fade" id="quickPaymentModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Quick Payment</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST" action="payments.php">
                    <div class="modal-body">
                        <div class="form-group">
                            <label>Supplier</label>
                            <input type="text" class="form-control" id="modal_supplier_name" readonly>
                            <input type="hidden" name="supplier_id" id="modal_supplier_id">
                            <input type="hidden" name="supplier_name" id="modal_supplier_name_hidden">
                        </div>
                        <div class="form-group">
                            <label>Outstanding Balance</label>
                            <input type="text" class="form-control" id="modal_outstanding" readonly>
                        </div>
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" step="0.01" class="form-control" name="amount" id="modal_amount" required>
                        </div>
                        <div class="form-group">
                            <label>Payment Mode *</label>
                            <select class="form-control" name="payment_mode" required>
                                <option value="cash">Cash</option>
                                <option value="upi">UPI</option>
                                <option value="bank_transfer">Bank Transfer</option>
                                <option value="cheque">Cheque</option>
                            </select>
                        </div>
                        <input type="hidden" name="payment_no" value="<?php echo 'PAY-' . date('YmdHis'); ?>">
                        <input type="hidden" name="payment_date" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-success">Record Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "order": [[ 4, "desc" ]]
            });
        });

        function makePayment(supplierId, supplierName, outstanding) {
            $('#modal_supplier_id').val(supplierId);
            $('#modal_supplier_name').val(supplierName);
            $('#modal_supplier_name_hidden').val(supplierName);
            $('#modal_outstanding').val('₹' + outstanding.toFixed(2));
            $('#modal_amount').val(outstanding.toFixed(2));
        }
    </script>
</body>
</html>
