<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    header('HTTP/1.1 401 Unauthorized');
    exit;
}

include('../includes/config.php');

if (isset($_GET['id'])) {
    $supplierId = $_GET['id'];
    
    $sql = "SELECT * FROM suppliers WHERE id = ?";
    $stmt = $con->prepare($sql);
    $stmt->bind_param("i", $supplierId);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        header('Content-Type: application/json');
        echo json_encode($row);
    } else {
        header('HTTP/1.1 404 Not Found');
        echo json_encode(['error' => 'Supplier not found']);
    }
} else {
    header('HTTP/1.1 400 Bad Request');
    echo json_encode(['error' => 'Missing supplier ID']);
}
?>
