<?php
session_start();
$_SESSION['uid'] = 1; // Set test session

include_once('../includes/config.php');

echo "<h2>Payment Collection Test with Invoice Allocation</h2>";

// Test customer data
$customer_name = 'Kannan';
echo "<h3>Testing payment collection for customer: $customer_name</h3>";

// Get customer info
$customer_stmt = $con->prepare("SELECT id, customer_name, outstanding_balance FROM customers WHERE LOWER(customer_name) = LOWER(?) AND status = 'active'");
$customer_stmt->bind_param("s", $customer_name);
$customer_stmt->execute();
$customer_result = $customer_stmt->get_result();

if ($customer_result->num_rows > 0) {
    $customer = $customer_result->fetch_assoc();
    echo "<p><strong>Customer ID:</strong> " . $customer['id'] . "</p>";
    echo "<p><strong>Customer Name:</strong> " . $customer['customer_name'] . "</p>";
    echo "<p><strong>Outstanding Balance:</strong> ₹" . $customer['outstanding_balance'] . "</p>";
    
    $customer_id = $customer['id'];
    
    // Get outstanding invoices
    echo "<h4>Outstanding Invoices:</h4>";
    $invoice_stmt = $con->prepare("
        SELECT id, invoice_no, invoice_date, total_amount, balance_amount, payment_status
        FROM sales_invoices 
        WHERE customer_id = ? AND balance_amount > 0 AND payment_status != 'paid' AND status = 'active'
        ORDER BY invoice_date ASC, id ASC
    ");
    $invoice_stmt->bind_param("i", $customer_id);
    $invoice_stmt->execute();
    $invoice_result = $invoice_stmt->get_result();
    
    if ($invoice_result->num_rows > 0) {
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>Invoice No</th><th>Date</th><th>Total Amount</th><th>Balance Amount</th><th>Status</th></tr>";
        
        while ($invoice = $invoice_result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $invoice['invoice_no'] . "</td>";
            echo "<td>" . $invoice['invoice_date'] . "</td>";
            echo "<td>₹" . $invoice['total_amount'] . "</td>";
            echo "<td>₹" . $invoice['balance_amount'] . "</td>";
            echo "<td>" . strtoupper($invoice['payment_status']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Test payment data
        echo "<h4>Test Payment Simulation:</h4>";
        $test_payment = [
            'customer_id' => $customer_id,
            'payment_amount' => 200.00,
            'payment_mode' => 'cash',
            'payment_date' => date('Y-m-d'),
            'reference_no' => '',
            'notes' => 'Test payment for invoice allocation'
        ];
        
        echo "<p><strong>Test Payment Data:</strong></p>";
        echo "<pre>" . json_encode($test_payment, JSON_PRETTY_PRINT) . "</pre>";
        
        echo "<p><strong>Explanation:</strong> This payment of ₹200.00 will be allocated to the oldest outstanding invoices first (FIFO basis). Each invoice will be marked as 'paid' when fully settled, 'partial' when partially paid, or remain 'unpaid' if no payment is allocated to it yet.</p>";
        
    } else {
        echo "<p>No outstanding invoices found for this customer.</p>";
    }
    
} else {
    echo "<p>Customer '$customer_name' not found.</p>";
}

echo "<hr>";
echo "<h4>Next Steps:</h4>";
echo "<ol>";
echo "<li>Go to the sales system</li>";
echo "<li>Select customer 'Kannan'</li>";
echo "<li>Click 'Collect Payment' button</li>";
echo "<li>Enter payment amount (e.g., ₹200.00)</li>";
echo "<li>Select payment mode and click 'Save Payment'</li>";
echo "<li>Check the success message to see which invoices were paid</li>";
echo "</ol>";

echo "<p><a href='index.php' target='_blank'>Open Sales System</a></p>";
?>
