<?php
session_start();
include_once('../includes/config.php');

if (!isset($_SESSION['uid']) || !isset($_GET['id'])) {
    header('location:../login.php');
    exit();
}

$invoiceId = (int)$_GET['id'];

try {
    // Get invoice data
    $stmt = $pdo->prepare("SELECT * FROM sales_invoices WHERE id = ?");
    $stmt->execute([$invoiceId]);
    $invoice = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$invoice) {
        echo "Invoice not found!";
        exit();
    }
    
    // Get invoice items with Tamil names
    $stmt = $pdo->prepare("
        SELECT 
            sid.*,
            COALESCE(tv.TamilName, sid.product_name) as tamil_name
        FROM sales_invoice_details sid
        LEFT JOIN tblvegetables tv ON sid.product_code = tv.VegetableCode
        WHERE sid.invoice_id = ? 
        ORDER BY sid.id
    ");
    $stmt->execute([$invoiceId]);
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Invoice - <?php echo htmlspecialchars($invoice['invoice_no']); ?></title>
    <!-- Stylish font for shop name -->
    <link href="https://fonts.googleapis.com/css2?family=Pacifico&display=swap" rel="stylesheet">
    <style>
        @media print {
            @page { 
                size: 80mm auto; 
                margin: 0; 
            }
            body { 
                margin: 0; 
                padding: 0; 
            }
        }
        
        body {
            font-family: 'Segoe UI', 'Arial Unicode MS', Arial, sans-serif;
            font-size: 15px;
            line-height: 1.15;
            margin: 0;
            padding: 6px 18px 6px 15px; /* Increased left padding from 8px to 15px */
            width: 80mm;
            background: white;
            color: #222;
            /* border: 2px solid #000; */ /* Removed border */
            box-sizing: border-box;
        }
        
        .receipt {
            width: 100%;
            max-width: 80mm;
            margin: 0 auto;
            padding: 0 2px 0 8px; /* Increased left padding from 2px to 8px */
            padding-right: 10px;
        }
        
        .center {
            text-align: center;
        }
        
        .bold {
            font-weight: bold;
        }
        
        .header {
            text-align: center;
            border-bottom: 1px dashed #888;
            padding-bottom: 4px;
            margin-bottom: 4px;
            padding-left: 2px;
            padding-right: 2px;
        }
        
        .shop-name {
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 3px;
            font-family: 'Times New Roman', Times, serif;
            color: #222;
            text-align: center;
            letter-spacing: 1px;
        }
        
        .big-a {
            font-size: 24px;
            font-weight: 900;
            color: #222;
            display: inline-block;
            margin-right: 2px;
            border: 1px solid #222;
            padding: 1px 3px;
            background: #fff;
        }
        
        .shop-details {
            font-size: 13px;
            margin-bottom: 4px;
            font-family: 'Segoe UI', 'Arial Unicode MS', Arial, sans-serif;
        }
        
        .invoice-info {
            margin: 4px 2px;
            font-size: 13px;
            text-align: center;
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 4px;
            padding: 2px 0;
        }
        
        .invoice-info > div {
            flex: 1;
            min-width: 60px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .customer-info {
            margin: 4px 2px;
            font-size: 13px;
            padding: 2px 0;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 4px 2px;
            font-size: 14px;
        }
        
        .items-table th,
        .items-table td {
            padding: 2px 4px;
            text-align: left;
            border-bottom: none;
        }
        
        .items-table th {
            font-weight: bold;
            font-size: 13px;
            border-bottom: 1px dashed #888;
        }
        
        .items-table td:first-child {
            font-size: 14px;
            font-weight: 500;
        }
        
        .items-table th.qty,
        .items-table th.rate,
        .items-table th.amount,
        .items-table td.qty,
        .items-table td.rate,
        .items-table td.amount {
            text-align: right;
        }
        
        .total-section {
            margin-top: 4px;
            padding: 4px 2px;
            border-top: 1px dashed #888;
            font-size: 14px;
        }
        
        .total-line {
            display: flex;
            justify-content: space-between;
            margin: 1px 0;
        }
        
        .grand-total {
            font-weight: bold;
            font-size: 16px;
            border-top: 1px solid #222;
            border-bottom: 1px solid #222;
            padding: 3px 0;
            margin: 3px 0;
            background: #f7f7f7;
            letter-spacing: 1px;
        }
        
        .footer {
            text-align: center;
            margin-top: 6px;
            font-size: 13px;
            border-top: 1px dashed #888;
            padding-top: 4px;
            font-family: 'Segoe UI', 'Arial Unicode MS', Arial, sans-serif;
        }
        
        .instagram {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            margin-top: 2px;
            font-size: 13px;
        }
        
        .instagram-logo {
            width: 16px;
            height: 16px;
            vertical-align: middle;
        }
        
        .tamil-slogan {
            font-size: 13px;
            font-weight: bold;
            color: #222;
            margin: 2px 0;
        }
        
        .english-thanks {
            font-size: 12px;
            margin: 2px 0;
            font-weight: bold;
        }
        
        .payment-info {
            margin: 4px 2px;
            font-size: 13px;
            padding: 4px 0;
            border-top: 1px dashed #888;
        }
        
        .payment-info .total-line {
            display: flex;
            justify-content: space-between;
            margin: 2px 0;
            padding: 1px 0;
        }
        
        .change-given {
            background: #e8f5e8;
            font-weight: bold;
            padding: 2px 4px;
            border-radius: 3px;
        }
        
        .balance-due {
            background: #ffe8e8;
            font-weight: bold;
            padding: 2px 4px;
            border-radius: 3px;
        }
    </style>
</head>
<body>
    <div class="receipt">
        <!-- Header -->
        <div class="header">
            <div class="shop-name" style="font-family: 'Times New Roman', Times, serif; font-size: 24px; text-transform: uppercase;">AANA VEG CORNER</div>
            <div class="shop-details">
                Opp. Bus Stand<br>
                Andipatti - 625512<br>
                <!-- Mobile SVG logo and number -->
                <span style="display:inline-flex;align-items:center;gap:4px;">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" style="vertical-align:middle;">
                        <rect x="6" y="2" width="12" height="20" rx="2" stroke="#222" stroke-width="1.5" fill="none"/>
                        <rect x="10" y="18" width="4" height="2" rx="1" fill="#222"/>
                    </svg>
                    95858 29948
                </span>
            </div>
        </div>
        
        <!-- Invoice Info -->
        <div class="invoice-info">
            <div><strong>No:</strong> <?php echo htmlspecialchars($invoice['invoice_no']); ?></div>
            <div><strong>Date:</strong> <?php echo date('d/m/Y', strtotime($invoice['invoice_date'])); ?></div>
            <div><strong>Time:</strong> <?php echo date('H:i', strtotime($invoice['created_date'])); ?></div>
        </div>
        <!-- Dotted line after invoice info -->
        <div style="border-bottom:1px dashed #888; margin: 2px 0;"></div>
        
        <!-- Customer Info -->
        <div class="customer-info">
            <div><strong>Customer:</strong> <?php echo !empty($invoice['customer_name']) ? htmlspecialchars($invoice['customer_name']) : 'Walk-in Customer'; ?></div>
            <?php if (!empty($invoice['customer_phone'])): ?>
            <div><strong>Mobile:</strong> <?php echo htmlspecialchars($invoice['customer_phone']); ?></div>
            <?php endif; ?>
        </div>
        
        <!-- Items -->
        <table class="items-table">
            <thead>
                <tr>
                    <th style="width: 40%;">Item</th>
                    <th style="width: 15%;" class="qty">Qty</th>
                    <th style="width: 20%;" class="rate">Rate</th>
                    <th style="width: 25%;" class="amount">Amount</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): ?>
                <tr>
                    <td><?php echo htmlspecialchars($item['tamil_name']); ?></td>
                    <td class="qty"><?php echo number_format($item['quantity'], 3); ?></td>
                    <td class="rate"><?php echo number_format($item['rate'], 2); ?></td>
                    <td class="amount"><?php echo number_format($item['amount'], 2); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <!-- Total Items Count -->
        <div style="text-align: right; font-size: 13px; font-weight: bold; margin: 3px 0; padding: 2px 0; border-bottom: 1px dashed #888;">
            Total Items: <?php echo count($items); ?>
        </div>
        
        <!-- Totals -->
        <div class="total-section">
            <div class="total-line">
                <span>Subtotal:</span>
                <span>₹<?php echo number_format($invoice['subtotal'], 2); ?></span>
            </div>
            
            <?php if ($invoice['discount_amount'] > 0): ?>
            <div class="total-line">
                <span>
                    Discount 
                    <?php if ($invoice['discount_percent'] > 0): ?>
                        (<?php echo number_format($invoice['discount_percent'], 1); ?>%)
                    <?php else: ?>
                        (Fixed)
                    <?php endif; ?>:
                </span>
                <span>-₹<?php echo number_format($invoice['discount_amount'], 2); ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($invoice['tax_amount'] > 0): ?>
            <div class="total-line">
                <span>Tax (<?php echo $invoice['tax_percent']; ?>%):</span>
                <span>₹<?php echo number_format($invoice['tax_amount'], 2); ?></span>
            </div>
            <?php endif; ?>
            
            <div class="total-line grand-total">
                <span>Grand Total:</span>
                <span>₹<?php echo number_format($invoice['total_amount'], 2); ?></span>
            </div>
        </div>
        
        <!-- Payment Info -->
        <div class="payment-info">
            <div style="text-align: center; font-weight: bold; margin-bottom: 4px; font-size: 14px;">PAYMENT DETAILS</div>
            
            <?php 
            $cashTenderReceived = floatval($invoice['cash_tender_received'] ?? 0);
            $upiReceived = floatval($invoice['upi_received'] ?? 0);
            $cashChange = floatval($invoice['cash_change'] ?? 0);
            $totalReceived = $cashTenderReceived + $upiReceived;
            ?>
            
            <?php if ($cashTenderReceived > 0): ?>
            <div class="total-line">
                <span>Cash Received:</span>
                <span>₹<?php echo number_format($cashTenderReceived, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($upiReceived > 0): ?>
            <div class="total-line">
                <span>UPI Received:</span>
                <span>₹<?php echo number_format($upiReceived, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($totalReceived > 0): ?>
            <div class="total-line" style="font-weight: bold; background: #e7f3ff; padding: 3px 4px; border-radius: 3px; margin: 3px 0; font-size: 14px;">
                <span>Total Received:</span>
                <span>₹<?php echo number_format($totalReceived, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <?php if ($cashChange > 0): ?>
            <div class="total-line" style="font-weight: bold; background: #d4edda; padding: 3px 4px; border-radius: 3px; margin: 3px 0; font-size: 14px;">
                <span>Change to Return:</span>
                <span>₹<?php echo number_format($cashChange, 2); ?></span>
            </div>
            <?php endif; ?>
            
            <div class="total-line" style="font-weight: bold; background: #fff3cd; padding: 3px 4px; border-radius: 3px; margin: 3px 0; font-size: 14px;">
                <span>Payment Status:</span>
                <span><?php echo strtoupper($invoice['payment_status']); ?></span>
            </div>
            
            <?php if ($invoice['payment_status'] === 'partial'): ?>
            <div class="total-line balance-due" style="font-weight: bold; background: #ffe8e8; padding: 3px 4px; border-radius: 3px; margin: 3px 0; font-size: 14px;">
                <span>Outstanding Balance:</span>
                <span>₹<?php echo number_format($invoice['balance_amount'], 2); ?></span>
            </div>
            <?php endif; ?>
            
            
        </div>
        
        <!-- Footer -->
        <div class="footer">
            <div class="english-thanks">Your healthy way with us ! </div>
            <div class="instagram">
                <!-- Instagram SVG logo -->
                <span>
                    <svg class="instagram-logo" viewBox="0 0 24 24" fill="none">
                        <rect x="2" y="2" width="20" height="20" rx="5" stroke="#222" stroke-width="2"/>
                        <circle cx="12" cy="12" r="5" stroke="#222" stroke-width="2"/>
                        <circle cx="17" cy="7" r="1.2" fill="#222"/>
                    </svg>
                </span>
             
                <span>aana_vegcorner</span>
            </div>
                <div class="shop-name" style="font-size: 12px; margin-top: 5px;">அ - காய்கறி கடை</div>
        </div>
    </div>
    
    <script>
        // Auto print on load
        window.onload = function() {
            window.print();
            // Close window after printing
            setTimeout(function() {
                window.close();
            }, 1000);
        };
    </script>
</body>
</html>
