<?php
session_start();
include_once('../includes/config.php');

if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Invoice Management - Vegetable Shop</title>

    <!-- Fonts -->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <div id="wrapper">
        <!-- Sidebar -->
        <?php include_once('../includes/sidebar.php'); ?>
        
        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <!-- Topbar -->
                <?php include_once('../includes/topbar.php'); ?>
                
                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-file-invoice mr-2"></i>Invoice Management
                        </h1>
                        <a href="index.php" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus mr-1"></i>New Sale
                        </a>
                    </div>

                    <!-- DataTales Example -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">All Invoices</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Invoice No</th>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Amount</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        try {
                                            $stmt = $pdo->prepare("
                                                SELECT id, invoice_no, invoice_date, customer_name, total_amount, payment_status 
                                                FROM sales_invoices 
                                                WHERE status = 'active' 
                                                ORDER BY invoice_date DESC, id DESC
                                            ");
                                            $stmt->execute();
                                            $invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                            
                                            foreach ($invoices as $invoice) {
                                                $statusClass = '';
                                                switch($invoice['payment_status']) {
                                                    case 'paid': $statusClass = 'badge-success'; break;
                                                    case 'partial': $statusClass = 'badge-warning'; break;
                                                    case 'unpaid': $statusClass = 'badge-danger'; break;
                                                }
                                                
                                                echo "<tr>";
                                                echo "<td>" . htmlspecialchars($invoice['invoice_no']) . "</td>";
                                                echo "<td>" . date('d/m/Y', strtotime($invoice['invoice_date'])) . "</td>";
                                                echo "<td>" . htmlspecialchars($invoice['customer_name']) . "</td>";
                                                echo "<td>₹" . number_format($invoice['total_amount'], 2) . "</td>";
                                                echo "<td><span class='badge {$statusClass}'>" . ucfirst($invoice['payment_status']) . "</span></td>";
                                                echo "<td>
                                                        <a href='print_invoice.php?id={$invoice['id']}' class='btn btn-sm btn-info' target='_blank'>
                                                            <i class='fas fa-print'></i>
                                                        </a>
                                                        <a href='index.php?edit={$invoice['id']}' class='btn btn-sm btn-warning'>
                                                            <i class='fas fa-edit'></i>
                                                        </a>
                                                      </td>";
                                                echo "</tr>";
                                            }
                                        } catch (Exception $e) {
                                            echo "<tr><td colspan='6'>Error loading invoices: " . $e->getMessage() . "</td></tr>";
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Footer -->
            <?php include_once('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "order": [[ 1, "desc" ]],
                "pageLength": 25
            });
        });
    </script>
</body>
</html>
