<?php
session_start();
include_once('../includes/config.php');

if (!isset($_SESSION['uid'])) {
    header('location:../login.php');
    exit();
}

// Handle invoice editing
$edit_invoice_data = null;
if (isset($_GET['edit_invoice']) && !empty($_GET['edit_invoice'])) {
    $invoice_id = mysqli_real_escape_string($con, $_GET['edit_invoice']);
    
    // Get invoice details
    $invoice_query = "SELECT si.*, c.customer_name, c.phone as customer_phone, c.gst_number as customer_gst, c.address as customer_address 
                      FROM sales_invoices si 
                      LEFT JOIN customers c ON si.customer_id = c.id 
                      WHERE si.id = '$invoice_id' AND si.status = 'active'";
    $invoice_result = mysqli_query($con, $invoice_query);
    
    if ($invoice_result && mysqli_num_rows($invoice_result) > 0) {
        $edit_invoice_data = mysqli_fetch_assoc($invoice_result);
        
        // Get invoice items
        $items_query = "SELECT sid.*, v.VegetableName, v.Unit 
                        FROM sales_invoice_details sid 
                        LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode 
                        WHERE sid.invoice_id = '$invoice_id'";
        $items_result = mysqli_query($con, $items_query);
        $edit_invoice_items = [];
        while ($item = mysqli_fetch_assoc($items_result)) {
            $edit_invoice_items[] = $item;
        }
        $edit_invoice_data['items'] = $edit_invoice_items;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Sales Management - Vegetable Shop</title>

    <!-- Fonts -->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    <link href="css/sales.css" rel="stylesheet">
</head>

<body class="windows-app-body">
    <div class="sales-container">
        <!-- Alert Container -->
        <div id="alertContainer"></div>

        <!-- Scan Mode Indicator -->
        <div class="scan-mode-indicator" id="scanModeIndicator">
            <i class="fas fa-barcode mr-2"></i>SCAN MODE ACTIVE
        </div>

        <!-- Header Section with Enhanced Design -->
        <div class="header-section">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h4 class="mb-0">
                        <i class="fas fa-cash-register mr-2"></i>Sales Management
                        <?php if ($edit_invoice_data): ?>
                        <span class="badge badge-warning ml-2">
                            <i class="fas fa-edit mr-1"></i>Editing Invoice: <?php echo $edit_invoice_data['invoice_no']; ?>
                        </span>
                        <?php endif; ?>
                        <span id="invoicePosition" class="badge badge-info ml-2" style="display: none;"></span>
                    </h4>
                </div>
                <div class="header-buttons">
                    <button type="button" class="btn btn-success" id="saveInvoice" title="Save Invoice (Ctrl+S)">
                        <i class="fas fa-save"></i>
                        <span>Save</span>
                        <span class="btn-shortcut">Ctrl+S</span>
                    </button>
                    <button type="button" class="btn btn-info" id="printInvoice" title="Print Invoice (Ctrl+P)">
                        <i class="fas fa-print"></i>
                        <span>Print</span>
                        <span class="btn-shortcut">Ctrl+P</span>
                    </button>
                    <button type="button" class="btn btn-primary" id="prevInvoice" title="Previous Invoice (Ctrl+←)" style="display: none;">
                        <i class="fas fa-chevron-left"></i>
                        <span>Prev</span>
                        <span class="btn-shortcut">Ctrl+←</span>
                    </button>
                    <button type="button" class="btn btn-primary" id="nextInvoice" title="Next Invoice (Ctrl+→)" style="display: none;">
                        <i class="fas fa-chevron-right"></i>
                        <span>Next</span>
                        <span class="btn-shortcut">Ctrl+→</span>
                    </button>
                    <button type="button" class="btn btn-warning" id="newInvoice" title="New Invoice (Ctrl+N)">
                        <i class="fas fa-plus"></i>
                        <span>New</span>
                        <span class="btn-shortcut">Ctrl+N</span>
                    </button>
                    <a href="../reports/bill_wise_report.php" class="btn btn-info" title="Bill Wise Report">
                        <i class="fas fa-file-invoice"></i>
                        <span>Reports</span>
                    </a>
                    <?php if ($edit_invoice_data): ?>
                    <a href="../reports/bill_wise_report.php" class="btn btn-success" title="Back to Bill Wise Report">
                        <i class="fas fa-arrow-left"></i>
                        <span>Back to Reports</span>
                    </a>
                    <?php endif; ?>
                    <a href="../dashboard.php" class="btn btn-secondary" title="Back to Dashboard (Esc)">
                        <i class="fas fa-arrow-left"></i>
                        <span>Dashboard</span>
                        <span class="btn-shortcut">Esc</span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Main Content Grid -->
        <div class="main-content">
            <!-- Left Panel -->
            <div class="left-panel">
                <!-- Sales Grid -->
                <div class="cart-section">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5><i class="fas fa-shopping-cart mr-2"></i>Shopping Cart</h5>
                        <div class="d-flex align-items-center">
                            <div class="form-group mr-3 mb-0">
                                <label class="mb-1">Invoice Type:</label>
                                <select class="form-control form-control-sm" id="invoiceType" style="width: 100px;" title="Select Invoice Type">
                                    <option value="cash">Cash Sale</option>
                                    <option value="credit">Credit Sale</option>
                                </select>
                            </div>
                            <div class="form-group mr-3 mb-0" id="creditDaysGroup" style="display: none;">
                                <label class="mb-1">Credit Days:</label>
                                <input type="number" class="form-control form-control-sm" id="creditDays" style="width: 80px;" min="0" max="365" value="30">
                            </div>
                            <div class="form-group mr-3 mb-0">
                                <label class="mb-1">Entry Mode:</label>
                                <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="scanMode">
                                    <label class="custom-control-label" for="scanMode">Scan Mode</label>
                                </div>
                            </div>
                            <div class="form-group mr-3 mb-0">
                                <label class="mb-1">Rate Type:</label>
                                <select class="form-control form-control-sm" id="rateType" style="width: 130px;" title="Change Rate Type (Alt+R)">
                                    <option value="CustomerRate">Customer Rate</option>
                                    <option value="ShopRate">Shop Rate</option>
                                    <option value="WholesaleRate">Wholesale Rate</option>
                                </select>
                            </div>
                            <button type="button" class="btn btn-primary btn-sm" id="addRow" title="Add Product (Ctrl+A)">
                                <i class="fas fa-plus mr-2"></i>Add Product
                                <span class="btn-shortcut">Ctrl+A</span>
                            </button>
                            <button type="button" class="btn btn-info btn-sm ml-2" id="searchProductBtn" title="Search Products (Ctrl+F)">
                                <i class="fas fa-search mr-2"></i>Search Products
                                <span class="btn-shortcut">Ctrl+F</span>
                            </button>
                        </div>
                    </div>
                    <div class="sales-grid">
                        <table id="salesGrid" class="table table-bordered mb-0">
                            <thead>
                                <tr>
                                    <th class="col-code">Code</th>
                                    <th class="col-product">Product Name</th>
                                    <th class="col-unit">Unit</th>
                                    <th class="col-qty">Quantity</th>
                                    <th class="col-rate">Rate (₹)</th>
                                    <th class="col-amount">Amount (₹)</th>
                                    <th class="col-action">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Rows will be added dynamically -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Sales Summary - Compact Design -->
                <div class="sales-summary" style="padding: 10px; background: #f8f9fa; border-radius: 8px; margin-bottom: 15px;">
                    <div class="row align-items-end" style="margin: 0;">
                        <!-- Discount Section -->
                        <div class="col-md-3" style="padding: 0 5px;">
                            <div class="row" style="margin: 0;">
                                <div class="col-6" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-percentage mr-1"></i>Discount % (F2)</label>
                                    <div class="input-group">
                                        <input type="number" class="form-control form-control-sm" id="discountPercent" placeholder="0.00" step="0.01" min="0" max="100" title="Discount Percentage" style="height: 28px; font-size: 12px; padding: 2px 6px;">
                                        <div class="input-group-append">
                                            <span class="input-group-text" style="height: 28px; padding: 2px 6px; font-size: 10px;">%</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-rupee-sign mr-1"></i>Discount ₹</label>
                                    <input type="number" class="form-control form-control-sm" id="discountAmount" placeholder="0.00" step="0.01" min="0" title="Discount Amount" style="height: 28px; font-size: 12px; padding: 2px 6px;">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Payment Section -->
                        <div class="col-md-6" style="padding: 0 5px;">
                            <div class="row" style="margin: 0;">
                                <div class="col-3" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-credit-card mr-1"></i>Pay Mode (F5)</label>
                                    <select class="form-control form-control-sm" id="paymentMode" title="Select Payment Mode" style="height: 28px; font-size: 11px; padding: 2px 6px;">
                                        <option value="cash">Cash</option>
                                        <option value="upi">UPI</option>
                                        <option value="mixed">Mixed</option>
                                        <option value="credit">Credit</option>
                                    </select>
                                </div>
                                <div class="col-3" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-money-bill mr-1"></i>Cash (F3)</label>
                                    <input type="number" class="form-control form-control-sm" id="cashTenderReceived" placeholder="0.00" step="0.01" min="0" title="Cash amount" style="height: 28px; font-size: 12px; padding: 2px 6px;">
                                </div>
                                <div class="col-3" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-mobile-alt mr-1"></i>UPI (F4)</label>
                                    <input type="number" class="form-control form-control-sm" id="upiAmount" placeholder="0.00" step="0.01" min="0" title="UPI amount" style="height: 28px; font-size: 12px; padding: 2px 6px;">
                                </div>
                                <div class="col-3" style="padding: 0 2px;">
                                    <label class="small mb-1 d-block" style="font-size: 11px; color: #666;"><i class="fas fa-hand-holding-usd mr-1"></i>Change</label>
                                    <input type="number" class="form-control form-control-sm" id="cashChange" placeholder="0.00" step="0.01" readonly title="Change amount" style="height: 28px; font-size: 12px; padding: 2px 6px; background: #e9ecef;">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Total Amount Section -->
                        <div class="col-md-3" style="padding: 0 5px;">
                            <div class="summary-totals" style="text-align: right;">
                                <div class="summary-item" style="margin-bottom: 3px;">
                                    <span class="summary-label" style="font-size: 11px; color: #666;">Subtotal:</span>
                                    <span class="summary-value" id="subtotalAmount" style="font-size: 13px; font-weight: 600; color: #495057;">₹0.00</span>
                                </div>
                                <div class="summary-item">
                                    <span class="summary-label" style="font-size: 12px; color: #333; font-weight: 600;">Total:</span>
                                    <span class="summary-value" id="totalAmount" style="font-size: 16px; font-weight: 700; color: #28a745;">₹0.00</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Notes -->
                <div class="form-group mb-0">
                    <label><i class="fas fa-sticky-note mr-2"></i>Additional Notes</label>
                    <textarea class="form-control" id="notes" rows="3" placeholder="Enter any additional notes or special instructions..."></textarea>
                </div>

                <!-- Hidden fields for calculations -->
                <input type="hidden" id="subtotalHidden">
                <input type="hidden" id="discountAmountHidden">
                <input type="hidden" id="taxAmountHidden">
                <input type="hidden" id="totalAmountHidden">
                <!-- Hidden invoice number for JavaScript reference -->
                <span id="invoiceNo" style="display: none;"></span>
            </div>

            <!-- Right Panel -->
            <div class="right-panel">
                <!-- Customer Selection -->
                <div class="customer-panel">
                    <h5><i class="fas fa-user-circle mr-2"></i>Customer Information</h5>
                    <div class="form-group">
                        <label><i class="fas fa-user mr-2"></i>Customer Name</label>
                        <input type="text" class="form-control" id="customerName" placeholder="Enter customer name" autocomplete="off" title="Search Customer (Alt+C)">
                        <div id="customerSuggestions" class="customer-suggestions"></div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><i class="fas fa-phone mr-2"></i>Phone Number</label>
                                <input type="text" class="form-control" id="customerPhone" placeholder="Enter phone number" autocomplete="off">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><i class="fas fa-file-invoice mr-2"></i>GST Number</label>
                                <input type="text" class="form-control" id="customerGst" placeholder="Enter GST number" maxlength="15" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label><i class="fas fa-map-marker-alt mr-2"></i>Address</label>
                        <textarea class="form-control" id="customerAddress" rows="3" placeholder="Enter customer address" autocomplete="off"></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><i class="fas fa-credit-card mr-2"></i>Credit Limit</label>
                                <input type="number" class="form-control" id="customerCreditLimit" placeholder="0.00" step="0.01" readonly>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-0">
                                <label><i class="fas fa-balance-scale mr-2"></i>Outstanding Balance</label>
                                <div class="d-flex align-items-end">
                                    <input type="number" class="form-control mr-2" id="customerOutstanding" placeholder="0.00" step="0.01" readonly>
                                    <button type="button" class="btn btn-success btn-sm" id="collectPaymentBtn" title="Collect Payment" style="display: none;">
                                        <i class="fas fa-hand-holding-usd"></i>
                                        <span class="d-none d-md-inline ml-1">Collect</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Sales -->
                <div class="recent-sales">
                    <div class="recent-sales-header">
                        <i class="fas fa-history mr-2"></i>Recent Sales History
                    </div>
                    <div id="recentSales">
                        <!-- Recent sales will be loaded here -->
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Access Panel -->
        <div class="quick-access-panel">
            <button class="quick-access-btn save-btn" id="quickSave" title="Save Invoice (Ctrl+S)">
                <i class="fas fa-save"></i>
                <span>Save Invoice</span>
            </button>
            <button class="quick-access-btn print-btn" id="quickPrint" title="Print Invoice (Ctrl+P)">
                <i class="fas fa-print"></i>
                <span>Print</span>
            </button>
            <button class="quick-access-btn new-btn" id="quickNew" title="New Invoice (Ctrl+N)">
                <i class="fas fa-plus"></i>
                <span>New Invoice</span>
            </button>
        </div>

        <!-- Product Search Modal -->
        <div class="product-search-modal" id="productSearchModal">
            <div class="product-search-modal-content">
                <div class="product-search-header">
                    <h6><i class="fas fa-search mr-2"></i>Search Product</h6>
                    <button type="button" class="close-modal" id="closeProductModal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="product-search-body">
                    <div class="search-input-container">
                        <input type="text" class="form-control" id="modalProductSearch" 
                               placeholder="Type product name or code..." autocomplete="off" autofocus>
                        <i class="fas fa-search search-icon"></i>
                    </div>
                    <div class="search-results" id="modalSearchResults">
                        <div class="no-results">
                            <i class="fas fa-box-open"></i>
                            <p>Start typing to search for products...</p>
                        </div>
                    </div>
                </div>
                <div class="product-search-footer">
                    <div class="search-help">
                        <span><kbd>↑</kbd><kbd>↓</kbd> Navigate</span>
                        <span><kbd>Enter</kbd> Select</span>
                        <span><kbd>Esc</kbd> Close</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status Bar -->
        <div class="status-bar">
            <div class="status-info">
                <div class="status-info-item">
                    <i class="fas fa-user"></i>
                    <span>User: <?php echo $_SESSION['username'] ?? 'Admin'; ?></span>
                </div>
                <div class="status-info-item">
                    <i class="fas fa-calendar"></i>
                    <span><?php echo date('d M Y'); ?></span>
                </div>
                <div class="status-info-item">
                    <i class="fas fa-clock"></i>
                    <span id="currentTime"></span>
                </div>
            </div>
            <div class="status-info">
                <div class="status-info-item">
                    <i class="fas fa-keyboard"></i>
                    <span>Press F1 for Help</span>
                </div>
            </div>
        </div>
    </div>



    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="js/sales.js"></script>
    <script>
    // Pass edit invoice data to JavaScript
    const editInvoiceData = <?php echo $edit_invoice_data ? json_encode($edit_invoice_data) : 'null'; ?>;
    
    // Add real-time clock
    function updateTime() {
        const now = new Date();
        document.getElementById('currentTime').textContent = now.toLocaleTimeString();
    }
    setInterval(updateTime, 1000);
    updateTime();

    // Quick access button handlers
    document.getElementById('quickSave').addEventListener('click', () => document.getElementById('saveInvoice').click());
    document.getElementById('quickPrint').addEventListener('click', () => document.getElementById('printInvoice').click());
    document.getElementById('quickNew').addEventListener('click', () => document.getElementById('newInvoice').click());

    // Invoice Type Change Handler
    document.getElementById('invoiceType').addEventListener('change', function() {
        const creditDaysGroup = document.getElementById('creditDaysGroup');
        if (this.value === 'credit') {
            creditDaysGroup.style.display = 'block';
        } else {
            creditDaysGroup.style.display = 'none';
        }
    });

    // Payment Mode Change Handler
    document.getElementById('paymentMode').addEventListener('change', function() {
        salesManager.handlePaymentModeChange(this.value);
    });

    // Payment Mode Keyboard Handler
    document.getElementById('paymentMode').addEventListener('keydown', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault();
            // Move to appropriate field based on payment mode
            const mode = this.value;
            if (mode === 'cash') {
                document.getElementById('cashTenderReceived').focus();
            } else if (mode === 'upi') {
                document.getElementById('upiAmount').focus();
            } else if (mode === 'mixed') {
                document.getElementById('cashTenderReceived').focus();
            } else if (mode === 'credit') {
                // Focus on notes for credit payments
                document.getElementById('notes').focus();
            }
        } else if (e.key >= '1' && e.key <= '4') {
            e.preventDefault();
            const modes = ['cash', 'upi', 'mixed', 'credit'];
            this.value = modes[parseInt(e.key) - 1];
            this.dispatchEvent(new Event('change'));
        }
    });

    // Cash Amount Change Handler
    document.getElementById('cashTenderReceived').addEventListener('input', function() {
        salesManager.handleCashAmountChange();
    });

    // UPI Amount Change Handler
    document.getElementById('upiAmount').addEventListener('input', function() {
        salesManager.handleUpiAmountChange();
    });

    // Auto-select text when focusing on input fields
    document.addEventListener('DOMContentLoaded', function() {
        // Add focus event listeners to all input fields for text selection
        const inputFields = document.querySelectorAll('input[type="text"], input[type="number"], input[type="tel"], input[type="email"], textarea');
        
        inputFields.forEach(function(input) {
            // Focus event for text selection
            input.addEventListener('focus', function() {
                const self = this;
                // Small delay to ensure the focus event is complete
                setTimeout(() => {
                    try {
                        self.select();
                        // Fallback for mobile browsers
                        if (self.setSelectionRange) {
                            self.setSelectionRange(0, self.value.length);
                        }
                    } catch (e) {
                        // Silent catch for any selection issues
                    }
                }, 10);
            });
            
            // Click event for better user experience
            input.addEventListener('click', function() {
                const self = this;
                setTimeout(() => {
                    try {
                        self.select();
                        if (self.setSelectionRange) {
                            self.setSelectionRange(0, self.value.length);
                        }
                    } catch (e) {
                        // Silent catch for any selection issues
                    }
                }, 10);
            });
            
            // MouseUp event to prevent deselection on some browsers
            input.addEventListener('mouseup', function(e) {
                if (this.selectionStart === this.selectionEnd) {
                    e.preventDefault();
                    this.select();
                }
            });
        });
        
        // Special handling for payment mode dropdown to ensure proper text display
        const paymentModeSelect = document.getElementById('paymentMode');
        if (paymentModeSelect) {
            paymentModeSelect.addEventListener('focus', function() {
                this.style.color = '#333';
            });
        }
    });



    // Customer selection handler to show outstanding balance
    function updateCustomerOutstanding(customerId) {
        if (customerId) {
            // Fetch customer outstanding balance
            fetch('ajax/get_customer_outstanding.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({customer_id: customerId})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.getElementById('customerOutstanding').value = data.outstanding_balance || '0.00';
                    document.getElementById('customerCreditLimit').value = data.credit_limit || '0.00';
                    
                    // Show warning if outstanding exceeds credit limit
                    const outstanding = parseFloat(data.outstanding_balance || 0);
                    const creditLimit = parseFloat(data.credit_limit || 0);
                    
                    if (outstanding > creditLimit && creditLimit > 0) {
                        alert('Warning: Customer has exceeded credit limit!\nOutstanding: ₹' + outstanding.toFixed(2) + '\nCredit Limit: ₹' + creditLimit.toFixed(2));
                    }
                }
            })
            .catch(error => console.error('Error:', error));
        } else {
            document.getElementById('customerOutstanding').value = '0.00';
            document.getElementById('customerCreditLimit').value = '0.00';
        }
    }

    // Keyboard shortcuts
    document.addEventListener('keydown', function(e) {
        // Ctrl+S - Save Invoice
        if (e.ctrlKey && e.key === 's') {
            e.preventDefault();
            document.getElementById('saveInvoice').click();
        }
        // Ctrl+P - Print Invoice
        else if (e.ctrlKey && e.key === 'p') {
            e.preventDefault();
            document.getElementById('printInvoice').click();
        }
        // Ctrl+N - New Invoice
        else if (e.ctrlKey && e.key === 'n') {
            e.preventDefault();
            document.getElementById('newInvoice').click();
        }
        // Ctrl+A - Add Product
        else if (e.ctrlKey && e.key === 'a') {
            e.preventDefault();
            document.getElementById('addRow').click();
        }
        // Ctrl+F - Search Products
        else if (e.ctrlKey && e.key === 'f') {
            e.preventDefault();
            document.getElementById('searchProductBtn').click();
        }
        // Alt+C - Focus Customer Name
        else if (e.altKey && e.key === 'c') {
            e.preventDefault();
            document.getElementById('customerName').focus();
        }
        // Alt+R - Focus Rate Type
        else if (e.altKey && e.key === 'r') {
            e.preventDefault();
            document.getElementById('rateType').focus();
        }
        // Alt+S - Toggle Scan Mode
        else if (e.altKey && e.key === 's') {
            e.preventDefault();
            const scanModeToggle = document.getElementById('scanMode');
            scanModeToggle.checked = !scanModeToggle.checked;
            scanModeToggle.dispatchEvent(new Event('change'));
        }
        // Esc - Go to Dashboard (only if modal is not open)
        else if (e.key === 'Escape') {
            e.preventDefault();
            // Check if product search modal is open
            if ($('#productSearchModal').hasClass('show')) {
                return; // Let modal handle ESC
            }
            window.location.href = '../dashboard.php';
        }
        // F1 - Help
        else if (e.key === 'F1') {
            e.preventDefault();
            alert('Keyboard Shortcuts:\n\n' +
                  'Ctrl+S - Save Invoice\n' +
                  'Ctrl+P - Print Invoice\n' +
                  'Ctrl+N - New Invoice\n' +
                  'Ctrl+A - Add Product\n' +
                  'Ctrl+F - Search Products\n' +
                  'Alt+C - Focus Customer Name\n' +
                  'Alt+R - Change Rate Type\n' +
                  'Alt+S - Toggle Scan Mode\n' +
                  'F2 - Focus Discount\n' +
                  'F3 - Focus Cash Amount\n' +
                  'F4 - Focus UPI Amount\n' +
                  'F5 - Focus Payment Mode\n' +
                  'Esc - Back to Dashboard\n' +
                  'Tab - Navigate between fields\n' +
                  'Enter - Confirm selection in dropdowns');
        }
        // F2 - Focus Discount
        else if (e.key === 'F2') {
            e.preventDefault();
            document.getElementById('discountPercent').focus();
        }
        // F3 - Focus Cash Tender
        else if (e.key === 'F3') {
            e.preventDefault();
            document.getElementById('cashTenderReceived').focus();
        }
        // F4 - Focus UPI Amount
        else if (e.key === 'F4') {
            e.preventDefault();
            document.getElementById('upiAmount').focus();
        }
        // F5 - Focus Payment Mode
        else if (e.key === 'F5') {
            e.preventDefault();
            document.getElementById('paymentMode').focus();
        }
    });
    </script>

    <!-- Payment Collection Modal -->
    <div class="modal fade" id="paymentCollectionModal" tabindex="-1" role="dialog" aria-labelledby="paymentCollectionModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentCollectionModalLabel">
                        <i class="fas fa-hand-holding-usd mr-2"></i>Collect Payment
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- Outstanding Invoices Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h6 class="mb-0"><i class="fas fa-file-invoice mr-2"></i>Outstanding Invoices (Payment will be allocated to oldest invoices first)</h6>
                                </div>
                                <div class="card-body p-2">
                                    <div id="outstandingInvoicesList" style="max-height: 150px; overflow-y: auto;">
                                        <!-- Outstanding invoices will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <form id="paymentCollectionForm">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-user mr-2"></i>Customer Name</label>
                                    <input type="text" class="form-control" id="paymentCustomerName" readonly>
                                    <input type="hidden" id="paymentCustomerId">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-balance-scale mr-2"></i>Outstanding Balance</label>
                                    <input type="number" class="form-control" id="paymentOutstandingBalance" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-calendar mr-2"></i>Payment Date</label>
                                    <input type="date" class="form-control" id="paymentDate" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-rupee-sign mr-2"></i>Payment Amount *</label>
                                    <input type="number" class="form-control" id="paymentAmount" placeholder="0.00" step="0.01" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-credit-card mr-2"></i>Payment Mode *</label>
                                    <select class="form-control" id="paymentMethod" required>
                                        <option value="">Select Payment Mode</option>
                                        <option value="cash">Cash</option>
                                        <option value="upi">UPI</option>
                                        <option value="bank_transfer">Bank Transfer</option>
                                        <option value="cheque">Cheque</option>
                                        <option value="card">Card</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><i class="fas fa-receipt mr-2"></i>Reference Number</label>
                                    <input type="text" class="form-control" id="paymentReference" placeholder="Enter reference number">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><i class="fas fa-sticky-note mr-2"></i>Notes</label>
                            <textarea class="form-control" id="paymentNotes" rows="3" placeholder="Enter payment notes or description..."></textarea>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-0">
                                    <label><i class="fas fa-balance-scale mr-2"></i>Remaining Balance</label>
                                    <input type="number" class="form-control" id="paymentRemainingBalance" readonly>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times mr-2"></i>Cancel
                    </button>
                    <button type="button" class="btn btn-success" id="savePaymentBtn">
                        <i class="fas fa-save mr-2"></i>Save Payment
                    </button>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
