<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    $_SESSION['uid'] = 1; // For testing
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!$con) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    $searchTerm = trim($_POST['search'] ?? '');
    $rateType = $_POST['rate_type'] ?? 'CustomerRate';
    $limit = intval($_POST['limit'] ?? 10); // Default to 10, allow custom limit
    
    if (empty($searchTerm)) {
        echo json_encode(['success' => false, 'message' => 'Search term is required']);
        exit();
    }
    
    // Ensure limit is reasonable
    if ($limit <= 0 || $limit > 50) {
        $limit = 10;
    }
    
    // Validate rate type
    $validRateTypes = ['CustomerRate', 'ShopRate', 'WholesaleRate'];
    if (!in_array($rateType, $validRateTypes)) {
        $rateType = 'CustomerRate';
    }
    
    // Search for products by name, Tamil name, or code (case insensitive)
    $searchTerm = mysqli_real_escape_string($con, $searchTerm);
    $query = "SELECT VegetableCode as code, VegetableName as name, TamilName as tamil_name, Unit as unit, 
              CustomerRate, ShopRate, WholesaleRate, $rateType as selling_rate 
              FROM tblvegetables 
              WHERE (VegetableName LIKE '%$searchTerm%' OR VegetableCode LIKE '%$searchTerm%' OR TamilName LIKE '%$searchTerm%')
              AND Status = 'Active' 
              ORDER BY 
                CASE 
                    WHEN VegetableCode LIKE '$searchTerm%' THEN 1
                    WHEN VegetableName LIKE '$searchTerm%' THEN 2
                    WHEN TamilName LIKE '$searchTerm%' THEN 3
                    ELSE 4
                END,
                VegetableName 
              LIMIT $limit";
    
    $result = mysqli_query($con, $query);
    
    if (!$result) {
        echo json_encode(['success' => false, 'message' => 'Query failed: ' . mysqli_error($con)]);
        exit();
    }
    
    $products = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $products[] = $row;
    }
    
    echo json_encode(['success' => true, 'data' => $products]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
