<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        echo json_encode(['success' => false, 'message' => 'Invalid JSON data']);
        exit();
    }
    
    // Validate required fields
    if (empty($input['customer_name']) || empty($input['phone'])) {
        echo json_encode(['success' => false, 'message' => 'Customer name and phone are required']);
        exit();
    }
    
    // Check if customer already exists
    $checkQuery = "SELECT id FROM customers WHERE phone = '" . mysqli_real_escape_string($con, $input['phone']) . "'";
    $checkResult = mysqli_query($con, $checkQuery);
    
    if (mysqli_num_rows($checkResult) > 0) {
        echo json_encode(['success' => false, 'message' => 'Customer with this phone number already exists']);
        exit();
    }
    
    // Generate customer code
    $codeQuery = "SELECT customer_code FROM customers ORDER BY id DESC LIMIT 1";
    $codeResult = mysqli_query($con, $codeQuery);
    
    if (mysqli_num_rows($codeResult) > 0) {
        $lastCustomer = mysqli_fetch_assoc($codeResult);
        $lastNumber = (int)substr($lastCustomer['customer_code'], 4);
        $newNumber = $lastNumber + 1;
    } else {
        $newNumber = 1;
    }
    
    $customerCode = 'CUST' . str_pad($newNumber, 4, '0', STR_PAD_LEFT);
    
    // Insert new customer
    $insertQuery = "INSERT INTO customers (customer_code, customer_name, phone, gst_number, address, status, created_by, created_date) 
                    VALUES (
                        '" . mysqli_real_escape_string($con, $customerCode) . "',
                        '" . mysqli_real_escape_string($con, $input['customer_name']) . "',
                        '" . mysqli_real_escape_string($con, $input['phone']) . "',
                        '" . mysqli_real_escape_string($con, $input['gst_number'] ?? '') . "',
                        '" . mysqli_real_escape_string($con, $input['address']) . "',
                        'active',
                        " . intval($_SESSION['uid']) . ",
                        NOW()
                    )";
    
    if (mysqli_query($con, $insertQuery)) {
        $customerId = mysqli_insert_id($con);
        
        echo json_encode([
            'success' => true, 
            'message' => 'Customer saved successfully',
            'customer_id' => $customerId,
            'customer_code' => $customerCode
        ]);
    } else {
        throw new Exception('Failed to save customer: ' . mysqli_error($con));
    }
    
} catch (Exception $e) {
    error_log("Save customer error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
