<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

include('../../includes/config.php');

header('Content-Type: application/json');

try {
    // Get form data
    $customer_id = intval($_POST['customer_id']);
    $outstanding_increase = floatval($_POST['total_amount']);
    $payment_mode = mysqli_real_escape_string($con, $_POST['payment_mode']);
    $reference_no = mysqli_real_escape_string($con, $_POST['reference_no'] ?? '');
    $notes = mysqli_real_escape_string($con, $_POST['notes'] ?? '');
    $receipt_date = mysqli_real_escape_string($con, $_POST['receipt_date']);
    $created_by = $_SESSION['uid'];
    
    // Validation
    if (empty($customer_id) || $outstanding_increase <= 0) {
        throw new Exception('Invalid customer or outstanding amount');
    }
    
    // Get current customer data
    $customerSql = "SELECT customer_name, outstanding_balance FROM customers WHERE id = $customer_id AND status = 'active'";
    $customerResult = mysqli_query($con, $customerSql);
    
    if (!$customerResult || mysqli_num_rows($customerResult) == 0) {
        throw new Exception('Customer not found');
    }
    
    $customer = mysqli_fetch_assoc($customerResult);
    $current_outstanding = $customer['outstanding_balance'];
    $new_outstanding = $current_outstanding + $outstanding_increase;
    
    // Start transaction
    mysqli_autocommit($con, false);
    
    // Update customer outstanding balance
    $updateCustomerSql = "UPDATE customers SET 
                         outstanding_balance = $new_outstanding,
                         updated_date = NOW() 
                         WHERE id = $customer_id";
    
    if (!mysqli_query($con, $updateCustomerSql)) {
        throw new Exception('Failed to update customer outstanding balance: ' . mysqli_error($con));
    }
    
    // Generate receipt number for outstanding increase record
    $receiptNoSql = "SELECT COALESCE(MAX(CAST(SUBSTRING(receipt_no, 13) AS UNSIGNED)), 0) + 1 as next_no 
                     FROM payment_receipts 
                     WHERE receipt_no LIKE 'RCP-" . date('Ym') . "-%'";
    $receiptNoResult = mysqli_query($con, $receiptNoSql);
    $receiptNoRow = mysqli_fetch_assoc($receiptNoResult);
    $receiptNo = 'RCP-' . date('Ym') . '-' . str_pad($receiptNoRow['next_no'], 4, '0', STR_PAD_LEFT);
    
    // Insert payment receipt record for outstanding increase
    $insertReceiptSql = "INSERT INTO payment_receipts (
        receipt_no, receipt_date, customer_id, customer_name, payment_mode,
        cash_amount, upi_amount, cheque_amount, bank_amount, total_amount,
        cheque_no, cheque_date, bank_details, notes, created_by, created_date
    ) VALUES (
        '$receiptNo', '$receipt_date', $customer_id, '" . mysqli_real_escape_string($con, $customer['customer_name']) . "', '$payment_mode',
        0.00, 0.00, 0.00, 0.00, $outstanding_increase,
        '$reference_no', NULL, '', 'Outstanding Balance Increase: ₹$outstanding_increase (From ₹$current_outstanding to ₹$new_outstanding). $notes', 
        $created_by, NOW()
    )";
    
    if (!mysqli_query($con, $insertReceiptSql)) {
        throw new Exception('Failed to create receipt record: ' . mysqli_error($con));
    }
    
    // Get current balance from customer ledger
    $balanceSql = "SELECT COALESCE(MAX(balance), 0) as current_balance FROM customer_ledger WHERE customer_id = $customer_id";
    $balanceResult = mysqli_query($con, $balanceSql);
    $balanceRow = mysqli_fetch_assoc($balanceResult);
    $current_balance = $balanceRow['current_balance'];
    $new_balance = $current_balance + $outstanding_increase;
    
    // Add entry to customer ledger for outstanding increase
    $ledgerSql = "INSERT INTO customer_ledger (
        customer_id, transaction_date, transaction_type, reference_no, 
        debit_amount, credit_amount, balance, description, created_by, created_date
    ) VALUES (
        $customer_id, '$receipt_date', 'debit_note', '$receiptNo',
        $outstanding_increase, 0.00, $new_balance,
        'Outstanding Balance Increased by ₹$outstanding_increase. Reference: $reference_no. $notes',
        $created_by, NOW()
    )";
    
    if (!mysqli_query($con, $ledgerSql)) {
        throw new Exception('Failed to update customer ledger: ' . mysqli_error($con));
    }
    
    // Commit transaction
    mysqli_commit($con);
    
    echo json_encode([
        'success' => true, 
        'message' => 'Outstanding balance increased successfully',
        'receipt_no' => $receiptNo,
        'old_outstanding' => $current_outstanding,
        'new_outstanding' => $new_outstanding,
        'outstanding_increase' => $outstanding_increase
    ]);
    
} catch (Exception $e) {
    // Rollback transaction
    mysqli_rollback($con);
    
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
} finally {
    // Reset autocommit
    mysqli_autocommit($con, true);
}
?>
