<?php
session_start();
include_once('../../includes/config.php');

header('Content-Type: application/json');

if (!isset($_SESSION['uid'])) {
    // For testing purposes, set a default user ID
    $_SESSION['uid'] = 1;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

if (!$con) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit();
}

try {
    $code = trim($_POST['code']);
    $rateType = $_POST['rate_type'] ?? 'CustomerRate';
    
    if (empty($code)) {
        echo json_encode(['success' => false, 'message' => 'Product code is required']);
        exit();
    }
    
    // Validate rate type
    $validRateTypes = ['CustomerRate', 'ShopRate', 'WholesaleRate'];
    if (!in_array($rateType, $validRateTypes)) {
        $rateType = 'CustomerRate';
    }
    
    // Search for product by code using mysqli
    $code = mysqli_real_escape_string($con, $code);
    $query = "SELECT VegetableCode as code, VegetableName as name, TamilName as tamil_name, Unit as unit, 
              CustomerRate, ShopRate, WholesaleRate, $rateType as selling_rate 
              FROM tblvegetables 
              WHERE VegetableCode = '$code' AND Status = 'Active' LIMIT 1";
    
    $result = mysqli_query($con, $query);
    
    if (!$result) {
        echo json_encode(['success' => false, 'message' => 'Query failed: ' . mysqli_error($con)]);
        exit();
    }
    
    if (mysqli_num_rows($result) > 0) {
        $product = mysqli_fetch_assoc($result);
        echo json_encode(['success' => true, 'data' => $product]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Product not found']);
    }
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
