<?php
header('Content-Type: application/json');
include_once('../../includes/config.php');

$response = ['success' => false, 'message' => ''];

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $customer_id = null;
    $customer_name = '';
    
    // Check if customer_id is provided
    if (isset($input['customer_id']) && !empty($input['customer_id'])) {
        $customer_id = intval($input['customer_id']);
        
        $sql = "SELECT id, customer_name, outstanding_balance, credit_limit FROM customers WHERE id = ? AND status = 'active'";
        $stmt = $con->prepare($sql);
        $stmt->bind_param('i', $customer_id);
    }
    // Check if customer_name is provided
    else if (isset($input['customer_name']) && !empty($input['customer_name'])) {
        $customer_name = trim($input['customer_name']);
        
        $sql = "SELECT id, customer_name, outstanding_balance, credit_limit FROM customers WHERE LOWER(customer_name) = LOWER(?) AND status = 'active'";
        $stmt = $con->prepare($sql);
        $stmt->bind_param('s', $customer_name);
    } else {
        throw new Exception('Customer ID or name is required');
    }
    
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($row = $result->fetch_assoc()) {
        // Calculate actual outstanding from customer_ledger
        $customer_id = $row['id'];
        $ledger_stmt = $con->prepare("
            SELECT COALESCE(SUM(debit_amount - credit_amount), 0) as actual_outstanding 
            FROM customer_ledger 
            WHERE customer_id = ?
        ");
        $ledger_stmt->bind_param("i", $customer_id);
        $ledger_stmt->execute();
        $ledger_result = $ledger_stmt->get_result();
        
        $actual_outstanding = 0;
        if ($ledger_result->num_rows > 0) {
            $ledger_data = $ledger_result->fetch_assoc();
            $actual_outstanding = (float)$ledger_data['actual_outstanding'];
        }
        
        // Update customer's outstanding balance if different
        $current_outstanding = (float)$row['outstanding_balance'];
        if (abs($current_outstanding - $actual_outstanding) > 0.01) {
            $update_stmt = $con->prepare("UPDATE customers SET outstanding_balance = ? WHERE id = ?");
            $update_stmt->bind_param("di", $actual_outstanding, $customer_id);
            $update_stmt->execute();
        }
        
        $response['success'] = true;
        $response['data'] = [
            'customer_id' => $customer_id,
            'customer_name' => $row['customer_name'],
            'outstanding_balance' => $actual_outstanding,
            'credit_limit' => (float)$row['credit_limit']
        ];
    } else {
        $response['message'] = 'Customer not found';
    }
    
} catch (Exception $e) {
    $response['message'] = 'Error getting customer outstanding: ' . $e->getMessage();
}

echo json_encode($response);
?>
