<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    $category = $_GET['category'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                si.invoice_date,
                si.invoice_no,
                COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
                v.VegetableName as product_name,
                v.Category,
                sid.quantity,
                sid.rate as selling_rate,
                COALESCE(sid.purchase_rate, v.PurchasedRate, 0) as purchase_rate,
                sid.amount as revenue,
                COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)))) as profit,
                COALESCE(sid.profit_margin_percent, 
                    CASE 
                        WHEN sid.rate > 0 
                        THEN ((sid.rate - COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) / sid.rate) * 100 
                        ELSE 0 
                    END) as profit_margin_percent,
                (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as cost
              FROM sales_invoice_details sid
              LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
              LEFT JOIN customers c ON si.customer_id = c.id
              LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
              WHERE si.status = 'active'";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    if ($category) $conditions[] = "v.Category = '$category'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " ORDER BY si.invoice_date DESC, si.id DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="profit_analysis_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Date', 'Invoice No', 'Customer', 'Product', 'Category', 'Quantity', 'Selling Rate', 'Purchase Rate', 'Revenue', 'Cost', 'Profit', 'Profit Margin %']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['invoice_date'],
            $row['invoice_no'],
            $row['customer_name'],
            $row['product_name'],
            $row['Category'],
            $row['quantity'],
            $row['selling_rate'],
            $row['purchase_rate'],
            $row['revenue'],
            $row['cost'],
            $row['profit'],
            round($row['profit_margin_percent'], 2) . '%'
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$category = $_GET['category'] ?? '';

// Build main query
$query = "SELECT 
            si.invoice_date,
            si.invoice_no,
            COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
            v.VegetableName as product_name,
            v.Category,
            sid.quantity,
            sid.rate as selling_rate,
            COALESCE(sid.purchase_rate, v.PurchasedRate, 0) as purchase_rate,
            sid.amount as revenue,
            COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)))) as profit,
            COALESCE(sid.profit_margin_percent, 
                CASE 
                    WHEN sid.rate > 0 
                    THEN ((sid.rate - COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) / sid.rate) * 100 
                    ELSE 0 
                END) as profit_margin_percent,
            (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as cost
          FROM sales_invoice_details sid
          LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
          LEFT JOIN customers c ON si.customer_id = c.id
          LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
          WHERE si.status = 'active'";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
if ($category) $conditions[] = "v.Category = '$category'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " ORDER BY si.invoice_date DESC, si.id DESC";
$result = mysqli_query($con, $query);

// Get categories for filter
$categories = mysqli_query($con, "SELECT DISTINCT Category FROM tblvegetables WHERE Status = 'Active' ORDER BY Category");

// Get summary totals
$summary_query = "SELECT 
                    SUM(sid.amount) as total_revenue,
                    SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
                    SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
                    COUNT(sid.id) as total_transactions,
                    AVG(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as avg_profit_per_item
                  FROM sales_invoice_details sid
                  LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
                  LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                  WHERE si.status = 'active'";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));

// Get profit by category
$profit_by_category = mysqli_query($con, "SELECT 
                                            v.Category,
                                            SUM(sid.amount) as revenue,
                                            SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as cost,
                                            SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as profit
                                          FROM sales_invoice_details sid
                                          LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
                                          LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                                          WHERE si.status = 'active' AND v.Category IS NOT NULL
                                          " . (!empty($conditions) ? " AND " . implode(" AND ", $conditions) : "") . "
                                          GROUP BY v.Category 
                                          ORDER BY profit DESC 
                                          LIMIT 5");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Profit Analysis | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-chart-pie mr-2"></i>Profit Analysis
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Profit Analysis</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-success text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-3">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="category" class="form-label">Category</label>
                                    <select class="form-control" id="category" name="category">
                                        <option value="">All Categories</option>
                                        <?php while($cat = mysqli_fetch_assoc($categories)) { ?>
                                        <option value="<?php echo $cat['Category']; ?>" <?php echo $category == $cat['Category'] ? 'selected' : ''; ?>><?php echo $cat['Category']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'profit_analysis', 'title' => 'Profit Analysis Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Revenue</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_revenue'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Cost</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_cost'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Profit</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_profit'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted">
                                                <?php 
                                                $overall_margin = $summary['total_revenue'] > 0 ? (($summary['total_profit'] / $summary['total_revenue']) * 100) : 0;
                                                echo round($overall_margin, 1) . '% margin';
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Avg Profit/Item</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['avg_profit_per_item'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $summary['total_transactions'] ?? 0; ?> transactions</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calculator fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <!-- Profit by Category Chart -->
                        <div class="col-xl-6 col-lg-7 no-print">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-success text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-chart-bar mr-2"></i>Profit by Category</h6>
                                </div>
                                <div class="card-body">
                                    <div class="chart-bar">
                                        <canvas id="profitChart"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Top Profitable Categories -->
                        <div class="col-xl-6 col-lg-5">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-warning text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-trophy mr-2"></i>Top Profitable Categories</h6>
                                </div>
                                <div class="card-body">
                                    <?php while($profit_cat = mysqli_fetch_assoc($profit_by_category)) { 
                                        $profit_percentage = $profit_cat['revenue'] > 0 ? (($profit_cat['profit'] / $profit_cat['revenue']) * 100) : 0;
                                    ?>
                                    <div class="d-flex justify-content-between align-items-center border-bottom py-3">
                                        <div>
                                            <strong><?php echo htmlspecialchars($profit_cat['Category']); ?></strong>
                                            <div class="text-muted small">₹<?php echo number_format($profit_cat['revenue'], 0); ?> revenue</div>
                                        </div>
                                        <div class="text-right">
                                            <div class="font-weight-bold text-success">₹<?php echo number_format($profit_cat['profit'], 0); ?></div>
                                            <div class="text-muted small"><?php echo round($profit_percentage, 1); ?>% margin</div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detailed Profit Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-success text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Detailed Profit Analysis</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Date</th>
                                            <th>Invoice</th>
                                            <th>Customer</th>
                                            <th>Product</th>
                                            <th>Category</th>
                                            <th>Qty</th>
                                            <th>Sell Rate</th>
                                            <th>Cost Rate</th>
                                            <th>Revenue</th>
                                            <th>Cost</th>
                                            <th>Profit</th>
                                            <th>Margin %</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_revenue = 0;
                                        $grand_cost = 0;
                                        $grand_profit = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $grand_revenue += $row['revenue'];
                                            $grand_cost += $row['cost'];
                                            $grand_profit += $row['profit'];
                                        ?>
                                        <tr>
                                            <td><?php echo date('d-m-Y', strtotime($row['invoice_date'])); ?></td>
                                            <td><span class="badge badge-info"><?php echo $row['invoice_no']; ?></span></td>
                                            <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                                            <td><strong><?php echo htmlspecialchars($row['product_name']); ?></strong></td>
                                            <td><span class="badge badge-secondary"><?php echo htmlspecialchars($row['Category']); ?></span></td>
                                            <td><?php echo number_format($row['quantity'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['selling_rate'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['purchase_rate'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['revenue'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['cost'], 2); ?></td>
                                            <td class="<?php echo $row['profit'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <strong>₹<?php echo number_format($row['profit'], 2); ?></strong>
                                            </td>
                                            <td class="<?php echo $row['profit_margin_percent'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <strong><?php echo number_format($row['profit_margin_percent'], 1); ?>%</strong>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="8">TOTAL</th>
                                            <th>₹<?php echo number_format($grand_revenue, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_cost, 2); ?></th>
                                            <th class="<?php echo $grand_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                ₹<?php echo number_format($grand_profit, 2); ?>
                                            </th>
                                            <th class="<?php echo $grand_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo $grand_revenue > 0 ? number_format(($grand_profit / $grand_revenue) * 100, 1) : 0; ?>%
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 0, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": [] }
                ]
            });
        });

        // Profit Chart
        const ctx = document.getElementById('profitChart').getContext('2d');
        const profitChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: [<?php 
                    mysqli_data_seek($profit_by_category, 0);
                    $categories = [];
                    $profits = [];
                    while($chart_row = mysqli_fetch_assoc($profit_by_category)) {
                        $categories[] = "'" . $chart_row['Category'] . "'";
                        $profits[] = $chart_row['profit'];
                    }
                    echo implode(',', $categories);
                ?>],
                datasets: [{
                    label: 'Profit (₹)',
                    data: [<?php echo implode(',', $profits); ?>],
                    backgroundColor: 'rgba(28, 200, 138, 0.8)',
                    borderColor: 'rgba(28, 200, 138, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            callback: function(value, index, values) {
                                return '₹' + value.toLocaleString();
                            }
                        }
                    }]
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem, data) {
                            return 'Profit: ₹' + Number(tooltipItem.yLabel).toLocaleString();
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
