<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    $category = $_GET['category'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                v.VegetableName as product_name,
                v.Category,
                v.Unit,
                SUM(sid.quantity) as total_quantity,
                AVG(sid.rate) as avg_rate,
                SUM(sid.amount) as total_sales,
                AVG(COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as avg_purchase_rate,
                SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
                SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
                COUNT(DISTINCT si.id) as invoice_count
              FROM sales_invoice_details sid
              LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
              LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
              WHERE si.status = 'active'";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    if ($category) $conditions[] = "v.Category = '$category'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " GROUP BY sid.product_code ORDER BY total_sales DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="item_wise_report_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Product Name', 'Category', 'Unit', 'Total Quantity', 'Average Rate', 'Total Sales', 'Avg Purchase Rate', 'Total Cost', 'Total Profit', 'Invoice Count', 'Profit Margin %']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        $profit_margin = $row['total_sales'] > 0 ? (($row['total_profit'] / $row['total_sales']) * 100) : 0;
        fputcsv($output, [
            $row['product_name'],
            $row['Category'],
            $row['Unit'],
            $row['total_quantity'],
            $row['avg_rate'],
            $row['total_sales'],
            $row['avg_purchase_rate'],
            $row['total_cost'],
            $row['total_profit'],
            $row['invoice_count'],
            round($profit_margin, 2) . '%'
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$category = $_GET['category'] ?? '';

// Build main query
$query = "SELECT 
            v.VegetableName as product_name,
            v.Category,
            v.Unit,
            SUM(sid.quantity) as total_quantity,
            AVG(sid.rate) as avg_rate,
            SUM(sid.amount) as total_sales,
            AVG(COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as avg_purchase_rate,
            SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
            SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
            COUNT(DISTINCT si.id) as invoice_count
          FROM sales_invoice_details sid
          LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
          LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
          WHERE si.status = 'active'";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
if ($category) $conditions[] = "v.Category = '$category'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " GROUP BY sid.product_code ORDER BY total_sales DESC";
$result = mysqli_query($con, $query);

// Get categories for filter
$categories = mysqli_query($con, "SELECT DISTINCT Category FROM tblvegetables WHERE Status = 'Active' ORDER BY Category");

// Get summary totals
$summary_query = "SELECT 
                    SUM(sid.amount) as total_revenue,
                    SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) as total_cost,
                    SUM(COALESCE(sid.profit_amount, (sid.amount - (sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0))))) as total_profit,
                    COUNT(DISTINCT sid.product_code) as unique_products
                  FROM sales_invoice_details sid
                  LEFT JOIN sales_invoices si ON sid.invoice_id = si.id
                  LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode
                  WHERE si.status = 'active'";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Item Wise Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-boxes mr-2"></i>Item Wise Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Item Wise Report</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-success text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-3">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="category" class="form-label">Category</label>
                                    <select class="form-control" id="category" name="category">
                                        <option value="">All Categories</option>
                                        <?php while($cat = mysqli_fetch_assoc($categories)) { ?>
                                        <option value="<?php echo $cat['Category']; ?>" <?php echo $category == $cat['Category'] ? 'selected' : ''; ?>><?php echo $cat['Category']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'item_wise', 'title' => 'Item Wise Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Revenue</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_revenue'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Total Cost</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_cost'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Profit</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_profit'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted">
                                                <?php 
                                                $profit_margin = $summary['total_revenue'] > 0 ? (($summary['total_profit'] / $summary['total_revenue']) * 100) : 0;
                                                echo round($profit_margin, 1) . '% margin';
                                                ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Unique Products</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['unique_products'] ?? 0; ?></div>
                                            <div class="text-xs text-muted">Items sold</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-boxes fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Items Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-success text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Item Sales Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Product Name</th>
                                            <th>Category</th>
                                            <th>Unit</th>
                                            <th>Total Qty</th>
                                            <th>Avg Rate</th>
                                            <th>Total Sales</th>
                                            <th>Purchase Rate</th>
                                            <th>Total Cost</th>
                                            <th>Total Profit</th>
                                            <th>Profit %</th>
                                            <th>Invoice Count</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_total_sales = 0;
                                        $grand_total_cost = 0;
                                        $grand_total_profit = 0;
                                        $grand_total_qty = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $profit_margin = $row['total_sales'] > 0 ? (($row['total_profit'] / $row['total_sales']) * 100) : 0;
                                            
                                            $grand_total_sales += $row['total_sales'];
                                            $grand_total_cost += $row['total_cost'];
                                            $grand_total_profit += $row['total_profit'];
                                            $grand_total_qty += $row['total_quantity'];
                                        ?>
                                        <tr>
                                            <td><strong><?php echo htmlspecialchars($row['product_name']); ?></strong></td>
                                            <td><span class="badge badge-secondary"><?php echo htmlspecialchars($row['Category']); ?></span></td>
                                            <td><?php echo htmlspecialchars($row['Unit']); ?></td>
                                            <td><?php echo number_format($row['total_quantity'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['avg_rate'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_sales'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['avg_purchase_rate'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_cost'], 2); ?></td>
                                            <td class="<?php echo $row['total_profit'] > 0 ? 'text-success' : 'text-danger'; ?>">
                                                ₹<?php echo number_format($row['total_profit'], 2); ?>
                                            </td>
                                            <td class="<?php echo $profit_margin > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo number_format($profit_margin, 1); ?>%
                                            </td>
                                            <td><span class="badge badge-info"><?php echo $row['invoice_count']; ?></span></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="3">TOTAL</th>
                                            <th><?php echo number_format($grand_total_qty, 2); ?></th>
                                            <th>-</th>
                                            <th>₹<?php echo number_format($grand_total_sales, 2); ?></th>
                                            <th>-</th>
                                            <th>₹<?php echo number_format($grand_total_cost, 2); ?></th>
                                            <th class="<?php echo $grand_total_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                ₹<?php echo number_format($grand_total_profit, 2); ?>
                                            </th>
                                            <th class="<?php echo $grand_total_profit > 0 ? 'text-success' : 'text-danger'; ?>">
                                                <?php echo $grand_total_sales > 0 ? number_format(($grand_total_profit / $grand_total_sales) * 100, 1) : 0; ?>%
                                            </th>
                                            <th>-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 5, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": [] }
                ]
            });
        });
    </script>
</body>
</html>
