<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Get dashboard statistics
$today = date('Y-m-d');
$todaySales = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count, COALESCE(SUM(total_amount), 0) as total FROM sales_invoices WHERE invoice_date = '$today' AND status = 'active'"));
$pendingPayments = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count, COALESCE(SUM(balance_amount), 0) as total FROM sales_invoices WHERE payment_status IN ('unpaid', 'partial') AND status = 'active'"));
$monthSales = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count, COALESCE(SUM(total_amount), 0) as total FROM sales_invoices WHERE MONTH(invoice_date) = MONTH(CURRENT_DATE()) AND YEAR(invoice_date) = YEAR(CURRENT_DATE()) AND status = 'active'"));

// Get recent sales for quick view
$recentSales = mysqli_query($con, "SELECT si.*, c.customer_name as cust_name FROM sales_invoices si LEFT JOIN customers c ON si.customer_id = c.id WHERE si.status = 'active' ORDER BY si.created_date DESC LIMIT 5");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Reports Dashboard | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-chart-bar mr-2"></i>Reports Dashboard
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item active">Reports</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Content Row - Dashboard Cards -->
                    <div class="row mb-4">
                        <!-- Today's Sales Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                                Today's Sales</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($todaySales['total'], 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $todaySales['count']; ?> invoices</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar-day fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Monthly Sales Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                This Month</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($monthSales['total'], 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $monthSales['count']; ?> invoices</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pending Payments Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                                Pending Payments</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($pendingPayments['total'], 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $pendingPayments['count']; ?> invoices</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions Card -->
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Quick Reports</div>
                                            <div class="h6 mb-1 font-weight-bold text-gray-800">Generate Now</div>
                                            <div class="text-xs text-muted">Access all reports</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Reports Grid -->
                    <div class="row">
                        <!-- Sales Reports Column -->
                        <div class="col-lg-6 mb-4">
                            <div class="card shadow">
                                <div class="card-header py-3 bg-primary text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-chart-line mr-2"></i>Sales Reports</h6>
                                </div>
                                <div class="card-body">
                                    <div class="list-group list-group-flush">
                                        <a href="bill_wise_report.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-file-invoice text-primary mr-2"></i>
                                                <strong>Bill Wise Report</strong>
                                                <div class="text-muted small">Detailed invoice reports with filters</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="item_wise_report.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-boxes text-success mr-2"></i>
                                                <strong>Item Wise Report</strong>
                                                <div class="text-muted small">Product sales analysis</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="category_wise_report.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-th-list text-info mr-2"></i>
                                                <strong>Category Wise Report</strong>
                                                <div class="text-muted small">Sales by vegetable categories</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="customer_wise_report.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-users text-warning mr-2"></i>
                                                <strong>Customer Wise Report</strong>
                                                <div class="text-muted small">Customer purchase analysis</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Analytics Reports Column -->
                        <div class="col-lg-6 mb-4">
                            <div class="card shadow">
                                <div class="card-header py-3 bg-success text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-chart-pie mr-2"></i>Analytics Reports</h6>
                                </div>
                                <div class="card-body">
                                    <div class="list-group list-group-flush">
                                        <a href="profit_analysis.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-chart-pie text-primary mr-2"></i>
                                                <strong>Profit Analysis</strong>
                                                <div class="text-muted small">Detailed profit & loss analysis</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="daily_summary.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-calendar-day text-success mr-2"></i>
                                                <strong>Daily Summary</strong>
                                                <div class="text-muted small">Day-wise sales summary</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="pending_payments.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-exclamation-triangle text-warning mr-2"></i>
                                                <strong>Pending Payments</strong>
                                                <div class="text-muted small">Outstanding payment tracking</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="customer_credit_outstanding.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-users text-danger mr-2"></i>
                                                <strong>Customer Credit Outstanding</strong>
                                                <div class="text-muted small">Customer wise outstanding balances with collection</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                        <a href="payment_analysis.php" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                            <div>
                                                <i class="fas fa-credit-card text-info mr-2"></i>
                                                <strong>Payment Analysis</strong>
                                                <div class="text-muted small">Cash vs UPI payment trends</div>
                                            </div>
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Sales Table -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 bg-gradient-primary text-white">
                                    <h6 class="m-0 font-weight-bold"><i class="fas fa-list mr-2"></i>Recent Sales</h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th>Invoice No</th>
                                                    <th>Date</th>
                                                    <th>Customer</th>
                                                    <th>Amount</th>
                                                    <th>Payment Status</th>
                                                    <th>Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php while($sale = mysqli_fetch_assoc($recentSales)) { ?>
                                                <tr>
                                                    <td><span class="badge badge-info"><?php echo $sale['invoice_no']; ?></span></td>
                                                    <td><?php echo date('d-m-Y', strtotime($sale['invoice_date'])); ?></td>
                                                    <td><?php echo $sale['cust_name'] ?: $sale['customer_name'] ?: 'Walk-in Customer'; ?></td>
                                                    <td>₹<?php echo number_format($sale['total_amount'], 2); ?></td>
                                                    <td>
                                                        <?php 
                                                        $statusColor = $sale['payment_status'] == 'paid' ? 'success' : ($sale['payment_status'] == 'partial' ? 'warning' : 'danger');
                                                        ?>
                                                        <span class="badge badge-<?php echo $statusColor; ?>"><?php echo ucfirst($sale['payment_status']); ?></span>
                                                    </td>
                                                    <td>
                                                        <a href="../sales/print_invoice.php?id=<?php echo $sale['id']; ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                                            <i class="fas fa-print"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
</body>
</html>
