<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    $payment_status = $_GET['payment_status'] ?? '';
    
    // Build query for export
    $query = "SELECT 
                COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
                COALESCE(c.phone, si.customer_phone, '') as phone,
                COALESCE(c.email, '') as email,
                COALESCE(c.city, '') as city,
                COUNT(si.id) as total_invoices,
                SUM(si.total_amount) as total_sales,
                SUM(si.cash_received) as total_cash,
                SUM(si.upi_received) as total_upi,
                SUM(si.balance_amount) as total_balance,
                MIN(si.invoice_date) as first_purchase,
                MAX(si.invoice_date) as last_purchase,
                AVG(si.total_amount) as avg_order_value
              FROM sales_invoices si
              LEFT JOIN customers c ON si.customer_id = c.id
              WHERE si.status = 'active'";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    if ($payment_status) $conditions[] = "si.payment_status = '$payment_status'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name)) ORDER BY total_sales DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="customer_wise_report_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Customer Name', 'Phone', 'Email', 'City', 'Total Invoices', 'Total Sales', 'Cash Received', 'UPI Received', 'Balance Due', 'First Purchase', 'Last Purchase', 'Avg Order Value']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['customer_name'],
            $row['phone'],
            $row['email'],
            $row['city'],
            $row['total_invoices'],
            $row['total_sales'],
            $row['total_cash'],
            $row['total_upi'],
            $row['total_balance'],
            $row['first_purchase'],
            $row['last_purchase'],
            $row['avg_order_value']
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$payment_status = $_GET['payment_status'] ?? '';

// Build main query
$query = "SELECT 
            COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
            COALESCE(c.phone, si.customer_phone, '') as phone,
            COALESCE(c.email, '') as email,
            COALESCE(c.city, '') as city,
            COALESCE(c.customer_code, '') as customer_code,
            COUNT(si.id) as total_invoices,
            SUM(si.total_amount) as total_sales,
            SUM(si.cash_received) as total_cash,
            SUM(si.upi_received) as total_upi,
            SUM(si.balance_amount) as total_balance,
            MIN(si.invoice_date) as first_purchase,
            MAX(si.invoice_date) as last_purchase,
            AVG(si.total_amount) as avg_order_value,
            si.customer_id
          FROM sales_invoices si
          LEFT JOIN customers c ON si.customer_id = c.id
          WHERE si.status = 'active'";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
if ($payment_status) $conditions[] = "si.payment_status = '$payment_status'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name)) ORDER BY total_sales DESC";
$result = mysqli_query($con, $query);

// Get summary totals
$summary_query = "SELECT 
                    COUNT(DISTINCT COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))) as unique_customers,
                    SUM(si.total_amount) as total_revenue,
                    SUM(si.cash_received) as total_cash,
                    SUM(si.upi_received) as total_upi,
                    SUM(si.balance_amount) as total_balance,
                    AVG(si.total_amount) as avg_order_value
                  FROM sales_invoices si
                  LEFT JOIN customers c ON si.customer_id = c.id
                  WHERE si.status = 'active'";

if (!empty($conditions)) {
    $summary_query .= " AND " . implode(" AND ", $conditions);
}

$summary = mysqli_fetch_assoc(mysqli_query($con, $summary_query));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Customer Wise Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-users mr-2"></i>Customer Wise Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Customer Wise Report</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-warning text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-3">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-3">
                                    <label for="payment_status" class="form-label">Payment Status</label>
                                    <select class="form-control" id="payment_status" name="payment_status">
                                        <option value="">All Status</option>
                                        <option value="paid" <?php echo $payment_status == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                        <option value="unpaid" <?php echo $payment_status == 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                                        <option value="partial" <?php echo $payment_status == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'customer_wise', 'title' => 'Customer Wise Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Customers</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo $summary['unique_customers'] ?? 0; ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-users fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Revenue</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_revenue'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Avg Order Value</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['avg_order_value'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-chart-bar fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Outstanding</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($summary['total_balance'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Customer Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-warning text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Customer Sales Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Customer</th>
                                            <th>Phone</th>
                                            <th>City</th>
                                            <th>Invoices</th>
                                            <th>Total Sales</th>
                                            <th>Cash</th>
                                            <th>UPI</th>
                                            <th>Balance</th>
                                            <th>Avg Order</th>
                                            <th>First Purchase</th>
                                            <th>Last Purchase</th>
                                            <th class="no-print">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_total_sales = 0;
                                        $grand_total_cash = 0;
                                        $grand_total_upi = 0;
                                        $grand_total_balance = 0;
                                        $grand_total_invoices = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $grand_total_sales += $row['total_sales'];
                                            $grand_total_cash += $row['total_cash'];
                                            $grand_total_upi += $row['total_upi'];
                                            $grand_total_balance += $row['total_balance'];
                                            $grand_total_invoices += $row['total_invoices'];
                                        ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar-sm mr-2">
                                                        <i class="fas fa-user-circle fa-2x text-primary"></i>
                                                    </div>
                                                    <div>
                                                        <strong><?php echo htmlspecialchars($row['customer_name']); ?></strong>
                                                        <?php if($row['customer_code']) { ?>
                                                        <div class="text-muted small"><?php echo $row['customer_code']; ?></div>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['phone']) ?: '-'; ?></td>
                                            <td><?php echo htmlspecialchars($row['city']) ?: '-'; ?></td>
                                            <td><span class="badge badge-primary"><?php echo $row['total_invoices']; ?></span></td>
                                            <td><strong>₹<?php echo number_format($row['total_sales'], 2); ?></strong></td>
                                            <td>₹<?php echo number_format($row['total_cash'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['total_upi'], 2); ?></td>
                                            <td class="<?php echo $row['total_balance'] > 0 ? 'text-danger' : 'text-muted'; ?>">
                                                ₹<?php echo number_format($row['total_balance'], 2); ?>
                                            </td>
                                            <td>₹<?php echo number_format($row['avg_order_value'], 2); ?></td>
                                            <td><?php echo date('d-m-Y', strtotime($row['first_purchase'])); ?></td>
                                            <td><?php echo date('d-m-Y', strtotime($row['last_purchase'])); ?></td>
                                            <td class="no-print">
                                                <div class="btn-group" role="group">
                                                    <?php if($row['customer_id']) { ?>
                                                    <a href="customer_detail.php?id=<?php echo $row['customer_id']; ?>" class="btn btn-sm btn-outline-info" title="View Details">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <?php } ?>
                                                    <a href="bill_wise_report.php?customer_id=<?php echo $row['customer_id']; ?>" class="btn btn-sm btn-outline-primary" title="View Bills">
                                                        <i class="fas fa-file-invoice"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="3">TOTAL</th>
                                            <th><?php echo $grand_total_invoices; ?></th>
                                            <th>₹<?php echo number_format($grand_total_sales, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_total_cash, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_total_upi, 2); ?></th>
                                            <th>₹<?php echo number_format($grand_total_balance, 2); ?></th>
                                            <th>₹<?php echo $grand_total_invoices > 0 ? number_format($grand_total_sales / $grand_total_invoices, 2) : 0; ?></th>
                                            <th colspan="3" class="no-print">-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 4, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": -1 }
                ]
            });
        });
    </script>
</body>
</html>
