<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    header('location:../index.php');
    exit;
}

include('../includes/config.php');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Customer Credit Outstanding - Vegetable Shop</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <!-- DataTables CSS from CDN -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap4.min.css">
    <style>
        .dt-buttons {
            margin-bottom: 10px;
        }
        .dataTables_filter {
            display: none; /* Hide default search box */
        }
        #exportButtons .btn {
            margin-left: 5px;
        }
        .filter-card {
            background: #f8f9fc;
        }
        .form-control:focus {
            border-color: #5a5c69;
            box-shadow: 0 0 0 0.2rem rgba(90, 92, 105, 0.25);
        }
        .table th {
            background-color: #f8f9fc;
            border-top: none;
        }
        .summary-update {
            transition: all 0.3s ease;
        }
        .modal-lg {
            max-width: 900px;
        }
        .form-control-plaintext {
            background: #f8f9fc;
            border: 1px solid #e3e6f0;
            padding: 0.375rem 0.75rem;
        }
        .card-header h6 {
            color: #5a5c69;
        }
        .payment-summary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px;
            padding: 15px;
        }
        .amount-input {
            font-size: 1.1rem;
            font-weight: bold;
        }
        .payment-breakdown {
            background: #f8f9fc;
            border-radius: 8px;
            padding: 10px;
            margin: 10px 0;
        }
        #mixedPaymentSection .form-control,
        #chequeDetailsSection .form-control {
            border-color: #d1ecf1;
        }
        #mixedPaymentSection h6,
        #chequeDetailsSection h6 {
            color: #0c5460;
            border-bottom: 2px solid #bee5eb;
            padding-bottom: 5px;
        }
    </style>
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include('../includes/sidebar.php'); ?>
        
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include('../includes/topbar.php'); ?>
                
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Customer Credit Outstanding</h1>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <?php
                        $totalOutstanding = 0;
                        $countSql = "SELECT COUNT(*) as total_customers, SUM(outstanding_balance) as total_outstanding 
                                     FROM customers WHERE status='active' AND outstanding_balance > 0";
                        $countResult = mysqli_query($con, $countSql);
                        $countRow = mysqli_fetch_assoc($countResult);
                        $totalOutstanding = $countRow['total_outstanding'] ?: 0;
                        ?>
                        <div class="col-xl-6 col-md-6 mb-4">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Total Outstanding
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                ₹<?php echo number_format($totalOutstanding, 2); ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-6 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                                Customers with Dues
                                            </div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                                <?php echo $countRow['total_customers']; ?>
                                            </div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-users fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Controls -->
                    <div class="card shadow mb-3">
                        <div class="card-header py-2">
                            <h6 class="m-0 font-weight-bold text-primary">Filter & Export Options</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3">
                                    <label>Search Customer:</label>
                                    <input type="text" id="searchCustomer" class="form-control" placeholder="Search by name or code...">
                                </div>
                                <div class="col-md-3">
                                    <label>Phone Number:</label>
                                    <input type="text" id="searchPhone" class="form-control" placeholder="Search by phone...">
                                </div>
                                <div class="col-md-3">
                                    <label>Outstanding Range:</label>
                                    <select id="amountRange" class="form-control">
                                        <option value="">All Amounts</option>
                                        <option value="0-1000">₹0 - ₹1,000</option>
                                        <option value="1000-5000">₹1,000 - ₹5,000</option>
                                        <option value="5000-10000">₹5,000 - ₹10,000</option>
                                        <option value="10000+">₹10,000+</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label>&nbsp;</label>
                                    <div>
                                        <button type="button" id="clearFilters" class="btn btn-secondary btn-sm">
                                            <i class="fas fa-times"></i> Clear Filters
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Outstanding Balance Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 d-flex justify-content-between align-items-center">
                            <h6 class="m-0 font-weight-bold text-primary">Customer Outstanding Summary</h6>
                            <div id="exportButtons"></div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Customer Code</th>
                                            <th>Customer Name</th>
                                            <th>Phone</th>
                                            <th>Outstanding Balance</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT * FROM customers WHERE status='active' AND outstanding_balance > 0 ORDER BY outstanding_balance DESC";
                                        $result = mysqli_query($con, $sql);
                                        while ($row = mysqli_fetch_assoc($result)) {
                                        ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['customer_code']); ?></td>
                                            <td><?php echo htmlspecialchars($row['customer_name']); ?></td>
                                            <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                            <td class="text-danger">
                                                <strong>₹<?php echo number_format($row['outstanding_balance'], 2); ?></strong>
                                            </td>
                                            <td>
                                                <a href="../customer_ledger.php?id=<?php echo $row['id']; ?>" class="btn btn-info btn-sm">
                                                    <i class="fas fa-book"></i> View Ledger
                                                </a>
                                                <button class="btn btn-success btn-sm" 
                                                        onclick="collectPayment(<?php echo $row['id']; ?>, '<?php echo addslashes($row['customer_name']); ?>', <?php echo $row['outstanding_balance']; ?>)"
                                                        data-toggle="modal" data-target="#collectPaymentModal">
                                                    <i class="fas fa-money-bill-wave"></i> Collect Payment
                                                </button>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Collect Payment Modal -->
    <div class="modal fade" id="collectPaymentModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-money-bill-wave"></i> Customer Payment Collection
                    </h5>
                    <button type="button" class="close text-white" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form id="paymentForm">
                    <div class="modal-body">
                        <input type="hidden" name="customer_id" id="modal_customer_id">
                        
                        <!-- Customer Information Card -->
                        <div class="card mb-3">
                            <div class="card-header py-2">
                                <h6 class="m-0 font-weight-bold text-primary">Customer Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label><strong>Customer Name:</strong></label>
                                            <input type="text" class="form-control-plaintext" id="modal_customer_name" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label><strong>Current Outstanding:</strong></label>
                                            <input type="text" class="form-control-plaintext text-danger font-weight-bold" id="modal_outstanding" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Details Card -->
                        <div class="card mb-3">
                            <div class="card-header py-2">
                                <h6 class="m-0 font-weight-bold text-primary">Payment Details</h6>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Action Type *</label>
                                            <select class="form-control" id="payment_type" name="payment_type" required>
                                                <option value="payment">Payment (Reduce Outstanding)</option>
                                                <option value="credit_increase">Increase Credit Limit</option>
                                                <option value="outstanding_increase">Increase Outstanding Balance</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Amount *</label>
                                            <input type="number" step="0.01" class="form-control amount-input" name="total_amount" id="modal_amount" required>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Payment Mode *</label>
                                            <select class="form-control" name="payment_mode" id="payment_mode" required>
                                                <option value="cash">Cash</option>
                                                <option value="upi">UPI</option>
                                                <option value="cheque">Cheque</option>
                                                <option value="bank_transfer">Bank Transfer</option>
                                                <option value="mixed">Mixed Payment</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>Reference Number</label>
                                            <input type="text" class="form-control" name="reference_no" id="reference_no" placeholder="Transaction/Cheque No">
                                        </div>
                                    </div>
                                </div>

                                <!-- Mixed Payment Details (Hidden by default) -->
                                <div id="mixedPaymentSection" style="display: none;">
                                    <hr>
                                    <h6 class="text-primary">Mixed Payment Breakdown</h6>
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Cash Amount</label>
                                                <input type="number" step="0.01" class="form-control" name="cash_amount" id="cash_amount" value="0.00">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>UPI Amount</label>
                                                <input type="number" step="0.01" class="form-control" name="upi_amount" id="upi_amount" value="0.00">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Cheque Amount</label>
                                                <input type="number" step="0.01" class="form-control" name="cheque_amount" id="cheque_amount" value="0.00">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label>Bank Transfer</label>
                                                <input type="number" step="0.01" class="form-control" name="bank_amount" id="bank_amount" value="0.00">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Cheque Details (Hidden by default) -->
                                <div id="chequeDetailsSection" style="display: none;">
                                    <hr>
                                    <h6 class="text-primary">Cheque Details</h6>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Cheque Number</label>
                                                <input type="text" class="form-control" name="cheque_no" id="cheque_no">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Cheque Date</label>
                                                <input type="date" class="form-control" name="cheque_date" id="cheque_date">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Bank Details</label>
                                        <input type="text" class="form-control" name="bank_details" id="bank_details" placeholder="Bank name and branch">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea class="form-control" name="notes" id="payment_notes" rows="2" placeholder="Additional notes..."></textarea>
                                </div>

                                <!-- Summary Section -->
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div id="paymentSummary">
                                                    <strong>Current Outstanding: </strong><span id="summary_outstanding" class="text-danger">₹0.00</span><br>
                                                    <strong>Payment Amount: </strong><span id="summary_payment" class="text-success">₹0.00</span><br>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div id="resultSummary">
                                                    <strong>New Outstanding: </strong><span id="summary_new_outstanding" class="text-info">₹0.00</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="receipt_date" value="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">
                            <i class="fas fa-times"></i> Cancel
                        </button>
                        <button type="submit" class="btn btn-success" id="submitPaymentBtn">
                            <i class="fas fa-save"></i> <span id="submitBtnText">Record Payment</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables from CDN -->
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap4.min.js"></script>
    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap4.min.js"></script>
    <!-- Export functionality -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script>
        $(document).ready(function() {
            // Debug: Check if all required libraries are loaded
            console.log('jQuery loaded:', typeof $ !== 'undefined');
            console.log('DataTables loaded:', typeof $.fn.DataTable !== 'undefined');
            console.log('DataTables Buttons loaded:', typeof $.fn.DataTable.Buttons !== 'undefined');
            
            // Wait a bit for all scripts to load, then initialize
            setTimeout(function() {
                // Ensure DataTables is loaded before initializing
                if (typeof $.fn.DataTable !== 'function') {
                    console.error('DataTables is not loaded properly');
                    alert('DataTables library failed to load. Please refresh the page.');
                    return;
                }

                try {
                    // Initialize DataTable with export buttons
                    var table = $('#dataTable').DataTable({
                        "order": [[3, "desc"]],
                        "dom": 'Bfrtip',
                        "buttons": [
                            {
                                extend: 'csv',
                                text: '<i class="fas fa-file-csv"></i> Export CSV',
                                className: 'btn btn-success btn-sm mr-1',
                                title: 'Customer_Outstanding_Report_' + new Date().toISOString().slice(0,10),
                                exportOptions: {
                                    columns: [0, 1, 2, 3] // Exclude actions column
                                }
                            },
                            {
                                extend: 'excel',
                                text: '<i class="fas fa-file-excel"></i> Export Excel',
                                className: 'btn btn-primary btn-sm mr-1',
                                title: 'Customer_Outstanding_Report_' + new Date().toISOString().slice(0,10),
                                exportOptions: {
                                    columns: [0, 1, 2, 3]
                                }
                            },
                            {
                                extend: 'pdf',
                                text: '<i class="fas fa-file-pdf"></i> Export PDF',
                                className: 'btn btn-danger btn-sm mr-1',
                                title: 'Customer Outstanding Report',
                                messageTop: 'Customer Credit Outstanding Report - Generated on ' + new Date().toLocaleDateString(),
                                exportOptions: {
                                    columns: [0, 1, 2, 3]
                                }
                            },
                            {
                                extend: 'print',
                                text: '<i class="fas fa-print"></i> Print',
                                className: 'btn btn-info btn-sm',
                                title: 'Customer Outstanding Report',
                                messageTop: 'Customer Credit Outstanding Report - Generated on ' + new Date().toLocaleDateString(),
                                exportOptions: {
                                    columns: [0, 1, 2, 3]
                                }
                            }
                        ],
                        "pageLength": 25,
                        "responsive": true,
                        "language": {
                            "search": "Search records:",
                            "lengthMenu": "Show _MENU_ entries per page",
                            "info": "Showing _START_ to _END_ of _TOTAL_ customers",
                            "infoEmpty": "No customers found",
                            "infoFiltered": "(filtered from _MAX_ total customers)"
                        }
                    });

                    // Move buttons to the designated area
                    table.buttons().container().appendTo('#exportButtons');

                    // Global variables to track current filter states
                    var currentCustomerSearch = '';
                    var currentAmountRange = '';
                    
                    // Unified filter function
                    function applyAllFilters() {
                        // Clear existing custom search filters
                        $.fn.dataTable.ext.search = [];
                        
                        // Add customer search filter if active
                        if (currentCustomerSearch !== '') {
                            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                                if (settings.nTable.id !== 'dataTable') {
                                    return true;
                                }
                                var customerCode = data[0].toLowerCase();
                                var customerName = data[1].toLowerCase();
                                return customerCode.includes(currentCustomerSearch) || customerName.includes(currentCustomerSearch);
                            });
                        }
                        
                        // Add amount range filter if active
                        if (currentAmountRange !== '') {
                            $.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
                                if (settings.nTable.id !== 'dataTable') {
                                    return true;
                                }
                                var amountText = data[3];
                                var amount = parseFloat(amountText.replace(/[₹,]/g, ''));
                                
                                if (currentAmountRange === '0-1000') {
                                    return amount >= 0 && amount <= 1000;
                                } else if (currentAmountRange === '1000-5000') {
                                    return amount > 1000 && amount <= 5000;
                                } else if (currentAmountRange === '5000-10000') {
                                    return amount > 5000 && amount <= 10000;
                                } else if (currentAmountRange === '10000+') {
                                    return amount > 10000;
                                }
                                return true;
                            });
                        }
                        
                        table.draw();
                    }

                    // Custom search for customer name/code
                    $('#searchCustomer').on('keyup', function() {
                        currentCustomerSearch = this.value.toLowerCase();
                        applyAllFilters();
                    });

                    // Custom search for phone number
                    $('#searchPhone').on('keyup', function() {
                        table.column(2).search(this.value).draw();
                    });

                    // Amount range filter
                    $('#amountRange').on('change', function() {
                        currentAmountRange = this.value;
                        applyAllFilters();
                    });

                    // Clear all filters
                    $('#clearFilters').on('click', function() {
                        $('#searchCustomer').val('');
                        $('#searchPhone').val('');
                        $('#amountRange').val('');
                        // Reset global filter states
                        currentCustomerSearch = '';
                        currentAmountRange = '';
                        // Clear all custom search filters
                        $.fn.dataTable.ext.search = [];
                        table.search('').columns().search('').draw();
                    });

                    // Update summary cards when filters change
                    table.on('draw', function() {
                        updateSummaryCards();
                    });

                    function updateSummaryCards() {
                        var data = table.rows({search: 'applied'}).data();
                        var totalOutstanding = 0;
                        var customerCount = data.length;

                        for (var i = 0; i < data.length; i++) {
                            var amountText = $(data[i][3]).text();
                            var amount = parseFloat(amountText.replace(/[₹,]/g, ''));
                            if (!isNaN(amount)) {
                                totalOutstanding += amount;
                            }
                        }

                        // Update the summary cards with filtered data
                        $('.card .text-danger .h5').text('₹' + numberWithCommas(totalOutstanding.toFixed(2)));
                        $('.card .text-info .h5').text(customerCount);
                    }

                    function numberWithCommas(x) {
                        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                    }

                    console.log('DataTable initialized successfully');
                    
                } catch (error) {
                    console.error('Error initializing DataTable:', error);
                    alert('Error initializing data table: ' + error.message);
                }
            }, 500); // Wait 500ms for all scripts to load
        });

        function collectPayment(customerId, customerName, outstandingBalance) {
            $('#modal_customer_id').val(customerId);
            $('#modal_customer_name').val(customerName);
            $('#modal_outstanding').val('₹' + parseFloat(outstandingBalance).toFixed(2));
            $('#modal_amount').val(parseFloat(outstandingBalance).toFixed(2));
            
            // Reset form
            $('#payment_type').val('payment');
            $('#payment_mode').val('cash');
            $('#reference_no').val('');
            $('#payment_notes').val('');
            $('#cash_amount, #upi_amount, #cheque_amount, #bank_amount').val('0.00');
            $('#cheque_no, #cheque_date, #bank_details').val('');
            
            // Hide additional sections
            $('#mixedPaymentSection, #chequeDetailsSection').hide();
            
            // Update summary
            updatePaymentSummary();
        }

        // Payment mode change handler
        $(document).on('change', '#payment_mode', function() {
            var paymentMode = $(this).val();
            
            if (paymentMode === 'mixed') {
                $('#mixedPaymentSection').show();
                $('#chequeDetailsSection').hide();
            } else if (paymentMode === 'cheque') {
                $('#mixedPaymentSection').hide();
                $('#chequeDetailsSection').show();
            } else {
                $('#mixedPaymentSection, #chequeDetailsSection').hide();
            }
        });

        // Payment type change handler
        $(document).on('change', '#payment_type', function() {
            var paymentType = $(this).val();
            
            if (paymentType === 'credit_increase') {
                $('#submitBtnText').text('Increase Credit');
                $('#modal_amount').val('');
                $('#paymentSummary').html('<strong>Action: </strong><span class="text-info">Increase Credit Limit</span>');
                $('#resultSummary').html('<strong>Credit Increase: </strong><span id="summary_credit_increase" class="text-success">₹0.00</span>');
            } else if (paymentType === 'outstanding_increase') {
                $('#submitBtnText').text('Increase Outstanding');
                $('#modal_amount').val('');
                $('#paymentSummary').html('<strong>Action: </strong><span class="text-warning">Increase Outstanding Balance</span>');
                $('#resultSummary').html('<strong>Outstanding Increase: </strong><span id="summary_outstanding_increase" class="text-warning">₹0.00</span>');
            } else {
                $('#submitBtnText').text('Record Payment');
                var outstanding = parseFloat($('#modal_outstanding').val().replace(/[₹,]/g, ''));
                $('#modal_amount').val(outstanding.toFixed(2));
                updatePaymentSummary();
            }
        });

        // Amount change handler
        $(document).on('input', '#modal_amount', function() {
            updatePaymentSummary();
        });

        // Mixed payment amount change handlers
        $(document).on('input', '#cash_amount, #upi_amount, #cheque_amount, #bank_amount', function() {
            if ($('#payment_mode').val() === 'mixed') {
                var total = 0;
                $('#cash_amount, #upi_amount, #cheque_amount, #bank_amount').each(function() {
                    var val = parseFloat($(this).val()) || 0;
                    total += val;
                });
                $('#modal_amount').val(total.toFixed(2));
                updatePaymentSummary();
            }
        });

        function updatePaymentSummary() {
            var paymentType = $('#payment_type').val();
            var outstandingText = $('#modal_outstanding').val();
            var outstanding = parseFloat(outstandingText.replace(/[₹,]/g, ''));
            var paymentAmount = parseFloat($('#modal_amount').val()) || 0;
            
            if (paymentType === 'credit_increase') {
                $('#summary_credit_increase').text('₹' + paymentAmount.toFixed(2));
            } else if (paymentType === 'outstanding_increase') {
                $('#summary_outstanding_increase').text('₹' + paymentAmount.toFixed(2));
            } else {
                var newOutstanding = outstanding - paymentAmount;
                
                $('#summary_outstanding').text('₹' + outstanding.toFixed(2));
                $('#summary_payment').text('₹' + paymentAmount.toFixed(2));
                $('#summary_new_outstanding').text('₹' + newOutstanding.toFixed(2));
                
                // Color coding for new outstanding
                if (newOutstanding <= 0) {
                    $('#summary_new_outstanding').removeClass('text-danger text-warning').addClass('text-success');
                } else if (newOutstanding < outstanding * 0.5) {
                    $('#summary_new_outstanding').removeClass('text-danger text-success').addClass('text-warning');
                } else {
                    $('#summary_new_outstanding').removeClass('text-success text-warning').addClass('text-danger');
                }
            }
        }

        $('#paymentForm').on('submit', function(e) {
            e.preventDefault();
            
            var paymentType = $('#payment_type').val();
            var paymentMode = $('#payment_mode').val();
            var totalAmount = parseFloat($('#modal_amount').val());
            
            // Validation
            if (!totalAmount || totalAmount <= 0) {
                alert('Please enter a valid amount');
                return;
            }
            
            // For mixed payment, validate total
            if (paymentMode === 'mixed') {
                var cashAmount = parseFloat($('#cash_amount').val()) || 0;
                var upiAmount = parseFloat($('#upi_amount').val()) || 0;
                var chequeAmount = parseFloat($('#cheque_amount').val()) || 0;
                var bankAmount = parseFloat($('#bank_amount').val()) || 0;
                var mixedTotal = cashAmount + upiAmount + chequeAmount + bankAmount;
                
                if (Math.abs(mixedTotal - totalAmount) > 0.01) {
                    alert('Mixed payment amounts do not match the total amount');
                    return;
                }
            }
            
            // For cheque payment, validate cheque details
            if (paymentMode === 'cheque') {
                if (!$('#cheque_no').val().trim()) {
                    alert('Please enter cheque number');
                    return;
                }
                if (!$('#cheque_date').val()) {
                    alert('Please select cheque date');
                    return;
                }
            }
            
            var formData = $(this).serialize();
            var confirmMessage = '';
            
            if (paymentType === 'credit_increase') {
                confirmMessage = 'Are you sure you want to increase credit limit by ₹' + totalAmount.toFixed(2) + '?';
            } else if (paymentType === 'outstanding_increase') {
                confirmMessage = 'Are you sure you want to increase outstanding balance by ₹' + totalAmount.toFixed(2) + '?';
            } else {
                confirmMessage = 'Are you sure you want to record payment of ₹' + totalAmount.toFixed(2) + '?';
            }
            
            if (!confirm(confirmMessage)) {
                return;
            }
            
            // Show loading state
            $('#submitPaymentBtn').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
            
            var ajaxUrl = '';
            if (paymentType === 'credit_increase') {
                ajaxUrl = '../sales/ajax/increase_customer_credit.php';
            } else if (paymentType === 'outstanding_increase') {
                ajaxUrl = '../sales/ajax/increase_customer_outstanding.php';
            } else {
                ajaxUrl = '../sales/ajax/collect_customer_payment.php';
            }
            
            $.ajax({
                url: ajaxUrl,
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        var successMessage = '';
                        if (paymentType === 'credit_increase') {
                            successMessage = 'Credit limit increased successfully!';
                        } else if (paymentType === 'outstanding_increase') {
                            successMessage = 'Outstanding balance increased successfully!';
                        } else {
                            successMessage = 'Payment recorded successfully!';
                        }
                        alert(successMessage);
                        location.reload();
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('AJAX Error:', error);
                    alert('An unexpected error occurred. Please try again.');
                },
                complete: function() {
                    // Reset button state
                    var buttonText = 'Record Payment';
                    if (paymentType === 'credit_increase') {
                        buttonText = 'Increase Credit';
                    } else if (paymentType === 'outstanding_increase') {
                        buttonText = 'Increase Outstanding';
                    }
                    $('#submitPaymentBtn').prop('disabled', false).html('<i class="fas fa-save"></i> <span id="submitBtnText">' + buttonText + '</span>');
                }
            });
        });
    </script>
</body>
</html>
