<?php
session_start();
include_once('../includes/config.php');
if (!isset($_SESSION['uid'])) {
    header('location:../logout.php');
    exit();
}

// Handle CSV Export
if (isset($_GET['export']) && $_GET['export'] == 'csv') {
    $from_date = $_GET['from_date'] ?? '';
    $to_date = $_GET['to_date'] ?? '';
    $payment_status = $_GET['payment_status'] ?? '';
    $customer_id = $_GET['customer_id'] ?? '';
    
    // Build query
    $query = "SELECT si.*, c.customer_name as cust_name, 
              (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) FROM sales_invoice_details sid 
               LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode 
               WHERE sid.invoice_id = si.id) as cost_price,
              (si.total_amount - (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) FROM sales_invoice_details sid 
               LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode 
               WHERE sid.invoice_id = si.id)) as profit
              FROM sales_invoices si 
              LEFT JOIN customers c ON si.customer_id = c.id 
              WHERE si.status = 'active'";
    
    $conditions = [];
    if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
    if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
    if ($payment_status) $conditions[] = "si.payment_status = '$payment_status'";
    if ($customer_id) $conditions[] = "si.customer_id = '$customer_id'";
    
    if (!empty($conditions)) {
        $query .= " AND " . implode(" AND ", $conditions);
    }
    
    $query .= " ORDER BY si.invoice_date DESC, si.created_date DESC";
    $result = mysqli_query($con, $query);
    
    // Generate CSV
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="bill_wise_report_' . date('Y-m-d') . '.csv"');
    
    $output = fopen('php://output', 'w');
    fputcsv($output, ['Invoice No', 'Date', 'Customer Name', 'Phone', 'Subtotal', 'Discount', 'Tax', 'Total Amount', 'Cost Price', 'Profit', 'Payment Status', 'Cash Received', 'UPI Received', 'Balance Amount']);
    
    while ($row = mysqli_fetch_assoc($result)) {
        fputcsv($output, [
            $row['invoice_no'],
            $row['invoice_date'],
            $row['cust_name'] ?: $row['customer_name'] ?: 'Walk-in Customer',
            $row['customer_phone'],
            $row['subtotal'],
            $row['discount_amount'],
            $row['tax_amount'],
            $row['total_amount'],
            $row['cost_price'] ?: 0,
            $row['profit'] ?: $row['total_amount'],
            $row['payment_status'],
            $row['cash_received'],
            $row['upi_received'],
            $row['balance_amount']
        ]);
    }
    
    fclose($output);
    exit();
}

// Get filter values
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';
$payment_status = $_GET['payment_status'] ?? '';
$customer_id = $_GET['customer_id'] ?? '';

// Build query with filters
$query = "SELECT si.*, c.customer_name as cust_name, 
          (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) FROM sales_invoice_details sid 
           LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode 
           WHERE sid.invoice_id = si.id) as cost_price,
          (si.total_amount - (SELECT SUM(sid.quantity * COALESCE(sid.purchase_rate, v.PurchasedRate, 0)) FROM sales_invoice_details sid 
           LEFT JOIN tblvegetables v ON sid.product_code = v.VegetableCode 
           WHERE sid.invoice_id = si.id)) as profit
          FROM sales_invoices si 
          LEFT JOIN customers c ON si.customer_id = c.id 
          WHERE si.status = 'active'";

$conditions = [];
if ($from_date) $conditions[] = "si.invoice_date >= '$from_date'";
if ($to_date) $conditions[] = "si.invoice_date <= '$to_date'";
if ($payment_status) $conditions[] = "si.payment_status = '$payment_status'";
if ($customer_id) $conditions[] = "si.customer_id = '$customer_id'";

if (!empty($conditions)) {
    $query .= " AND " . implode(" AND ", $conditions);
}

$query .= " ORDER BY si.invoice_date DESC, si.created_date DESC";
$result = mysqli_query($con, $query);

// Get customers for filter dropdown
$customers = mysqli_query($con, "SELECT id, customer_name FROM customers WHERE status = 'active' ORDER BY customer_name");

// Calculate totals
$totals_query = str_replace("si.*,", "SUM(si.total_amount) as total_sales, SUM(si.cash_received) as total_cash, SUM(si.upi_received) as total_upi, SUM(si.balance_amount) as total_balance, COUNT(*) as total_invoices,", $query);
$totals_result = mysqli_fetch_assoc(mysqli_query($con, $totals_query));
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Bill Wise Report | Vegetable Shop</title>
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../css/enhanced-admin.css" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
    
    <style>
        @media print {
            .no-print { display: none !important; }
            .card { border: none !important; box-shadow: none !important; }
            .card-body { padding: 0 !important; }
            body { font-size: 12px !important; }
            .table th, .table td { padding: 0.3rem !important; }
            
            /* 3-inch printer styles */
            @page { size: 80mm auto; margin: 5mm; }
            body { width: 70mm; font-size: 10px; }
            .table { font-size: 9px; }
            .card-header { font-size: 11px; }
        }
    </style>
</head>
<body id="page-top">
    <div id="wrapper">
        <?php include_once('../includes/sidebar.php');?>
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include_once('../includes/topbar.php');?>
                <div class="container-fluid">
                    
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4 no-print">
                        <h1 class="h2 mb-0 text-gradient font-weight-bold">
                            <i class="fas fa-file-invoice mr-2"></i>Bill Wise Report
                        </h1>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="index.php">Reports</a></li>
                                <li class="breadcrumb-item active">Bill Wise Report</li>
                            </ol>
                        </nav>
                    </div>

                    <!-- Filters Card -->
                    <div class="card shadow mb-4 no-print">
                        <div class="card-header py-3 bg-primary text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-filter mr-2"></i>Filters & Export</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" class="row">
                                <div class="col-md-2">
                                    <label for="from_date" class="form-label">From Date</label>
                                    <input type="date" class="form-control" id="from_date" name="from_date" value="<?php echo $from_date; ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="to_date" class="form-label">To Date</label>
                                    <input type="date" class="form-control" id="to_date" name="to_date" value="<?php echo $to_date; ?>">
                                </div>
                                <div class="col-md-2">
                                    <label for="payment_status" class="form-label">Payment Status</label>
                                    <select class="form-control" id="payment_status" name="payment_status">
                                        <option value="">All Status</option>
                                        <option value="paid" <?php echo $payment_status == 'paid' ? 'selected' : ''; ?>>Paid</option>
                                        <option value="unpaid" <?php echo $payment_status == 'unpaid' ? 'selected' : ''; ?>>Unpaid</option>
                                        <option value="partial" <?php echo $payment_status == 'partial' ? 'selected' : ''; ?>>Partial</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <label for="customer_id" class="form-label">Customer</label>
                                    <select class="form-control" id="customer_id" name="customer_id">
                                        <option value="">All Customers</option>
                                        <?php while($customer = mysqli_fetch_assoc($customers)) { ?>
                                        <option value="<?php echo $customer['id']; ?>" <?php echo $customer_id == $customer['id'] ? 'selected' : ''; ?>><?php echo $customer['customer_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                                <div class="col-md-3 d-flex align-items-end">
                                    <button type="submit" class="btn btn-primary mr-2"><i class="fas fa-search mr-1"></i>Filter</button>
                                    <a href="?" class="btn btn-secondary mr-2"><i class="fas fa-refresh mr-1"></i>Reset</a>
                                    <div class="dropdown">
                                        <button class="btn btn-success dropdown-toggle" type="button" data-toggle="dropdown">
                                            <i class="fas fa-download mr-1"></i>Export
                                        </button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="?<?php echo http_build_query(array_merge($_GET, ['export' => 'csv'])); ?>">
                                                <i class="fas fa-file-csv mr-1"></i>Export to CSV
                                            </a>
                                            <a class="dropdown-item" href="javascript:window.print()">
                                                <i class="fas fa-print mr-1"></i>Print Report
                                            </a>
                                            <a class="dropdown-item" href="print_thermal_report.php?<?php echo http_build_query(array_merge($_GET, ['report_type' => 'bill_wise', 'title' => 'Bill Wise Report'])); ?>" target="_blank">
                                                <i class="fas fa-receipt mr-1"></i>3" Thermal Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-primary shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Sales</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($totals_result['total_sales'] ?? 0, 2); ?></div>
                                            <div class="text-xs text-muted"><?php echo $totals_result['total_invoices'] ?? 0; ?> invoices</div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-rupee-sign fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Cash Received</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($totals_result['total_cash'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-info shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">UPI Received</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($totals_result['total_upi'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-credit-card fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-3 col-md-6 mb-4">
                            <div class="card border-left-warning shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Balance Due</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($totals_result['total_balance'] ?? 0, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Bills Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3 bg-gradient-primary text-white">
                            <h6 class="m-0 font-weight-bold"><i class="fas fa-table mr-2"></i>Bills Details</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-hover" id="dataTable">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Invoice No</th>
                                            <th>Date</th>
                                            <th>Customer</th>
                                            <th>Phone</th>
                                            <th>Amount</th>
                                            <th>Cost</th>
                                            <th>Profit</th>
                                            <th>Status</th>
                                            <th>Cash</th>
                                            <th>UPI</th>
                                            <th>Balance</th>
                                            <th class="no-print">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $total_amount = 0;
                                        $total_cost = 0;
                                        $total_profit = 0;
                                        $total_cash = 0;
                                        $total_upi = 0;
                                        $total_balance = 0;
                                        
                                        while($row = mysqli_fetch_assoc($result)) { 
                                            $cost_price = $row['cost_price'] ?? 0;
                                            $profit = $row['total_amount'] - $cost_price;
                                            
                                            $total_amount += $row['total_amount'];
                                            $total_cost += $cost_price;
                                            $total_profit += $profit;
                                            $total_cash += $row['cash_received'];
                                            $total_upi += $row['upi_received'];
                                            $total_balance += $row['balance_amount'];
                                        ?>
                                        <tr>
                                            <td><span class="badge badge-info"><?php echo $row['invoice_no']; ?></span></td>
                                            <td><?php echo date('d-m-Y', strtotime($row['invoice_date'])); ?></td>
                                            <td><?php echo $row['cust_name'] ?: $row['customer_name'] ?: 'Walk-in Customer'; ?></td>
                                            <td><?php echo $row['customer_phone'] ?: '-'; ?></td>
                                            <td>₹<?php echo number_format($row['total_amount'], 2); ?></td>
                                            <td>₹<?php echo number_format($cost_price, 2); ?></td>
                                            <td class="<?php echo $profit > 0 ? 'text-success' : 'text-danger'; ?>">₹<?php echo number_format($profit, 2); ?></td>
                                            <td>
                                                <?php 
                                                $statusColor = $row['payment_status'] == 'paid' ? 'success' : ($row['payment_status'] == 'partial' ? 'warning' : 'danger');
                                                ?>
                                                <span class="badge badge-<?php echo $statusColor; ?>"><?php echo ucfirst($row['payment_status']); ?></span>
                                            </td>
                                            <td>₹<?php echo number_format($row['cash_received'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['upi_received'], 2); ?></td>
                                            <td>₹<?php echo number_format($row['balance_amount'], 2); ?></td>
                                            <td class="no-print">
                                                <div class="btn-group" role="group">
                                                    <a href="../sales/index.php?edit_invoice=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-success" title="Edit Invoice">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <a href="../sales/print_invoice.php?id=<?php echo $row['id']; ?>" class="btn btn-sm btn-outline-primary" target="_blank" title="Print Invoice">
                                                        <i class="fas fa-print"></i>
                                                    </a>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot class="thead-dark">
                                        <tr>
                                            <th colspan="4">TOTAL</th>
                                            <th>₹<?php echo number_format($total_amount, 2); ?></th>
                                            <th>₹<?php echo number_format($total_cost, 2); ?></th>
                                            <th class="<?php echo $total_profit > 0 ? 'text-success' : 'text-danger'; ?>">₹<?php echo number_format($total_profit, 2); ?></th>
                                            <th>-</th>
                                            <th>₹<?php echo number_format($total_cash, 2); ?></th>
                                            <th>₹<?php echo number_format($total_upi, 2); ?></th>
                                            <th>₹<?php echo number_format($total_balance, 2); ?></th>
                                            <th class="no-print">-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- End of Main Content -->
            <?php include_once('../includes/footer.php');?>
        </div>
        <!-- End of Content Wrapper -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>
    <!-- DataTables JavaScript-->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "pageLength": 25,
                "order": [[ 1, "desc" ]],
                "columnDefs": [
                    { "orderable": false, "targets": -1 }
                ]
            });
        });
    </script>
</body>
</html>
