<?php
// Determine the base path based on current directory
$currentDir = basename(dirname($_SERVER['PHP_SELF']));
$basePath = (in_array($currentDir, ['reports', 'suppliers', 'sales'])) ? '../' : '';
?>
<!-- Enhanced Sidebar -->
<ul class="navbar-nav bg-gradient-primary sidebar sidebar-dark accordion" id="accordionSidebar">

    <!-- Sidebar - Brand -->
    <div class="sidebar-brand d-flex align-items-center justify-content-center">
        <div class="sidebar-brand-icon">
            <i class="fas fa-carrot"></i>
        </div>
        <div class="sidebar-brand-text mx-3">Vegetable Shop</div>
    </div>

    <!-- Divider -->
    <hr class="sidebar-divider my-0">

    <!-- Nav Item - Dashboard -->
    <li class="nav-item active">
        <a class="nav-link" href="<?php echo $basePath; ?>dashboard.php">
            <i class="fas fa-fw fa-tachometer-alt"></i>
            <span>Dashboard</span>
        </a>
    </li>

    <!-- Divider -->
    <hr class="sidebar-divider">

    <!-- Heading -->
    <div class="sidebar-heading">
        Management
    </div>

    <!-- Nav Item - Products -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseProducts"
            aria-expanded="true" aria-controls="collapseProducts">
            <i class="fas fa-fw fa-seedling"></i>
            <span>Vegetables</span>
        </a>
        <div id="collapseProducts" class="collapse" aria-labelledby="headingProducts" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Vegetable Management:</h6>
                <a class="collapse-item" href="<?php echo $basePath; ?>vegetable-master.php">
                    <i class="fas fa-list mr-1"></i>Vegetable Master
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>vegetable-rates-editor.php">
                    <i class="fas fa-edit mr-1"></i>Rates Editor
                </a>
            </div>
        </div>
    </li>

    <!-- Nav Item - Sales Management -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSales"
            aria-expanded="true" aria-controls="collapseSales">
            <i class="fas fa-fw fa-cash-register"></i>
            <span>Sales Management</span>
             
        </a>
        <div id="collapseSales" class="collapse" aria-labelledby="headingSales" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Sales Operations:</h6>
                <a class="collapse-item" href="<?php echo $basePath; ?>sales/index.php">
                    <i class="fas fa-plus-circle mr-1"></i>New Sale
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>sales/invoices.php">
                    <i class="fas fa-file-invoice mr-1"></i>Invoices
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>customer_credit_outstanding.php">
                    <i class="fas fa-balance-scale-left mr-1"></i>Credit Outstanding
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>payment_receive.php">
                    <i class="fas fa-hand-holding-usd mr-1"></i>Payment Receive
                </a>
           
            </div>
        </div>
    </li>

    <!-- Nav Item - Supplier Management -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseSuppliers"
            aria-expanded="true" aria-controls="collapseSuppliers">
            <i class="fas fa-fw fa-truck"></i>
            <span>Supplier Management</span>
            
        </a>
        <div id="collapseSuppliers" class="collapse" aria-labelledby="headingSuppliers" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Supplier Operations:</h6>
                <a class="collapse-item" href="<?php echo $basePath; ?>suppliers/index.php">
                    <i class="fas fa-list mr-1"></i>Supplier Master
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>suppliers/ledger.php">
                    <i class="fas fa-book mr-1"></i>Supplier Ledger
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>suppliers/payments.php">
                    <i class="fas fa-money-bill-wave mr-1"></i>Payments
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>suppliers/outstanding.php">
                    <i class="fas fa-exclamation-circle mr-1"></i>Outstanding Balance
                </a>
            </div>
        </div>
    </li>

    <!-- Nav Item - Finance Management -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseFinance"
            aria-expanded="true" aria-controls="collapseFinance">
            <i class="fas fa-fw fa-money-bill-wave"></i>
            <span>Finance Management</span>
            
        </a>
        <div id="collapseFinance" class="collapse" aria-labelledby="headingFinance" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Finance Operations:</h6>
                <a class="collapse-item" href="<?php echo $basePath; ?>finance/index.php">
                    <i class="fas fa-tachometer-alt mr-1"></i>Finance Dashboard
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>finance/reports.php">
                    <i class="fas fa-chart-line mr-1"></i>Finance Reports
                </a>
            </div>
        </div>
    </li>

    <!-- Divider -->
    <hr class="sidebar-divider">

    <!-- Heading -->
    <div class="sidebar-heading">
        System
    </div>

    <!-- Nav Item - Reports -->
    <li class="nav-item">
        <a class="nav-link collapsed" href="#" data-toggle="collapse" data-target="#collapseReports"
            aria-expanded="true" aria-controls="collapseReports">
            <i class="fas fa-fw fa-chart-bar"></i>
            <span>Reports & Analytics</span>
             
        </a>
        <div id="collapseReports" class="collapse" aria-labelledby="headingReports" data-parent="#accordionSidebar">
            <div class="bg-white py-2 collapse-inner rounded">
                <h6 class="collapse-header">Sales Reports:</h6>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/index.php">
                    <i class="fas fa-chart-line mr-1"></i>Reports Dashboard
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/bill_wise_report.php">
                    <i class="fas fa-file-invoice mr-1"></i>Bill Wise Report
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/item_wise_report.php">
                    <i class="fas fa-boxes mr-1"></i>Item Wise Report
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/category_wise_report.php">
                    <i class="fas fa-th-list mr-1"></i>Category Wise Report
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/customer_wise_report.php">
                    <i class="fas fa-users mr-1"></i>Customer Wise Report
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/profit_analysis.php">
                    <i class="fas fa-chart-pie mr-1"></i>Profit Analysis
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/daily_summary.php">
                    <i class="fas fa-calendar-day mr-1"></i>Daily Summary
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/pending_payments.php">
                    <i class="fas fa-exclamation-triangle mr-1"></i>Pending Payments
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/customer_credit_outstanding.php">
                    <i class="fas fa-credit-card mr-1"></i>Credit Outstanding
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/inventory_status.php">
                    <i class="fas fa-boxes mr-1"></i>Inventory Status
                </a>
                <a class="collapse-item" href="<?php echo $basePath; ?>reports/cash_flow_report.php">
                    <i class="fas fa-exchange-alt mr-1"></i>Cash Flow Report
                </a>
            </div>
        </div>
    </li>
 

    <!-- Divider -->
    <hr class="sidebar-divider d-none d-md-block">

    <!-- Sidebar Toggler (Sidebar) -->
    <div class="text-center d-none d-md-inline">
        <button class="rounded-circle border-0" id="sidebarToggle"></button>
    </div>

    

</ul>
<!-- End of Enhanced Sidebar -->