<?php
// Enhanced Database Configuration (Auto-fixed on 2025-07-20 16:52:04)
// Set timezone
date_default_timezone_set('Asia/Kolkata');

// Database Configuration Constants
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'veg-shop');
define('DB_PORT', 3306);

// Enhanced database connection with better error handling
$con = null;

try {
    // Use the verified working configuration
    $con = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME, DB_PORT);
    
    if (!$con) {
        throw new Exception("Connection failed: " . mysqli_connect_error());
    }
    
    // Set charset to UTF-8
    mysqli_set_charset($con, "utf8mb4");
    
    // Set timezone for MySQL connection
    mysqli_query($con, "SET time_zone = '+05:30'");
    
} catch (Exception $e) {
    // Log error for debugging
    error_log("Database connection error: " . $e->getMessage());
    
    // For API calls, we'll handle the error in the calling script
    // Don't echo here as it can break JSON responses
}

// PDO Database Connection
$pdo = null;

try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];
    
    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    
    // Set timezone for PDO connection
    $pdo->exec("SET time_zone = '+05:30'");
    
} catch (PDOException $e) {
    // Log error for debugging
    error_log("PDO Database connection error: " . $e->getMessage());
    
    // For API calls, we'll handle the error in the calling script
    // Don't echo here as it can break JSON responses
}

// Function to check database connection health
function checkDatabaseConnection() {
    global $con;
    if (!$con) {
        return false;
    }
    return mysqli_ping($con);
}

// Function to get database connection error
function getDatabaseError() {
    if (mysqli_connect_errno()) {
        return mysqli_connect_error();
    }
    return null;
}