<?php
require_once '../includes/config.php';

if(!isset($_SESSION)) {
    session_start();
}

// Date filters
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-01');
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');

$page_title = "Finance Reports";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $page_title; ?> - Vegetable Shop</title>

    <!-- Custom fonts for this template-->
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">

    <!-- Page Wrapper -->
    <div class="container-fluid">

        <!-- Main Content -->
        <div class="content">

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Simple Navigation Header -->
                <nav class="navbar navbar-expand-lg navbar-light bg-light mb-4">
                    <a class="navbar-brand" href="../dashboard.php">
                        <i class="fas fa-carrot text-success mr-2"></i>Vegetable Shop
                    </a>
                    <div class="navbar-nav ml-auto">
                        <a class="nav-link" href="../dashboard.php">
                            <i class="fas fa-home mr-1"></i>Dashboard
                        </a>
                        <a class="nav-link" href="index.php">
                            <i class="fas fa-money-bill-wave mr-1"></i>Finance
                        </a>
                        <a class="nav-link active" href="reports.php">
                            <i class="fas fa-chart-line mr-1"></i>Reports
                        </a>
                    </div>
                </nav>

                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas fa-chart-line text-primary mr-2"></i>Finance Reports
                        </h1>
                    </div>

                    <!-- Date Filter -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Filter by Date Range</h6>
                        </div>
                        <div class="card-body">
                            <form method="GET" action="">
                                <div class="row">
                                    <div class="col-md-4">
                                        <label for="start_date">Start Date:</label>
                                        <input type="date" class="form-control" name="start_date" value="<?php echo $start_date; ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="end_date">End Date:</label>
                                        <input type="date" class="form-control" name="end_date" value="<?php echo $end_date; ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label>&nbsp;</label><br>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-search mr-1"></i>Filter
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <?php
                    // Get summary data for the selected period
                    $income_query = "SELECT COALESCE(SUM(amount), 0) as total_income FROM income_expense WHERE type='income' AND transaction_date BETWEEN '$start_date' AND '$end_date'";
                    $income_result = mysqli_query($con, $income_query);
                    $total_income = mysqli_fetch_assoc($income_result)['total_income'];

                    $expense_query = "SELECT COALESCE(SUM(amount), 0) as total_expense FROM income_expense WHERE type='expense' AND transaction_date BETWEEN '$start_date' AND '$end_date'";
                    $expense_result = mysqli_query($con, $expense_query);
                    $total_expense = mysqli_fetch_assoc($expense_result)['total_expense'];

                    $net_profit = $total_income - $total_expense;
                    ?>

                    <!-- Summary Cards -->
                    <div class="row mb-4">
                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card border-left-success shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                                Total Income</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($total_income, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-arrow-up fa-2x text-success"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card border-left-danger shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                                Total Expense</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($total_expense, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-arrow-down fa-2x text-danger"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-xl-4 col-md-6 mb-4">
                            <div class="card border-left-<?php echo ($net_profit >= 0) ? 'success' : 'danger'; ?> shadow h-100 py-2">
                                <div class="card-body">
                                    <div class="row no-gutters align-items-center">
                                        <div class="col mr-2">
                                            <div class="text-xs font-weight-bold text-<?php echo ($net_profit >= 0) ? 'success' : 'danger'; ?> text-uppercase mb-1">
                                                Net Profit/Loss</div>
                                            <div class="h5 mb-0 font-weight-bold text-gray-800">₹<?php echo number_format($net_profit, 2); ?></div>
                                        </div>
                                        <div class="col-auto">
                                            <i class="fas fa-balance-scale fa-2x text-<?php echo ($net_profit >= 0) ? 'success' : 'danger'; ?>"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Category Wise Income -->
                    <div class="row">
                        <div class="col-xl-6 col-lg-6">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Income by Category</h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Category</th>
                                                    <th class="text-right">Amount</th>
                                                    <th class="text-right">%</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $category_income_query = "SELECT category, SUM(amount) as total_amount FROM income_expense 
                                                                        WHERE type='income' AND transaction_date BETWEEN '$start_date' AND '$end_date' 
                                                                        GROUP BY category ORDER BY total_amount DESC";
                                                $category_income_result = mysqli_query($con, $category_income_query);
                                                
                                                while($row = mysqli_fetch_assoc($category_income_result)) {
                                                    $percentage = ($total_income > 0) ? ($row['total_amount'] / $total_income * 100) : 0;
                                                ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($row['category']); ?></td>
                                                    <td class="text-right font-weight-bold text-success">₹<?php echo number_format($row['total_amount'], 2); ?></td>
                                                    <td class="text-right"><?php echo number_format($percentage, 1); ?>%</td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Category Wise Expense -->
                        <div class="col-xl-6 col-lg-6">
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">Expense by Category</h6>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Category</th>
                                                    <th class="text-right">Amount</th>
                                                    <th class="text-right">%</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $category_expense_query = "SELECT category, SUM(amount) as total_amount FROM income_expense 
                                                                         WHERE type='expense' AND transaction_date BETWEEN '$start_date' AND '$end_date' 
                                                                         GROUP BY category ORDER BY total_amount DESC";
                                                $category_expense_result = mysqli_query($con, $category_expense_query);
                                                
                                                while($row = mysqli_fetch_assoc($category_expense_result)) {
                                                    $percentage = ($total_expense > 0) ? ($row['total_amount'] / $total_expense * 100) : 0;
                                                ?>
                                                <tr>
                                                    <td><?php echo htmlspecialchars($row['category']); ?></td>
                                                    <td class="text-right font-weight-bold text-danger">₹<?php echo number_format($row['total_amount'], 2); ?></td>
                                                    <td class="text-right"><?php echo number_format($percentage, 1); ?>%</td>
                                                </tr>
                                                <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Monthly Trend -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Daily Trend</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="trendTable">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th class="text-right">Income</th>
                                            <th class="text-right">Expense</th>
                                            <th class="text-right">Net</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $daily_query = "SELECT 
                                                       transaction_date,
                                                       SUM(CASE WHEN type='income' THEN amount ELSE 0 END) as daily_income,
                                                       SUM(CASE WHEN type='expense' THEN amount ELSE 0 END) as daily_expense
                                                       FROM income_expense 
                                                       WHERE transaction_date BETWEEN '$start_date' AND '$end_date' 
                                                       GROUP BY transaction_date 
                                                       ORDER BY transaction_date DESC";
                                        $daily_result = mysqli_query($con, $daily_query);
                                        
                                        while($row = mysqli_fetch_assoc($daily_result)) {
                                            $daily_net = $row['daily_income'] - $row['daily_expense'];
                                        ?>
                                        <tr>
                                            <td><?php echo date('d-m-Y', strtotime($row['transaction_date'])); ?></td>
                                            <td class="text-right font-weight-bold text-success">₹<?php echo number_format($row['daily_income'], 2); ?></td>
                                            <td class="text-right font-weight-bold text-danger">₹<?php echo number_format($row['daily_expense'], 2); ?></td>
                                            <td class="text-right font-weight-bold text-<?php echo ($daily_net >= 0) ? 'success' : 'danger'; ?>">
                                                ₹<?php echo number_format($daily_net, 2); ?>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Bootstrap core JavaScript-->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="../js/sb-admin-2.min.js"></script>

    <!-- Page level plugins -->
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>

    <!-- Page level custom scripts -->
    <script>
        $(document).ready(function() {
            $('#trendTable').DataTable({
                "order": [[ 0, "desc" ]],
                "pageLength": 31
            });
        });
    </script>

</body>

</html>
