<?php
require_once '../includes/config.php';

if(!isset($_SESSION)) {
    session_start();
}

if(isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id = intval($_GET['id']);
    
    try {
        // First, get the transaction details for confirmation
        $check_query = "SELECT type, category, amount FROM income_expense WHERE id = ?";
        $check_stmt = mysqli_prepare($con, $check_query);
        mysqli_stmt_bind_param($check_stmt, "i", $id);
        mysqli_stmt_execute($check_stmt);
        $result = mysqli_stmt_get_result($check_stmt);
        
        if(mysqli_num_rows($result) > 0) {
            $transaction = mysqli_fetch_assoc($result);
            
            // Delete the transaction
            $delete_query = "DELETE FROM income_expense WHERE id = ?";
            $delete_stmt = mysqli_prepare($con, $delete_query);
            mysqli_stmt_bind_param($delete_stmt, "i", $id);
            
            if(mysqli_stmt_execute($delete_stmt)) {
                $_SESSION['success'] = ucfirst($transaction['type']) . " transaction of ₹" . number_format($transaction['amount'], 2) . " has been deleted successfully.";
            } else {
                $_SESSION['error'] = "Error deleting transaction: " . mysqli_error($con);
            }
            
            mysqli_stmt_close($delete_stmt);
        } else {
            $_SESSION['error'] = "Transaction not found.";
        }
        
        mysqli_stmt_close($check_stmt);
        
    } catch (Exception $e) {
        $_SESSION['error'] = "Database error: " . $e->getMessage();
    }
    
} else {
    $_SESSION['error'] = "Invalid transaction ID.";
}

header("Location: index.php");
exit();
?>
