# Finance Management Module

A simple income and expense management system for the vegetable shop.

## Features

- **Income Management**: Track all income sources (sales revenue, other income, etc.)
- **Expense Management**: Track all expenses (purchases, rent, utilities, salaries, etc.)
- **Dashboard**: Overview of daily and monthly financials with summary cards
- **Reports**: Detailed financial reports with category-wise breakdown
- **CRUD Operations**: Create, Read, Update, Delete transactions
- **Date Filtering**: Filter reports by date range
- **Payment Methods**: Support for cash, bank, UPI, and card payments

## Installation

1. **Database Setup**: Run the setup script to create the necessary table:
   ```
   http://your-domain/vegetable-shop/finance/setup.php
   ```

2. **Manual Database Setup** (Alternative): Execute the SQL commands in `create_tables.sql`:
   ```sql
   -- Run this in your MySQL/phpMyAdmin
   source create_tables.sql;
   ```

## File Structure

```
finance/
├── index.php                  # Main dashboard
├── process_transaction.php    # Add new transactions
├── edit_transaction.php       # Edit existing transactions
├── update_transaction.php     # Update transaction handler
├── delete_transaction.php     # Delete transactions
├── reports.php               # Financial reports
├── setup.php                 # Database setup script
├── create_tables.sql         # SQL table creation script
└── README.md                 # This file
```

## Database Table Structure

### `income_expense` Table

| Field | Type | Description |
|-------|------|-------------|
| id | int(11) | Primary key, auto-increment |
| type | enum('income','expense') | Transaction type |
| category | varchar(100) | Category of transaction |
| description | text | Description of transaction |
| amount | decimal(10,2) | Transaction amount |
| transaction_date | date | Date of transaction |
| payment_method | enum('cash','bank','upi','card') | Payment method |
| reference_no | varchar(50) | Reference number (optional) |
| notes | text | Additional notes (optional) |
| created_by | varchar(50) | User who created the record |
| created_at | timestamp | Record creation time |
| updated_at | timestamp | Last update time |

## Usage

### Adding Transactions

1. Go to Finance Management from the sidebar
2. Click "Add Income" or "Add Expense" button
3. Fill in the required details
4. Submit the form

### Editing Transactions

1. In the transactions table, click the edit (pencil) icon
2. Modify the details as needed
3. Click "Update" to save changes

### Deleting Transactions

1. In the transactions table, click the delete (trash) icon
2. Confirm the deletion in the popup

### Viewing Reports

1. Click on "Finance Reports" from the Finance Management menu
2. Use date filters to view specific periods
3. View category-wise breakdowns and daily trends

## Navigation

The Finance Management section is added to the sidebar with the following structure:

```
Finance Management
├── Finance Dashboard    # Main overview page
└── Finance Reports     # Detailed reports
```

## Categories

### Income Categories
- Sales Revenue
- Other Income
- Interest Income  
- Rental Income

### Expense Categories
- Purchase
- Rent
- Electricity
- Transportation
- Staff Salary
- Marketing
- Maintenance
- Other Expenses

## Payment Methods

- Cash
- Bank Transfer
- UPI
- Card

## Features in Detail

### Dashboard Cards
- Today's Income/Expense/Net
- This Month's Net Profit/Loss
- Color-coded indicators (green for positive, red for negative)

### Reports
- Total income and expense for selected period
- Category-wise breakdown with percentages
- Daily trend analysis
- Profit/Loss calculations

### Data Table Features
- Sortable columns
- Pagination
- Search functionality
- Export options (planned)

## Security Notes

- All user inputs are sanitized using `mysqli_real_escape_string()`
- Prepared statements are used for database operations
- Input validation for required fields and data types
- Session-based error and success message handling

## Future Enhancements

- Export to Excel/PDF functionality
- Advanced filtering options
- Recurring transactions
- Budget planning
- Graphical charts and analytics
- User role-based access control
- Backup and restore functionality

## Support

For any issues or questions, please refer to the main project documentation or contact the development team.
