<?php
include_once('includes/config.php');

echo "<h2>Customer Outstanding Debug Report</h2>\n";
echo "<style>
table { border-collapse: collapse; width: 100%; margin: 10px 0; }
th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
th { background-color: #f2f2f2; }
.highlight { background-color: #ffff99; }
.error { color: red; font-weight: bold; }
.success { color: green; font-weight: bold; }
</style>";

// Test the original query vs the fixed query
echo "<h3>1. Original Query (Restrictive Filters)</h3>\n";
$original_query = "SELECT 
    COALESCE(si.customer_id, 0) as customer_id,
    COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
    COALESCE(c.phone, si.customer_phone, '') as phone,
    SUM(si.balance_amount) as total_outstanding
  FROM sales_invoices si
  LEFT JOIN customers c ON si.customer_id = c.id
  WHERE si.invoice_type = 'credit' 
  AND si.balance_amount > 0 
  AND si.status = 'active'
  GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))
  ORDER BY total_outstanding DESC";

$original_result = mysqli_query($con, $original_query);
$original_count = mysqli_num_rows($original_result);
echo "<p>Original query found: <span class='error'>$original_count customers</span></p>";

if ($original_count > 0) {
    echo "<table><tr><th>Customer ID</th><th>Customer Name</th><th>Phone</th><th>Outstanding</th></tr>";
    while ($row = mysqli_fetch_assoc($original_result)) {
        echo "<tr>";
        echo "<td>{$row['customer_id']}</td>";
        echo "<td>{$row['customer_name']}</td>";
        echo "<td>{$row['phone']}</td>";
        echo "<td>₹" . number_format($row['total_outstanding'], 2) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='error'>No results found with original query!</p>";
}

echo "<h3>2. Fixed Query (Removed Restrictive Filters)</h3>\n";
$fixed_query = "SELECT 
    COALESCE(si.customer_id, 0) as customer_id,
    COALESCE(c.customer_name, si.customer_name, 'Walk-in Customer') as customer_name,
    COALESCE(c.phone, si.customer_phone, '') as phone,
    SUM(si.balance_amount) as total_outstanding
  FROM sales_invoices si
  LEFT JOIN customers c ON si.customer_id = c.id
  WHERE si.balance_amount > 0 
  AND (si.status IS NULL OR si.status = '' OR si.status = 'active')
  GROUP BY COALESCE(si.customer_id, CONCAT('walk_', si.customer_name))
  ORDER BY total_outstanding DESC";

$fixed_result = mysqli_query($con, $fixed_query);
$fixed_count = mysqli_num_rows($fixed_result);
echo "<p>Fixed query found: <span class='success'>$fixed_count customers</span></p>";

if ($fixed_count > 0) {
    echo "<table><tr><th>Customer ID</th><th>Customer Name</th><th>Phone</th><th>Outstanding</th></tr>";
    while ($row = mysqli_fetch_assoc($fixed_result)) {
        echo "<tr>";
        echo "<td>{$row['customer_id']}</td>";
        echo "<td>{$row['customer_name']}</td>";
        echo "<td>{$row['phone']}</td>";
        echo "<td>₹" . number_format($row['total_outstanding'], 2) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='error'>Still no results found with fixed query!</p>";
}

// Check what values exist in the problematic fields
echo "<h3>3. Field Value Analysis</h3>\n";

echo "<h4>Invoice Types in Database:</h4>\n";
$invoice_types = mysqli_query($con, "SELECT DISTINCT invoice_type, COUNT(*) as count FROM sales_invoices GROUP BY invoice_type");
echo "<table><tr><th>Invoice Type</th><th>Count</th></tr>";
while ($row = mysqli_fetch_assoc($invoice_types)) {
    echo "<tr><td>" . ($row['invoice_type'] ?: 'NULL/Empty') . "</td><td>{$row['count']}</td></tr>";
}
echo "</table>";

echo "<h4>Status Values in Database:</h4>\n";
$status_values = mysqli_query($con, "SELECT DISTINCT status, COUNT(*) as count FROM sales_invoices GROUP BY status");
echo "<table><tr><th>Status</th><th>Count</th></tr>";
while ($row = mysqli_fetch_assoc($status_values)) {
    echo "<tr><td>" . ($row['status'] ?: 'NULL/Empty') . "</td><td>{$row['count']}</td></tr>";
}
echo "</table>";

echo "<h4>Invoices with Outstanding Balance:</h4>\n";
$outstanding_invoices = mysqli_query($con, "SELECT invoice_type, status, balance_amount, COUNT(*) as count 
                                           FROM sales_invoices 
                                           WHERE balance_amount > 0 
                                           GROUP BY invoice_type, status, balance_amount > 0
                                           ORDER BY balance_amount DESC");
echo "<table><tr><th>Invoice Type</th><th>Status</th><th>Has Balance</th><th>Count</th></tr>";
while ($row = mysqli_fetch_assoc($outstanding_invoices)) {
    echo "<tr>";
    echo "<td>" . ($row['invoice_type'] ?: 'NULL/Empty') . "</td>";
    echo "<td>" . ($row['status'] ?: 'NULL/Empty') . "</td>";
    echo "<td>₹" . number_format($row['balance_amount'], 2) . "</td>";
    echo "<td>{$row['count']}</td>";
    echo "</tr>";
}
echo "</table>";

// Check for common issues
echo "<h3>4. Common Issues Check</h3>\n";

$total_invoices = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count FROM sales_invoices"))['count'];
$invoices_with_balance = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count FROM sales_invoices WHERE balance_amount > 0"))['count'];
$credit_invoices = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count FROM sales_invoices WHERE invoice_type = 'credit'"))['count'];
$active_invoices = mysqli_fetch_assoc(mysqli_query($con, "SELECT COUNT(*) as count FROM sales_invoices WHERE status = 'active'"))['count'];

echo "<ul>";
echo "<li>Total invoices in database: <strong>$total_invoices</strong></li>";
echo "<li>Invoices with outstanding balance: <strong>$invoices_with_balance</strong></li>";
echo "<li>Invoices marked as 'credit': <strong>$credit_invoices</strong></li>";
echo "<li>Invoices with status 'active': <strong>$active_invoices</strong></li>";
echo "</ul>";

if ($invoices_with_balance > 0 && $original_count == 0) {
    echo "<p class='error'>ISSUE FOUND: There are invoices with outstanding balance but the original query returns 0 results.</p>";
    echo "<p class='error'>This suggests the invoice_type or status filters are too restrictive.</p>";
}

if ($fixed_count > $original_count) {
    echo "<p class='success'>FIXED: The updated query found " . ($fixed_count - $original_count) . " additional customers with outstanding balance.</p>";
}

mysqli_close($con);
?>
