<?php
include_once('includes/config.php');

echo "<h2>Customer Ledger Analysis</h2>\n";

// 1. Check if customer_ledger table exists and has data
echo "<h3>1. Customer Ledger Table Overview</h3>\n";
$query1 = "SELECT COUNT(*) as total_entries FROM customer_ledger";
$result1 = mysqli_query($con, $query1);
$row1 = mysqli_fetch_assoc($result1);
echo "Total entries in customer_ledger: " . $row1['total_entries'] . "<br><br>";

if ($row1['total_entries'] > 0) {
    // 2. Check transaction types in ledger
    echo "<h3>2. Transaction Types in Customer Ledger</h3>\n";
    $query2 = "SELECT transaction_type, COUNT(*) as count FROM customer_ledger GROUP BY transaction_type";
    $result2 = mysqli_query($con, $query2);
    echo "<table border='1'><tr><th>Transaction Type</th><th>Count</th></tr>";
    while ($row = mysqli_fetch_assoc($result2)) {
        echo "<tr><td>{$row['transaction_type']}</td><td>{$row['count']}</td></tr>";
    }
    echo "</table><br>";

    // 3. Check customer balances from ledger
    echo "<h3>3. Customer Balances from Ledger</h3>\n";
    $query3 = "SELECT 
                cl.customer_id,
                c.customer_name,
                SUM(cl.debit_amount) as total_debit,
                SUM(cl.credit_amount) as total_credit,
                SUM(cl.debit_amount) - SUM(cl.credit_amount) as current_balance
              FROM customer_ledger cl
              LEFT JOIN customers c ON cl.customer_id = c.id
              GROUP BY cl.customer_id
              HAVING current_balance > 0
              ORDER BY current_balance DESC
              LIMIT 10";
    $result3 = mysqli_query($con, $query3);
    echo "<table border='1'><tr><th>Customer ID</th><th>Customer Name</th><th>Total Debit</th><th>Total Credit</th><th>Balance</th></tr>";
    while ($row = mysqli_fetch_assoc($result3)) {
        echo "<tr>";
        echo "<td>{$row['customer_id']}</td>";
        echo "<td>" . ($row['customer_name'] ?: 'Unknown') . "</td>";
        echo "<td>₹" . number_format($row['total_debit'], 2) . "</td>";
        echo "<td>₹" . number_format($row['total_credit'], 2) . "</td>";
        echo "<td>₹" . number_format($row['current_balance'], 2) . "</td>";
        echo "</tr>";
    }
    echo "</table><br>";
} else {
    echo "<p style='color: red;'>No entries found in customer_ledger table!</p>";
}

// 4. Check customers table
echo "<h3>4. Customers Table Overview</h3>\n";
$query4 = "SELECT COUNT(*) as total_customers FROM customers WHERE status = 'active'";
$result4 = mysqli_query($con, $query4);
$row4 = mysqli_fetch_assoc($result4);
echo "Total active customers: " . $row4['total_customers'] . "<br><br>";

// 5. Compare sales_invoices balance vs ledger balance for customers
echo "<h3>5. Invoice Balance vs Ledger Balance Comparison</h3>\n";
$query5 = "SELECT 
            si.customer_id,
            c.customer_name,
            SUM(si.balance_amount) as invoice_balance,
            COALESCE(ledger.ledger_balance, 0) as ledger_balance
          FROM sales_invoices si
          LEFT JOIN customers c ON si.customer_id = c.id
          LEFT JOIN (
              SELECT customer_id, SUM(debit_amount) - SUM(credit_amount) as ledger_balance
              FROM customer_ledger
              GROUP BY customer_id
          ) ledger ON si.customer_id = ledger.customer_id
          WHERE si.balance_amount > 0
          GROUP BY si.customer_id
          ORDER BY invoice_balance DESC
          LIMIT 10";
$result5 = mysqli_query($con, $query5);
echo "<table border='1'><tr><th>Customer ID</th><th>Customer Name</th><th>Invoice Balance</th><th>Ledger Balance</th><th>Difference</th></tr>";
while ($row = mysqli_fetch_assoc($result5)) {
    $difference = $row['invoice_balance'] - $row['ledger_balance'];
    echo "<tr>";
    echo "<td>{$row['customer_id']}</td>";
    echo "<td>" . ($row['customer_name'] ?: 'Unknown') . "</td>";
    echo "<td>₹" . number_format($row['invoice_balance'], 2) . "</td>";
    echo "<td>₹" . number_format($row['ledger_balance'], 2) . "</td>";
    echo "<td style='color: " . ($difference != 0 ? 'red' : 'green') . "'>₹" . number_format($difference, 2) . "</td>";
    echo "</tr>";
}
echo "</table><br>";

mysqli_close($con);
?>
