-- Optimization and fixes for customer_ledger table
-- Run these SQL commands in your database to improve performance and add necessary constraints

-- Add indexes for better performance
ALTER TABLE `customer_ledger` 
ADD INDEX `idx_customer_ledger_customer_date` (`customer_id`, `transaction_date`),
ADD INDEX `idx_customer_ledger_reference` (`reference_no`),
ADD INDEX `idx_customer_ledger_balance` (`balance`);

-- Add indexes for payment_receipts table
ALTER TABLE `payment_receipts` 
ADD INDEX `idx_payment_receipts_receipt_no` (`receipt_no`),
ADD INDEX `idx_payment_receipts_customer_date` (`customer_id`, `receipt_date`);

-- Add indexes for customers table
ALTER TABLE `customers` 
ADD INDEX `idx_customers_outstanding` (`outstanding_balance`),
ADD INDEX `idx_customers_name` (`customer_name`),
ADD INDEX `idx_customers_phone` (`phone`);

-- Optional: Add foreign key constraints (if you want referential integrity)
-- Note: Only run these if you don't have conflicting data

-- ALTER TABLE `customer_ledger` 
-- ADD CONSTRAINT `fk_customer_ledger_customer` 
-- FOREIGN KEY (`customer_id`) REFERENCES `customers`(`id`) ON DELETE CASCADE;

-- ALTER TABLE `payment_receipts` 
-- ADD CONSTRAINT `fk_payment_receipts_customer` 
-- FOREIGN KEY (`customer_id`) REFERENCES `customers`(`id`) ON DELETE CASCADE;

-- ALTER TABLE `payment_allocations` 
-- ADD CONSTRAINT `fk_payment_allocations_receipt` 
-- FOREIGN KEY (`payment_receipt_id`) REFERENCES `payment_receipts`(`id`) ON DELETE CASCADE,
-- ADD CONSTRAINT `fk_payment_allocations_invoice` 
-- FOREIGN KEY (`invoice_id`) REFERENCES `sales_invoices`(`id`) ON DELETE CASCADE;

-- Optimize tables after adding indexes
OPTIMIZE TABLE `customer_ledger`;
OPTIMIZE TABLE `payment_receipts`;
OPTIMIZE TABLE `customers`;
OPTIMIZE TABLE `payment_allocations`;

-- Update table statistics
ANALYZE TABLE `customer_ledger`;
ANALYZE TABLE `payment_receipts`;
ANALYZE TABLE `customers`;
ANALYZE TABLE `payment_allocations`;
