<?php
// Test session functionality
session_start();

echo "<h2>Session Test</h2>";

// Set a test session variable
if (!isset($_SESSION['test_counter'])) {
    $_SESSION['test_counter'] = 1;
} else {
    $_SESSION['test_counter']++;
}

echo "<p><strong>Session Status:</strong> ";
if (session_status() === PHP_SESSION_ACTIVE) {
    echo "<span style='color: green;'>✓ Sessions are working!</span></p>";
} else {
    echo "<span style='color: red;'>✗ Sessions are not working</span></p>";
}

echo "<p><strong>Session ID:</strong> " . session_id() . "</p>";
echo "<p><strong>Session Save Path:</strong> " . session_save_path() . "</p>";
echo "<p><strong>Test Counter:</strong> " . $_SESSION['test_counter'] . "</p>";

// Check if the session directory is writable
$session_path = session_save_path();
if (is_writable($session_path)) {
    echo "<p><strong>Session Directory:</strong> <span style='color: green;'>✓ Writable</span></p>";
} else {
    echo "<p><strong>Session Directory:</strong> <span style='color: red;'>✗ Not writable</span></p>";
}

echo "<hr>";
echo "<p><a href='test_session.php'>Refresh Page</a> (Counter should increase)</p>";
echo "<p><a href='login.php'>Go to Login Page</a></p>";
?>
