<?php
session_start();
if (strlen($_SESSION['uid']) == 0) {
    header('location:../index.php');
    exit;
}

include('../includes/config.php');

// Handle payment submission
if (isset($_POST['submit'])) {
    $paymentNo = $_POST['payment_no'];
    $paymentDate = $_POST['payment_date'];
    $supplierId = $_POST['supplier_id'];
    $supplierName = $_POST['supplier_name'];
    $paymentMode = $_POST['payment_mode'];
    $amount = $_POST['amount'];
    $referenceNo = $_POST['reference_no'];
    $notes = $_POST['notes'];
    $createdBy = $_SESSION['uid'];

    // Insert payment record
    $paymentSql = "INSERT INTO supplier_payments (payment_no, payment_date, supplier_id, supplier_name, payment_mode, amount, reference_no, notes, created_by) 
                   VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $paymentStmt = $con->prepare($paymentSql);
    $paymentStmt->bind_param("ssissdssi", $paymentNo, $paymentDate, $supplierId, $supplierName, $paymentMode, $amount, $referenceNo, $notes, $createdBy);
    
    if ($paymentStmt->execute()) {
        // Add entry to supplier ledger
        $ledgerSql = "INSERT INTO supplier_ledger (supplier_id, transaction_date, transaction_type, reference_no, credit_amount, description, created_by) 
                      VALUES (?, ?, 'payment', ?, ?, ?, ?)";
        $ledgerStmt = $con->prepare($ledgerSql);
        $description = "Payment via " . $paymentMode;
        $ledgerStmt->bind_param("issdsi", $supplierId, $paymentDate, $paymentNo, $amount, $description, $createdBy);
        $ledgerStmt->execute();
        
        // Update supplier outstanding balance
        $balanceSql = "SELECT outstanding_balance FROM suppliers WHERE id = ?";
        $balanceStmt = $con->prepare($balanceSql);
        $balanceStmt->bind_param("i", $supplierId);
        $balanceStmt->execute();
        $balanceResult = $balanceStmt->get_result();
        $balanceRow = $balanceResult->fetch_assoc();
        
        $newBalance = $balanceRow['outstanding_balance'] - $amount;
        
        $updateSql = "UPDATE suppliers SET outstanding_balance = ? WHERE id = ?";
        $updateStmt = $con->prepare($updateSql);
        $updateStmt->bind_param("di", $newBalance, $supplierId);
        $updateStmt->execute();
        
        echo "<script>alert('Payment recorded successfully');</script>";
    } else {
        echo "<script>alert('Error recording payment');</script>";
    }
}

// Handle delete payment
if (isset($_GET['delete_payment'])) {
    $paymentId = $_GET['delete_payment'];
    
    // Get payment details before deleting
    $getPaymentSql = "SELECT * FROM supplier_payments WHERE id = ?";
    $getStmt = $con->prepare($getPaymentSql);
    $getStmt->bind_param("i", $paymentId);
    $getStmt->execute();
    $paymentResult = $getStmt->get_result();
    
    if ($payment = $paymentResult->fetch_assoc()) {
        // Delete the payment
        $deleteSql = "DELETE FROM supplier_payments WHERE id = ?";
        $deleteStmt = $con->prepare($deleteSql);
        $deleteStmt->bind_param("i", $paymentId);
        
        if ($deleteStmt->execute()) {
            // Delete corresponding ledger entry
            $deleteLedgerSql = "DELETE FROM supplier_ledger WHERE reference_no = ? AND transaction_type = 'payment'";
            $deleteLedgerStmt = $con->prepare($deleteLedgerSql);
            $deleteLedgerStmt->bind_param("s", $payment['payment_no']);
            $deleteLedgerStmt->execute();
            
            // Recalculate supplier balance
            $supplierId = $payment['supplier_id'];
            $balanceSql = "SELECT SUM(debit_amount) - SUM(credit_amount) as balance FROM supplier_ledger WHERE supplier_id = ?";
            $balanceStmt = $con->prepare($balanceSql);
            $balanceStmt->bind_param("i", $supplierId);
            $balanceStmt->execute();
            $balanceResult = $balanceStmt->get_result();
            $balanceRow = $balanceResult->fetch_assoc();
            $newBalance = $balanceRow['balance'] ?: 0;
            
            $updateSupplierSql = "UPDATE suppliers SET outstanding_balance = ? WHERE id = ?";
            $updateSupplierStmt = $con->prepare($updateSupplierSql);
            $updateSupplierStmt->bind_param("di", $newBalance, $supplierId);
            $updateSupplierStmt->execute();
            
            echo "<script>alert('Payment deleted successfully'); window.location.href='payments.php';</script>";
        } else {
            echo "<script>alert('Error deleting payment');</script>";
        }
    } else {
        echo "<script>alert('Payment not found');</script>";
    }
}

// Generate payment number
function generatePaymentNo($con) {
    $sql = "SELECT payment_no FROM supplier_payments ORDER BY id DESC LIMIT 1";
    $result = mysqli_query($con, $sql);
    $lastPaymentNo = '';
    if ($row = mysqli_fetch_assoc($result)) {
        $lastPaymentNo = $row['payment_no'];
    }
    
    if (empty($lastPaymentNo)) {
        return 'PAY-' . date('Ym') . '-0001';
    } else {
        $parts = explode('-', $lastPaymentNo);
        $number = intval($parts[2]) + 1;
        return 'PAY-' . date('Ym') . '-' . str_pad($number, 4, '0', STR_PAD_LEFT);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Supplier Payments - Vegetable Shop</title>
    <link href="../vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="../css/sb-admin-2.min.css" rel="stylesheet">
    <link href="../vendor/datatables/dataTables.bootstrap4.min.css" rel="stylesheet">
</head>

<body id="page-top">
    <div id="wrapper">
        <?php include('../includes/sidebar.php'); ?>
        
        <div id="content-wrapper" class="d-flex flex-column">
            <div id="content">
                <?php include('../includes/topbar.php'); ?>
                
                <div class="container-fluid">
                    <!-- Page Heading -->
                    <div class="d-sm-flex align-items-center justify-content-between mb-4">
                        <h1 class="h3 mb-0 text-gray-800">Supplier Payments</h1>
                        <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#addPaymentModal">
                            <i class="fas fa-plus"></i> Record Payment
                        </button>
                    </div>

                    <!-- Payments Table -->
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Payment History</h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>Payment No</th>
                                            <th>Date</th>
                                            <th>Supplier</th>
                                            <th>Amount</th>
                                            <th>Mode</th>
                                            <th>Reference</th>
                                            <th>Notes</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sql = "SELECT sp.*, s.supplier_name FROM supplier_payments sp 
                                                LEFT JOIN suppliers s ON sp.supplier_id = s.id 
                                                ORDER BY sp.payment_date DESC";
                                        $result = mysqli_query($con, $sql);
                                        while ($row = mysqli_fetch_assoc($result)) {
                                        ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($row['payment_no']); ?></td>
                                            <td><?php echo date('d-m-Y', strtotime($row['payment_date'])); ?></td>
                                            <td><?php echo htmlspecialchars($row['supplier_name']); ?></td>
                                            <td>₹<?php echo number_format($row['amount'], 2); ?></td>
                                            <td>
                                                <span class="badge badge-info">
                                                    <?php echo ucfirst($row['payment_mode']); ?>
                                                </span>
                                            </td>
                                            <td><?php echo htmlspecialchars($row['reference_no']); ?></td>
                                            <td><?php echo htmlspecialchars($row['notes']); ?></td>
                                            <td>
                                                <a href="?delete_payment=<?php echo $row['id']; ?>" 
                                                   class="btn btn-danger btn-sm" 
                                                   onclick="return confirm('Are you sure you want to delete this payment?')">
                                                    <i class="fas fa-trash"></i> Delete
                                                </a>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include('../includes/footer.php'); ?>
        </div>
    </div>

    <!-- Add Payment Modal -->
    <div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Record Payment</h5>
                    <button type="button" class="close" data-dismiss="modal">
                        <span>&times;</span>
                    </button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment No *</label>
                                    <input type="text" class="form-control" name="payment_no" 
                                           value="<?php echo generatePaymentNo($con); ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Date *</label>
                                    <input type="date" class="form-control" name="payment_date" 
                                           value="<?php echo date('Y-m-d'); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Supplier *</label>
                                    <select class="form-control" name="supplier_id" id="supplier_select" required>
                                        <option value="">Select Supplier</option>
                                        <?php
                                        $supplierSql = "SELECT * FROM suppliers WHERE status='active' ORDER BY supplier_name";
                                        $supplierResult = mysqli_query($con, $supplierSql);
                                        while ($supplier = mysqli_fetch_assoc($supplierResult)) {
                                            echo "<option value='{$supplier['id']}' data-name='{$supplier['supplier_name']}' data-balance='{$supplier['outstanding_balance']}'>";
                                            echo htmlspecialchars($supplier['supplier_name']) . " (Outstanding: ₹" . number_format($supplier['outstanding_balance'], 2) . ")";
                                            echo "</option>";
                                        }
                                        ?>
                                    </select>
                                    <input type="hidden" name="supplier_name" id="supplier_name">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Mode *</label>
                                    <select class="form-control" name="payment_mode" required>
                                        <option value="">Select Mode</option>
                                        <option value="cash">Cash</option>
                                        <option value="upi">UPI</option>
                                        <option value="bank_transfer">Bank Transfer</option>
                                        <option value="cheque">Cheque</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="number" step="0.01" class="form-control" name="amount" min="0" required>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Reference No</label>
                                    <input type="text" class="form-control" name="reference_no">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Notes</label>
                                    <textarea class="form-control" name="notes" rows="2"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" name="submit" class="btn btn-primary">Record Payment</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="../vendor/jquery/jquery.min.js"></script>
    <script src="../vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="../vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="../js/sb-admin-2.min.js"></script>
    <script src="../vendor/datatables/jquery.dataTables.min.js"></script>
    <script src="../vendor/datatables/dataTables.bootstrap4.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#dataTable').DataTable({
                "order": [[ 1, "desc" ]]
            });
            
            $('#supplier_select').change(function() {
                var selectedOption = $(this).find('option:selected');
                $('#supplier_name').val(selectedOption.data('name'));
            });
        });
    </script>
</body>
</html>
